/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.stream;

import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.UUID;
import neqsim.process.equipment.ProcessEquipmentBaseClass;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.process.util.monitor.StreamResponse;
import neqsim.standards.gasquality.Standard_ISO6976;
import neqsim.standards.oilquality.Standard_ASTM_D6377;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.ThermodynamicOperations;
import neqsim.util.exception.InvalidInputException;
import neqsim.util.exception.NotImplementedException;
import neqsim.util.unit.Units;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Stream
extends ProcessEquipmentBaseClass
implements StreamInterface,
Cloneable {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(Stream.class);
    protected SystemInterface thermoSystem;
    protected int streamNumber = 0;
    protected static int numberOfStreams = 0;
    private double gasQuality = 0.5;
    protected StreamInterface stream = null;
    protected double lastTemperature = 0.0;
    protected double lastPressure = 0.0;
    protected double lastFlowRate = 0.0;
    protected double[] lastComposition = null;

    public Stream(String name) {
        super(name);
    }

    public Stream(String name, StreamInterface stream) {
        this(name);
        this.setStream(stream);
        this.streamNumber = ++numberOfStreams;
    }

    public Stream(String name, SystemInterface thermoSystem) {
        super(name);
        this.thermoSystem = thermoSystem;
        this.streamNumber = ++numberOfStreams;
    }

    public double getGasQuality() {
        return this.gasQuality;
    }

    public void setGasQuality(double gasQuality) {
        this.gasQuality = gasQuality;
    }

    @Override
    public double getHydrateEquilibriumTemperature() {
        if (!this.getFluid().getPhase(0).hasComponent("water")) {
            logger.info("no hydrate: no water in stream: " + this.name);
            return 0.0;
        }
        try {
            SystemInterface copySystem = this.getFluid().clone();
            copySystem.setHydrateCheck(true);
            ThermodynamicOperations thermoOps = new ThermodynamicOperations(copySystem);
            thermoOps.hydrateFormationTemperature();
            return copySystem.getTemperature();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return 0.0;
        }
    }

    public double getSolidFormationTemperature(String solidName) {
        SystemInterface copySystem = this.getFluid().clone();
        try {
            if (solidName.equals("hydrate")) {
                copySystem.setHydrateCheck(true);
                ThermodynamicOperations thermoOps = new ThermodynamicOperations(copySystem);
                thermoOps.hydrateFormationTemperature();
            } else {
                copySystem.setSolidPhaseCheck(false);
                copySystem.setSolidPhaseCheck(solidName);
                ThermodynamicOperations thermoOps = new ThermodynamicOperations(copySystem);
                thermoOps.freezingPointTemperatureFlash();
            }
            return copySystem.getTemperature();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return 0.0;
        }
    }

    @Override
    public Stream clone() {
        Stream clonedSystem = null;
        try {
            clonedSystem = (Stream)super.clone();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (this.stream != null) {
            clonedSystem.setStream(this.stream.clone());
        }
        if (this.thermoSystem != null) {
            clonedSystem.thermoSystem = this.thermoSystem.clone();
        }
        return clonedSystem;
    }

    @Override
    public Stream clone(String name) {
        if (this.getName() == name) {
            throw new RuntimeException(new InvalidInputException(this, "clone", "name", "- Same name as in original object"));
        }
        Stream s = this.clone();
        s.setName(name);
        return s;
    }

    @Override
    public double getTemperature() {
        return this.getFluid().getTemperature();
    }

    @Override
    public double getTemperature(String unit) {
        return this.getFluid().getTemperature(unit);
    }

    @Override
    public double getMolarRate() {
        return this.getFluid().getTotalNumberOfMoles();
    }

    @Override
    public void setThermoSystem(SystemInterface thermoSystem) {
        if (this.stream != null) {
            this.stream.setThermoSystem(thermoSystem);
        } else {
            this.thermoSystem = thermoSystem;
        }
    }

    @Override
    public void setFluid(SystemInterface fluid) {
        if (this.stream != null) {
            this.stream.setFluid(fluid);
        } else {
            this.setThermoSystem(fluid);
        }
    }

    @Override
    public void setThermoSystemFromPhase(SystemInterface thermoSystem, String phaseTypeName) {
        if (phaseTypeName.equals("liquid")) {
            if (thermoSystem.hasPhaseType("oil") && thermoSystem.hasPhaseType("aqueous")) {
                this.thermoSystem = thermoSystem.phaseToSystem(thermoSystem.getPhaseNumberOfPhase("oil"), thermoSystem.getPhaseNumberOfPhase("aqueous"));
            } else if (thermoSystem.hasPhaseType("oil")) {
                this.thermoSystem = thermoSystem.phaseToSystem(thermoSystem.getPhaseNumberOfPhase("oil"));
            } else if (thermoSystem.hasPhaseType("aqueous")) {
                this.thermoSystem = thermoSystem.phaseToSystem(thermoSystem.getPhaseNumberOfPhase("aqueous"));
            } else {
                logger.warn("no phase of type " + phaseTypeName);
                logger.warn("...returning empty system ");
                this.setEmptyThermoSystem(thermoSystem);
            }
            return;
        }
        if (thermoSystem.hasPhaseType(phaseTypeName)) {
            this.thermoSystem = thermoSystem.phaseToSystem(phaseTypeName);
        } else {
            logger.warn("no phase of type " + phaseTypeName);
            logger.warn("...returning empty system ");
            this.setEmptyThermoSystem(thermoSystem);
        }
    }

    @Override
    public void setEmptyThermoSystem(SystemInterface thermoSystem) {
        this.thermoSystem = thermoSystem.getEmptySystemClone();
        this.thermoSystem.setNumberOfPhases(0);
    }

    @Override
    public SystemInterface getThermoSystem() {
        return this.getFluid();
    }

    @Override
    public void setFlowRate(double flowrate, String unit) {
        this.getFluid().setTotalFlowRate(flowrate, unit);
    }

    @Override
    public void setPressure(double pressure, String unit) {
        this.getFluid().setPressure(pressure, unit);
    }

    @Override
    public void setTemperature(double temperature, String unit) {
        this.getFluid().setTemperature(temperature, unit);
    }

    @Override
    public void runTPflash() {
        if (this.stream != null) {
            this.thermoSystem = this.stream.getThermoSystem().clone();
        }
        ThermodynamicOperations thermoOps = new ThermodynamicOperations(this.thermoSystem);
        thermoOps.TPflash();
        this.thermoSystem.initProperties();
        if (this.stream != null) {
            this.stream.setFluid(this.thermoSystem);
        }
    }

    @Override
    public boolean needRecalculation() {
        if (this.stream != null) {
            this.thermoSystem = this.stream.getFluid();
        }
        if (this.getFluid().getTemperature() == this.lastTemperature && this.getFluid().getPressure() == this.lastPressure && Math.abs(this.getFluid().getFlowRate("kg/hr") - this.lastFlowRate) / this.getFluid().getFlowRate("kg/hr") < 1.0E-6 && Arrays.equals(this.getFluid().getMolarComposition(), this.lastComposition)) {
            this.isSolved = true;
            return false;
        }
        this.isSolved = false;
        return true;
    }

    @Override
    public void run(UUID id) {
        if (!this.getFluid().isInitialized()) {
            this.getFluid().init(0);
        }
        this.thermoSystem = this.getFluid().clone();
        ThermodynamicOperations thermoOps = new ThermodynamicOperations(this.thermoSystem);
        if (this.stream != null && this.thermoSystem.getNumberOfComponents() == 1 && this.getSpecification().equals("TP")) {
            this.setSpecification("PH");
        }
        if (this.getSpecification().equals("TP")) {
            thermoOps.TPflash();
        } else if (this.getSpecification().equals("dewP")) {
            try {
                thermoOps.dewPointTemperatureFlash();
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
                thermoOps.TPflash();
            }
        } else if (this.getSpecification().equals("dewT")) {
            try {
                thermoOps.dewPointPressureFlash();
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
                thermoOps.TPflash();
            }
        } else if (this.getSpecification().equals("gas quality")) {
            try {
                this.thermoSystem.init(0);
                this.thermoSystem.init(2);
                double gasEnthalpy = this.thermoSystem.getPhase(0).getEnthalpy();
                double liquidEnthalpy = this.thermoSystem.getPhase(1).getEnthalpy();
                double enthalpySpec = this.getGasQuality() * gasEnthalpy + (1.0 - this.getGasQuality()) * liquidEnthalpy;
                thermoOps.PHflash(enthalpySpec);
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
                thermoOps.TPflash();
            }
        } else if (this.getSpecification().equals("bubP")) {
            try {
                thermoOps.bubblePointTemperatureFlash();
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
                thermoOps.TPflash();
            }
        } else if (this.getSpecification().equals("bubT")) {
            try {
                thermoOps.bubblePointPressureFlash(false);
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
                thermoOps.TPflash();
            }
        } else if (this.getSpecification().equals("PH")) {
            try {
                thermoOps.PHflash(this.thermoSystem.getEnthalpy(), 0);
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
                thermoOps.TPflash();
            }
        } else {
            thermoOps.TPflash();
        }
        this.thermoSystem.initProperties();
        this.lastFlowRate = this.thermoSystem.getFlowRate("kg/hr");
        this.lastTemperature = this.thermoSystem.getTemperature();
        this.lastPressure = this.thermoSystem.getPressure();
        this.lastComposition = this.thermoSystem.getMolarComposition();
        if (this.stream != null) {
            this.stream.setFluid(this.thermoSystem);
        }
        this.setCalculationIdentifier(id);
    }

    @Override
    public void displayResult() {
        this.getFluid().display(this.name);
    }

    @Override
    public String[][] getResultTable() {
        return this.getFluid().calcResultTable();
    }

    @Override
    public void runTransient(double dt, UUID id) {
        if (this.hasController) {
            this.runController(dt, id);
            this.setFlowRate(this.getController().getResponse(), "kg/hr");
        }
        this.run(id);
        this.increaseTime(dt);
    }

    public void runController(double dt, UUID id) {
        if (this.hasController) {
            this.getController().runTransient(this.getFlowRate("kg/hr"), dt, id);
        }
    }

    @Override
    public void flashStream() {
        ThermodynamicOperations ops = new ThermodynamicOperations(this.getFluid());
        ops.TPflash();
    }

    public void phaseEnvelope() {
        SystemInterface localSyst = this.getFluid().clone();
        ThermodynamicOperations ops = new ThermodynamicOperations(localSyst);
        ops.setRunAsThread(true);
        ops.calcPTphaseEnvelope(true);
        ops.waitAndCheckForFinishedCalculation(10000);
        ops.displayResult();
    }

    @Override
    public double CCB(String unit) {
        SystemInterface localSyst = this.getFluid().clone();
        ThermodynamicOperations ops = new ThermodynamicOperations(localSyst);
        ops.setRunAsThread(true);
        ops.calcPTphaseEnvelope(true);
        ops.waitAndCheckForFinishedCalculation(10000);
        if (unit.equals("bara") || unit.equals("bar")) {
            return ops.get("cricondenbar")[1];
        }
        if (unit.equals("C")) {
            return ops.get("cricondenbar")[0] - 273.15;
        }
        return ops.get("cricondenbar")[0];
    }

    @Override
    public double CCT(String unit) {
        SystemInterface localSyst = this.getFluid().clone();
        ThermodynamicOperations ops = new ThermodynamicOperations(localSyst);
        ops.setRunAsThread(true);
        ops.calcPTphaseEnvelope(true);
        ops.waitAndCheckForFinishedCalculation(10000);
        if (unit.equals("bara") || unit.equals("bar")) {
            return ops.get("cricondentherm")[1];
        }
        if (unit.equals("C")) {
            return ops.get("cricondentherm")[0] - 273.15;
        }
        return ops.get("cricondentherm")[0];
    }

    @Override
    public double TVP(double temperature, String unit) {
        SystemInterface localSyst = this.getFluid().clone();
        localSyst.setTemperature(temperature, unit);
        ThermodynamicOperations ops = new ThermodynamicOperations(localSyst);
        try {
            ops.bubblePointPressureFlash(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return localSyst.getPressure();
    }

    @Override
    public double getTVP(double referenceTemperature, String unit, String returnUnit) {
        SystemInterface localSyst = this.getFluid().clone();
        localSyst.setTemperature(referenceTemperature, unit);
        ThermodynamicOperations ops = new ThermodynamicOperations(localSyst);
        try {
            ops.bubblePointPressureFlash(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return localSyst.getPressure(returnUnit);
    }

    @Override
    public double getRVP(double referenceTemperature, String unit, String returnUnit) {
        SystemInterface localSyst = this.getFluid().clone();
        Standard_ASTM_D6377 standard = new Standard_ASTM_D6377(localSyst);
        standard.setReferenceTemperature(referenceTemperature, unit);
        standard.calculate();
        return standard.getValue("RVP", returnUnit);
    }

    @Override
    public String[][] reportResults() {
        return this.getFluid().getResultTable();
    }

    public Object getProperty(String propertyName, String unit, String phase, String component) {
        throw new RuntimeException(new NotImplementedException(this, "getProperty"));
    }

    @Override
    public double GCV() {
        Standard_ISO6976 standard = new Standard_ISO6976(this.getFluid().clone(), 0.0, 15.55, "volume");
        standard.setReferenceState("real");
        standard.calculate();
        return standard.getValue("GCV") * 1000.0;
    }

    @Override
    public double getGCV(String unit, double refTVolume, double refTCombustion) {
        Standard_ISO6976 standard = new Standard_ISO6976(this.getFluid().clone(), refTVolume, refTCombustion, unit);
        standard.setReferenceState("real");
        standard.calculate();
        return standard.getValue("SuperiorCalorificValue") * 1000.0;
    }

    @Override
    public double getWI(String unit, double refTVolume, double refTCombustion) {
        Standard_ISO6976 standard = new Standard_ISO6976(this.getFluid().clone(), refTVolume, refTCombustion, unit);
        standard.setReferenceState("real");
        standard.calculate();
        return standard.getValue("SuperiorWobbeIndex") * 1000.0;
    }

    @Override
    public Standard_ISO6976 getISO6976(String unit, double refTVolume, double refTCombustion) {
        Standard_ISO6976 standard = new Standard_ISO6976(this.getFluid().clone(), refTVolume, refTCombustion, unit);
        standard.setReferenceState("real");
        return standard;
    }

    @Override
    public double LCV() {
        Standard_ISO6976 standard = new Standard_ISO6976(this.getFluid().clone(), 0.0, 15.55, "volume");
        standard.setReferenceState("real");
        standard.calculate();
        return standard.getValue("InferiorCalorificValue") * 1000.0;
    }

    public void setStream(StreamInterface stream) {
        this.stream = stream;
    }

    @Override
    public SystemInterface getFluid() {
        if (this.stream != null) {
            return this.stream.getFluid();
        }
        return this.thermoSystem;
    }

    public ArrayList<String[]> getReport() {
        HashMap<String, String> gasprops = new HashMap<String, String>();
        ArrayList<String> phases = new ArrayList<String>();
        phases.add("Total");
        if (this.getFluid().hasPhaseType("gas")) {
            phases.add("Gas");
            gasprops.put("temperature", Double.toString(this.getTemperature(Units.getSymbol("temperature"))));
        }
        if (this.getFluid().hasPhaseType("oil")) {
            phases.add("oil");
        }
        if (this.getFluid().hasPhaseType("aqueous")) {
            phases.add("aqueous");
        }
        ArrayList<String[]> report = new ArrayList<String[]>();
        report.add(phases.toArray(new String[0]));
        report.add(new String[]{"temperature", Double.toString(this.getTemperature(Units.getSymbol("temperature"))), Units.getSymbol("temperature")});
        report.add(new String[]{"pressure", Double.toString(this.getPressure(Units.getSymbol("pressure"))), Units.getSymbol("pressure")});
        report.add(new String[]{"mass flow", Double.toString(this.getFlowRate(Units.getSymbol("mass flow"))), Units.getSymbol("mass flow")});
        report.add(new String[]{"molar flow", Double.toString(this.getFlowRate(Units.getSymbol("molar flow"))), Units.getSymbol("molar flow")});
        report.add(new String[]{"volume flow", Double.toString(this.getFlowRate(Units.getSymbol("volume flow"))), Units.getSymbol("volume flow")});
        return report;
    }

    @Override
    public String toJson() {
        return new GsonBuilder().create().toJson(new StreamResponse(this));
    }
}

