/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.subsea;

import java.util.ArrayList;
import java.util.UUID;
import neqsim.process.equipment.TwoPortEquipment;
import neqsim.process.equipment.pipeline.AdiabaticTwoPhasePipe;
import neqsim.process.equipment.reservoir.SimpleReservoir;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.process.equipment.subsea.SimpleFlowLine;
import neqsim.process.equipment.util.Adjuster;
import neqsim.process.equipment.valve.ThrottlingValve;
import neqsim.process.processmodel.ProcessSystem;
import neqsim.thermo.system.SystemSrkEos;

public class SubseaWell
extends TwoPortEquipment {
    private static final long serialVersionUID = 1000L;
    public double height = 1000.0;
    public double length = 1200.0;
    AdiabaticTwoPhasePipe pipeline;

    public SubseaWell(String name, StreamInterface instream) {
        super(name);
        this.setInletStream(instream);
        this.pipeline = new AdiabaticTwoPhasePipe("pipeline", instream);
    }

    public AdiabaticTwoPhasePipe getPipeline() {
        return this.pipeline;
    }

    @Override
    public void run(UUID id) {
        this.pipeline.run(id);
        this.getOutletStream().setFluid(this.pipeline.getOutletStream().getFluid());
        this.setCalculationIdentifier(id);
    }

    public static void main(String[] args) {
        SystemSrkEos testSystem = new SystemSrkEos(373.15, 250.0);
        testSystem.addComponent("nitrogen", 0.1);
        testSystem.addComponent("methane", 70.0);
        testSystem.addComponent("ethane", 1.0);
        testSystem.addComponent("propane", 1.0);
        testSystem.addComponent("i-butane", 1.0);
        testSystem.addComponent("n-butane", 1.0);
        testSystem.addComponent("n-hexane", 0.1);
        testSystem.addComponent("n-heptane", 0.1);
        testSystem.addComponent("n-nonane", 1.0);
        testSystem.addComponent("nC10", 1.0);
        testSystem.addComponent("nC12", 3.0);
        testSystem.addComponent("nC15", 13.0);
        testSystem.addComponent("nC20", 13.0);
        testSystem.addComponent("water", 11.0);
        testSystem.setMixingRule(2);
        testSystem.setMultiPhaseCheck(true);
        SimpleReservoir reservoirOps = new SimpleReservoir("Well 1 reservoir");
        reservoirOps.setReservoirFluid(testSystem, 5.0E7, 5.52E8, 1.0E7);
        StreamInterface producedOilStream = reservoirOps.addOilProducer("oilproducer_1");
        producedOilStream.setFlowRate(5.04E7, "kg/day");
        reservoirOps.run();
        System.out.println("water volume" + reservoirOps.getReservoirFluid().getPhase("aqueous").getVolume("m3") / 1000000.0);
        System.out.println("oil production  total" + reservoirOps.getOilProductionTotal("Sm3") + " Sm3");
        System.out.println("total produced  " + reservoirOps.getProductionTotal("MSm3 oe") + " MSm3 oe");
        SubseaWell well1 = new SubseaWell("oilproducer_1", reservoirOps.getOilProducer("oilproducer_1").getStream());
        well1.getPipeline().setDiameter(0.3);
        well1.getPipeline().setLength(5500.0);
        well1.getPipeline().setInletElevation(-1000.0);
        well1.getPipeline().setOutletElevation(-100.0);
        ThrottlingValve subseaChoke = new ThrottlingValve("subseaChoke", well1.getOutletStream());
        subseaChoke.setOutletPressure(90.0);
        subseaChoke.setAcceptNegativeDP(false);
        SimpleFlowLine flowLine = new SimpleFlowLine("flowLine", subseaChoke.getOutletStream());
        flowLine.getPipeline().setDiameter(0.4);
        flowLine.getPipeline().setLength(2000.0);
        flowLine.getPipeline().setInletElevation(-100.0);
        ThrottlingValve topsideChoke = new ThrottlingValve("topsideChoke", flowLine.getOutletStream());
        topsideChoke.setOutletPressure(50.0, "bara");
        topsideChoke.setAcceptNegativeDP(false);
        Adjuster adjust = new Adjuster("adjust");
        adjust.setActivateWhenLess(true);
        adjust.setTargetVariable(flowLine.getOutletStream(), "pressure", 70.0, "bara");
        adjust.setAdjustedVariable(producedOilStream, "flow rate");
        ProcessSystem ops = new ProcessSystem();
        ops.add(well1);
        ops.add(subseaChoke);
        ops.add(flowLine);
        ops.add(topsideChoke);
        ops.add(adjust);
        ArrayList<double[]> res = new ArrayList<double[]>();
        reservoirOps.runTransient(86400.0);
        ops.run();
        res.add(new double[]{reservoirOps.getTime(), producedOilStream.getFluid().getFlowRate("kg/hr"), reservoirOps.getOilProductionTotal("MSm3 oe")});
        System.out.println("subsea choke DP " + subseaChoke.getDeltaPressure("bara"));
        System.out.println("topside  choke DP " + topsideChoke.getDeltaPressure("bara"));
        System.out.println("oil production " + producedOilStream.getFluid().getFlowRate("kg/hr"));
        ProcessSystem GasOilProcess = ProcessSystem.open("c:/temp/offshorePro.neqsim");
        ((StreamInterface)GasOilProcess.getUnit("well stream")).setThermoSystem(topsideChoke.getOutletStream().getFluid());
        ((StreamInterface)GasOilProcess.getUnit("well stream")).setPressure(70.0, "bara");
        ((StreamInterface)GasOilProcess.getUnit("well stream")).setTemperature(65.0, "C");
        GasOilProcess.run();
        System.out.println("power " + GasOilProcess.getPower("MW"));
        for (int i = 0; i < res.size(); ++i) {
            System.out.println("time " + ((double[])res.get(i))[0] + " oil production " + ((double[])res.get(i))[1] + " total production MSm3 oe " + ((double[])res.get(i))[2]);
        }
    }
}

