/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.tank;

import java.util.UUID;
import neqsim.process.equipment.ProcessEquipmentBaseClass;
import neqsim.process.equipment.mixer.Mixer;
import neqsim.process.equipment.stream.Stream;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.ThermodynamicOperations;

public class Tank
extends ProcessEquipmentBaseClass {
    private static final long serialVersionUID = 1000L;
    SystemInterface thermoSystem;
    SystemInterface gasSystem;
    SystemInterface waterSystem;
    SystemInterface liquidSystem;
    SystemInterface thermoSystemCloned;
    Stream gasOutStream;
    Stream liquidOutStream;
    private int numberOfInputStreams = 0;
    Mixer inletStreamMixer = new Mixer("Separator Inlet Stream Mixer");
    private double efficiency = 1.0;
    private double liquidCarryoverFraction = 0.0;
    private double gasCarryunderFraction = 0.0;
    private double volume = 136000.0;
    double steelWallTemperature = 298.15;
    double steelWallMass = 1840000.0;
    double steelWallArea = 15613.0;
    double heatTransferNumber = 5.0;
    double steelCp = 450.0;
    double separatorLength = 40.0;
    double separatorDiameter = 60.0;
    double liquidVolume = 235.0;
    double gasVolume = 15.0;
    private double liquidLevel = this.liquidVolume / (this.liquidVolume + this.gasVolume);

    public Tank(String name) {
        super(name);
        this.setCalculateSteadyState(false);
    }

    public Tank(String name, StreamInterface inletStream) {
        this(name);
        this.setInletStream(inletStream);
    }

    public void setInletStream(StreamInterface inletStream) {
        this.inletStreamMixer.addStream(inletStream);
        this.thermoSystem = inletStream.getThermoSystem().clone();
        this.gasSystem = this.thermoSystem.phaseToSystem(this.thermoSystem.getPhases()[0]);
        this.gasOutStream = new Stream("gasOutStream", this.gasSystem);
        this.thermoSystem = inletStream.getThermoSystem().clone();
        this.liquidSystem = this.thermoSystem.phaseToSystem(this.thermoSystem.getPhases()[1]);
        this.liquidOutStream = new Stream("liquidOutStream", this.liquidSystem);
    }

    public void addStream(StreamInterface newStream) {
        if (this.numberOfInputStreams == 0) {
            this.setInletStream(newStream);
        } else {
            this.inletStreamMixer.addStream(newStream);
        }
        ++this.numberOfInputStreams;
    }

    public StreamInterface getLiquidOutStream() {
        return this.liquidOutStream;
    }

    public StreamInterface getGasOutStream() {
        return this.gasOutStream;
    }

    public StreamInterface getGas() {
        return this.getGasOutStream();
    }

    public StreamInterface getLiquid() {
        return this.getLiquidOutStream();
    }

    @Override
    public void run(UUID id) {
        this.inletStreamMixer.run(id);
        SystemInterface thermoSystem2 = this.inletStreamMixer.getOutletStream().getThermoSystem().clone();
        ThermodynamicOperations ops = new ThermodynamicOperations(thermoSystem2);
        ops.VUflash(thermoSystem2.getVolume(), thermoSystem2.getInternalEnergy());
        System.out.println("Volume " + thermoSystem2.getVolume() + " internalEnergy " + thermoSystem2.getInternalEnergy());
        this.steelWallTemperature = thermoSystem2.getTemperature();
        if (thermoSystem2.hasPhaseType("gas")) {
            this.gasOutStream.setThermoSystemFromPhase(thermoSystem2, "gas");
        } else {
            this.gasOutStream.setThermoSystemFromPhase(thermoSystem2.getEmptySystemClone(), "gas");
        }
        if (thermoSystem2.hasPhaseType("oil")) {
            this.liquidOutStream.setThermoSystemFromPhase(thermoSystem2, "oil");
        } else {
            this.gasOutStream.setThermoSystemFromPhase(thermoSystem2.getEmptySystemClone(), "oil");
        }
        this.thermoSystem = thermoSystem2.clone();
        this.thermoSystem.setTotalNumberOfMoles(1.0E-10);
        this.thermoSystem.init(1);
        System.out.println("number of phases " + this.thermoSystem.getNumberOfPhases());
        for (int j = 0; j < this.thermoSystem.getNumberOfPhases(); ++j) {
            double relFact = this.gasVolume / (this.thermoSystem.getPhase(j).getVolume() * 1.0E-5);
            if (j == 1) {
                relFact = this.liquidVolume / (this.thermoSystem.getPhase(j).getVolume() * 1.0E-5);
            }
            for (int i = 0; i < this.thermoSystem.getPhase(j).getNumberOfComponents(); ++i) {
                this.thermoSystem.addComponent(this.thermoSystem.getPhase(j).getComponent(i).getComponentName(), relFact * this.thermoSystem.getPhase(j).getComponent(i).getNumberOfMolesInPhase(), j);
            }
        }
        if (thermoSystem2.getNumberOfPhases() == 2) {
            this.thermoSystem.setBeta(this.gasVolume / thermoSystem2.getPhase(0).getMolarVolume() / (this.gasVolume / thermoSystem2.getPhase(0).getMolarVolume() + this.liquidVolume / thermoSystem2.getPhase(1).getMolarVolume()));
        } else {
            this.thermoSystem.setBeta(0.9999999999);
        }
        this.thermoSystem.init(3);
        System.out.println("moles in separator " + this.thermoSystem.getNumberOfMoles());
        double volume1 = this.thermoSystem.getVolume();
        System.out.println("volume1 bef " + volume1);
        System.out.println("beta " + this.thermoSystem.getBeta());
        this.liquidLevel = thermoSystem2.getNumberOfPhases() == 2 ? this.thermoSystem.getPhase(1).getVolume() * 1.0E-5 / (this.liquidVolume + this.gasVolume) : 1.0E-10;
        this.liquidVolume = this.getLiquidLevel() * 3.14 / 4.0 * this.separatorDiameter * this.separatorDiameter * this.separatorLength;
        this.gasVolume = (1.0 - this.getLiquidLevel()) * 3.14 / 4.0 * this.separatorDiameter * this.separatorDiameter * this.separatorLength;
        System.out.println("moles out" + this.liquidOutStream.getThermoSystem().getTotalNumberOfMoles());
        this.setCalculationIdentifier(id);
    }

    @Override
    public void displayResult() {
        this.thermoSystem.display();
    }

    @Override
    public void runTransient(double dt, UUID id) {
        if (this.getCalculateSteadyState()) {
            this.run(id);
            this.increaseTime(dt);
            return;
        }
        this.inletStreamMixer.run(id);
        System.out.println("moles out" + this.liquidOutStream.getThermoSystem().getTotalNumberOfMoles());
        this.thermoSystem.init(3);
        this.gasOutStream.getThermoSystem().init(3);
        this.liquidOutStream.getThermoSystem().init(3);
        this.inletStreamMixer.getOutletStream().getThermoSystem().init(3);
        double volume1 = this.thermoSystem.getVolume();
        System.out.println("volume1 " + volume1);
        double deltaEnergy = this.inletStreamMixer.getOutletStream().getThermoSystem().getEnthalpy() - this.gasOutStream.getThermoSystem().getEnthalpy() - this.liquidOutStream.getThermoSystem().getEnthalpy();
        System.out.println("enthalph delta " + deltaEnergy);
        double wallHeatTransfer = this.heatTransferNumber * this.steelWallArea * (this.steelWallTemperature - this.thermoSystem.getTemperature()) * dt;
        System.out.println("delta temp " + (this.steelWallTemperature - this.thermoSystem.getTemperature()));
        this.steelWallTemperature -= wallHeatTransfer / (this.steelCp * this.steelWallMass);
        System.out.println("wall Temperature " + this.steelWallTemperature);
        double newEnergy = this.thermoSystem.getInternalEnergy() + dt * deltaEnergy + wallHeatTransfer;
        System.out.println("energy cooling " + dt * deltaEnergy);
        System.out.println("energy heating " + wallHeatTransfer / dt + " kW");
        for (int i = 0; i < this.thermoSystem.getPhase(0).getNumberOfComponents(); ++i) {
            double dn = 0.0;
            for (int k = 0; k < this.inletStreamMixer.getOutletStream().getThermoSystem().getNumberOfPhases(); ++k) {
                dn += this.inletStreamMixer.getOutletStream().getThermoSystem().getPhase(k).getComponent(i).getNumberOfMolesInPhase();
            }
            dn = dn - this.gasOutStream.getThermoSystem().getPhase(0).getComponent(i).getNumberOfMolesInPhase() - this.liquidOutStream.getThermoSystem().getPhase(0).getComponent(i).getNumberOfMolesInPhase();
            System.out.println("dn " + dn);
            this.thermoSystem.addComponent(this.inletStreamMixer.getOutletStream().getThermoSystem().getPhase(0).getComponent(i).getComponentName(), dn * dt);
        }
        System.out.println("liquid level " + this.liquidLevel);
        this.liquidVolume = this.getLiquidLevel() * 3.14 / 4.0 * this.separatorDiameter * this.separatorDiameter * this.separatorLength;
        this.gasVolume = (1.0 - this.getLiquidLevel()) * 3.14 / 4.0 * this.separatorDiameter * this.separatorDiameter * this.separatorLength;
        System.out.println("total moles " + this.thermoSystem.getTotalNumberOfMoles());
        ThermodynamicOperations thermoOps = new ThermodynamicOperations(this.thermoSystem);
        thermoOps.VUflash(volume1, newEnergy);
        this.setOutComposition(this.thermoSystem);
        this.setTempPres(this.thermoSystem.getTemperature(), this.thermoSystem.getPressure());
        this.liquidLevel = this.thermoSystem.hasPhaseType("oil") ? this.thermoSystem.getPhase(1).getVolume() * 1.0E-5 / (this.liquidVolume + this.gasVolume) : 1.0E-10;
        System.out.println("liquid level " + this.liquidLevel);
        this.liquidVolume = this.getLiquidLevel() * 3.14 / 4.0 * this.separatorDiameter * this.separatorDiameter * this.separatorLength;
        this.gasVolume = (1.0 - this.getLiquidLevel()) * 3.14 / 4.0 * this.separatorDiameter * this.separatorDiameter * this.separatorLength;
        this.setCalculationIdentifier(id);
    }

    public void setOutComposition(SystemInterface thermoSystem) {
        for (int i = 0; i < thermoSystem.getPhase(0).getNumberOfComponents(); ++i) {
            if (thermoSystem.hasPhaseType("gas")) {
                this.getGasOutStream().getThermoSystem().getPhase(0).getComponent(i).setx(thermoSystem.getPhase(thermoSystem.getPhaseNumberOfPhase("gas")).getComponent(i).getx());
            }
            if (!thermoSystem.hasPhaseType("oil")) continue;
            this.getLiquidOutStream().getThermoSystem().getPhase(0).getComponent(i).setx(thermoSystem.getPhase(thermoSystem.getPhaseNumberOfPhase("oil")).getComponent(i).getx());
        }
    }

    public void setTempPres(double temp, double pres) {
        this.gasOutStream.getThermoSystem().setTemperature(temp);
        this.liquidOutStream.getThermoSystem().setTemperature(temp);
        this.inletStreamMixer.setPressure(pres);
        this.gasOutStream.getThermoSystem().setPressure(pres);
        this.liquidOutStream.getThermoSystem().setPressure(pres);
        UUID id = UUID.randomUUID();
        this.inletStreamMixer.run(id);
        this.gasOutStream.run(id);
        this.liquidOutStream.run(id);
    }

    public double getEfficiency() {
        return this.efficiency;
    }

    public void setEfficiency(double efficiency) {
        this.efficiency = efficiency;
    }

    public double getLiquidCarryoverFraction() {
        return this.liquidCarryoverFraction;
    }

    public void setLiquidCarryoverFraction(double liquidCarryoverFraction) {
        this.liquidCarryoverFraction = liquidCarryoverFraction;
    }

    public double getGasCarryunderFraction() {
        return this.gasCarryunderFraction;
    }

    public void setGasCarryunderFraction(double gasCarryunderFraction) {
        this.gasCarryunderFraction = gasCarryunderFraction;
    }

    public double getLiquidLevel() {
        return this.liquidLevel;
    }

    public double getVolume() {
        return this.volume;
    }

    public void setVolume(double volume) {
        this.volume = volume;
    }
}

