/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.util;

import java.util.ArrayList;
import java.util.UUID;
import neqsim.process.equipment.ProcessEquipmentBaseClass;
import neqsim.process.equipment.ProcessEquipmentInterface;
import neqsim.process.equipment.compressor.Compressor;
import neqsim.process.equipment.splitter.Splitter;
import neqsim.process.equipment.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Calculator
extends ProcessEquipmentBaseClass {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(Calculator.class);
    ArrayList<ProcessEquipmentInterface> inputVariable = new ArrayList();
    private ProcessEquipmentInterface outputVariable;
    String type = "sumTEG";

    public Calculator(String name) {
        super(name);
    }

    public void addInputVariable(ProcessEquipmentInterface unit) {
        this.inputVariable.add(unit);
    }

    public ProcessEquipmentInterface getOutputVariable() {
        return this.outputVariable;
    }

    public void runAntiSurgeCalc(UUID id) {
        Compressor compressor = (Compressor)this.inputVariable.get(0);
        Splitter anitSurgeSplitter = (Splitter)this.outputVariable;
        double distToSurge = compressor.getDistanceToSurge();
        double flowInAntiSurge = anitSurgeSplitter.getSplitStream(1).getFlowRate("MSm3/day");
        flowInAntiSurge = anitSurgeSplitter.getSplitStream(1).getFlowRate("MSm3/day") - compressor.getInletStream().getFlowRate("MSm3/day") * distToSurge * 0.5;
        if (flowInAntiSurge > compressor.getInletStream().getFlowRate("MSm3/day")) {
            flowInAntiSurge = compressor.getInletStream().getFlowRate("MSm3/day") * 0.99;
        }
        if (flowInAntiSurge < 1.0E-6) {
            flowInAntiSurge = 1.0E-6;
        }
        anitSurgeSplitter.setFlowRates(new double[]{-1.0, flowInAntiSurge}, "MSm3/day");
        anitSurgeSplitter.run();
        anitSurgeSplitter.setCalculationIdentifier(id);
    }

    @Override
    public void run(UUID id) {
        int i;
        double sum = 0.0;
        if (this.name.equals("anti surge calculator")) {
            this.runAntiSurgeCalc(id);
            return;
        }
        if (this.name.equals("MEG makeup calculator")) {
            for (i = 0; i < this.inputVariable.size(); ++i) {
                sum += this.inputVariable.get(i).getFluid().getPhase(0).getComponent("MEG").getFlowRate("kg/hr");
            }
        } else {
            for (i = 0; i < this.inputVariable.size(); ++i) {
                sum += this.inputVariable.get(i).getFluid().getComponent("TEG").getFlowRate("kg/hr");
            }
        }
        try {
            if (sum < 0.0) {
                sum = 0.0;
            }
            ((Stream)this.outputVariable).setFlowRate(sum, "kg/hr");
            this.outputVariable.run();
            this.outputVariable.setCalculationIdentifier(id);
        }
        catch (Exception ex) {
            logger.info("flow rate error " + sum);
            logger.error("error in calculator", (Throwable)ex);
        }
        this.setCalculationIdentifier(id);
    }

    public void setOutputVariable(ProcessEquipmentInterface outputVariable) {
        this.outputVariable = outputVariable;
    }
}

