/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.util;

import java.util.UUID;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.process.equipment.valve.ThrottlingValve;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.ThermodynamicOperations;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PressureDrop
extends ThrottlingValve {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(PressureDrop.class);
    SystemInterface thermoSystem;
    double pressureDrop = 0.1;

    public PressureDrop(String name) {
        super(name);
    }

    public void setPressureDrop(double pressureDrop, String unit) {
        if (unit.equals("bara")) {
            this.pressureDrop = pressureDrop;
        } else if (unit.equals("Pa")) {
            this.pressureDrop = pressureDrop / 100000.0;
        } else {
            throw new RuntimeException("pressure drop unit not supported: " + unit);
        }
    }

    public PressureDrop(String name, StreamInterface inletStream) {
        this(name);
        this.setInletStream(inletStream);
    }

    @Override
    public void run(UUID id) {
        this.thermoSystem = this.getInletStream().getThermoSystem().clone();
        ThermodynamicOperations thermoOps = new ThermodynamicOperations(this.thermoSystem);
        this.thermoSystem.init(3);
        double enthalpy = this.thermoSystem.getEnthalpy();
        this.thermoSystem.setPressure(this.thermoSystem.getPressure() - this.pressureDrop);
        thermoOps.PHflash(enthalpy);
        this.outStream.setFluid(this.thermoSystem);
    }
}

