/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.util;

import java.util.UUID;
import neqsim.process.equipment.ProcessEquipmentBaseClass;
import neqsim.process.equipment.ProcessEquipmentInterface;
import neqsim.process.equipment.stream.Stream;
import neqsim.process.processmodel.ProcessSystem;
import neqsim.thermo.system.SystemSrkEos;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SetPoint
extends ProcessEquipmentBaseClass {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(SetPoint.class);
    ProcessEquipmentInterface sourceEquipment = null;
    ProcessEquipmentInterface targetEquipment = null;
    String sourceVariable = "";
    String targetVariable = "";
    String targetPhase = "";
    String targetComponent = "";
    double targetValue = 0.0;
    String targetUnit = "";
    double inputValue = 0.0;
    double oldInputValue = 0.0;

    @Deprecated
    public SetPoint() {
        this("SetPoint");
    }

    public SetPoint(String name) {
        super(name);
    }

    public SetPoint(String name, ProcessEquipmentInterface targetEquipment, String targetVariable, ProcessEquipmentInterface sourceEquipment) {
        this(name);
        this.targetEquipment = targetEquipment;
        this.targetVariable = targetVariable;
        this.sourceEquipment = sourceEquipment;
    }

    public void setSourceVariable(ProcessEquipmentInterface adjustedEquipment, String adjstedVariable) {
        this.sourceEquipment = adjustedEquipment;
        this.sourceVariable = adjstedVariable;
    }

    public void setSourceVariable(ProcessEquipmentInterface adjustedEquipment) {
        this.sourceEquipment = adjustedEquipment;
    }

    public void setTargetVariable(ProcessEquipmentInterface targetEquipment, String targetVariable, double targetValue, String targetUnit) {
        this.targetEquipment = targetEquipment;
        this.targetVariable = targetVariable;
        this.targetValue = targetValue;
        this.targetUnit = targetUnit;
    }

    public void setTargetVariable(ProcessEquipmentInterface targetEquipment, String targetVariable) {
        this.targetEquipment = targetEquipment;
        this.targetVariable = targetVariable;
    }

    public void setTargetVariable(ProcessEquipmentInterface targetEquipment, String targetVariable, double targetValue, String targetUnit, String targetPhase) {
        this.targetEquipment = targetEquipment;
        this.targetVariable = targetVariable;
        this.targetValue = targetValue;
        this.targetUnit = targetUnit;
        this.targetPhase = targetPhase;
    }

    public void setTargetVariable(ProcessEquipmentInterface targetEquipment, String targetVariable, double targetValue, String targetUnit, String targetPhase, String targetComponent) {
        this.targetEquipment = targetEquipment;
        this.targetVariable = targetVariable;
        this.targetValue = targetValue;
        this.targetUnit = targetUnit;
        this.targetPhase = targetPhase;
        this.targetComponent = targetComponent;
    }

    @Override
    public void run(UUID id) {
        if (this.targetVariable.equals("pressure")) {
            this.targetEquipment.setPressure(this.sourceEquipment.getPressure());
        } else {
            this.inputValue = ((Stream)this.sourceEquipment).getThermoSystem().getNumberOfMoles();
            double targetValueCurrent = ((Stream)this.targetEquipment).getThermoSystem().getVolume(this.targetUnit);
            double deviation = this.targetValue - targetValueCurrent;
            logger.info("adjuster deviation " + deviation + " inputValue " + this.inputValue);
            this.oldInputValue = this.inputValue;
        }
        this.setCalculationIdentifier(id);
    }

    @Override
    public void displayResult() {
    }

    public static void main(String[] args) {
        SystemSrkEos testSystem = new SystemSrkEos(298.15, 20.0);
        testSystem.addComponent("methane", 1000.0);
        testSystem.createDatabase(true);
        testSystem.setMixingRule(2);
        Stream stream_1 = new Stream("Stream1", testSystem);
        SetPoint adjuster1 = new SetPoint();
        adjuster1.setSourceVariable(stream_1, "molarFlow");
        adjuster1.setTargetVariable(stream_1, "gasVolumeFlow", 10.0, "", "MSm3/day");
        ProcessSystem operations = new ProcessSystem();
        operations.add(stream_1);
        operations.add(adjuster1);
        operations.run();
    }
}

