/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.util;

import java.util.UUID;
import neqsim.process.equipment.TwoPortEquipment;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.process.processmodel.ProcessSystem;
import neqsim.thermo.system.SystemInterface;

public class StreamTransition
extends TwoPortEquipment {
    private static final long serialVersionUID = 1L;

    public StreamTransition(String name, StreamInterface inletStream, StreamInterface outletStream) {
        super(name);
        this.inStream = inletStream;
        this.outStream = outletStream;
    }

    @Override
    public void run(UUID id) {
        SystemInterface outThermoSystem = null;
        outThermoSystem = this.outStream != null ? this.outStream.getFluid().clone() : this.inStream.getFluid().clone();
        outThermoSystem.setEmptyFluid();
        for (int i = 0; i < this.inStream.getFluid().getNumberOfComponents(); ++i) {
            if (!outThermoSystem.getPhase(0).hasComponent(this.inStream.getFluid().getComponent(i).getName())) continue;
            outThermoSystem.addComponent(this.inStream.getFluid().getComponent(i).getName(), this.inStream.getFluid().getComponent(i).getNumberOfmoles());
        }
        this.outStream.setThermoSystem(outThermoSystem);
        this.outStream.run(id);
        this.setCalculationIdentifier(id);
    }

    @Override
    public void displayResult() {
        this.outStream.getFluid().display();
    }

    public static void main(String[] args) {
        ProcessSystem offshoreProcessoperations = ProcessSystem.open("c:/temp/offshorePro.neqsim");
        ProcessSystem TEGprocess = ProcessSystem.open("c:/temp//TEGprocessHX.neqsim");
        StreamTransition trans = new StreamTransition("tmp", (StreamInterface)offshoreProcessoperations.getUnit("rich gas"), (StreamInterface)TEGprocess.getUnit("dry feed gas"));
        UUID id = UUID.randomUUID();
        offshoreProcessoperations.run(id);
        trans.run(id);
        ((StreamInterface)offshoreProcessoperations.getUnit("rich gas")).displayResult();
        trans.displayResult();
        TEGprocess.run(id);
        ((StreamInterface)TEGprocess.getUnit("dry feed gas")).displayResult();
    }
}

