/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.valve;

import com.google.gson.GsonBuilder;
import java.util.UUID;
import neqsim.physicalproperties.PhysicalPropertyType;
import neqsim.process.equipment.TwoPortEquipment;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.process.equipment.valve.ValveInterface;
import neqsim.process.mechanicaldesign.valve.ValveMechanicalDesign;
import neqsim.process.util.monitor.ValveResponse;
import neqsim.thermo.phase.PhaseType;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.ThermodynamicOperations;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ThrottlingValve
extends TwoPortEquipment
implements ValveInterface {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(ThrottlingValve.class);
    SystemInterface thermoSystem;
    private boolean valveCvSet = false;
    private boolean isoThermal = false;
    double pressure = 0.0;
    private double Cv;
    private double maxMolarFlow = 1000.0;
    private double minMolarFlow = 0.0;
    private double maxValveOpening = 100.0;
    private double minValveOpening = 0.0;
    private double percentValveOpening = 100.0;
    double molarFlow = 0.0;
    private String pressureUnit = "bara";
    private boolean acceptNegativeDP = true;
    ValveMechanicalDesign valveMechanicalDesign;
    boolean isCalcPressure = false;
    private boolean gasValve = true;
    private double Fp = 1.0;

    public ThrottlingValve(String name) {
        super(name);
        this.setCalculateSteadyState(false);
    }

    public ThrottlingValve(String name, StreamInterface inletStream) {
        this(name);
        this.setInletStream(inletStream);
    }

    public double getDeltaPressure(String unit) {
        return this.inStream.getFluid().getPressure(unit) - this.thermoSystem.getPressure(unit);
    }

    @Override
    public double getOutletPressure() {
        return this.pressure;
    }

    @Override
    public SystemInterface getThermoSystem() {
        return this.thermoSystem;
    }

    @Override
    public double getInletPressure() {
        return this.getInletStream().getThermoSystem().getPressure();
    }

    @Override
    public void setPressure(double pressure) {
        this.setOutletPressure(pressure);
    }

    public void setPressure(double pressure, String unit) {
        this.setOutletPressure(pressure, unit);
    }

    @Override
    public void setOutletPressure(double pressure) {
        this.pressure = pressure;
        this.getOutletStream().getThermoSystem().setPressure(pressure, this.pressureUnit);
    }

    public void setOutletPressure(double pressure, String unit) {
        this.pressureUnit = unit;
        this.pressure = pressure;
        this.getOutletStream().getThermoSystem().setPressure(pressure, this.pressureUnit);
    }

    @Override
    public boolean needRecalculation() {
        return this.getInletStream().getThermoSystem().getTemperature() != this.thermoSystem.getTemperature() || this.getInletStream().getThermoSystem().getPressure() != this.thermoSystem.getPressure() || this.getInletStream().getThermoSystem().getFlowRate("kg/hr") != this.thermoSystem.getFlowRate("kg/hr") || this.getOutletPressure() != this.getOutletStream().getPressure();
    }

    private static double adjustCv(double Cv, double percentValveOpening) {
        return Cv * (percentValveOpening / 100.0);
    }

    public static double liquidValveMassFlow(double P1, double P2, double rho, double Cv, double Fp, double percentValveOpening) {
        double N1 = 0.0865;
        double P1Pa = P1 * 100000.0;
        double P2Pa = P2 * 100000.0;
        double adjustedCv = ThrottlingValve.adjustCv(Cv, percentValveOpening);
        double clippedCv = Math.max(adjustedCv, 0.0);
        double deltaP = Math.max(P1Pa - P2Pa, 0.0);
        double massFlowRate = clippedCv * 0.0865 * Fp * Math.sqrt(deltaP * rho);
        return massFlowRate;
    }

    public static double calcPercentValveOpeningLiquid(double massFlowRate, double P1, double P2, double rho, double Cv, double Fp) {
        double N1 = 0.0865;
        double P1Pa = P1 * 100000.0;
        double P2Pa = P2 * 100000.0;
        double deltaP = Math.max(P1Pa - P2Pa, 0.0);
        double denominator = Cv * 0.0865 * Fp * Math.sqrt(deltaP * rho);
        double percentValveOpening = massFlowRate / denominator * 100.0;
        return percentValveOpening;
    }

    public static double liquidValvePout(double P1, double m, double rho, double Cv, double Fp, double percentValveOpening) {
        double N1 = 0.0865;
        double P1Pa = P1 * 100000.0;
        double adjustedCv = ThrottlingValve.adjustCv(Cv, percentValveOpening);
        double clippedCv = Math.max(adjustedCv, 0.0);
        double deltaP = Math.pow(m / (clippedCv * 0.0865 * Fp), 2.0) / rho;
        double P2Pa = P1Pa - deltaP;
        P2Pa = Math.max(P2Pa, 0.0);
        return P2Pa / 100000.0;
    }

    public static double liquidValveCv(double P1, double P2, double rho, double m, double Fp, double percentValveOpening) {
        double N1 = 0.0865;
        double P1Pa = P1 * 100000.0;
        double P2Pa = P2 * 100000.0;
        double deltaP = Math.max(P1Pa - P2Pa, 0.0);
        double Cv = m / (0.0865 * Fp * Math.sqrt(deltaP * rho));
        return Cv / (percentValveOpening / 100.0);
    }

    public double calcmassflow(double Pus, double Pds, double rhous, double Cv, double percentValveOpening) {
        double sineFactor = Math.sin(113.9);
        double massFlowRate = 0.0457 * Math.sqrt(Pus * 100.0 * rhous) * sineFactor * Math.sqrt((Pus - Pds) / Pus) * Cv * percentValveOpening / 100.0;
        return massFlowRate;
    }

    public double calcValvePout(double Pus, double rhous, double Cv, double massFlowRate, double percentValveOpening) {
        double sineFactor = Math.sin(113.9);
        double flowTerm = massFlowRate / (0.0457 * Math.sqrt(Pus * 100.0 * rhous) * sineFactor * Cv * (percentValveOpening / 100.0));
        double flowTermSquared = flowTerm * flowTerm;
        double Pds = Pus * (1.0 - flowTermSquared);
        return Pds;
    }

    public double calcCv(double Pus, double Pds, double rhous, double massFlowRate, double percentValveOpening) {
        double sineFactor = Math.sin(113.9);
        double Cv = massFlowRate / (0.0457 * Math.sqrt(Pus * 100.0 * rhous) * sineFactor * Math.sqrt((Pus - Pds) / Pus) * percentValveOpening / 100.0);
        return Cv;
    }

    public double calcPercentValveOpening(double Pus, double Pds, double rhous, double Cv, double massFlowRate) {
        double sineFactor = Math.sin(113.9);
        double term = massFlowRate / (0.0457 * Math.sqrt(Pus * 100.0 * rhous) * sineFactor * Cv);
        double percentValveOpening = term / Math.sqrt(1.0 - Pds / Pus) * 100.0;
        return percentValveOpening;
    }

    @Override
    public void run(UUID id) {
        this.thermoSystem = this.getInletStream().getThermoSystem().clone();
        ThermodynamicOperations thermoOps = new ThermodynamicOperations(this.thermoSystem);
        this.thermoSystem.init(3);
        double enthalpy = this.thermoSystem.getEnthalpy();
        this.inStream.getThermoSystem().initPhysicalProperties(PhysicalPropertyType.MASS_DENSITY);
        double outp = 0.0;
        if (this.inStream.getThermoSystem().hasPhaseType(PhaseType.GAS) && this.inStream.getThermoSystem().getVolumeFraction(0) > 0.9) {
            this.setGasValve(true);
        } else {
            this.setGasValve(false);
        }
        if (this.valveCvSet && this.isCalcPressure) {
            outp = this.gasValve ? this.calcValvePout(this.inStream.getThermoSystem().getPressure(), this.inStream.getThermoSystem().getDensity("kg/m3"), this.Cv, this.inStream.getFlowRate("kg/hr"), this.percentValveOpening) : ThrottlingValve.liquidValvePout(this.inStream.getThermoSystem().getPressure(), this.inStream.getFlowRate("kg/hr"), this.inStream.getThermoSystem().getDensity("kg/m3"), this.Cv, this.Fp, this.percentValveOpening);
            this.setOutletPressure(outp);
        }
        if (this.thermoSystem.getPressure(this.pressureUnit) - this.pressure < 0.0) {
            if (this.isAcceptNegativeDP()) {
                this.thermoSystem.setPressure(this.pressure, this.pressureUnit);
            }
        } else {
            this.thermoSystem.setPressure(this.pressure, this.pressureUnit);
        }
        if (this.getSpecification().equals("out stream")) {
            this.thermoSystem.setPressure(this.outStream.getPressure(), this.pressureUnit);
        }
        if (this.isIsoThermal() || Math.abs(this.pressure - this.inStream.getThermoSystem().getPressure()) < 1.0E-6 || this.thermoSystem.getNumberOfMoles() < 1.0E-12) {
            thermoOps.TPflash();
        } else {
            thermoOps.PHflash(enthalpy, 0);
        }
        this.outStream.setThermoSystem(this.thermoSystem);
        if (!this.valveCvSet) {
            this.Cv = this.gasValve ? this.calcCv(this.inStream.getThermoSystem().getPressure(), this.outStream.getThermoSystem().getPressure(), this.inStream.getFluid().getDensity("kg/m3"), this.inStream.getFlowRate("kg/hr"), this.percentValveOpening) : ThrottlingValve.liquidValveCv(this.inStream.getThermoSystem().getPressure(), this.outStream.getThermoSystem().getPressure(), this.inStream.getFluid().getDensity("kg/m3"), this.inStream.getFlowRate("kg/hr"), this.Fp, this.percentValveOpening);
            this.valveCvSet = true;
        }
        this.percentValveOpening = this.gasValve ? this.calcPercentValveOpening(this.inStream.getThermoSystem().getPressure(), this.outStream.getThermoSystem().getPressure(), this.inStream.getFluid().getDensity("kg/m3"), this.Cv, this.inStream.getFlowRate("kg/hr")) : ThrottlingValve.calcPercentValveOpeningLiquid(this.inStream.getFlowRate("kg/hr"), this.inStream.getThermoSystem().getPressure(), this.outStream.getThermoSystem().getPressure(), this.inStream.getFluid().getDensity("kg/m3"), this.Cv, this.Fp);
        this.molarFlow = this.gasValve ? this.calcmassflow(this.inStream.getThermoSystem().getPressure(), this.outStream.getThermoSystem().getPressure(), this.inStream.getFluid().getDensity("kg/m3"), this.Cv, this.percentValveOpening) / 3600.0 / this.inStream.getFluid().getMolarMass("kg/mol") : ThrottlingValve.liquidValveMassFlow(this.inStream.getThermoSystem().getPressure(), this.outStream.getThermoSystem().getPressure(), this.inStream.getFluid().getDensity("kg/m3"), this.Cv, this.Fp, this.percentValveOpening) / 3600.0 / this.inStream.getFluid().getMolarMass("kg/mol");
        if (Math.abs(this.pressure - this.inStream.getThermoSystem().getPressure()) < 1.0E-6) {
            this.molarFlow = this.inStream.getThermoSystem().getTotalNumberOfMoles();
        }
        try {
            this.inStream.getThermoSystem().setTotalNumberOfMoles(this.molarFlow);
            this.inStream.getThermoSystem().init(3);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
        }
        this.outStream.setThermoSystem(this.thermoSystem.clone());
        this.outStream.getThermoSystem().setTotalNumberOfMoles(this.molarFlow);
        this.outStream.getThermoSystem().init(3);
        this.outStream.setCalculationIdentifier(id);
        this.setCalculationIdentifier(id);
    }

    @Override
    public void displayResult() {
        this.thermoSystem.display(this.getName());
    }

    @Override
    public String[][] getResultTable() {
        return this.thermoSystem.getResultTable();
    }

    @Override
    public void runTransient(double dt, UUID id) {
        if (this.getCalculateSteadyState()) {
            this.run(id);
            this.increaseTime(dt);
            return;
        }
        this.runController(dt, id);
        this.thermoSystem = this.inStream.getThermoSystem().clone();
        ThermodynamicOperations thermoOps = new ThermodynamicOperations(this.thermoSystem);
        this.thermoSystem.init(3);
        double enthalpy = this.thermoSystem.getEnthalpy();
        this.thermoSystem.setPressure(this.getOutletStream().getThermoSystem().getPressure());
        if (this.isIsoThermal()) {
            thermoOps.TPflash();
        } else {
            thermoOps.PHflash(enthalpy, 0);
        }
        this.thermoSystem.initPhysicalProperties(PhysicalPropertyType.MASS_DENSITY);
        this.outStream.setThermoSystem(this.thermoSystem);
        this.molarFlow = this.gasValve ? this.calcmassflow(this.inStream.getThermoSystem().getPressure(), this.outStream.getThermoSystem().getPressure(), this.inStream.getFluid().getDensity("kg/m3"), this.Cv, this.percentValveOpening) / 3600.0 / this.inStream.getFluid().getMolarMass("kg/mol") : ThrottlingValve.liquidValveMassFlow(this.inStream.getThermoSystem().getPressure(), this.outStream.getThermoSystem().getPressure(), this.inStream.getFluid().getDensity("kg/m3"), this.Cv, this.Fp, this.percentValveOpening) / 3600.0 / this.inStream.getFluid().getMolarMass("kg/mol");
        try {
            this.inStream.getThermoSystem().setTotalNumberOfMoles(this.molarFlow);
            this.inStream.getThermoSystem().init(1);
            this.inStream.run(id);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
        }
        try {
            this.outStream.getThermoSystem().setTotalNumberOfMoles(this.molarFlow);
            this.outStream.getThermoSystem().init(1);
            this.outStream.run(id);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
        }
        this.setCalculationIdentifier(id);
    }

    public void runController(double dt, UUID id) {
        if (this.hasController && this.getController().isActive()) {
            this.getController().runTransient(this.percentValveOpening, dt, id);
            this.percentValveOpening = this.getController().getResponse();
            if (this.percentValveOpening > this.maxValveOpening) {
                this.percentValveOpening = this.maxValveOpening;
            }
            if (this.percentValveOpening < this.minValveOpening) {
                this.percentValveOpening = this.minValveOpening;
            }
        }
        this.setCalculationIdentifier(id);
    }

    public void setMinimumValveOpening(double minopen) {
        this.minValveOpening = minopen;
    }

    @Override
    public double getCv() {
        return this.Cv;
    }

    @Override
    public double getCv(String unit) {
        if (unit.equals("US")) {
            return this.Cv / 54.9;
        }
        return this.Cv;
    }

    @Override
    public void setCv(double cv) {
        this.Cv = cv;
        this.valveCvSet = true;
    }

    @Override
    public void setCv(double cv, String unit) {
        this.Cv = unit.equals("US") ? cv * 54.9 : cv;
        this.valveCvSet = true;
    }

    @Override
    public double getPercentValveOpening() {
        return this.percentValveOpening;
    }

    @Override
    public void setPercentValveOpening(double percentValveOpening) {
        this.percentValveOpening = percentValveOpening;
    }

    public boolean isValveCvSet() {
        return this.valveCvSet;
    }

    public void setValveCvSet(boolean valveCvSet) {
        this.valveCvSet = valveCvSet;
    }

    @Override
    public boolean isIsoThermal() {
        return this.isoThermal;
    }

    @Override
    public void setIsoThermal(boolean isoThermal) {
        this.isoThermal = isoThermal;
    }

    @Override
    public double getEntropyProduction(String unit) {
        this.outStream.getThermoSystem().init(3);
        this.inStream.getThermoSystem().init(3);
        return this.outStream.getThermoSystem().getEntropy(unit) - this.inStream.getThermoSystem().getEntropy(unit);
    }

    @Override
    public double getExergyChange(String unit, double surroundingTemperature) {
        this.outStream.getThermoSystem().init(3);
        this.inStream.getThermoSystem().init(3);
        return this.outStream.getThermoSystem().getExergy(surroundingTemperature, unit) - this.inStream.getThermoSystem().getExergy(surroundingTemperature, unit);
    }

    public boolean isAcceptNegativeDP() {
        return this.acceptNegativeDP;
    }

    public void setAcceptNegativeDP(boolean acceptNegativeDP) {
        this.acceptNegativeDP = acceptNegativeDP;
    }

    @Override
    public void initMechanicalDesign() {
        this.valveMechanicalDesign = new ValveMechanicalDesign(this);
    }

    @Override
    public ValveMechanicalDesign getMechanicalDesign() {
        return this.valveMechanicalDesign;
    }

    public void setIsCalcOutPressure(boolean isSetPres) {
        this.isCalcPressure = isSetPres;
    }

    @Override
    public String toJson() {
        return new GsonBuilder().create().toJson(new ValveResponse(this));
    }

    public boolean isGasValve() {
        return this.gasValve;
    }

    public void setGasValve(boolean gasValve) {
        this.gasValve = gasValve;
    }

    public double getFp() {
        return this.Fp;
    }

    public void setFp(double fp) {
        this.Fp = fp;
    }
}

