/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.measurementdevice;

import java.util.HashMap;
import java.util.Map;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.process.measurementdevice.StreamMeasurementDeviceBaseClass;

public class CombustionEmissionsCalculator
extends StreamMeasurementDeviceBaseClass {
    private static final long serialVersionUID = 1L;
    private static final Map<String, Double> NATURAL_GAS_COMPOSITION = new HashMap<String, Double>();
    private static final Map<String, Double> CO2_EMISSIONS_FACTORS = new HashMap<String, Double>();

    public CombustionEmissionsCalculator(StreamInterface stream) {
        this("EmissionCalculator", stream);
    }

    public CombustionEmissionsCalculator(String name, StreamInterface stream) {
        super(name, "kg/hr", stream);
    }

    public void setComponents() {
        NATURAL_GAS_COMPOSITION.clear();
        CO2_EMISSIONS_FACTORS.clear();
        if (this.stream.getFluid().getPhase(0).hasComponent("methane")) {
            NATURAL_GAS_COMPOSITION.put("Methane", this.stream.getFluid().getComponent("methane").getz());
            CO2_EMISSIONS_FACTORS.put("Methane", 2.75);
        }
        if (this.stream.getFluid().getPhase(0).hasComponent("ethane")) {
            NATURAL_GAS_COMPOSITION.put("Ethane", this.stream.getFluid().getComponent("ethane").getz());
            CO2_EMISSIONS_FACTORS.put("Ethane", 3.75);
        }
        if (this.stream.getFluid().getPhase(0).hasComponent("propane")) {
            NATURAL_GAS_COMPOSITION.put("Propane", this.stream.getFluid().getComponent("propane").getz());
            CO2_EMISSIONS_FACTORS.put("Propane", 5.5);
        }
        if (this.stream.getFluid().getPhase(0).hasComponent("n-butane")) {
            NATURAL_GAS_COMPOSITION.put("n-butane", this.stream.getFluid().getComponent("n-butane").getz());
            CO2_EMISSIONS_FACTORS.put("n-butane", 6.5);
        }
        if (this.stream.getFluid().getPhase(0).hasComponent("i-butane")) {
            NATURAL_GAS_COMPOSITION.put("i-butane", this.stream.getFluid().getComponent("i-butane").getz());
            CO2_EMISSIONS_FACTORS.put("i-butane", 6.5);
        }
    }

    @Override
    public double getMeasuredValue(String unit) {
        this.setComponents();
        return CombustionEmissionsCalculator.calculateCO2Emissions(NATURAL_GAS_COMPOSITION, CO2_EMISSIONS_FACTORS) * this.stream.getFluid().getFlowRate(unit);
    }

    public static double calculateCO2Emissions(Map<String, Double> composition, Map<String, Double> emissionsFactors) {
        double totalEmissions = 0.0;
        for (Map.Entry<String, Double> entry : composition.entrySet()) {
            String component = entry.getKey();
            double molePercent = entry.getValue();
            double emissionsFactor = emissionsFactors.get(component);
            double componentEmissions = molePercent * emissionsFactor;
            totalEmissions += componentEmissions;
        }
        return totalEmissions;
    }
}

