/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.measurementdevice;

import neqsim.process.equipment.stream.StreamInterface;
import neqsim.process.measurementdevice.StreamMeasurementDeviceBaseClass;
import neqsim.util.exception.InvalidInputException;

public class MolarMassAnalyser
extends StreamMeasurementDeviceBaseClass {
    private static final long serialVersionUID = 1000L;

    public MolarMassAnalyser(StreamInterface stream) {
        this("molar mass analyser", stream);
    }

    public MolarMassAnalyser(String name, StreamInterface stream) {
        super(name, "gr/mol", stream);
    }

    @Override
    public void displayResult() {
        System.out.println("measured Molar mass " + this.getMeasuredValue());
    }

    @Override
    public double getMeasuredValue(String unit) {
        if (!unit.equalsIgnoreCase("gr/mol")) {
            throw new RuntimeException(new InvalidInputException(this, "getMeasuredValue", "unit", "currently only supports \"gr/mol\""));
        }
        return this.stream.getThermoSystem().getMolarMass() * 1000.0;
    }
}

