/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.measurementdevice;

import neqsim.process.equipment.stream.StreamInterface;
import neqsim.process.measurementdevice.StreamMeasurementDeviceBaseClass;

public class VolumeFlowTransmitter
extends StreamMeasurementDeviceBaseClass {
    private static final long serialVersionUID = 1000L;
    private int measuredPhaseNumber = 0;

    public VolumeFlowTransmitter(StreamInterface stream) {
        this("volume flow rate", stream);
    }

    public VolumeFlowTransmitter(String name, StreamInterface stream) {
        super(name, "m^3/hr", stream);
    }

    @Override
    public void displayResult() {
        System.out.println("measured volume " + Double.toString(this.getMeasuredValue()) + " " + this.unit);
    }

    @Override
    public double getMeasuredValue(String unit) {
        this.stream.getThermoSystem().initPhysicalProperties();
        if (unit.equals("kg/hr")) {
            return this.stream.getFlowRate(unit);
        }
        if (unit.equals("m^3/hr")) {
            return this.stream.getThermoSystem().getPhase(this.measuredPhaseNumber).getNumberOfMolesInPhase() * this.stream.getThermoSystem().getPhase(this.measuredPhaseNumber).getMolarMass() / this.stream.getThermoSystem().getPhase(this.measuredPhaseNumber).getPhysicalProperties().getDensity() * 3600.0;
        }
        if (unit.equals("Nm^3/day")) {
            return this.stream.getThermoSystem().getPhase(this.measuredPhaseNumber).getNumberOfMolesInPhase() * 8.3144621 * 273.15 / 101325.0 * 3600.0 * 24.0;
        }
        if (unit.equals("Sm^3/day")) {
            return this.stream.getThermoSystem().getPhase(this.measuredPhaseNumber).getNumberOfMolesInPhase() * 8.3144621 * 288.15 / 101325.0 * 3600.0 * 24.0;
        }
        return this.stream.getThermoSystem().getPhase(this.measuredPhaseNumber).getNumberOfMolesInPhase() * this.stream.getThermoSystem().getPhase(this.measuredPhaseNumber).getMolarMass() / this.stream.getThermoSystem().getPhase(this.measuredPhaseNumber).getPhysicalProperties().getDensity() * 3600.0;
    }

    public int getMeasuredPhaseNumber() {
        return this.measuredPhaseNumber;
    }

    public void setMeasuredPhaseNumber(int measuredPhase) {
        this.measuredPhaseNumber = measuredPhase;
    }
}

