/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.measurementdevice;

import neqsim.process.equipment.stream.StreamInterface;
import neqsim.process.measurementdevice.StreamMeasurementDeviceBaseClass;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.util.empiric.BukacekWaterInGas;
import neqsim.thermodynamicoperations.ThermodynamicOperations;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WaterDewPointAnalyser
extends StreamMeasurementDeviceBaseClass {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(WaterDewPointAnalyser.class);
    private double referencePressure = 70.0;
    private String method = "Bukacek";

    public WaterDewPointAnalyser(StreamInterface stream) {
        this("WaterDewPointAnalyser", stream);
    }

    public WaterDewPointAnalyser(String name, StreamInterface stream) {
        super(name, "K", stream);
        this.setConditionAnalysisMaxDeviation(1.0);
    }

    @Override
    public void displayResult() {
    }

    @Override
    public double getMeasuredValue(String unit) {
        if (this.method.equals("Bukacek")) {
            SystemInterface tempFluid = this.stream.getThermoSystem().clone();
            tempFluid.setTemperature(BukacekWaterInGas.waterDewPointTemperature(tempFluid.getComponent("water").getx(), this.referencePressure));
            return tempFluid.getTemperature(unit);
        }
        if (this.method.equals("multiphase")) {
            SystemInterface tempFluid = this.stream.getThermoSystem().clone();
            tempFluid.setPressure(this.referencePressure);
            tempFluid.setTemperature(0.1, "C");
            ThermodynamicOperations thermoOps = new ThermodynamicOperations(tempFluid);
            try {
                thermoOps.waterDewPointTemperatureMultiphaseFlash();
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            return tempFluid.getTemperature(unit);
        }
        SystemInterface tempFluid = this.stream.getThermoSystem().clone();
        SystemInterface tempFluid2 = tempFluid.setModel("GERG-water-EOS");
        tempFluid2.setPressure(this.referencePressure);
        tempFluid2.setTemperature(-17.0, "C");
        ThermodynamicOperations thermoOps = new ThermodynamicOperations(tempFluid2);
        try {
            thermoOps.waterDewPointTemperatureFlash();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return tempFluid2.getTemperature(unit);
    }

    public double getReferencePressure() {
        return this.referencePressure;
    }

    public void setReferencePressure(double referencePressure) {
        this.referencePressure = referencePressure;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }
}

