/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.measurementdevice;

import neqsim.process.equipment.stream.StreamInterface;
import neqsim.process.measurementdevice.StreamMeasurementDeviceBaseClass;

public class WellAllocator
extends StreamMeasurementDeviceBaseClass {
    private static final long serialVersionUID = 1L;
    protected StreamInterface exportGasStream = null;
    protected StreamInterface exportOilStream = null;

    public WellAllocator(StreamInterface stream) {
        this("Well Allocator", stream);
    }

    public WellAllocator(String name, StreamInterface stream) {
        super(name, "kg/hr", stream);
    }

    public void setExportGasStream(StreamInterface stream) {
        this.exportGasStream = stream;
    }

    public void setExportOilStream(StreamInterface stream) {
        this.exportOilStream = stream;
    }

    @Override
    public double getMeasuredValue(String unit) {
        return this.stream.getThermoSystem().getFlowRate(unit);
    }

    public double getMeasuredValue(String measurement, String unit) {
        int numberOfComps = this.stream.getThermoSystem().getNumberOfComponents();
        double[] splitFactors = new double[numberOfComps];
        double gasExportFlow = 0.0;
        double oilExportFlow = 0.0;
        for (int i = 0; i < numberOfComps; ++i) {
            splitFactors[i] = this.exportGasStream.getFluid().getComponent(i).getFlowRate("kg/hr") / (this.exportGasStream.getFluid().getComponent(i).getFlowRate("kg/hr") + this.exportOilStream.getFluid().getComponent(i).getFlowRate("kg/hr"));
            gasExportFlow += this.stream.getFluid().getComponent(i).getTotalFlowRate(unit) * splitFactors[i];
            oilExportFlow += this.stream.getFluid().getComponent(i).getTotalFlowRate(unit) * (1.0 - splitFactors[i]);
        }
        if (measurement.equals("gas export rate")) {
            return gasExportFlow;
        }
        if (measurement.equals("oil export rate")) {
            return oilExportFlow;
        }
        if (measurement.equals("total export rate")) {
            return this.stream.getFluid().getFlowRate(unit);
        }
        return 0.0;
    }
}

