/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.mechanicaldesign;

import java.awt.BorderLayout;
import java.awt.Container;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Objects;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import neqsim.process.costestimation.UnitCostEstimateBaseClass;
import neqsim.process.equipment.ProcessEquipmentInterface;
import neqsim.process.mechanicaldesign.designstandards.AdsorptionDehydrationDesignStandard;
import neqsim.process.mechanicaldesign.designstandards.CompressorDesignStandard;
import neqsim.process.mechanicaldesign.designstandards.DesignStandard;
import neqsim.process.mechanicaldesign.designstandards.GasScrubberDesignStandard;
import neqsim.process.mechanicaldesign.designstandards.JointEfficiencyPlateStandard;
import neqsim.process.mechanicaldesign.designstandards.MaterialPipeDesignStandard;
import neqsim.process.mechanicaldesign.designstandards.MaterialPlateDesignStandard;
import neqsim.process.mechanicaldesign.designstandards.PipelineDesignStandard;
import neqsim.process.mechanicaldesign.designstandards.PressureVesselDesignStandard;
import neqsim.process.mechanicaldesign.designstandards.SeparatorDesignStandard;

public class MechanicalDesign
implements Serializable {
    private static final long serialVersionUID = 1000L;
    private boolean hasSetCompanySpecificDesignStandards = false;
    private double maxOperationPressure = 100.0;
    private double minOperationPressure = 1.0;
    private double maxOperationTemperature = 100.0;
    private double minOperationTemperature = 1.0;
    public double maxDesignVolumeFlow = 0.0;
    public double minDesignVolumeFLow = 0.0;
    public double maxDesignGassVolumeFlow = 0.0;
    public double minDesignGassVolumeFLow = 0.0;
    public double maxDesignOilVolumeFlow = 0.0;
    public double minDesignOilFLow = 0.0;
    public double maxDesignWaterVolumeFlow = 0.0;
    public double minDesignWaterVolumeFLow = 0.0;
    private String companySpecificDesignStandards = "Statoil";
    private ProcessEquipmentInterface processEquipment = null;
    private double tensileStrength = 483.0;
    private double jointEfficiency = 1.0;
    private MaterialPlateDesignStandard materialPlateDesignStandard = new MaterialPlateDesignStandard();
    private MaterialPipeDesignStandard materialPipeDesignStandard = new MaterialPipeDesignStandard();
    private String construtionMaterial = "steel";
    private double corrosionAllowanse = 0.0;
    private double pressureMarginFactor = 0.1;
    public double innerDiameter = 0.0;
    public double outerDiameter = 0.0;
    public double wallThickness = 0.0;
    public double tantanLength = 0.0;
    private double weightTotal = 0.0;
    private double volumeTotal = 2.0;
    public double weigthInternals = 0.0;
    public double weightNozzle = 0.0;
    public double weightPiping = 0.0;
    public double weightElectroInstrument = 0.0;
    public double weightStructualSteel = 0.0;
    public double weightVessel = 0.0;
    public double weigthVesselShell = 0.0;
    public double moduleHeight = 0.0;
    public double moduleWidth = 0.0;
    public double moduleLength = 0.0;
    public Hashtable<String, DesignStandard> designStandard = new Hashtable();
    public UnitCostEstimateBaseClass costEstimate = null;
    double defaultLiquidDensity = 1000.0;
    double defaultLiquidViscosity = 0.001012;

    public MaterialPipeDesignStandard getMaterialPipeDesignStandard() {
        return this.materialPipeDesignStandard;
    }

    public void setMaterialPipeDesignStandard(MaterialPipeDesignStandard materialPipeDesignStandard) {
        this.materialPipeDesignStandard = materialPipeDesignStandard;
    }

    public MaterialPlateDesignStandard getMaterialDesignStandard() {
        return this.materialPlateDesignStandard;
    }

    public void setMaterialDesignStandard(MaterialPlateDesignStandard materialDesignStandard) {
        this.materialPlateDesignStandard = materialDesignStandard;
    }

    public MechanicalDesign(ProcessEquipmentInterface processEquipment) {
        this.processEquipment = processEquipment;
        this.costEstimate = new UnitCostEstimateBaseClass(this);
    }

    public double getMaxOperationPressure() {
        return this.maxOperationPressure;
    }

    public double getMaxDesignPressure() {
        return this.getMaxOperationPressure() * (1.0 + this.pressureMarginFactor);
    }

    public double getMinDesignPressure() {
        return this.getMinOperationPressure() * (1.0 - this.pressureMarginFactor);
    }

    public void readDesignSpecifications() {
    }

    public void setMaxOperationPressure(double maxPressure) {
        this.maxOperationPressure = maxPressure;
    }

    public double getMinOperationPressure() {
        return this.minOperationPressure;
    }

    public void setMinOperationPressure(double minPressure) {
        this.minOperationPressure = minPressure;
    }

    public double getMaxOperationTemperature() {
        return this.maxOperationTemperature;
    }

    public void setMaxOperationTemperature(double maxTemperature) {
        this.maxOperationTemperature = maxTemperature;
    }

    public double getMinOperationTemperature() {
        return this.minOperationTemperature;
    }

    public void setMinOperationTemperature(double minTemperature) {
        this.minOperationTemperature = minTemperature;
    }

    public ProcessEquipmentInterface getProcessEquipment() {
        return this.processEquipment;
    }

    public void setProcessEquipment(ProcessEquipmentInterface processEquipment) {
        this.processEquipment = processEquipment;
    }

    public void calcDesign() {
        if (!this.hasSetCompanySpecificDesignStandards) {
            this.setCompanySpecificDesignStandards("default");
        }
        this.readDesignSpecifications();
    }

    public void setDesign() {
        this.readDesignSpecifications();
    }

    public double getTensileStrength() {
        return this.tensileStrength;
    }

    public void setTensileStrength(double tensileStrength) {
        this.tensileStrength = tensileStrength;
    }

    public String getConstrutionMaterial() {
        return this.construtionMaterial;
    }

    public void setConstrutionMaterial(String construtionMaterial) {
        this.construtionMaterial = construtionMaterial;
    }

    public double getJointEfficiency() {
        return this.jointEfficiency;
    }

    public double getMaxAllowableStress() {
        return this.tensileStrength / 3.5;
    }

    public void setJointEfficiency(double jointEfficiency) {
        this.jointEfficiency = jointEfficiency;
    }

    public double getCorrosionAllowanse() {
        return this.corrosionAllowanse;
    }

    public void setCorrosionAllowanse(double corrosionAllowanse) {
        this.corrosionAllowanse = corrosionAllowanse;
    }

    public double getPressureMarginFactor() {
        return this.pressureMarginFactor;
    }

    public void setPressureMarginFactor(double pressureMarginFactor) {
        this.pressureMarginFactor = pressureMarginFactor;
    }

    public double getOuterDiameter() {
        return this.outerDiameter;
    }

    public String getCompanySpecificDesignStandards() {
        return this.companySpecificDesignStandards;
    }

    public void setCompanySpecificDesignStandards(String companySpecificDesignStandards) {
        this.companySpecificDesignStandards = companySpecificDesignStandards;
        if (companySpecificDesignStandards.equals("StatoilTR")) {
            this.getDesignStandard().put("pressure vessel design code", new PressureVesselDesignStandard("ASME - Pressure Vessel Code", this));
            this.getDesignStandard().put("separator process design", new SeparatorDesignStandard("StatoilTR", this));
            this.getDesignStandard().put("gas scrubber process design", new GasScrubberDesignStandard("Statoil_TR1414", this));
            this.getDesignStandard().put("adsorption dehydration process design", new AdsorptionDehydrationDesignStandard("", this));
            this.getDesignStandard().put("pipeline design codes", new PipelineDesignStandard("Statoil_TR1414", this));
            this.getDesignStandard().put("compressor design codes", new CompressorDesignStandard("Statoil_TR1414", this));
            this.getDesignStandard().put("material plate design codes", new MaterialPlateDesignStandard("Statoil_TR1414", this));
            this.getDesignStandard().put("plate Joint Efficiency design codes", new JointEfficiencyPlateStandard("Statoil_TR1414", this));
            this.getDesignStandard().put("material pipe design codes", new MaterialPipeDesignStandard("Statoil_TR1414", this));
        } else {
            System.out.println("using default mechanical design standards...no design standard " + companySpecificDesignStandards);
            this.getDesignStandard().put("pressure vessel design code", new PressureVesselDesignStandard("ASME - Pressure Vessel Code", this));
            this.getDesignStandard().put("separator process design", new SeparatorDesignStandard("StatoilTR", this));
            this.getDesignStandard().put("gas scrubber process design", new GasScrubberDesignStandard("Statoil_TR1414", this));
            this.getDesignStandard().put("adsorption dehydration process design", new AdsorptionDehydrationDesignStandard("", this));
            this.getDesignStandard().put("pipeline design codes", new PipelineDesignStandard("Statoil_TR1414", this));
            this.getDesignStandard().put("compressor design codes", new CompressorDesignStandard("Statoil_TR1414", this));
            this.getDesignStandard().put("material plate design codes", new MaterialPlateDesignStandard("Statoil_TR1414", this));
            this.getDesignStandard().put("plate Joint Efficiency design codes", new JointEfficiencyPlateStandard("Statoil_TR1414", this));
            this.getDesignStandard().put("material pipe design codes", new MaterialPipeDesignStandard("Statoil_TR1414", this));
        }
        this.hasSetCompanySpecificDesignStandards = true;
    }

    public double getInnerDiameter() {
        return this.innerDiameter;
    }

    public void setInnerDiameter(double innerDiameter) {
        this.innerDiameter = innerDiameter;
    }

    public void setOuterDiameter(double outerDiameter) {
        this.outerDiameter = outerDiameter;
    }

    public double getWallThickness() {
        return this.wallThickness;
    }

    public void setWallThickness(double wallThickness) {
        this.wallThickness = wallThickness;
    }

    public double getTantanLength() {
        return this.tantanLength;
    }

    public void setTantanLength(double tantanLength) {
        this.tantanLength = tantanLength;
    }

    public double getWeightTotal() {
        return this.weightTotal;
    }

    public void setWeightTotal(double weightTotal) {
        this.weightTotal = weightTotal;
    }

    public double getWeigthInternals() {
        return this.weigthInternals;
    }

    public void setWeigthInternals(double weigthInternals) {
        this.weigthInternals = weigthInternals;
    }

    public double getWeightVessel() {
        return this.weightVessel;
    }

    public void setWeightVessel(double weightVessel) {
        this.weightVessel = weightVessel;
    }

    public double getWeightNozzle() {
        return this.weightNozzle;
    }

    public void setWeightNozzle(double weightNozzle) {
        this.weightNozzle = weightNozzle;
    }

    public double getWeightPiping() {
        return this.weightPiping;
    }

    public void setWeightPiping(double weightPiping) {
        this.weightPiping = weightPiping;
    }

    public double getWeightElectroInstrument() {
        return this.weightElectroInstrument;
    }

    public void setWeightElectroInstrument(double weightElectroInstrument) {
        this.weightElectroInstrument = weightElectroInstrument;
    }

    public double getWeightStructualSteel() {
        return this.weightStructualSteel;
    }

    public void setWeightStructualSteel(double weightStructualSteel) {
        this.weightStructualSteel = weightStructualSteel;
    }

    public double getWeigthVesselShell() {
        return this.weigthVesselShell;
    }

    public void setWeigthVesselShell(double weigthVesselShell) {
        this.weigthVesselShell = weigthVesselShell;
    }

    public double getModuleHeight() {
        return this.moduleHeight;
    }

    public void setModuleHeight(double moduleHeight) {
        this.moduleHeight = moduleHeight;
    }

    public double getModuleWidth() {
        return this.moduleWidth;
    }

    public void setModuleWidth(double moduleWidth) {
        this.moduleWidth = moduleWidth;
    }

    public double getModuleLength() {
        return this.moduleLength;
    }

    public void setModuleLength(double moduleLength) {
        this.moduleLength = moduleLength;
    }

    public Hashtable<String, DesignStandard> getDesignStandard() {
        return this.designStandard;
    }

    public void setDesignStandard(Hashtable<String, DesignStandard> designStandard) {
        this.designStandard = designStandard;
    }

    public double getMaxDesignVolumeFlow() {
        return this.maxDesignVolumeFlow;
    }

    public void setMaxDesignVolumeFlow(double maxDesignVolumeFlow) {
        this.maxDesignVolumeFlow = maxDesignVolumeFlow;
    }

    public double getMinDesignVolumeFLow() {
        return this.minDesignVolumeFLow;
    }

    public void setMinDesignVolumeFLow(double minDesignVolumeFLow) {
        this.minDesignVolumeFLow = minDesignVolumeFLow;
    }

    public double getMaxDesignGassVolumeFlow() {
        return this.maxDesignGassVolumeFlow;
    }

    public void setMaxDesignGassVolumeFlow(double maxDesignGassVolumeFlow) {
        this.maxDesignGassVolumeFlow = maxDesignGassVolumeFlow;
    }

    public double getMinDesignGassVolumeFLow() {
        return this.minDesignGassVolumeFLow;
    }

    public void setMinDesignGassVolumeFLow(double minDesignGassVolumeFLow) {
        this.minDesignGassVolumeFLow = minDesignGassVolumeFLow;
    }

    public double getMaxDesignOilVolumeFlow() {
        return this.maxDesignOilVolumeFlow;
    }

    public void setMaxDesignOilVolumeFlow(double maxDesignOilVolumeFlow) {
        this.maxDesignOilVolumeFlow = maxDesignOilVolumeFlow;
    }

    public double getMinDesignOilFLow() {
        return this.minDesignOilFLow;
    }

    public void setMinDesignOilFLow(double minDesignOilFLow) {
        this.minDesignOilFLow = minDesignOilFLow;
    }

    public double getMaxDesignWaterVolumeFlow() {
        return this.maxDesignWaterVolumeFlow;
    }

    public void setMaxDesignWaterVolumeFlow(double maxDesignWaterVolumeFlow) {
        this.maxDesignWaterVolumeFlow = maxDesignWaterVolumeFlow;
    }

    public double getMinDesignWaterVolumeFLow() {
        return this.minDesignWaterVolumeFLow;
    }

    public void setMinDesignWaterVolumeFLow(double minDesignWaterVolumeFLow) {
        this.minDesignWaterVolumeFLow = minDesignWaterVolumeFLow;
    }

    public void displayResults() {
        JFrame dialog = new JFrame("Unit design " + this.getProcessEquipment().getName());
        Container dialogContentPane = dialog.getContentPane();
        dialogContentPane.setLayout(new BorderLayout());
        Object[][] table = new String[3][3];
        table[1][0] = this.getProcessEquipment().getName();
        table[1][1] = Double.toString(this.getWeightTotal());
        table[1][2] = Double.toString(this.getVolumeTotal());
        Object[] names = new String[]{"", "Volume", "Weight"};
        JTable Jtab = new JTable(table, names);
        JScrollPane scrollpane = new JScrollPane(Jtab);
        dialogContentPane.add(scrollpane);
        dialog.setSize(800, 600);
        dialog.setVisible(true);
    }

    public double getVolumeTotal() {
        return this.volumeTotal;
    }

    public boolean isHasSetCompanySpecificDesignStandards() {
        return this.hasSetCompanySpecificDesignStandards;
    }

    public void setHasSetCompanySpecificDesignStandards(boolean hasSetCompanySpecificDesignStandards) {
        this.hasSetCompanySpecificDesignStandards = hasSetCompanySpecificDesignStandards;
    }

    public UnitCostEstimateBaseClass getCostEstimate() {
        return this.costEstimate;
    }

    public void setDefaultLiquidDensity(double defaultLiqDens) {
        this.defaultLiquidDensity = defaultLiqDens;
    }

    public double getDefaultLiquidDensity() {
        return this.defaultLiquidDensity;
    }

    public void setDefaultLiquidViscosity(double defaultLiqVisc) {
        this.defaultLiquidViscosity = defaultLiqVisc;
    }

    public double getDefaultLiquidViscosity() {
        return this.defaultLiquidViscosity;
    }

    public int hashCode() {
        return Objects.hash(this.companySpecificDesignStandards, this.construtionMaterial, this.corrosionAllowanse, this.costEstimate, this.designStandard, this.hasSetCompanySpecificDesignStandards, this.innerDiameter, this.jointEfficiency, this.materialPipeDesignStandard, this.materialPlateDesignStandard, this.maxDesignGassVolumeFlow, this.maxDesignOilVolumeFlow, this.maxDesignVolumeFlow, this.maxDesignWaterVolumeFlow, this.maxOperationPressure, this.maxOperationTemperature, this.minDesignGassVolumeFLow, this.minDesignOilFLow, this.minDesignVolumeFLow, this.minDesignWaterVolumeFLow, this.minOperationPressure, this.minOperationTemperature, this.moduleHeight, this.moduleLength, this.moduleWidth, this.outerDiameter, this.pressureMarginFactor, this.processEquipment, this.tantanLength, this.tensileStrength, this.volumeTotal, this.wallThickness, this.weightElectroInstrument, this.weightNozzle, this.weightPiping, this.weightStructualSteel, this.weightTotal, this.weightVessel, this.weigthInternals, this.weigthVesselShell);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MechanicalDesign other = (MechanicalDesign)obj;
        return Objects.equals(this.companySpecificDesignStandards, other.companySpecificDesignStandards) && Objects.equals(this.construtionMaterial, other.construtionMaterial) && Double.doubleToLongBits(this.corrosionAllowanse) == Double.doubleToLongBits(other.corrosionAllowanse) && Objects.equals(this.costEstimate, other.costEstimate) && Objects.equals(this.designStandard, other.designStandard) && this.hasSetCompanySpecificDesignStandards == other.hasSetCompanySpecificDesignStandards && Double.doubleToLongBits(this.innerDiameter) == Double.doubleToLongBits(other.innerDiameter) && Double.doubleToLongBits(this.jointEfficiency) == Double.doubleToLongBits(other.jointEfficiency) && Objects.equals(this.materialPipeDesignStandard, other.materialPipeDesignStandard) && Objects.equals(this.materialPlateDesignStandard, other.materialPlateDesignStandard) && Double.doubleToLongBits(this.maxDesignGassVolumeFlow) == Double.doubleToLongBits(other.maxDesignGassVolumeFlow) && Double.doubleToLongBits(this.maxDesignOilVolumeFlow) == Double.doubleToLongBits(other.maxDesignOilVolumeFlow) && Double.doubleToLongBits(this.maxDesignVolumeFlow) == Double.doubleToLongBits(other.maxDesignVolumeFlow) && Double.doubleToLongBits(this.maxDesignWaterVolumeFlow) == Double.doubleToLongBits(other.maxDesignWaterVolumeFlow) && Double.doubleToLongBits(this.maxOperationPressure) == Double.doubleToLongBits(other.maxOperationPressure) && Double.doubleToLongBits(this.maxOperationTemperature) == Double.doubleToLongBits(other.maxOperationTemperature) && Double.doubleToLongBits(this.minDesignGassVolumeFLow) == Double.doubleToLongBits(other.minDesignGassVolumeFLow) && Double.doubleToLongBits(this.minDesignOilFLow) == Double.doubleToLongBits(other.minDesignOilFLow) && Double.doubleToLongBits(this.minDesignVolumeFLow) == Double.doubleToLongBits(other.minDesignVolumeFLow) && Double.doubleToLongBits(this.minDesignWaterVolumeFLow) == Double.doubleToLongBits(other.minDesignWaterVolumeFLow) && Double.doubleToLongBits(this.minOperationPressure) == Double.doubleToLongBits(other.minOperationPressure) && Double.doubleToLongBits(this.minOperationTemperature) == Double.doubleToLongBits(other.minOperationTemperature) && Double.doubleToLongBits(this.moduleHeight) == Double.doubleToLongBits(other.moduleHeight) && Double.doubleToLongBits(this.moduleLength) == Double.doubleToLongBits(other.moduleLength) && Double.doubleToLongBits(this.moduleWidth) == Double.doubleToLongBits(other.moduleWidth) && Double.doubleToLongBits(this.outerDiameter) == Double.doubleToLongBits(other.outerDiameter) && Double.doubleToLongBits(this.pressureMarginFactor) == Double.doubleToLongBits(other.pressureMarginFactor) && Objects.equals(this.processEquipment, other.processEquipment) && Double.doubleToLongBits(this.tantanLength) == Double.doubleToLongBits(other.tantanLength) && Double.doubleToLongBits(this.tensileStrength) == Double.doubleToLongBits(other.tensileStrength) && Double.doubleToLongBits(this.volumeTotal) == Double.doubleToLongBits(other.volumeTotal) && Double.doubleToLongBits(this.wallThickness) == Double.doubleToLongBits(other.wallThickness) && Double.doubleToLongBits(this.weightElectroInstrument) == Double.doubleToLongBits(other.weightElectroInstrument) && Double.doubleToLongBits(this.weightNozzle) == Double.doubleToLongBits(other.weightNozzle) && Double.doubleToLongBits(this.weightPiping) == Double.doubleToLongBits(other.weightPiping) && Double.doubleToLongBits(this.weightStructualSteel) == Double.doubleToLongBits(other.weightStructualSteel) && Double.doubleToLongBits(this.weightTotal) == Double.doubleToLongBits(other.weightTotal) && Double.doubleToLongBits(this.weightVessel) == Double.doubleToLongBits(other.weightVessel) && Double.doubleToLongBits(this.weigthInternals) == Double.doubleToLongBits(other.weigthInternals) && Double.doubleToLongBits(this.weigthVesselShell) == Double.doubleToLongBits(other.weigthVesselShell);
    }
}

