/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.mechanicaldesign.absorber;

import neqsim.process.equipment.ProcessEquipmentInterface;
import neqsim.process.equipment.absorber.SimpleTEGAbsorber;
import neqsim.process.equipment.separator.Separator;
import neqsim.process.equipment.separator.SeparatorInterface;
import neqsim.process.equipment.separator.sectiontype.SeparatorSection;
import neqsim.process.mechanicaldesign.designstandards.PressureVesselDesignStandard;
import neqsim.process.mechanicaldesign.designstandards.SeparatorDesignStandard;
import neqsim.process.mechanicaldesign.separator.SeparatorMechanicalDesign;

public class AbsorberMechanicalDesign
extends SeparatorMechanicalDesign {
    private static final long serialVersionUID = 1000L;
    private double wallThickness = 0.02;
    private double outerDiameter = 0.0;
    double gasLoadFactor = 1.0;
    double volumeSafetyFactor = 1.0;

    public AbsorberMechanicalDesign(ProcessEquipmentInterface equipment) {
        super(equipment);
    }

    @Override
    public void readDesignSpecifications() {
        super.readDesignSpecifications();
        if (!this.getDesignStandard().containsKey("pressure vessel design code")) {
            System.out.println("no pressure vessel code standard specified......");
            return;
        }
        System.out.println("pressure vessel code standard: " + this.getDesignStandard().get("pressure vessel design code").getStandardName());
        this.wallThickness = ((PressureVesselDesignStandard)this.getDesignStandard().get("pressure vessel design code")).calcWallThickness();
        if (!this.getDesignStandard().containsKey("absorption dehydration process design")) {
            System.out.println("no separator process design specified......");
            return;
        }
        if (this.getDesignStandard().containsKey("separator process design")) {
            System.out.println("separator process design: " + this.getDesignStandard().get("separator process design").getStandardName());
            this.gasLoadFactor = ((SeparatorDesignStandard)this.getDesignStandard().get("separator process design")).getGasLoadFactor();
            this.volumeSafetyFactor = ((SeparatorDesignStandard)this.getDesignStandard().get("separator process design")).getVolumetricDesignFactor();
        } else {
            System.out.println("no separator process design specified......");
        }
    }

    @Override
    public void calcDesign() {
        super.calcDesign();
        SimpleTEGAbsorber separator = (SimpleTEGAbsorber)this.getProcessEquipment();
        double Fg = 1.0;
        double emptyVesselWeight = 0.0;
        double internalsWeight = 0.0;
        double externalNozzelsWeight = 0.0;
        double pipingWeight = 0.0;
        double structualWeight = 0.0;
        double electricalWeight = 0.0;
        double totalSkidWeight = 0.0;
        double moduleWidth = 0.0;
        double moduleHeight = 0.0;
        double moduleLength = 0.0;
        double materialsCost = 0.0;
        double gasDensity = ((Separator)this.getProcessEquipment()).getGasOutStream().getThermoSystem().getPhase(0).getPhysicalProperties().getDensity();
        double liqDensity = 1000.0;
        double maxGasVelocity = this.gasLoadFactor * Math.sqrt((liqDensity - gasDensity) / gasDensity);
        this.innerDiameter = Math.sqrt(4.0 * this.getMaxDesignVolumeFlow() / (3.14159265 * maxGasVelocity * Fg));
        this.tantanLength = this.innerDiameter * 5.0;
        System.out.println("inner Diameter " + this.innerDiameter);
        emptyVesselWeight = 0.032 * this.getWallThickness() * this.innerDiameter * 1000.0 * this.tantanLength;
        for (SeparatorSection sep : separator.getSeparatorSections()) {
            sep.getMechanicalDesign().calcDesign();
            internalsWeight += sep.getMechanicalDesign().getTotalWeight();
        }
        System.out.println("internal weight " + internalsWeight);
        externalNozzelsWeight = 0.0;
        double Wv = emptyVesselWeight + internalsWeight + externalNozzelsWeight;
        pipingWeight = Wv * 0.4;
        structualWeight = Wv * 0.1;
        electricalWeight = Wv * 0.08;
        totalSkidWeight = Wv + pipingWeight + structualWeight + electricalWeight;
        materialsCost = totalSkidWeight / 1000.0 * 6000.0 / 1000.0;
        moduleWidth = this.innerDiameter * 2.0;
        moduleLength = this.innerDiameter * 2.5;
        moduleHeight = this.innerDiameter * 2.0;
        this.setOuterDiameter(this.innerDiameter * 2.0 * this.getWallThickness());
        System.out.println("wall thickness: " + separator.getName() + " " + this.getWallThickness() + " mm");
        System.out.println("separator dry weigth: " + emptyVesselWeight + " kg");
        System.out.println("total skid weigth: " + totalSkidWeight + " kg");
        System.out.println("foot print: width:" + moduleWidth + " length " + moduleLength + " height " + moduleHeight + " meter.");
        System.out.println("mechanical price: " + materialsCost + " kNOK");
        this.setWeigthVesselShell(emptyVesselWeight);
        this.tantanLength = this.innerDiameter * 5.0;
        this.setInnerDiameter(this.innerDiameter);
        this.setWeightElectroInstrument(electricalWeight);
        this.setWeightNozzle(externalNozzelsWeight);
        this.setWeightPiping(pipingWeight);
        this.setWeightStructualSteel(structualWeight);
        this.setWeightTotal(totalSkidWeight);
        this.setWeigthInternals(internalsWeight);
        this.setWallThickness(this.wallThickness);
        this.setModuleHeight(moduleHeight);
        this.setModuleWidth(moduleWidth);
        this.setModuleLength(moduleLength);
    }

    @Override
    public void setDesign() {
        ((SeparatorInterface)((Object)this.getProcessEquipment())).setInternalDiameter(this.innerDiameter);
        ((Separator)this.getProcessEquipment()).setSeparatorLength(this.tantanLength);
    }

    @Override
    public double getOuterDiameter() {
        return this.outerDiameter;
    }

    @Override
    public double getWallThickness() {
        return this.wallThickness;
    }

    @Override
    public void setWallThickness(double wallThickness) {
        this.wallThickness = wallThickness;
    }

    @Override
    public void setOuterDiameter(double outerDiameter) {
        this.outerDiameter = outerDiameter;
    }
}

