/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.mechanicaldesign.designstandards;

import java.sql.ResultSet;
import neqsim.process.mechanicaldesign.MechanicalDesign;
import neqsim.process.mechanicaldesign.designstandards.DesignStandard;
import neqsim.util.database.NeqSimProcessDesignDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AdsorptionDehydrationDesignStandard
extends DesignStandard {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(AdsorptionDehydrationDesignStandard.class);
    private double molecularSieveWaterCapacity = 20.0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AdsorptionDehydrationDesignStandard(String name, MechanicalDesign equipmentInn) {
        super(name, equipmentInn);
        try (NeqSimProcessDesignDataBase database = new NeqSimProcessDesignDataBase();){
            ResultSet dataSet = null;
            try {
                dataSet = database.getResultSet("SELECT * FROM technicalrequirements_process WHERE EQUIPMENTTYPE='Adsorber Dehydration' AND Company='" + this.standardName + "'");
                while (dataSet.next()) {
                    String specName = dataSet.getString("SPECIFICATION");
                    if (!specName.equals("MolecularSieve3AWaterCapacity")) continue;
                    this.molecularSieveWaterCapacity = Double.parseDouble(dataSet.getString("MAXVALUE"));
                }
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            finally {
                try {
                    if (dataSet != null) {
                        dataSet.close();
                    }
                }
                catch (Exception ex) {
                    System.out.println("error closing database.....GasScrubberDesignStandard");
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public double getMolecularSieveWaterCapacity() {
        return this.molecularSieveWaterCapacity;
    }

    public void setMolecularSieveWaterCapacity(double molecularSieveWaterCapacity) {
        this.molecularSieveWaterCapacity = molecularSieveWaterCapacity;
    }
}

