/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.mechanicaldesign.designstandards;

import java.sql.ResultSet;
import neqsim.process.mechanicaldesign.MechanicalDesign;
import neqsim.process.mechanicaldesign.designstandards.DesignStandard;
import neqsim.util.database.NeqSimProcessDesignDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MaterialPlateDesignStandard
extends DesignStandard {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(MaterialPlateDesignStandard.class);
    String grade = "";
    String materialName = "";
    String specificationNumber = "";
    int divisionClassNumber = 1;
    private double divisionClass = 425.0;

    public MaterialPlateDesignStandard() {
    }

    public MaterialPlateDesignStandard(String name, MechanicalDesign equipmentInn) {
        super(name, equipmentInn);
        this.readMaterialDesignStandard("Carbon Steel Plates and Sheets", "SA-516", "55", 1);
    }

    public double getDivisionClass() {
        return this.divisionClass;
    }

    public void setDivisionClass(double divisionClass) {
        this.divisionClass = divisionClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readMaterialDesignStandard(String name, String specNo, String grade, int divClassNo) {
        this.materialName = name;
        this.specificationNumber = specNo;
        this.divisionClassNumber = divClassNo;
        try (NeqSimProcessDesignDataBase database = new NeqSimProcessDesignDataBase();){
            ResultSet dataSet = null;
            try {
                dataSet = database.getResultSet("SELECT * FROM materialplateproperties WHERE materialName='" + name + "' AND grade='" + grade + "' AND specificationNumber='" + specNo + "'");
                while (dataSet.next()) {
                    if (divClassNo == 1) {
                        this.divisionClass = Double.parseDouble(dataSet.getString("divisionClass1")) * 0.00689475729;
                        continue;
                    }
                    this.divisionClass = Double.parseDouble(dataSet.getString("divisionClass2")) * 0.00689475729;
                }
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            finally {
                try {
                    if (dataSet != null) {
                        dataSet.close();
                    }
                }
                catch (Exception ex) {
                    System.out.println("error closing database.....GasScrubberDesignStandard");
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

