/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.mechanicaldesign.valve;

import java.awt.BorderLayout;
import java.awt.Container;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import neqsim.process.costestimation.valve.ValveCostEstimate;
import neqsim.process.equipment.ProcessEquipmentInterface;
import neqsim.process.equipment.valve.ThrottlingValve;
import neqsim.process.mechanicaldesign.MechanicalDesign;
import neqsim.process.mechanicaldesign.designstandards.ValveDesignStandard;

public class ValveMechanicalDesign
extends MechanicalDesign {
    private static final long serialVersionUID = 1000L;
    double valveCvMax = 1.0;
    double valveWeight = 100.0;
    double inletPressure = 0.0;
    double outletPressure = 0.0;
    double dP = 0.0;

    public ValveMechanicalDesign(ProcessEquipmentInterface equipment) {
        super(equipment);
        this.costEstimate = new ValveCostEstimate(this);
    }

    @Override
    public void readDesignSpecifications() {
        super.readDesignSpecifications();
        if (this.getDesignStandard().containsKey("valve design codes")) {
            System.out.println("valve code standard: " + this.getDesignStandard().get("valve design codes").getStandardName());
            this.valveCvMax = ((ValveDesignStandard)this.getDesignStandard().get("valve design codes")).getValveCvMax();
        } else {
            System.out.println("no valve code standard specified......using default");
        }
    }

    @Override
    public void calcDesign() {
        super.calcDesign();
        ThrottlingValve valve1 = (ThrottlingValve)this.getProcessEquipment();
        this.inletPressure = valve1.getInletPressure();
        this.outletPressure = valve1.getOutletPressure();
        this.dP = this.inletPressure - this.outletPressure;
        this.valveCvMax = valve1.getThermoSystem().getFlowRate("m3/hr") * Math.sqrt(valve1.getThermoSystem().getDensity("kg/m3") / 1000.0 / this.dP);
        this.valveWeight = this.valveCvMax * 100.0;
        this.setWeightTotal(this.valveWeight);
    }

    @Override
    public void displayResults() {
        JFrame dialog = new JFrame("Unit design " + this.getProcessEquipment().getName());
        Container dialogContentPane = dialog.getContentPane();
        dialogContentPane.setLayout(new BorderLayout());
        Object[] names = new String[]{"Name", "Value", "Unit"};
        Object[][] table = new String[16][3];
        table[1][0] = "Valve weight [kg]";
        table[1][1] = Double.toString(this.valveWeight);
        table[1][2] = "kg";
        table[2][0] = "Valve Cv";
        table[2][1] = Double.toString(this.valveCvMax);
        table[2][2] = "-";
        table[3][0] = "Inlet pressure [bar]";
        table[3][1] = Double.toString(this.inletPressure);
        table[3][2] = "bar";
        table[4][0] = "outlet pressure [bar]";
        table[4][1] = Double.toString(this.outletPressure);
        table[4][2] = "bar";
        JTable Jtab = new JTable(table, names);
        JScrollPane scrollpane = new JScrollPane(Jtab);
        dialogContentPane.add(scrollpane);
        dialog.setSize(800, 600);
        dialog.setVisible(true);
    }
}

