/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.processmodel.processmodules;

import java.util.UUID;
import neqsim.process.equipment.ProcessEquipmentBaseClass;
import neqsim.process.equipment.absorber.SimpleTEGAbsorber;
import neqsim.process.equipment.heatexchanger.Cooler;
import neqsim.process.equipment.heatexchanger.Heater;
import neqsim.process.equipment.pump.Pump;
import neqsim.process.equipment.separator.Separator;
import neqsim.process.equipment.stream.Stream;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.process.equipment.util.StreamSaturatorUtil;
import neqsim.process.equipment.valve.ThrottlingValve;
import neqsim.process.processmodel.ProcessModuleBaseClass;
import neqsim.process.processmodel.ProcessSystem;
import neqsim.thermo.system.SystemSrkCPAstatoil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GlycolDehydrationlModule
extends ProcessModuleBaseClass {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(GlycolDehydrationlModule.class);
    protected StreamInterface gasStreamToAbsorber = null;
    protected StreamInterface strippingGas = null;
    protected StreamInterface gasStreamFromAbsorber = null;
    protected StreamInterface gasFromStripper = null;
    protected StreamInterface leanTEGStreamToAbsorber = null;
    protected SimpleTEGAbsorber absorbtionColumn = null;
    protected Separator stripperColumn = null;
    Heater reboiler = null;
    protected Pump HPpump = null;
    protected Separator glycolFlashDrum = null;
    protected Separator waterSeparator = null;
    protected ThrottlingValve valveHP = null;
    protected ThrottlingValve valveMP = null;
    Cooler heatExchanger1 = null;
    Cooler heatExchanger2 = null;
    Cooler heatExchanger3 = null;
    double waterDewPontSpecification = 263.15;
    double numberOfTheoreticalEquilibriumStages = 2.0;
    private double flashPressure = 5.0;
    double designStandardGasFlowRate = 20.0;
    double maxAbsorberDesignPressure = 70.0;
    double designGasFeedTemperature = 303.15;
    double leanGlycolMolarFraction = 0.95;
    double leanGlycolwtFraction = 0.99;
    double leanGlycolMolarFlowRate = 1.0;
    double maxglycolFlowRate = 1.0;
    String glycolTypeName = "TEG";
    double reboilerTemperature = 477.15;
    double regenerationPressure = 1.4;

    public GlycolDehydrationlModule(String name) {
        super(name);
    }

    @Override
    public void addInputStream(String streamName, StreamInterface stream) {
        if (streamName.equals("gasStreamToAbsorber")) {
            this.gasStreamToAbsorber = stream;
            this.strippingGas = stream.clone();
        }
        if (streamName.equals("strippingGas")) {
            this.strippingGas = stream;
        }
    }

    @Override
    public StreamInterface getOutputStream(String streamName) {
        if (!this.isInitializedStreams) {
            this.initializeStreams();
        }
        if (streamName.equals("gasStreamFromAbsorber")) {
            return this.gasStreamFromAbsorber;
        }
        if (streamName.equals("liquidFromStripper")) {
            return this.stripperColumn.getLiquidOutStream();
        }
        if (streamName.equals("liquidFromStripper")) {
            return this.stripperColumn.getLiquidOutStream();
        }
        if (streamName.equals("condenserStripper")) {
            return this.stripperColumn.getGasOutStream();
        }
        return null;
    }

    public double solveAbsorptionFactor(double Ea) {
        double A = 7.0;
        double Aold = 7.0;
        double error = 1.0;
        double errorOld = 1.0;
        int iter = 0;
        do {
            errorOld = error;
            error = (Math.pow(A, this.numberOfTheoreticalEquilibriumStages + 1.0) - A) / (Math.pow(A, this.numberOfTheoreticalEquilibriumStages + 1.0) - 1.0) - Ea;
            double dErrordA = (error - errorOld) / (A - Aold);
            Aold = A;
            if (++iter > 2) {
                A -= error / dErrordA;
                continue;
            }
            A += error;
        } while (Math.abs(error) > 1.0E-6 && iter < 100);
        return A;
    }

    @Override
    public void run(UUID id) {
        if (!this.isInitializedStreams) {
            this.initializeStreams();
        }
        if (!this.isInitializedModule) {
            this.initializeModule();
        }
        if (!this.isCalcDesign()) {
            this.calcDesign();
        }
        this.getOperations().run(id);
        this.setCalculationIdentifier(id);
    }

    @Override
    public void initializeStreams() {
        this.isInitializedStreams = true;
        try {
            this.gasStreamFromAbsorber = this.gasStreamToAbsorber.clone("Stream from TEG Absorber");
            this.gasFromStripper = this.gasStreamToAbsorber.clone("Gas stream from Stripper");
            this.leanTEGStreamToAbsorber = this.gasStreamToAbsorber.clone("lean TEG to absorber");
            this.leanTEGStreamToAbsorber.getThermoSystem().setEmptyFluid();
            this.leanTEGStreamToAbsorber.getThermoSystem().addComponent("water", this.leanGlycolMolarFlowRate * (1.0 - this.leanGlycolMolarFraction));
            this.leanTEGStreamToAbsorber.getThermoSystem().addComponent("TEG", this.leanGlycolMolarFlowRate * this.leanGlycolMolarFraction);
            this.leanTEGStreamToAbsorber.getThermoSystem().setTotalFlowRate(this.maxglycolFlowRate, "kg/hr");
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public void initializeModule() {
        if (!this.isInitializedStreams) {
            this.initializeStreams();
        }
        this.isInitializedModule = true;
        this.absorbtionColumn = new SimpleTEGAbsorber("absorbtionColumn");
        this.absorbtionColumn.addGasInStream(this.gasStreamToAbsorber);
        this.absorbtionColumn.addSolventInStream(this.leanTEGStreamToAbsorber);
        this.valveHP = new ThrottlingValve("valveHP", this.absorbtionColumn.getLiquidOutStream());
        this.valveHP.setOutletPressure(this.flashPressure);
        this.glycolFlashDrum = new Separator("flash drum", this.valveHP.getOutletStream());
        this.valveMP = new ThrottlingValve("valveMP", this.glycolFlashDrum.getLiquidOutStream());
        this.valveMP.setOutletPressure(this.regenerationPressure);
        Heater reboiler = new Heater("reboiler", this.valveMP.getOutletStream());
        reboiler.setOutTemperature(this.reboilerTemperature);
        this.strippingGas.setTemperature(this.reboilerTemperature, "K");
        this.strippingGas.setPressure(this.regenerationPressure, "bara");
        this.stripperColumn = new Separator("stripperColumn", reboiler.getOutletStream());
        this.stripperColumn.addStream(this.strippingGas);
        this.heatExchanger1 = new Cooler("heatExchanger1", this.stripperColumn.getLiquidOutStream());
        this.heatExchanger1.setOutTemperature(100.0);
        this.HPpump = new Pump("HP lean TEG pump", this.heatExchanger1.getOutletStream());
        this.HPpump.setOutletPressure(this.gasStreamToAbsorber.getPressure());
        this.heatExchanger2 = new Cooler("heatExchanger2", this.HPpump.getOutletStream());
        this.heatExchanger2.setOutTemperature(313.15);
        this.heatExchanger3 = new Cooler("heatExchanger3", this.stripperColumn.getGasOutStream());
        this.heatExchanger3.setOutTemperature(303.15);
        this.waterSeparator = new Separator("watersep", this.heatExchanger3.getOutletStream());
        this.getOperations().add(this.leanTEGStreamToAbsorber);
        this.getOperations().add(this.absorbtionColumn);
        this.getOperations().add(this.valveHP);
        this.getOperations().add(this.glycolFlashDrum);
        this.getOperations().add(this.valveMP);
        this.getOperations().add(reboiler);
        this.getOperations().add(this.stripperColumn);
        this.getOperations().add(this.heatExchanger1);
        this.getOperations().add(this.HPpump);
        this.getOperations().add(this.heatExchanger2);
        this.getOperations().add(this.heatExchanger3);
        this.getOperations().add(this.waterSeparator);
    }

    @Override
    public void setProperty(String specificationName, double value, String unit) {
        if (unit == "") {
            this.setProperty(specificationName, value);
        } else {
            this.setProperty(specificationName, value);
        }
    }

    @Override
    public void setProperty(String specificationName, double value) {
        if (specificationName.equals("water dew point specification")) {
            this.waterDewPontSpecification = value;
        }
        if (specificationName.equals("number of theoretical stages")) {
            this.numberOfTheoreticalEquilibriumStages = value;
        }
        if (specificationName.equals("designStandardGasFlowRate")) {
            this.designStandardGasFlowRate = value;
        }
        if (specificationName.equals("designGasFeedTemperature")) {
            this.designGasFeedTemperature = value;
        }
        if (specificationName.equals("maxAbsorberDesignPressure")) {
            this.maxAbsorberDesignPressure = value;
        }
        if (specificationName.equals("maxglycolFlowRate")) {
            this.maxglycolFlowRate = value;
        }
        if (specificationName.equals("flashPressure")) {
            this.flashPressure = value;
        }
        if (specificationName.equals("reboilerTemperature")) {
            this.reboilerTemperature = value;
        }
        if (specificationName.equals("regenerationPressure")) {
            this.regenerationPressure = value;
        }
    }

    public double calcGlycolConcentration(double y0) {
        Stream tempStream = (Stream)this.gasStreamToAbsorber.clone();
        tempStream.run();
        double dn = 1.0 * tempStream.getThermoSystem().getPhase(0).getComponent("water").getNumberOfMolesInPhase();
        double error = 1.0;
        double oldError = 0.0;
        double oldNumberOfMoles = 0.0;
        double numberOfMoles = 0.0;
        int iter = 0;
        do {
            ++iter;
            oldNumberOfMoles = numberOfMoles;
            tempStream.getThermoSystem().addComponent("TEG", dn);
            tempStream.run();
            numberOfMoles = tempStream.getThermoSystem().getPhase(0).getComponent("TEG").getNumberOfmoles();
            oldError = error;
            error = tempStream.getThermoSystem().getPhase(0).getComponent("water").getx() - y0;
            double derrordn = (error - oldError) / (numberOfMoles - oldNumberOfMoles);
            dn = iter < 2 ? error : -error / derrordn;
            System.out.println("error " + error);
        } while (Math.abs(error) > 1.0E-8 && iter < 100);
        this.leanGlycolMolarFraction = tempStream.getThermoSystem().getPhase(1).getComponent("TEG").getx();
        this.leanGlycolwtFraction = tempStream.getThermoSystem().getPhase(1).getComponent("TEG").getx() * tempStream.getThermoSystem().getPhase(1).getComponent("TEG").getMolarMass() / tempStream.getThermoSystem().getPhase(1).getMolarMass();
        return this.leanGlycolwtFraction;
    }

    public double calcKglycol() {
        Stream tempStream = (Stream)this.gasStreamToAbsorber.clone();
        tempStream.getThermoSystem().addComponent("TEG", 5.0 * tempStream.getThermoSystem().getPhase(0).getComponent("water").getNumberOfMolesInPhase());
        tempStream.run();
        double activityCoefficientTEG = tempStream.getThermoSystem().getPhase(1).getActivityCoefficient(tempStream.getThermoSystem().getPhase(1).getComponent("water").getComponentNumber());
        double K = tempStream.getThermoSystem().getPhase(0).getComponent("water").getx() / (tempStream.getThermoSystem().getPhase(1).getComponent("water").getx() * activityCoefficientTEG);
        return K;
    }

    @Override
    public void displayResult() {
        this.gasStreamFromAbsorber.getThermoSystem().display();
        this.leanTEGStreamToAbsorber.displayResult();
        this.glycolFlashDrum.displayResult();
        this.heatExchanger2.displayResult();
        this.waterSeparator.displayResult();
    }

    @Override
    public void calcDesign() {
        this.setIsCalcDesign(true);
        double yN = this.gasStreamToAbsorber.getThermoSystem().getPhase(0).getComponent("water").getx();
        double K = this.calcKglycol();
        this.gasStreamFromAbsorber = this.gasStreamToAbsorber.clone();
        this.gasStreamFromAbsorber.getThermoSystem().setTemperature(this.waterDewPontSpecification);
        UUID id = UUID.randomUUID();
        this.gasStreamFromAbsorber.run(id);
        double y1 = this.gasStreamFromAbsorber.getThermoSystem().getPhase(0).getComponent("water").getx();
        this.gasStreamFromAbsorber.getThermoSystem().setTemperature(this.waterDewPontSpecification - 10.0);
        this.gasStreamFromAbsorber.run(id);
        double y0 = this.gasStreamFromAbsorber.getThermoSystem().getPhase(0).getComponent("water").getx();
        this.gasStreamFromAbsorber.run(id);
        this.calcGlycolConcentration(y0);
        double Ea = (yN - y1) / (yN - y0);
        double absorptionFactor = this.solveAbsorptionFactor(Ea);
        this.leanGlycolMolarFlowRate = absorptionFactor * K * this.designStandardGasFlowRate * 42.28981 / 24.0 / 3600.0;
        this.gasStreamFromAbsorber.getThermoSystem().removePhase(1);
        this.gasStreamFromAbsorber.getThermoSystem().setTemperature(this.designGasFeedTemperature);
        this.gasStreamFromAbsorber.run(id);
        this.leanTEGStreamToAbsorber.getThermoSystem().setEmptyFluid();
        this.leanTEGStreamToAbsorber.getThermoSystem().addComponent("methane", 1.0E-15);
        this.leanTEGStreamToAbsorber.getThermoSystem().addComponent("water", this.leanGlycolMolarFlowRate * (1.0 - this.leanGlycolMolarFraction));
        this.leanTEGStreamToAbsorber.getThermoSystem().addComponent("TEG", this.leanGlycolMolarFlowRate * this.leanGlycolMolarFraction);
        this.leanTEGStreamToAbsorber.run(id);
    }

    @Override
    public void setDesign() {
        SystemSrkCPAstatoil testSystem = new SystemSrkCPAstatoil(313.15, 1.0);
        testSystem.addComponent("water", this.leanGlycolMolarFlowRate * (1.0 - this.leanGlycolMolarFraction));
        testSystem.addComponent("TEG", this.leanGlycolMolarFlowRate * this.leanGlycolMolarFraction);
        testSystem.setMixingRule(9);
        this.leanTEGStreamToAbsorber.setThermoSystem(testSystem);
        this.leanTEGStreamToAbsorber.run();
        this.absorbtionColumn.getMechanicalDesign().setDesign();
    }

    public static void main(String[] args) {
        SystemSrkCPAstatoil testSystem = new SystemSrkCPAstatoil(313.15, 70.0);
        testSystem.addComponent("methane", 100.0);
        testSystem.addComponent("water", 0.1);
        testSystem.addComponent("TEG", 0.0);
        testSystem.createDatabase(true);
        testSystem.setMultiPhaseCheck(true);
        testSystem.setMixingRule(10);
        testSystem.setTotalFlowRate(5.0, "MSm^3/day");
        Stream gasinletStream = new Stream("gasinletStream", testSystem);
        SystemSrkCPAstatoil strippingGasSystem = new SystemSrkCPAstatoil(313.15, 70.0);
        strippingGasSystem.addComponent("methane", 1.0);
        strippingGasSystem.addComponent("water", 0.0);
        strippingGasSystem.addComponent("TEG", 0.0);
        strippingGasSystem.createDatabase(true);
        strippingGasSystem.setMultiPhaseCheck(true);
        strippingGasSystem.setMixingRule(10);
        strippingGasSystem.setTotalFlowRate(0.005, "MSm^3/day");
        Stream strippingGasStream = new Stream("strippingGasStream", strippingGasSystem);
        StreamSaturatorUtil saturator = new StreamSaturatorUtil("saturator", gasinletStream);
        Separator separator = new Separator("Separator 1", saturator.getOutletStream());
        GlycolDehydrationlModule TEGplant = new GlycolDehydrationlModule("TEGplant");
        TEGplant.addInputStream("gasStreamToAbsorber", saturator.getOutletStream());
        TEGplant.addInputStream("strippingGas", strippingGasStream);
        TEGplant.setSpecification("water dew point specification", 263.15);
        TEGplant.setSpecification("number of theoretical stages", 1.5);
        TEGplant.setSpecification("maxAbsorberDesignPressure", 70.0);
        TEGplant.setSpecification("designStandardGasFlowRate", 5000000.0);
        TEGplant.setSpecification("maxglycolFlowRate", 10.0);
        TEGplant.setSpecification("designGasFeedTemperature", 303.15);
        TEGplant.setSpecification("flashPressure", 5.0);
        TEGplant.setSpecification("regenerationPressure", 1.21325);
        TEGplant.setSpecification("reboilerTemperature", 478.15);
        ProcessSystem operations = new ProcessSystem();
        operations.add(gasinletStream);
        operations.add(saturator);
        operations.add(TEGplant);
        operations.run();
        saturator.getOutletStream().displayResult();
        separator.getThermoSystem().display();
        ((ProcessEquipmentBaseClass)operations.getUnit("reboiler")).run();
        TEGplant.getOutputStream("gasStreamFromAbsorber").displayResult();
        TEGplant.getOutputStream("liquidFromStripper").run();
        TEGplant.getOutputStream("liquidFromStripper").displayResult();
        System.out.println("wt TEG " + TEGplant.getOutputStream("liquidFromStripper").getFluid().getPhase(0).getWtFrac("TEG"));
        System.out.println("reboiler duty " + ((Heater)operations.getUnit("reboiler")).getDuty() / 1000.0 + " kW");
        System.out.println("Lean TEG flow " + ((Pump)operations.getUnit("HP lean TEG pump")).getFluid().getFlowRate("kg/hr") + " kg/hr");
        System.out.println("Lean TEG pump power " + ((Pump)operations.getUnit("HP lean TEG pump")).getPower() / 1000.0 + " kW");
        ((Separator)operations.getUnit("flash drum")).displayResult();
        ((Separator)operations.getUnit("watersep")).displayResult();
        ((ProcessEquipmentBaseClass)operations.getUnit("reboiler")).run();
        ((ProcessEquipmentBaseClass)operations.getUnit("reboiler")).displayResult();
    }

    public double getFlashPressure() {
        return this.flashPressure;
    }

    public void setFlashPressure(double flashPressure) {
        this.flashPressure = flashPressure;
    }
}

