/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.util.monitor;

import java.util.HashMap;
import neqsim.process.util.monitor.Value;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.util.unit.Units;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FluidResponse {
    private static final long serialVersionUID = 1L;
    static Logger logger = LogManager.getLogger(FluidResponse.class);
    public String name;
    public HashMap<String, HashMap<String, Value>> properties = new HashMap();
    public HashMap<String, HashMap<String, Value>> composition = new HashMap();
    public HashMap<String, HashMap<String, Value>> conditions = new HashMap();

    public FluidResponse(SystemInterface inputFluid) {
        this(inputFluid.getFluidName(), inputFluid);
    }

    public FluidResponse(String nameinp) {
        this.name = nameinp;
    }

    public FluidResponse(String fluidname, SystemInterface inputFluid) {
        this(fluidname);
        String name;
        int i;
        this.name = inputFluid.getFluidName();
        HashMap<String, Value> newdata = new HashMap<String, Value>();
        newdata.put("temperature", new Value(Double.toString(inputFluid.getTemperature(Units.getSymbol("temperature"))), Units.getSymbol("temperature")));
        newdata.put("pressure", new Value(Double.toString(inputFluid.getPressure(Units.getSymbol("pressure"))), Units.getSymbol("pressure")));
        newdata.put("molar flow", new Value(Double.toString(inputFluid.getFlowRate(Units.getSymbol("molar flow"))), Units.getSymbol("molar flow")));
        newdata.put("mass flow", new Value(Double.toString(inputFluid.getFlowRate(Units.getSymbol("mass flow"))), Units.getSymbol("mass flow")));
        newdata.put("fluid model", new Value(inputFluid.getModelName(), ""));
        newdata.put("enthalpy", new Value(Double.toString(inputFluid.getEnthalpy(Units.getSymbol("enthalpy"))), Units.getSymbol("enthalpy")));
        this.conditions.put("overall", newdata);
        for (i = 0; i < inputFluid.getNumberOfPhases(); ++i) {
            name = inputFluid.getPhase(i).getPhaseTypeName();
            newdata = new HashMap();
            newdata.put("temperature", new Value(Double.toString(inputFluid.getPhase(name).getTemperature(Units.getSymbol("temperature"))), Units.getSymbol("temperature")));
            newdata.put("pressure", new Value(Double.toString(inputFluid.getPhase(name).getPressure(Units.getSymbol("pressure"))), Units.getSymbol("pressure")));
            newdata.put("molar flow", new Value(Double.toString(inputFluid.getPhase(name).getFlowRate(Units.getSymbol("molar flow"))), Units.getSymbol("molar flow")));
            newdata.put("mass flow", new Value(Double.toString(inputFluid.getPhase(name).getFlowRate(Units.getSymbol("mass flow"))), Units.getSymbol("mass flow")));
            newdata.put("fluid model", new Value(inputFluid.getModelName(), ""));
            newdata.put("enthalpy", new Value(Double.toString(inputFluid.getPhase(name).getEnthalpy(Units.getSymbol("enthalpy"))), Units.getSymbol("enthalpy")));
            this.conditions.put(name, newdata);
        }
        this.name = inputFluid.getFluidName();
        newdata = new HashMap();
        for (i = 0; i < inputFluid.getNumberOfComponents(); ++i) {
            newdata.put(inputFluid.getComponent(i).getComponentName(), new Value(Double.toString(inputFluid.getComponent(i).getz()), "mole fraction"));
        }
        this.composition.put("overall", newdata);
        for (int j = 0; j < inputFluid.getNumberOfPhases(); ++j) {
            newdata = new HashMap();
            HashMap<String, Value> newdata2 = new HashMap<String, Value>();
            for (int i2 = 0; i2 < inputFluid.getNumberOfComponents(); ++i2) {
                newdata2.put(inputFluid.getPhase(j).getComponent(i2).getComponentName(), new Value(Double.toString(inputFluid.getPhase(j).getComponent(i2).getx()), "mole fraction"));
                newdata.put(inputFluid.getPhase(j).getComponent(i2).getComponentName(), new Value(Double.toString(inputFluid.getPhase(j).getWtFrac(i2)), "weight fraction"));
            }
            this.composition.put(inputFluid.getPhase(j).getPhaseTypeName(), newdata2);
            this.composition.put(inputFluid.getPhase(j).getPhaseTypeName() + "_wt", newdata);
        }
        newdata = new HashMap();
        newdata.put("density", new Value(Double.toString(inputFluid.getDensity(Units.getSymbol("density"))), Units.getSymbol("density")));
        newdata.put("molar mass", new Value(Double.toString(inputFluid.getMolarMass(Units.getSymbol("Molar Mass"))), Units.getSymbol("Molar Mass")));
        newdata.put("flow rate", new Value(Double.toString(inputFluid.getFlowRate(Units.getSymbol("volume flow"))), Units.getSymbol("volume flow")));
        this.properties.put("overall", newdata);
        for (i = 0; i < inputFluid.getNumberOfPhases(); ++i) {
            newdata = new HashMap();
            name = inputFluid.getPhase(i).getPhaseTypeName();
            newdata.put("density", new Value(Double.toString(inputFluid.getPhase(name).getDensity(Units.getSymbol("density"))), Units.getSymbol("density")));
            newdata.put("molar mass", new Value(Double.toString(inputFluid.getPhase(name).getMolarMass(Units.getSymbol("Molar Mass"))), Units.getSymbol("Molar Mass")));
            newdata.put("flow rate", new Value(Double.toString(inputFluid.getPhase(name).getFlowRate(Units.getSymbol("volume flow"))), Units.getSymbol("volume flow")));
            this.properties.put(name, newdata);
        }
    }

    SystemInterface getNeqSimFluid() {
        SystemSrkEos tempFluid = new SystemSrkEos();
        return tempFluid;
    }

    public void print() {
    }
}

