/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.util.monitor;

import neqsim.process.equipment.separator.Separator;
import neqsim.process.equipment.separator.ThreePhaseSeparator;
import neqsim.process.util.monitor.StreamResponse;

public class SeparatorResponse {
    public String name;
    public Double gasLoadFactor;
    public StreamResponse feed;
    public StreamResponse gas;
    public StreamResponse liquid;
    public StreamResponse oil;
    public StreamResponse water;

    public SeparatorResponse(ThreePhaseSeparator inputSeparator) {
        this.name = inputSeparator.getName();
        this.gasLoadFactor = inputSeparator.getGasLoadFactor();
        this.feed = new StreamResponse(inputSeparator.getFeedStream());
        if (inputSeparator.getThermoSystem().hasPhaseType("aqueous")) {
            this.water = new StreamResponse(inputSeparator.getWaterOutStream());
        }
        if (inputSeparator.getThermoSystem().hasPhaseType("oil")) {
            this.oil = new StreamResponse(inputSeparator.getOilOutStream());
        }
        if (inputSeparator.getThermoSystem().hasPhaseType("gas")) {
            this.gas = new StreamResponse(inputSeparator.getGasOutStream());
        }
    }

    public SeparatorResponse(Separator inputSeparator) {
        this.name = inputSeparator.getName();
        this.gasLoadFactor = inputSeparator.getGasLoadFactor();
        this.feed = new StreamResponse(inputSeparator.getFeedStream());
        if (inputSeparator.getThermoSystem().hasPhaseType("aqueous") || inputSeparator.getThermoSystem().hasPhaseType("liquid") || inputSeparator.getThermoSystem().hasPhaseType("oil")) {
            this.liquid = new StreamResponse(inputSeparator.getLiquidOutStream());
        }
        if (inputSeparator.getThermoSystem().hasPhaseType("gas")) {
            this.gas = new StreamResponse(inputSeparator.getGasOutStream());
        }
    }
}

