/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.util.monitor;

import java.util.HashMap;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.process.util.monitor.Value;
import neqsim.standards.gasquality.Standard_ISO6976;
import neqsim.util.unit.Units;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StreamResponse {
    static Logger logger = LogManager.getLogger(StreamResponse.class);
    public String name;
    public HashMap<String, HashMap<String, Value>> properties = new HashMap();
    public HashMap<String, HashMap<String, Value>> conditions = new HashMap();
    public HashMap<String, HashMap<String, Value>> composition = new HashMap();

    public StreamResponse(StreamInterface inputStream) {
        String name;
        int i;
        this.name = inputStream.getName();
        HashMap<String, Value> newdata = new HashMap<String, Value>();
        newdata.put("temperature", new Value(Double.toString(inputStream.getTemperature(Units.getSymbol("temperature"))), Units.getSymbol("temperature")));
        newdata.put("pressure", new Value(Double.toString(inputStream.getPressure(Units.getSymbol("pressure"))), Units.getSymbol("pressure")));
        newdata.put("molar flow", new Value(Double.toString(inputStream.getFlowRate(Units.getSymbol("molar flow"))), Units.getSymbol("molar flow")));
        newdata.put("mass flow", new Value(Double.toString(inputStream.getFlowRate(Units.getSymbol("mass flow"))), Units.getSymbol("mass flow")));
        newdata.put("fluid model", new Value(inputStream.getFluid().getModelName(), ""));
        newdata.put("enthalpy", new Value(Double.toString(inputStream.getFluid().getEnthalpy(Units.getSymbol("enthalpy"))), Units.getSymbol("enthalpy")));
        this.conditions.put("overall", newdata);
        for (i = 0; i < inputStream.getFluid().getNumberOfPhases(); ++i) {
            name = inputStream.getFluid().getPhase(i).getPhaseTypeName();
            newdata = new HashMap();
            newdata.put("temperature", new Value(Double.toString(inputStream.getFluid().getPhase(name).getTemperature(Units.getSymbol("temperature"))), Units.getSymbol("temperature")));
            newdata.put("pressure", new Value(Double.toString(inputStream.getFluid().getPhase(name).getPressure(Units.getSymbol("pressure"))), Units.getSymbol("pressure")));
            newdata.put("molar flow", new Value(Double.toString(inputStream.getFluid().getPhase(name).getFlowRate(Units.getSymbol("molar flow"))), Units.getSymbol("molar flow")));
            newdata.put("mass flow", new Value(Double.toString(inputStream.getFluid().getPhase(name).getFlowRate(Units.getSymbol("mass flow"))), Units.getSymbol("mass flow")));
            newdata.put("fluid model", new Value(inputStream.getFluid().getModelName(), ""));
            newdata.put("enthalpy", new Value(Double.toString(inputStream.getFluid().getPhase(name).getEnthalpy(Units.getSymbol("enthalpy"))), Units.getSymbol("enthalpy")));
            this.conditions.put(name, newdata);
        }
        this.name = inputStream.getName();
        newdata = new HashMap();
        for (i = 0; i < inputStream.getFluid().getNumberOfComponents(); ++i) {
            newdata.put(inputStream.getFluid().getComponent(i).getComponentName(), new Value(Double.toString(inputStream.getFluid().getComponent(i).getz()), "mole fraction"));
        }
        this.composition.put("overall", newdata);
        for (int j = 0; j < inputStream.getFluid().getNumberOfPhases(); ++j) {
            newdata = new HashMap();
            HashMap<String, Value> newdata2 = new HashMap<String, Value>();
            for (int i2 = 0; i2 < inputStream.getFluid().getNumberOfComponents(); ++i2) {
                newdata2.put(inputStream.getFluid().getPhase(j).getComponent(i2).getComponentName(), new Value(Double.toString(inputStream.getFluid().getPhase(j).getComponent(i2).getx()), "mole fraction"));
                newdata.put(inputStream.getFluid().getPhase(j).getComponent(i2).getComponentName(), new Value(Double.toString(inputStream.getFluid().getPhase(j).getWtFrac(i2)), "weight fraction"));
            }
            this.composition.put(inputStream.getFluid().getPhase(j).getPhaseTypeName(), newdata2);
            this.composition.put(inputStream.getFluid().getPhase(j).getPhaseTypeName() + "_wt", newdata);
        }
        newdata = new HashMap();
        newdata.put("density", new Value(Double.toString(inputStream.getFluid().getDensity(Units.getSymbol("density"))), Units.getSymbol("density")));
        newdata.put("molar mass", new Value(Double.toString(inputStream.getFluid().getMolarMass(Units.getSymbol("Molar Mass"))), Units.getSymbol("Molar Mass")));
        newdata.put("flow rate", new Value(Double.toString(inputStream.getFluid().getFlowRate(Units.getSymbol("volume flow"))), Units.getSymbol("volume flow")));
        newdata.put("heat capacity (Cp)", new Value(Double.toString(inputStream.getFluid().getCp(Units.getSymbol("Heat Capacity (Cp)"))), Units.getSymbol("Heat Capacity (Cp)")));
        newdata.put("heat capacity (Cv)", new Value(Double.toString(inputStream.getFluid().getCv(Units.getSymbol("Heat Capacity (Cv)"))), Units.getSymbol("Heat Capacity (Cv)")));
        newdata.put("enthalpy", new Value(Double.toString(inputStream.getFluid().getEnthalpy(Units.getSymbol("enthalpy"))), Units.getSymbol("enthalpy")));
        newdata.put("entropy", new Value(Double.toString(inputStream.getFluid().getEntropy(Units.getSymbol("entropy"))), Units.getSymbol("entropy")));
        this.properties.put("overall", newdata);
        for (i = 0; i < inputStream.getFluid().getNumberOfPhases(); ++i) {
            newdata = new HashMap();
            name = inputStream.getFluid().getPhase(i).getPhaseTypeName();
            newdata.put("density", new Value(Double.toString(inputStream.getFluid().getPhase(name).getDensity(Units.getSymbol("density"))), Units.getSymbol("density")));
            newdata.put("molar mass", new Value(Double.toString(inputStream.getFluid().getPhase(name).getMolarMass(Units.getSymbol("Molar Mass"))), Units.getSymbol("Molar Mass")));
            newdata.put("flow rate", new Value(Double.toString(inputStream.getFluid().getPhase(name).getFlowRate(Units.getSymbol("volume flow"))), Units.getSymbol("volume flow")));
            newdata.put("heat capacity (Cp)", new Value(Double.toString(inputStream.getFluid().getPhase(name).getCp(Units.getSymbol("Heat Capacity (Cp)"))), Units.getSymbol("Heat Capacity (Cp)")));
            newdata.put("heat capacity (Cv)", new Value(Double.toString(inputStream.getFluid().getPhase(name).getCv(Units.getSymbol("Heat Capacity (Cv)"))), Units.getSymbol("Heat Capacity (Cv)")));
            newdata.put("enthalpy", new Value(Double.toString(inputStream.getFluid().getPhase(name).getEnthalpy(Units.getSymbol("enthalpy"))), Units.getSymbol("enthalpy")));
            newdata.put("entropy", new Value(Double.toString(inputStream.getFluid().getPhase(name).getEntropy(Units.getSymbol("entropy"))), Units.getSymbol("entropy")));
            if (name.equals("oil")) {
                try {
                    newdata.put("TVP", new Value(Double.toString(inputStream.getTVP(37.8, "C", Units.getSymbol("pressure"))), Units.getSymbol("pressure")));
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage());
                }
                try {
                    newdata.put("RVP", new Value(Double.toString(inputStream.getRVP(37.8, "C", Units.getSymbol("pressure"))), Units.getSymbol("pressure")));
                    newdata.put("relative density", new Value(Double.toString(inputStream.getFluid().getPhase(name).getDensity("kg/m3") / 1000.0), "-"));
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage());
                }
            } else if (name.equals("gas")) {
                Standard_ISO6976 standard = inputStream.getISO6976("volume", 15.0, 15.0);
                standard.calculate();
                newdata.put("GCV", new Value(Double.toString(standard.getValue("SuperiorCalorificValue") / 1000.0), "MJ/Sm3 @15C,15C"));
                newdata.put("WI", new Value(Double.toString(standard.getValue("SuperiorWobbeIndex") / 1000.0), "MJ/Sm3 @15C,15C"));
                newdata.put("standard flow rate", new Value(Double.toString(inputStream.getFluid().getPhase(name).getFlowRate(Units.getSymbol("standard volume flow"))), Units.getSymbol("standard volume flow")));
                newdata.put("relative density", new Value(Double.toString(standard.getValue("RelativeDensity")), "[-]"));
            }
            this.properties.put(name, newdata);
        }
    }

    public void print() {
    }
}

