/*
 * Decompiled with CFR 0.152.
 */
package neqsim.pvtsimulation.simulation;

import neqsim.pvtsimulation.simulation.BasePVTsimulation;
import neqsim.thermo.phase.PhaseType;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkEos;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DifferentialLiberation
extends BasePVTsimulation {
    static Logger logger = LogManager.getLogger(DifferentialLiberation.class);
    double VoilStd = 0.0;
    double[] relativeVolume = null;
    double[] totalVolume = null;
    double[] liquidVolumeRelativeToVsat = null;
    double[] liquidVolume = null;
    private double[] oilDensity = null;
    private double[] gasStandardVolume = null;
    double saturationVolume = 0.0;
    double saturationPressure = 0.0;
    boolean saturationConditionFound = false;
    private double[] Bo;
    private double[] Bg;
    private double[] Rs;
    private double[] Zgas;
    private double[] relGasGravity;
    double[] gasVolume;

    public DifferentialLiberation(SystemInterface tempSystem) {
        super(tempSystem);
    }

    public void calcSaturationConditions() {
        this.getThermoSystem().setPressure(1.0);
        do {
            this.getThermoSystem().setPressure(this.getThermoSystem().getPressure() + 10.0);
        } while (this.getThermoSystem().getNumberOfPhases() == 1 && this.getThermoSystem().getPressure() < 1000.0);
        do {
            this.getThermoSystem().setPressure(this.getThermoSystem().getPressure() + 10.0);
            this.thermoOps.TPflash();
        } while (this.getThermoSystem().getNumberOfPhases() > 1 && this.getThermoSystem().getPressure() < 1000.0);
        double minPres = this.getThermoSystem().getPressure() - 10.0;
        double maxPres = this.getThermoSystem().getPressure();
        do {
            this.getThermoSystem().setPressure((minPres + maxPres) / 2.0);
            this.thermoOps.TPflash();
            if (this.getThermoSystem().getNumberOfPhases() > 1) {
                minPres = this.getThermoSystem().getPressure();
                continue;
            }
            maxPres = this.getThermoSystem().getPressure();
        } while (Math.abs(maxPres - minPres) > 1.0E-5);
        this.getThermoSystem().initPhysicalProperties();
        this.saturationVolume = this.getThermoSystem().getPhase(0).getMass() / this.getThermoSystem().getPhase(0).getPhysicalProperties().getDensity();
        this.saturationPressure = this.getThermoSystem().getPressure();
        this.saturationConditionFound = true;
    }

    public void runCalc() {
        this.saturationConditionFound = false;
        this.relativeVolume = new double[this.pressures.length];
        double[] mass = new double[this.pressures.length];
        this.totalVolume = new double[this.pressures.length];
        this.liquidVolumeRelativeToVsat = new double[this.pressures.length];
        this.liquidVolume = new double[this.pressures.length];
        this.gasVolume = new double[this.pressures.length];
        this.gasStandardVolume = new double[this.pressures.length];
        this.Bo = new double[this.pressures.length];
        this.Bg = new double[this.pressures.length];
        this.Rs = new double[this.pressures.length];
        this.Zgas = new double[this.pressures.length];
        this.relGasGravity = new double[this.pressures.length];
        this.oilDensity = new double[this.pressures.length];
        double totalGasStandardVolume = 0.0;
        if (!Double.isNaN(this.temperature)) {
            this.getThermoSystem().setTemperature(this.temperature, this.temperatureUnit);
        }
        for (int i = 0; i < this.pressures.length; ++i) {
            this.getThermoSystem().setPressure(this.pressures[i]);
            try {
                this.thermoOps.TPflash();
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            this.getThermoSystem().initPhysicalProperties();
            this.oilDensity[i] = this.getThermoSystem().getDensity("kg/m3");
            mass[i] = this.getThermoSystem().getMass("kg");
            this.totalVolume[i] = mass[i] / this.oilDensity[i];
            this.liquidVolume[i] = this.totalVolume[i];
            if (this.getThermoSystem().getNumberOfPhases() <= 1) continue;
            if (!this.saturationConditionFound) {
                this.calcSaturationConditions();
                this.getThermoSystem().setPressure(this.pressures[i]);
                try {
                    this.thermoOps.TPflash();
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
            this.gasStandardVolume[i] = this.getThermoSystem().getPhase(PhaseType.GAS).getMass() / this.getThermoSystem().getPhase(PhaseType.GAS).getPhysicalProperties().getDensity() * this.getThermoSystem().getPhase(0).getPressure() / 1.01325 / this.getThermoSystem().getPhase(0).getZ() * 288.15 / this.getThermoSystem().getTemperature();
            totalGasStandardVolume += this.getGasStandardVolume()[i];
            this.Zgas[i] = this.getThermoSystem().getPhase(0).getZ();
            this.relGasGravity[i] = this.getThermoSystem().getPhase(0).getMolarMass() / 0.028;
            if (this.getThermoSystem().hasPhaseType(PhaseType.GAS) && this.getThermoSystem().hasPhaseType(PhaseType.OIL)) {
                this.oilDensity[i] = this.getThermoSystem().getPhase(1).getPhysicalProperties().getDensity();
                this.liquidVolume[i] = this.getThermoSystem().getPhase(1).getMass() / this.oilDensity[i];
                this.getThermoSystem().getPhase(1).getMass();
            } else if (this.getThermoSystem().hasPhaseType("oil")) {
                this.oilDensity[i] = this.getThermoSystem().getPhase(0).getPhysicalProperties().getDensity();
                this.liquidVolume[i] = this.getThermoSystem().getPhase(0).getMass() / this.oilDensity[i];
            } else {
                this.oilDensity[i] = this.getThermoSystem().getPhase(0).getPhysicalProperties().getDensity();
                this.liquidVolume[i] = this.getThermoSystem().getPhase(0).getMass() / this.oilDensity[i];
            }
            if (this.getThermoSystem().getNumberOfPhases() > 1) {
                this.gasVolume[i] = this.getThermoSystem().getPhase(PhaseType.GAS).getMass() / this.getThermoSystem().getPhase(PhaseType.GAS).getPhysicalProperties().getDensity();
            }
            this.liquidVolumeRelativeToVsat[i] = this.liquidVolume[i] / this.saturationVolume;
            this.getThermoSystem().removePhase(0);
        }
        this.getThermoSystem().setPressure(1.01325);
        this.getThermoSystem().setTemperature(288.15);
        try {
            this.thermoOps.TPflash();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        this.getThermoSystem().initPhysicalProperties();
        this.VoilStd = this.getThermoSystem().getPhase(PhaseType.OIL).getMass() / this.getThermoSystem().getPhase(PhaseType.OIL).getPhysicalProperties().getDensity();
        if (this.getThermoSystem().hasPhaseType(PhaseType.GAS)) {
            totalGasStandardVolume += this.getThermoSystem().getPhase(PhaseType.GAS).getCorrectedVolume();
        }
        double total = 0.0;
        for (int i = 0; i < this.pressures.length; ++i) {
            this.relativeVolume[i] = this.totalVolume[i] / this.saturationVolume;
            this.Bo[i] = this.liquidVolume[i] / this.VoilStd;
            this.Rs[i] = (totalGasStandardVolume - (total += this.getGasStandardVolume()[i])) / this.VoilStd;
            if (!(this.Zgas[i] > 1.0E-10)) continue;
            this.Bg[i] = this.gasVolume[i] / this.getGasStandardVolume()[i];
        }
    }

    public static void main(String[] args) {
        SystemSrkEos tempSystem = new SystemSrkEos(356.65, 450.0);
        tempSystem.addComponent("nitrogen", 0.586);
        tempSystem.addComponent("CO2", 0.087);
        tempSystem.addComponent("methane", 107.0209);
        tempSystem.addComponent("ethane", 15.176);
        tempSystem.addComponent("propane", 6.652);
        tempSystem.addComponent("i-butane", 3.533);
        tempSystem.addComponent("n-butane", 5.544);
        tempSystem.addComponent("i-pentane", 1.585);
        tempSystem.addComponent("n-pentane", 2.036);
        tempSystem.addTBPfraction("C6", 2.879, 0.0849, 0.6668);
        tempSystem.addTBPfraction("C7", 4.435, 0.0932, 0.7243);
        tempSystem.addTBPfraction("C8", 4.815, 0.1057, 0.7527);
        tempSystem.addTBPfraction("C9", 3.488, 0.1198, 0.7743);
        tempSystem.addPlusFraction("C10", 45.944, 0.32, 0.924);
        tempSystem.getCharacterization().characterisePlusFraction();
        DifferentialLiberation differentialLiberation = new DifferentialLiberation(tempSystem);
        differentialLiberation.setPressures(new double[]{350.0, 250.0, 200.0, 150.0, 100.0, 70.0, 50.0, 40.0, 30.0, 20.0, 1.0});
        differentialLiberation.setTemperature(83.5, "C");
        differentialLiberation.runCalc();
    }

    public double[] getRelativeVolume() {
        return this.relativeVolume;
    }

    @Override
    public double getSaturationPressure() {
        return this.saturationPressure;
    }

    public double[] getBo() {
        return this.Bo;
    }

    public double[] getBg() {
        return this.Bg;
    }

    public double[] getRs() {
        return this.Rs;
    }

    public double[] getZgas() {
        return this.Zgas;
    }

    public double[] getRelGasGravity() {
        return this.relGasGravity;
    }

    public double[] getGasStandardVolume() {
        return this.gasStandardVolume;
    }

    public double[] getOilDensity() {
        return this.oilDensity;
    }
}

