/*
 * Decompiled with CFR 0.152.
 */
package neqsim.pvtsimulation.simulation;

import neqsim.pvtsimulation.simulation.BasePVTsimulation;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkEos;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SwellingTest
extends BasePVTsimulation {
    static Logger logger = LogManager.getLogger(SwellingTest.class);
    double[] gasInjected = null;
    private double[] pressures = null;
    private double[] relativeOilVolume = null;
    SystemInterface injectionGas;

    public SwellingTest(SystemInterface tempSystem) {
        super(tempSystem);
    }

    public void setInjectionGas(SystemInterface injectionGas) {
        this.injectionGas = injectionGas;
    }

    public void setCummulativeMolePercentGasInjected(double[] gasInjected) {
        this.gasInjected = gasInjected;
        this.setPressures(new double[gasInjected.length]);
        this.setRelativeOilVolume(new double[gasInjected.length]);
    }

    public void runCalc() {
        int i;
        double oldInjected = 0.0;
        try {
            this.thermoOps.bubblePointPressureFlash(false);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        double orginalOilVolume = this.getThermoSystem().getVolume();
        double oilMoles = this.getThermoSystem().getTotalNumberOfMoles();
        for (i = 0; i < this.getPressures().length; ++i) {
            if (this.gasInjected[i] > 1.0E-10) {
                this.injectionGas.setTotalFlowRate(oilMoles * (this.gasInjected[i] - oldInjected) / 100.0, "mol/sec");
                this.injectionGas.init(0);
                this.injectionGas.init(1);
                oldInjected = this.gasInjected[i];
                this.getThermoSystem().init(0);
                this.getThermoSystem().addFluid(this.injectionGas);
            }
            this.getThermoSystem().init(0);
            if (i == 0) {
                this.getThermoSystem().setPressure(10.0);
            }
            this.getThermoSystem().setTemperature(this.temperature);
            try {
                this.thermoOps.bubblePointPressureFlash(false);
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            this.pressures[i] = this.getThermoSystem().getPressure();
            this.getRelativeOilVolume()[i] = this.getThermoSystem().getVolume() / orginalOilVolume;
        }
        for (i = 0; i < this.getPressures().length; ++i) {
            logger.info("pressure " + this.getPressures()[i] + " relativeOil volume " + this.getRelativeOilVolume()[i]);
        }
    }

    public static void main(String[] args) {
        SystemSrkEos oilSystem = new SystemSrkEos(298.0, 50.0);
        oilSystem.addComponent("methane", 5.01);
        oilSystem.addComponent("propane", 0.01);
        oilSystem.addTBPfraction("C10", 100.0, 0.145, 0.82);
        oilSystem.addTBPfraction("C12", 120.0, 0.175, 0.85);
        oilSystem.createDatabase(true);
        oilSystem.setMixingRule(2);
        SystemSrkEos gasSystem = new SystemSrkEos(298.0, 50.0);
        gasSystem.addComponent("methane", 110.0);
        gasSystem.addComponent("ethane", 10.0);
        gasSystem.createDatabase(true);
        gasSystem.setMixingRule(2);
        SwellingTest test = new SwellingTest(oilSystem);
        test.setInjectionGas(gasSystem);
        test.setTemperature(298.15);
        test.setCummulativeMolePercentGasInjected(new double[]{0.0, 0.01, 0.02, 0.03, 0.05, 0.1, 0.2, 0.4, 0.5, 1.0, 10.3, 22.0});
        test.runCalc();
        test.getThermoSystem().display();
    }

    public double[] getRelativeOilVolume() {
        return this.relativeOilVolume;
    }

    public void setRelativeOilVolume(double[] relativeOilVolume) {
        this.relativeOilVolume = relativeOilVolume;
    }

    @Override
    public double[] getPressures() {
        return this.pressures;
    }

    @Override
    public void setPressures(double[] pressures) {
        this.pressures = pressures;
    }
}

