/*
 * Decompiled with CFR 0.152.
 */
package neqsim.pvtsimulation.simulation;

import java.util.ArrayList;
import neqsim.physicalproperties.util.parameterfitting.purecomponentparameterfitting.purecompviscosity.linearliquidmodel.ViscosityFunction;
import neqsim.pvtsimulation.simulation.BasePVTsimulation;
import neqsim.statistics.parameterfitting.SampleSet;
import neqsim.statistics.parameterfitting.SampleValue;
import neqsim.statistics.parameterfitting.nonlinearparameterfitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkEos;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ViscositySim
extends BasePVTsimulation {
    static Logger logger = LogManager.getLogger(ViscositySim.class);
    double[] temperature = new double[1];
    double[] pressure = new double[1];
    private double[] gasViscosity;
    private double[] oilViscosity;
    private double[] aqueousViscosity;
    ViscosityFunction function;

    public ViscositySim(SystemInterface tempSystem) {
        super(tempSystem);
        this.temperature[0] = tempSystem.getTemperature();
        this.pressure[0] = tempSystem.getPressure();
    }

    public void setTemperaturesAndPressures(double[] temperature, double[] pressure) {
        this.pressure = pressure;
        this.temperature = temperature;
        this.experimentalData = new double[temperature.length][1];
    }

    public void runTuning() {
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        try {
            System.out.println("adding....");
            for (int i = 0; i < this.experimentalData[0].length; ++i) {
                ViscosityFunction function = new ViscosityFunction();
                double[] guess = new double[]{1.0};
                function.setInitialGuess(guess);
                SystemInterface tempSystem = this.getThermoSystem().clone();
                tempSystem.setTemperature(this.temperature[i]);
                tempSystem.setPressure(this.pressure[i]);
                this.thermoOps.TPflash();
                double[] sample1 = new double[]{this.temperature[i]};
                double viscosity = this.experimentalData[0][i];
                double[] standardDeviation1 = new double[]{1.5};
                SampleValue sample = new SampleValue(viscosity, viscosity / 50.0, sample1, standardDeviation1);
                sample.setFunction(function);
                sample.setThermodynamicSystem(tempSystem);
                sampleList.add(sample);
            }
        }
        catch (Exception ex) {
            logger.error("database error", (Throwable)ex);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        this.optimizer = new LevenbergMarquardt();
        this.optimizer.setMaxNumberOfIterations(20);
        this.optimizer.setSampleSet(sampleSet);
        this.optimizer.solve();
        this.runCalc();
    }

    public void runCalc() {
        this.gasViscosity = new double[this.pressure.length];
        this.oilViscosity = new double[this.pressure.length];
        this.aqueousViscosity = new double[this.pressure.length];
        for (int i = 0; i < this.pressure.length; ++i) {
            this.getThermoSystem().setPressure(this.pressure[i]);
            this.getThermoSystem().setTemperature(this.temperature[i]);
            this.thermoOps.TPflash();
            this.getThermoSystem().initPhysicalProperties();
            if (this.getThermoSystem().hasPhaseType("gas")) {
                this.gasViscosity[i] = this.getThermoSystem().getPhase("gas").getPhysicalProperties().getViscosity();
            }
            if (this.getThermoSystem().hasPhaseType("oil")) {
                this.oilViscosity[i] = this.getThermoSystem().getPhase("oil").getPhysicalProperties().getViscosity();
            }
            if (!this.getThermoSystem().hasPhaseType("aqueous")) continue;
            this.aqueousViscosity[i] = this.getThermoSystem().getPhase("aqueous").getPhysicalProperties().getViscosity();
        }
    }

    public static void main(String[] args) {
        SystemSrkEos tempSystem = new SystemSrkEos(298.0, 10.0);
        tempSystem.addComponent("n-heptane", 6.78);
        tempSystem.addPlusFraction("C20", 10.62, 0.1, 0.73);
        tempSystem.createDatabase(true);
        tempSystem.setMixingRule(2);
        tempSystem.init(0);
        tempSystem.init(1);
        ViscositySim sepSim = new ViscositySim(tempSystem);
        double[] temps = new double[]{300.15, 293.15, 283.15, 273.15, 264.15};
        double[] pres = new double[]{5.0, 5.0, 5.0, 5.0, 5.0};
        sepSim.setTemperaturesAndPressures(temps, pres);
        sepSim.runCalc();
        double[][] expData = new double[][]{{2.0E-4, 3.0E-4, 4.0E-4, 5.0E-4, 6.0E-4}};
        sepSim.setExperimentalData(expData);
        sepSim.runCalc();
        double a = sepSim.getGasViscosity()[0];
        double a2 = sepSim.getOilViscosity()[0];
    }

    public double[] getGasViscosity() {
        return this.gasViscosity;
    }

    public double[] getOilViscosity() {
        return this.oilViscosity;
    }

    public double[] getAqueousViscosity() {
        return this.aqueousViscosity;
    }
}

