/*
 * Decompiled with CFR 0.152.
 */
package neqsim.pvtsimulation.util.parameterfitting;

import java.util.ArrayList;
import neqsim.pvtsimulation.util.parameterfitting.SaturationPressureFunction;
import neqsim.statistics.parameterfitting.SampleSet;
import neqsim.statistics.parameterfitting.SampleValue;
import neqsim.statistics.parameterfitting.nonlinearparameterfitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemSrkEos;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestSaturationPresFunction {
    static Logger logger = LogManager.getLogger(TestSaturationPresFunction.class);

    public static void main(String[] args) {
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        try {
            System.out.println("adding....");
            for (int i = 0; i < 1; ++i) {
                SaturationPressureFunction function = new SaturationPressureFunction();
                double[] guess = new double[]{0.3416};
                function.setInitialGuess(guess);
                SystemSrkEos tempSystem = new SystemSrkEos(393.15, 100.0);
                tempSystem.addComponent("nitrogen", 0.34);
                tempSystem.addComponent("CO2", 3.59);
                tempSystem.addComponent("methane", 67.42);
                tempSystem.addComponent("ethane", 9.02);
                tempSystem.addComponent("propane", 4.31);
                tempSystem.addComponent("i-butane", 0.93);
                tempSystem.addComponent("n-butane", 1.71);
                tempSystem.addComponent("i-pentane", 0.74);
                tempSystem.addComponent("n-pentane", 0.85);
                tempSystem.addComponent("n-hexane", 1.38);
                tempSystem.addTBPfraction("C7", 1.5, 0.109, 0.6912);
                tempSystem.addTBPfraction("C8", 1.69, 0.1202, 0.7255);
                tempSystem.addTBPfraction("C9", 1.14, 0.1295, 0.7454);
                tempSystem.addTBPfraction("C10", 0.8, 0.1353, 0.7864);
                tempSystem.addPlusFraction("C11", 4.58, 0.3412, 0.8398);
                tempSystem.getCharacterization().getLumpingModel().setNumberOfLumpedComponents(12);
                tempSystem.createDatabase(true);
                tempSystem.setMixingRule(2);
                tempSystem.init(0);
                tempSystem.init(1);
                double[] sample1 = new double[]{373.15};
                double satPres = 400.0;
                double[] standardDeviation1 = new double[]{1.5};
                SampleValue sample = new SampleValue(satPres, satPres / 100.0, sample1, standardDeviation1);
                sample.setFunction(function);
                function.setInitialGuess(guess);
                sample.setThermodynamicSystem(tempSystem);
                sampleList.add(sample);
            }
        }
        catch (Exception ex) {
            logger.error("database error", (Throwable)ex);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        LevenbergMarquardt optim = new LevenbergMarquardt();
        optim.setMaxNumberOfIterations(5);
        optim.setSampleSet(sampleSet);
        optim.solve();
        optim.displayCurveFit();
    }
}

