/*
 * Decompiled with CFR 0.152.
 */
package neqsim.standards.gasquality;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import neqsim.standards.Standard;
import neqsim.thermo.system.SystemGERG2004Eos;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.ThermodynamicOperations;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Draft_GERG2004
extends Standard {
    private static final long serialVersionUID = 1L;
    static Logger logger = LogManager.getLogger(Draft_GERG2004.class);
    double specPressure = 70.0;
    double initTemperature = 273.15;

    public Draft_GERG2004(SystemInterface thermoSystemMet) {
        super("Draft_GERG2004", "reference properties of natural gas");
        if (thermoSystemMet.getModelName().equals("GERG2004-EOS")) {
            this.thermoSystem = thermoSystemMet;
        } else {
            this.thermoSystem = new SystemGERG2004Eos(thermoSystemMet.getTemperature(), thermoSystemMet.getPressure());
            for (int i = 0; i < thermoSystemMet.getPhase(0).getNumberOfComponents(); ++i) {
                this.thermoSystem.addComponent(thermoSystemMet.getPhase(0).getComponent(i).getName(), thermoSystemMet.getPhase(0).getComponent(i).getNumberOfmoles());
            }
        }
        this.thermoSystem.setMixingRule(1);
        this.thermoSystem.init(0);
        this.thermoSystem.init(1);
        this.thermoOps = new ThermodynamicOperations(this.thermoSystem);
    }

    @Override
    public void calculate() {
        try {
            this.thermoOps.TPflash();
            this.thermoSystem.display();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public double getValue(String returnParameter, String returnUnit) {
        return 0.0;
    }

    @Override
    public double getValue(String returnParameter) {
        if (returnParameter.equals("dewPointTemperature")) {
            return 0.0;
        }
        if (returnParameter.equals("pressure")) {
            return this.thermoSystem.getPressure();
        }
        return 0.0;
    }

    @Override
    public String getUnit(String returnParameter) {
        if (returnParameter.equals("dewPointTemperature")) {
            return "";
        }
        if (returnParameter.equals("pressureUnit")) {
            return "";
        }
        return "";
    }

    @Override
    public boolean isOnSpec() {
        return false;
    }

    @Override
    public String[][] createTable(String name) {
        int i;
        this.thermoSystem.createTable(name);
        DecimalFormat nf = new DecimalFormat();
        nf.setMaximumFractionDigits(5);
        nf.applyPattern("#.#####E0");
        int rows = 0;
        if (this.thermoSystem == null) {
            String[][] table = new String[0][6];
            return table;
        }
        rows = this.thermoSystem.getPhases()[0].getNumberOfComponents() + 30;
        String[][] table = new String[rows][6];
        table[0][0] = "";
        for (i = 0; i < this.thermoSystem.getPhases()[0].getNumberOfComponents() + 30; ++i) {
            for (int j = 0; j < 6; ++j) {
                table[i][j] = "";
            }
        }
        for (i = 0; i < this.thermoSystem.getNumberOfPhases(); ++i) {
            table[0][i + 1] = this.thermoSystem.getPhase(i).getType().toString();
        }
        StringBuffer buf = new StringBuffer();
        FieldPosition test = new FieldPosition(0);
        for (int i2 = 0; i2 < this.thermoSystem.getNumberOfPhases(); ++i2) {
            for (int j = 0; j < this.thermoSystem.getPhases()[0].getNumberOfComponents(); ++j) {
                table[j + 1][0] = this.thermoSystem.getPhases()[0].getComponents()[j].getName();
                buf = new StringBuffer();
                table[j + 1][i2 + 1] = nf.format(this.thermoSystem.getPhase(this.thermoSystem.getPhaseIndex(i2)).getComponents()[j].getx(), buf, test).toString();
                table[j + 1][4] = "[-]";
            }
            buf = new StringBuffer();
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 3][0] = "Compressibility Factor";
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 3][i2 + 1] = nf.format(this.thermoSystem.getPhase(i2).getZ());
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 3][4] = "[-]";
            buf = new StringBuffer();
            table[this.thermoSystem.getPhase((int)this.thermoSystem.getPhaseIndex((int)i2)).getNumberOfComponents() + 4][0] = "Density";
            table[this.thermoSystem.getPhase((int)this.thermoSystem.getPhaseIndex((int)i2)).getNumberOfComponents() + 4][i2 + 1] = nf.format(this.thermoSystem.getPhase(this.thermoSystem.getPhaseIndex(i2)).getPhysicalProperties().getDensity(), buf, test).toString();
            table[this.thermoSystem.getPhase((int)this.thermoSystem.getPhaseIndex((int)i2)).getNumberOfComponents() + 4][4] = "[kg/m^3]";
            buf = new StringBuffer();
            table[this.thermoSystem.getPhase((int)this.thermoSystem.getPhaseIndex((int)i2)).getNumberOfComponents() + 5][0] = "PhaseFraction";
            table[this.thermoSystem.getPhase((int)this.thermoSystem.getPhaseIndex((int)i2)).getNumberOfComponents() + 5][i2 + 1] = nf.format(this.thermoSystem.getPhase(this.thermoSystem.getPhaseIndex(i2)).getBeta(), buf, test).toString();
            table[this.thermoSystem.getPhase((int)this.thermoSystem.getPhaseIndex((int)i2)).getNumberOfComponents() + 5][4] = "[-]";
            buf = new StringBuffer();
            table[this.thermoSystem.getPhase((int)this.thermoSystem.getPhaseIndex((int)i2)).getNumberOfComponents() + 6][0] = "MolarMass";
            table[this.thermoSystem.getPhase((int)this.thermoSystem.getPhaseIndex((int)i2)).getNumberOfComponents() + 6][i2 + 1] = nf.format(this.thermoSystem.getPhase(this.thermoSystem.getPhaseIndex(i2)).getMolarMass() * 1000.0, buf, test).toString();
            table[this.thermoSystem.getPhase((int)this.thermoSystem.getPhaseIndex((int)i2)).getNumberOfComponents() + 6][4] = "[kg/kmol]";
            buf = new StringBuffer();
            table[this.thermoSystem.getPhase((int)this.thermoSystem.getPhaseIndex((int)i2)).getNumberOfComponents() + 7][0] = "Cp";
            table[this.thermoSystem.getPhase((int)this.thermoSystem.getPhaseIndex((int)i2)).getNumberOfComponents() + 7][i2 + 1] = nf.format(this.thermoSystem.getPhase(this.thermoSystem.getPhaseIndex(i2)).getCp() / (this.thermoSystem.getPhase(this.thermoSystem.getPhaseIndex(i2)).getNumberOfMolesInPhase() * this.thermoSystem.getPhase(this.thermoSystem.getPhaseIndex(i2)).getMolarMass() * 1000.0), buf, test).toString();
            table[this.thermoSystem.getPhase((int)this.thermoSystem.getPhaseIndex((int)i2)).getNumberOfComponents() + 7][4] = "[kJ/kg*K]";
            buf = new StringBuffer();
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 10][0] = "Pressure";
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 10][i2 + 1] = Double.toString(this.thermoSystem.getPhase(this.thermoSystem.getPhaseIndex(i2)).getPressure());
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 10][4] = "[bar]";
            buf = new StringBuffer();
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 11][0] = "Temperature";
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 11][i2 + 1] = Double.toString(this.thermoSystem.getPhase(this.thermoSystem.getPhaseIndex(i2)).getTemperature());
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 11][4] = "[K]";
            Double.toString(this.thermoSystem.getPhase(this.thermoSystem.getPhaseIndex(i2)).getTemperature());
        }
        this.resultTable = table;
        return table;
    }
}

