/*
 * Decompiled with CFR 0.152.
 */
package neqsim.standards.gasquality;

import neqsim.standards.Standard;
import neqsim.thermo.system.SystemInterface;

public class GasChromotograpyhBase
extends Standard {
    private static final long serialVersionUID = 1L;
    String unit = "mol%";

    public GasChromotograpyhBase(SystemInterface thermoSystem) {
        super("gas chromotography", "Gas composition", thermoSystem);
    }

    @Override
    public void calculate() {
        this.thermoSystem.init(0);
        this.thermoSystem.init(0);
    }

    @Override
    public double getValue(String componentName, String returnUnit) {
        this.unit = returnUnit;
        if (returnUnit.equals("mol%")) {
            return 100.0 * this.thermoSystem.getPhase(0).getComponent(componentName).getz();
        }
        if (returnUnit.equals("mg/m3")) {
            return this.thermoSystem.getPhase(0).getComponent(componentName).getz() * 1000000.0;
        }
        return this.thermoSystem.getPhase(0).getComponent(componentName).getz();
    }

    @Override
    public double getValue(String componentName) {
        return this.thermoSystem.getPhase(0).getComponent(componentName).getz();
    }

    @Override
    public String getUnit(String returnParameter) {
        return this.unit;
    }

    @Override
    public boolean isOnSpec() {
        return true;
    }
}

