/*
 * Decompiled with CFR 0.152.
 */
package neqsim.standards.gasquality;

import neqsim.standards.Standard;
import neqsim.thermo.system.SystemInterface;
import neqsim.util.exception.InvalidInputException;

public class Standard_ISO15403
extends Standard {
    private static final long serialVersionUID = 1L;
    private double NM;
    private double MON;

    public Standard_ISO15403(SystemInterface thermoSystem) {
        super("Standard_ISO15403", "Natural gas \u2014 Natural gas for use as a compressed fuel for vehicles", thermoSystem);
    }

    private double getMolefraction(String name) {
        if (this.thermoSystem.getPhase(0).hasComponent(name)) {
            return this.thermoSystem.getComponent(name).getz();
        }
        return 0.0;
    }

    @Override
    public void calculate() {
        this.MON = 137.78 * this.getMolefraction("methane") + 29.948 * this.getMolefraction("ethane") - 18.193 * this.getMolefraction("propane") - 167.062 * (this.getMolefraction("n-butane") + this.getMolefraction("i-butane")) + 181.233 * this.getMolefraction("CO2") + 26.944 * this.getMolefraction("nitrogen");
        this.NM = 1.445 * this.MON - 103.42;
    }

    @Override
    public double getValue(String returnParameter) {
        if (returnParameter.equals("MON")) {
            return this.MON;
        }
        if (returnParameter.equals("NM")) {
            return this.NM;
        }
        throw new RuntimeException(new InvalidInputException(this, "getValue", "returnParameter", "parameter not supported"));
    }

    @Override
    public double getValue(String returnParameter, String returnUnit) {
        return this.getValue(returnParameter);
    }

    @Override
    public String getUnit(String returnParameter) {
        return "";
    }

    @Override
    public boolean isOnSpec() {
        return true;
    }
}

