/*
 * Decompiled with CFR 0.152.
 */
package neqsim.standards.gasquality;

import java.sql.ResultSet;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.util.ArrayList;
import java.util.Arrays;
import neqsim.standards.Standard;
import neqsim.thermo.ThermodynamicConstantsInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Standard_ISO6976
extends Standard
implements ThermodynamicConstantsInterface {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(Standard_ISO6976.class);
    ArrayList<String> componentsNotDefinedByStandard = new ArrayList();
    double volRefT = 0.0;
    double volRefP = 1.01325;
    double R = 8.31451;
    double molRefm3 = 0.0;
    double energyRefT = 25.0;
    double energyRefP = 1.01325;
    String referenceType = "volume";
    String energyUnit = "KJ/Nm3";
    double energy = 1.0;
    double Zmix0 = 1.0;
    double Zmix15 = 1.0;
    double Zmix20 = 1.0;
    double Zair0 = 0.99941;
    double Zair15 = 0.99958;
    double Zair20 = 0.99963;
    double averageCarbonNumber = 0.0;
    int[] carbonNumber;
    double[] M;
    double[] Z0;
    double[] Z15;
    double[] Z20;
    double[] bsqrt0;
    double[] bsqrt15;
    double[] bsqrt20;
    double[] Hsup0;
    double[] Hsup15;
    double[] Hsup20;
    double[] Hsup25;
    double[] Hsup60F;
    double[] Hinf0;
    double[] Hinf15;
    double[] Hinf20;
    double[] Hinf25;
    double[] Hinf60F;
    double Mmix = 0.0;
    double HsupIdeal0 = 0.0;
    double HsupIdeal15 = 0.0;
    double HsupIdeal20 = 0.0;
    double HsupIdeal25 = 0.0;
    double HsupIdeal60F = 0.0;
    double HinfIdeal0 = 0.0;
    double HinfIdeal15 = 0.0;
    double HinfIdeal20 = 0.0;
    double HinfIdeal25 = 0.0;
    double HinfIdeal60F = 0.0;
    double wobbeIdeal = 0.0;
    double wobbeReal = 0.0;
    double relDensIdeal = 0.0;
    double relDensReal = 0.0;
    double densIdeal = 0.0;
    double densReal = 0.0;

    public Standard_ISO6976(SystemInterface thermoSystem) {
        this("Standard_ISO6976", "Calculation of calorific values, density, relative density and Wobbe index from composition", thermoSystem);
    }

    public Standard_ISO6976(String name, String description, SystemInterface thermoSystem) {
        super(name, description, thermoSystem);
        this.M = new double[thermoSystem.getPhase(0).getNumberOfComponents()];
        this.carbonNumber = new int[thermoSystem.getPhase(0).getNumberOfComponents()];
        this.Z0 = new double[thermoSystem.getPhase(0).getNumberOfComponents()];
        this.Z15 = new double[thermoSystem.getPhase(0).getNumberOfComponents()];
        this.Z20 = new double[thermoSystem.getPhase(0).getNumberOfComponents()];
        this.bsqrt0 = new double[thermoSystem.getPhase(0).getNumberOfComponents()];
        this.bsqrt15 = new double[thermoSystem.getPhase(0).getNumberOfComponents()];
        this.bsqrt20 = new double[thermoSystem.getPhase(0).getNumberOfComponents()];
        this.Hsup0 = new double[thermoSystem.getPhase(0).getNumberOfComponents()];
        this.Hsup15 = new double[thermoSystem.getPhase(0).getNumberOfComponents()];
        this.Hsup20 = new double[thermoSystem.getPhase(0).getNumberOfComponents()];
        this.Hsup25 = new double[thermoSystem.getPhase(0).getNumberOfComponents()];
        this.Hsup60F = new double[thermoSystem.getPhase(0).getNumberOfComponents()];
        this.Hinf0 = new double[thermoSystem.getPhase(0).getNumberOfComponents()];
        this.Hinf15 = new double[thermoSystem.getPhase(0).getNumberOfComponents()];
        this.Hinf20 = new double[thermoSystem.getPhase(0).getNumberOfComponents()];
        this.Hinf25 = new double[thermoSystem.getPhase(0).getNumberOfComponents()];
        this.Hinf60F = new double[thermoSystem.getPhase(0).getNumberOfComponents()];
        try (NeqSimDataBase database = new NeqSimDataBase();){
            ResultSet dataSet = null;
            for (int i = 0; i < thermoSystem.getPhase(0).getNumberOfComponents(); ++i) {
                try {
                    dataSet = database.getResultSet("SELECT * FROM ISO6976constants WHERE ComponentName='" + this.thermoSystem.getPhase(0).getComponent(i).getName() + "'");
                    dataSet.next();
                    dataSet.getString("ID");
                }
                catch (Exception ex) {
                    try {
                        String compName = "inert";
                        String compType = this.thermoSystem.getPhase(0).getComponent(i).getComponentType();
                        if (compType.equals("HC") || compType.equals("TBP") || compType.equals("plus")) {
                            compName = "n-heptane";
                        } else if (compType.equals("alcohol") || compType.equals("glycol")) {
                            compName = "methanol";
                        }
                        dataSet.close();
                        dataSet = database.getResultSet("SELECT * FROM iso6976constants WHERE ComponentName='" + compName + "'");
                        this.M[i] = this.thermoSystem.getPhase(0).getComponent(i).getMolarMass();
                        dataSet.next();
                    }
                    catch (Exception ex2) {
                        logger.error(ex2.getMessage());
                    }
                    this.componentsNotDefinedByStandard.add("this.thermoSystem.getPhase(0).getComponent(i).getComponentName()");
                }
                this.carbonNumber[i] = Integer.parseInt(dataSet.getString("numberOfCarbon"));
                this.M[i] = Double.parseDouble(dataSet.getString("MolarMass"));
                this.Z0[i] = Double.parseDouble(dataSet.getString("Z0"));
                this.Z15[i] = Double.parseDouble(dataSet.getString("Z15"));
                this.Z20[i] = Double.parseDouble(dataSet.getString("Z20"));
                this.bsqrt0[i] = Double.parseDouble(dataSet.getString("srtb0"));
                this.bsqrt15[i] = Double.parseDouble(dataSet.getString("srtb15"));
                this.bsqrt20[i] = Double.parseDouble(dataSet.getString("srtb20"));
                this.Hsup0[i] = Double.parseDouble(dataSet.getString("Hsupmolar0"));
                this.Hsup15[i] = Double.parseDouble(dataSet.getString("Hsupmolar15"));
                this.Hsup20[i] = Double.parseDouble(dataSet.getString("Hsupmolar20"));
                this.Hsup25[i] = Double.parseDouble(dataSet.getString("Hsupmolar25"));
                this.Hsup60F[i] = Double.parseDouble(dataSet.getString("Hsupmolar60F"));
                this.Hinf0[i] = Double.parseDouble(dataSet.getString("Hinfmolar0"));
                this.Hinf15[i] = Double.parseDouble(dataSet.getString("Hinfmolar15"));
                this.Hinf20[i] = Double.parseDouble(dataSet.getString("Hinfmolar20"));
                this.Hinf25[i] = Double.parseDouble(dataSet.getString("Hinfmolar25"));
                this.Hinf60F[i] = Double.parseDouble(dataSet.getString("Hinfmolar60F"));
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public Standard_ISO6976(SystemInterface thermoSystem, double volumetricReferenceTemperaturedegC, double energyReferenceTemperaturedegC, String calculationType) {
        this(thermoSystem);
        this.referenceType = calculationType;
        this.volRefT = volumetricReferenceTemperaturedegC;
        this.energyRefT = energyReferenceTemperaturedegC;
    }

    @Override
    public void calculate() {
        this.Zmix0 = 1.0;
        this.Zmix15 = 1.0;
        this.Zmix20 = 1.0;
        double Zmixtemp0 = 0.0;
        double Zmixtemp15 = 0.0;
        double Zmixtemp20 = 0.0;
        this.Mmix = 0.0;
        this.relDensIdeal = 0.0;
        this.HsupIdeal0 = 0.0;
        this.HsupIdeal15 = 0.0;
        this.HsupIdeal20 = 0.0;
        this.HsupIdeal25 = 0.0;
        this.HsupIdeal60F = 0.0;
        this.HinfIdeal0 = 0.0;
        this.HinfIdeal15 = 0.0;
        this.HinfIdeal20 = 0.0;
        this.HinfIdeal25 = 0.0;
        this.HinfIdeal60F = 0.0;
        for (int i = 0; i < this.thermoSystem.getPhase(0).getNumberOfComponents(); ++i) {
            this.Mmix += this.thermoSystem.getPhase(0).getComponent(i).getz() * this.M[i];
            Zmixtemp0 += this.thermoSystem.getPhase(0).getComponent(i).getz() * this.bsqrt0[i];
            Zmixtemp15 += this.thermoSystem.getPhase(0).getComponent(i).getz() * this.bsqrt15[i];
            Zmixtemp20 += this.thermoSystem.getPhase(0).getComponent(i).getz() * this.bsqrt20[i];
            this.HsupIdeal0 += this.thermoSystem.getPhase(0).getComponent(i).getz() * this.Hsup0[i];
            this.HsupIdeal15 += this.thermoSystem.getPhase(0).getComponent(i).getz() * this.Hsup15[i];
            this.HsupIdeal20 += this.thermoSystem.getPhase(0).getComponent(i).getz() * this.Hsup20[i];
            this.HsupIdeal25 += this.thermoSystem.getPhase(0).getComponent(i).getz() * this.Hsup25[i];
            this.HsupIdeal60F += this.thermoSystem.getPhase(0).getComponent(i).getz() * this.Hsup60F[i];
            this.HinfIdeal0 += this.thermoSystem.getPhase(0).getComponent(i).getz() * this.Hinf0[i];
            this.HinfIdeal15 += this.thermoSystem.getPhase(0).getComponent(i).getz() * this.Hinf15[i];
            this.HinfIdeal20 += this.thermoSystem.getPhase(0).getComponent(i).getz() * this.Hinf20[i];
            this.HinfIdeal25 += this.thermoSystem.getPhase(0).getComponent(i).getz() * this.Hinf25[i];
            this.HinfIdeal60F += this.thermoSystem.getPhase(0).getComponent(i).getz() * this.Hinf60F[i];
            this.relDensIdeal += this.thermoSystem.getPhase(0).getComponent(i).getz() * this.M[i] / 28.96546;
        }
        this.Zmix0 -= Math.pow(Zmixtemp0, 2.0);
        this.Zmix15 -= Math.pow(Zmixtemp15, 2.0);
        this.Zmix20 -= Math.pow(Zmixtemp20, 2.0);
        this.molRefm3 = this.volRefP * 100000.0 * 1.0 / (this.R * (this.getVolRefT() + 273.15) * this.getValue("CompressionFactor"));
    }

    @Override
    public double getValue(String returnParameter, String returnUnit) {
        this.checkReferenceCondition();
        if (returnParameter.equals("GCV")) {
            returnParameter = "SuperiorCalorificValue";
        }
        if (returnParameter.equals("LCV")) {
            returnParameter = "InferiorCalorificValue";
        }
        double returnValue = 0.0;
        returnValue = this.getVolRefT() == 0.0 ? this.Zmix0 : (this.getVolRefT() == 15.0 ? this.Zmix15 : (this.getVolRefT() == 15.55 ? this.Zmix15 : (this.getVolRefT() == 20.0 ? this.Zmix20 : this.Zmix15)));
        if (returnParameter.equals("CompressionFactor")) {
            return returnValue;
        }
        if (returnParameter.equals("MolarMass")) {
            return this.Mmix;
        }
        double realCorrection = 1.0;
        realCorrection = this.getReferenceState().equals("ideal") ? 1.0 : returnValue;
        if (returnParameter.equals("SuperiorCalorificValue") && this.getEnergyRefT() == 0.0) {
            returnValue = this.HsupIdeal0;
        } else if (returnParameter.equals("SuperiorCalorificValue") && this.getEnergyRefT() == 15.0) {
            returnValue = this.HsupIdeal15;
        } else if (returnParameter.equals("SuperiorCalorificValue") && this.getEnergyRefT() == 20.0) {
            returnValue = this.HsupIdeal20;
        } else if (returnParameter.equals("SuperiorCalorificValue") && this.getEnergyRefT() == 25.0) {
            returnValue = this.HsupIdeal25;
        } else if (returnParameter.equals("SuperiorCalorificValue") && this.getEnergyRefT() == 15.55) {
            returnValue = this.HsupIdeal60F;
        } else if (returnParameter.equals("InferiorCalorificValue") && this.getEnergyRefT() == 0.0) {
            returnValue = this.HinfIdeal0;
        } else if (returnParameter.equals("InferiorCalorificValue") && this.getEnergyRefT() == 15.0) {
            returnValue = this.HinfIdeal15;
        } else if (returnParameter.equals("InferiorCalorificValue") && this.getEnergyRefT() == 20.0) {
            returnValue = this.HinfIdeal20;
        } else if (returnParameter.equals("InferiorCalorificValue") && this.getEnergyRefT() == 25.0) {
            returnValue = this.HinfIdeal25;
        } else if (returnParameter.equals("InferiorCalorificValue") && this.getEnergyRefT() == 15.55) {
            returnValue = this.HinfIdeal60F;
        } else if (returnParameter.equals("SuperiorWobbeIndex") && this.getEnergyRefT() == 0.0) {
            returnValue = this.HsupIdeal0;
        } else if (returnParameter.equals("SuperiorWobbeIndex") && this.getEnergyRefT() == 15.0) {
            returnValue = this.HsupIdeal15;
        } else if (returnParameter.equals("SuperiorWobbeIndex") && this.getEnergyRefT() == 20.0) {
            returnValue = this.HsupIdeal20;
        } else if (returnParameter.equals("SuperiorWobbeIndex") && this.getEnergyRefT() == 25.0) {
            returnValue = this.HsupIdeal25;
        } else if (returnParameter.equals("SuperiorWobbeIndex") && this.getEnergyRefT() == 15.55) {
            returnValue = this.HsupIdeal60F;
        } else if (returnParameter.equals("InferiorWobbeIndex") && this.getEnergyRefT() == 0.0) {
            returnValue = this.HinfIdeal0;
        } else if (returnParameter.equals("InferiorWobbeIndex") && this.getEnergyRefT() == 15.0) {
            returnValue = this.HinfIdeal15;
        } else if (returnParameter.equals("InferiorWobbeIndex") && this.getEnergyRefT() == 20.0) {
            returnValue = this.HinfIdeal20;
        } else if (returnParameter.equals("InferiorWobbeIndex") && this.getEnergyRefT() == 15.55) {
            returnValue = this.HinfIdeal60F;
        } else if (returnParameter.equals("InferiorWobbeIndex") && this.getEnergyRefT() == 25.0) {
            returnValue = this.HinfIdeal25;
        }
        if (returnUnit.equals("kWh")) {
            returnValue /= 3600.0;
        }
        double relativeDens = 0.0;
        if (this.getReferenceState().equals("ideal")) {
            relativeDens = this.relDensIdeal;
        } else if (this.getVolRefT() == 0.0) {
            relativeDens = this.relDensIdeal * this.Zair0 / this.Zmix0;
        } else if (this.getVolRefT() == 15.0) {
            relativeDens = this.relDensIdeal * this.Zair15 / this.Zmix15;
        } else if (this.getVolRefT() == 15.55) {
            relativeDens = this.relDensIdeal * this.Zair15 / this.Zmix15;
        } else if (this.getVolRefT() == 20.0) {
            relativeDens = this.relDensIdeal * this.Zair20 / this.Zmix20;
        }
        if (returnParameter.equals("RelativeDensity")) {
            return relativeDens;
        }
        if (returnParameter.equals("InferiorWobbeIndex") || returnParameter.equals("SuperiorWobbeIndex")) {
            returnValue /= Math.sqrt(relativeDens);
        }
        if (returnParameter.equals("DensityIdeal")) {
            return this.volRefP * 100000.0 / (this.R * (this.getVolRefT() + 273.15)) * this.Mmix / 1000.0;
        }
        if (returnParameter.equals("DensityReal")) {
            return this.volRefP * 100000.0 / (this.R * (this.getVolRefT() + 273.15)) * this.Mmix / 1000.0 / realCorrection;
        }
        if (this.getReferenceType().equals("molar")) {
            return returnValue;
        }
        if (this.getReferenceType().equals("mass")) {
            return returnValue / (this.Mmix / 1000.0);
        }
        return returnValue * this.volRefP * 100000.0 / (this.R * (this.getVolRefT() + 273.15)) / realCorrection;
    }

    public void checkReferenceCondition() {
        Double[] validvalues = new Double[]{0.0, 15.0, 15.55, 20.0, 25.0};
        if (!Arrays.stream(validvalues).anyMatch(this.energyRefT::equals)) {
            this.energyRefT = 25.0;
            logger.error("energy reference temperature not in valid range...setting it to 25C");
        }
        if (!Arrays.stream(validvalues).anyMatch(this.volRefT::equals)) {
            this.volRefT = 15.0;
            logger.error("volume reference temperature not in valid range...setting it to 15C");
        }
    }

    @Override
    public double getValue(String returnParameter) {
        return this.getValue(returnParameter, "");
    }

    @Override
    public String getUnit(String returnParameter) {
        if (returnParameter.equals("CompressionFactor")) {
            return "-";
        }
        return this.energyUnit;
    }

    @Override
    public boolean isOnSpec() {
        return true;
    }

    @Override
    public String[][] createTable(String name) {
        int i;
        this.thermoSystem.setNumberOfPhases(1);
        this.thermoSystem.createTable(name);
        DecimalFormat nf = new DecimalFormat();
        nf.setMaximumFractionDigits(5);
        nf.applyPattern("#.#####E0");
        int rows = 0;
        if (this.thermoSystem == null) {
            String[][] table = new String[0][6];
            return table;
        }
        rows = this.thermoSystem.getPhases()[0].getNumberOfComponents() + 30;
        String[][] table = new String[rows][6];
        table[0][0] = "";
        for (i = 0; i < this.thermoSystem.getPhases()[0].getNumberOfComponents() + 30; ++i) {
            for (int j = 0; j < 6; ++j) {
                table[i][j] = "";
            }
        }
        for (i = 0; i < this.thermoSystem.getNumberOfPhases(); ++i) {
            table[0][i + 1] = this.thermoSystem.getPhase(i).getType().toString();
        }
        StringBuffer buf = new StringBuffer();
        FieldPosition test = new FieldPosition(0);
        String referenceTypeUnit = "";
        if (this.getReferenceType().equals("volume")) {
            referenceTypeUnit = "m^3";
        } else if (this.getReferenceType().equals("mass")) {
            referenceTypeUnit = "kg";
        } else if (this.getReferenceType().equals("molar")) {
            referenceTypeUnit = "mol";
        }
        for (int i2 = 0; i2 < this.thermoSystem.getNumberOfPhases(); ++i2) {
            for (int j = 0; j < this.thermoSystem.getPhases()[0].getNumberOfComponents(); ++j) {
                table[j + 1][0] = this.thermoSystem.getPhases()[0].getComponents()[j].getName();
                buf = new StringBuffer();
                table[j + 1][i2 + 1] = nf.format(this.thermoSystem.getPhase(this.thermoSystem.getPhaseIndex(i2)).getComponents()[j].getx(), buf, test).toString();
                table[j + 1][4] = "[-]";
            }
            buf = new StringBuffer();
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 3][0] = "Compressibility Factor";
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 3][i2 + 1] = nf.format(this.getValue("CompressionFactor"));
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 3][4] = "[-]";
            buf = new StringBuffer();
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 4][0] = "Superior Calorific Value";
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 4][i2 + 1] = nf.format(this.getValue("SuperiorCalorificValue"));
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 4][4] = "[kJ/" + referenceTypeUnit + "]";
            buf = new StringBuffer();
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 5][0] = "Inferior Calorific Value";
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 5][i2 + 1] = nf.format(this.getValue("InferiorCalorificValue"));
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 5][4] = "[kJ/" + referenceTypeUnit + "]";
            buf = new StringBuffer();
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 6][0] = "Superior Wobbe Index";
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 6][i2 + 1] = nf.format(this.getValue("SuperiorWobbeIndex") / 3600.0);
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 6][4] = "[kWh/" + referenceTypeUnit + "]";
            buf = new StringBuffer();
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 7][0] = "Superior Wobbe Index";
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 7][i2 + 1] = nf.format(this.getValue("SuperiorWobbeIndex"));
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 7][4] = "[kJ/" + referenceTypeUnit + "]";
            buf = new StringBuffer();
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 8][0] = "Inferior Wobbe Index";
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 8][i2 + 1] = nf.format(this.getValue("InferiorWobbeIndex"));
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 8][4] = "[kJ/" + referenceTypeUnit + "]";
            buf = new StringBuffer();
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 9][0] = "Relative Density";
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 9][i2 + 1] = nf.format(this.getValue("RelativeDensity"));
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 9][4] = "[-]";
            buf = new StringBuffer();
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 10][0] = "Molar Mass";
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 10][i2 + 1] = nf.format(this.getValue("MolarMass"));
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 10][4] = "[gr/mol]";
            buf = new StringBuffer();
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 11][0] = "Density";
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 11][i2 + 1] = nf.format(this.getValue("DensityReal"));
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 11][4] = "[kg/m^3]";
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 13][0] = "Reference Temperature Combustion";
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 13][i2 + 1] = Double.toString(this.getEnergyRefT());
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 13][4] = "[C]";
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 14][0] = "Reference Temperature Volume";
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 14][i2 + 1] = Double.toString(this.getVolRefT());
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 14][4] = "[C]";
        }
        this.resultTable = table;
        return table;
    }

    public double getEnergyRefT() {
        return this.energyRefT;
    }

    public void setEnergyRefT(double energyRefT) {
        this.energyRefT = energyRefT;
    }

    public double getEnergyRefP() {
        return this.energyRefP;
    }

    public void setEnergyRefP(double energyRefP) {
        this.energyRefP = energyRefP;
    }

    public double getVolRefT() {
        return this.volRefT;
    }

    public void setVolRefT(double volRefT) {
        this.volRefT = volRefT;
    }

    public ArrayList<String> getComponentsNotDefinedByStandard() {
        return this.componentsNotDefinedByStandard;
    }

    public double getTotalMolesOfInerts() {
        double inerts = 0.0;
        for (int j = 0; j < this.thermoSystem.getPhases()[0].getNumberOfComponents(); ++j) {
            if (this.carbonNumber[j] != 0) continue;
            inerts += this.thermoSystem.getPhase(0).getComponent(j).getNumberOfmoles();
        }
        return inerts;
    }

    public void removeInertsButNitrogen() {
        for (int j = 0; j < this.thermoSystem.getPhases()[0].getNumberOfComponents(); ++j) {
            if (this.carbonNumber[j] != 0 || this.thermoSystem.getPhase(0).getComponent(j).getName().equals("nitrogen")) continue;
            this.thermoSystem.addComponent("nitrogen", this.thermoSystem.getPhase(0).getComponent(j).getNumberOfmoles());
            this.thermoSystem.addComponent(this.thermoSystem.getPhase(0).getComponent(j).getName(), -this.thermoSystem.getPhase(0).getComponent(j).getNumberOfmoles() * 0.99999);
        }
    }

    public double getAverageCarbonNumber() {
        double inerts = this.getTotalMolesOfInerts();
        this.averageCarbonNumber = 0.0;
        for (int j = 0; j < this.thermoSystem.getPhases()[0].getNumberOfComponents(); ++j) {
            this.averageCarbonNumber += (double)this.carbonNumber[j] * this.thermoSystem.getPhase(0).getComponent(j).getNumberOfmoles() / (this.thermoSystem.getTotalNumberOfMoles() - inerts);
        }
        System.out.println("average carbon number " + this.averageCarbonNumber);
        return this.averageCarbonNumber;
    }

    public String getReferenceType() {
        return this.referenceType;
    }

    public void setReferenceType(String referenceType) {
        this.referenceType = referenceType;
    }
}

