/*
 * Decompiled with CFR 0.152.
 */
package neqsim.standards.gasquality;

import neqsim.standards.Standard;
import neqsim.thermo.system.SystemInterface;

public class SulfurSpecificationMethod
extends Standard {
    private static final long serialVersionUID = 1L;
    String unit = "ppm";
    double H2Scontent = 0.0;

    public SulfurSpecificationMethod(SystemInterface thermoSystem) {
        super("SulfurSpecificationMethod", "Sulfur Specification Method", thermoSystem);
    }

    @Override
    public void calculate() {
        this.thermoSystem.init(0);
    }

    @Override
    public double getValue(String returnParameter, String returnUnit) {
        this.thermoSystem.init(0);
        if (returnParameter.equals("H2S")) {
            if (this.thermoSystem.getPhase(0).hasComponent("H2S")) {
                this.H2Scontent = this.thermoSystem.getPhase(0).getComponent("H2S").getx() * 1000000.0;
                return this.H2Scontent;
            }
            return 0.0;
        }
        if (returnParameter.equals("Total sulfur")) {
            double sulfurcontent = 0.0;
            if (this.thermoSystem.getPhase(0).hasComponent("H2S")) {
                sulfurcontent += this.thermoSystem.getPhase(0).getComponent("H2S").getx() * 1000000.0;
            }
            if (this.thermoSystem.getPhase(0).hasComponent("SO2")) {
                sulfurcontent += this.thermoSystem.getPhase(0).getComponent("So2").getx() * 1000000.0;
            }
            return sulfurcontent;
        }
        return 0.0;
    }

    @Override
    public double getValue(String returnParameter) {
        return this.getValue(returnParameter, "");
    }

    @Override
    public String getUnit(String returnParameter) {
        return this.unit;
    }

    @Override
    public boolean isOnSpec() {
        return true;
    }
}

