/*
 * Decompiled with CFR 0.152.
 */
package neqsim.standards.oilquality;

import neqsim.standards.Standard;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.thermodynamicoperations.ThermodynamicOperations;
import neqsim.util.unit.PressureUnit;
import neqsim.util.unit.TemperatureUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Standard_ASTM_D6377
extends Standard {
    private static final long serialVersionUID = 1L;
    static Logger logger = LogManager.getLogger(Standard_ASTM_D6377.class);
    String unit = "bara";
    double RVP = 1.0;
    double TVP = 1.0;
    double referenceTemperature = 37.8;
    String referenceTemperatureUnit = "C";
    String methodRVP = "VPCR4";
    private double VPCR4_no_water = 0.0;
    private double VPCR4 = 0.0;
    private double RVP_ASTM_D6377 = 0.0;
    private double RVP_ASTM_D323_73_79 = 0.0;
    private double RVP_ASTM_D323_82 = 0.0;

    public String getMethodRVP() {
        return this.methodRVP;
    }

    public void setMethodRVP(String methodRVP) {
        this.methodRVP = methodRVP;
    }

    public Standard_ASTM_D6377(SystemInterface thermoSystem) {
        super("Standard_ASTM_D6377", "Standard_ASTM_D6377", thermoSystem);
    }

    @Override
    public void calculate() {
        this.thermoSystem.setTemperature(this.referenceTemperature, "C");
        this.thermoSystem.setPressure(1.01325);
        this.thermoOps = new ThermodynamicOperations(this.thermoSystem);
        try {
            this.thermoOps.bubblePointPressureFlash(false);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        this.TVP = this.thermoSystem.getPressure();
        this.thermoSystem.setPressure(this.TVP * 0.9);
        try {
            this.thermoOps.TVfractionFlash(0.8);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        this.VPCR4 = this.thermoSystem.getPressure();
        this.RVP_ASTM_D6377 = 0.834 * this.VPCR4;
        this.RVP_ASTM_D323_82 = (0.752 * (100.0 * this.thermoSystem.getPressure()) + 6.07) / 100.0;
        SystemInterface fluid1 = this.thermoSystem.clone();
        if (fluid1.hasComponent("water")) {
            fluid1.removeComponent("water");
            fluid1.init(0);
        }
        try {
            this.thermoOps.TVfractionFlash(0.8);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        this.RVP_ASTM_D323_73_79 = this.VPCR4_no_water = this.thermoSystem.getPressure();
    }

    @Override
    public boolean isOnSpec() {
        return true;
    }

    @Override
    public String getUnit(String returnParameter) {
        return this.unit;
    }

    @Override
    public double getValue(String returnParameter, String returnUnit) {
        if (returnParameter == "RVP") {
            double RVPlocal = this.getValue("RVP");
            PressureUnit presConversion = new PressureUnit(RVPlocal, "bara");
            return presConversion.getValue(returnUnit);
        }
        if (returnParameter == "TVP") {
            PressureUnit presConversion = new PressureUnit(this.getValue("TVP"), "bara");
            return presConversion.getValue(returnUnit);
        }
        return this.RVP;
    }

    @Override
    public double getValue(String returnParameter) {
        if (returnParameter.equals("RVP")) {
            switch (this.methodRVP) {
                case "RVP_ASTM_D6377": {
                    return this.RVP_ASTM_D6377;
                }
                case "RVP_ASTM_D323_73_79": {
                    return this.RVP_ASTM_D323_73_79;
                }
                case "VPCR4": {
                    return this.VPCR4;
                }
                case "RVP_ASTM_D323_82": {
                    return this.RVP_ASTM_D323_82;
                }
                case "VPCR4_no_water": {
                    return this.VPCR4_no_water;
                }
            }
            return this.VPCR4;
        }
        if (returnParameter.equals("TVP")) {
            return this.TVP;
        }
        logger.error("returnParameter not supported.. " + returnParameter);
        return 0.0;
    }

    public void setReferenceTemperature(double refTemp, String refTempUnit) {
        TemperatureUnit tempConversion = new TemperatureUnit(refTemp, refTempUnit);
        this.referenceTemperature = tempConversion.getValue(refTemp, refTempUnit, "C");
    }

    public static void main(String[] args) {
        SystemSrkEos testSystem = new SystemSrkEos(275.15, 1.0);
        testSystem.addComponent("methane", 6.538E-4);
        testSystem.addComponent("ethane", 0.006538);
        testSystem.addComponent("propane", 0.006538);
        testSystem.addComponent("n-pentane", 0.545);
        testSystem.addComponent("water", 0.00545);
        testSystem.setMixingRule(2);
        testSystem.init(0);
        Standard_ASTM_D6377 standard = new Standard_ASTM_D6377(testSystem);
        standard.calculate();
        System.out.println("RVP " + standard.getValue("RVP", "bara"));
        standard.setMethodRVP("RVP_ASTM_D323_73_79");
        standard.calculate();
        System.out.println("RVP_ASTM_D323_73_79 " + standard.getValue("RVP", "bara"));
    }
}

