/*
 * Decompiled with CFR 0.152.
 */
package neqsim.standards.salescontract;

import java.awt.BorderLayout;
import java.awt.Container;
import java.sql.ResultSet;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import neqsim.standards.StandardInterface;
import neqsim.standards.gasquality.BestPracticeHydrocarbonDewPoint;
import neqsim.standards.gasquality.Draft_ISO18453;
import neqsim.standards.gasquality.GasChromotograpyhBase;
import neqsim.standards.gasquality.Standard_ISO6974;
import neqsim.standards.gasquality.Standard_ISO6976;
import neqsim.standards.gasquality.SulfurSpecificationMethod;
import neqsim.standards.gasquality.UKspecifications_ICF_SI;
import neqsim.standards.salescontract.ContractInterface;
import neqsim.standards.salescontract.ContractSpecification;
import neqsim.thermo.system.SystemInterface;
import neqsim.util.database.NeqSimContractDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BaseContract
implements ContractInterface {
    static Logger logger = LogManager.getLogger(BaseContract.class);
    private String[][] resultTable = new String[50][9];
    double waterDewPointTemperature = -12.0;
    double waterDewPointSpecPressure = 70.0;
    private String contractName = "";
    ArrayList<ContractSpecification> spesifications = new ArrayList();
    private int specificationsNumber = 0;

    public BaseContract() {
    }

    public BaseContract(SystemInterface system) {
        Draft_ISO18453 standard = new Draft_ISO18453(system);
        this.spesifications.add(new ContractSpecification("", "", "", "water dew point specification", standard, 0.0, 0.0, "degC", 0.0, 0.0, 0.0, ""));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseContract(SystemInterface system, String terminal, String country) {
        this.setContractName(this.contractName);
        try (NeqSimContractDataBase database = new NeqSimContractDataBase();
             ResultSet dataSet = database.getResultSet("SELECT * FROM gascontractspecifications WHERE TERMINAL='" + terminal + "' AND COUNTRY='" + country + "'");){
            while (dataSet.next()) {
                StandardInterface method = this.getMethod(system, dataSet.getString("METHOD"));
                double referencePressure = Double.parseDouble(dataSet.getString("ReferencePbar"));
                method.setReferencePressure(referencePressure);
                this.spesifications.add(this.getSpecification(method, dataSet.getString("NAME"), dataSet.getString("SPECIFICATION"), dataSet.getString("COUNTRY"), dataSet.getString("TERMINAL"), Double.parseDouble(dataSet.getString("MINVALUE")), Double.parseDouble(dataSet.getString("MAXVALUE")), dataSet.getString("UNIT"), Double.parseDouble(dataSet.getString("ReferenceTdegC")), Double.parseDouble(dataSet.getString("ReferenceTdegC")), referencePressure, ""));
            }
        }
        catch (Exception ex) {
            logger.error("error in comp");
        }
        finally {
            this.specificationsNumber = this.spesifications.size();
        }
    }

    public StandardInterface getMethod(SystemInterface system, String methodName) {
        if (methodName.equals("ISO18453")) {
            Draft_ISO18453 standard = new Draft_ISO18453(system);
            standard.setReferencePressure(this.specificationsNumber);
            return new Draft_ISO18453(system);
        }
        if (methodName.equals("ISO6974")) {
            return new Standard_ISO6974(system);
        }
        if (methodName.equals("Total sulphur")) {
            return new GasChromotograpyhBase(system);
        }
        if (methodName.equals("oxygen")) {
            return new Standard_ISO6974(system);
        }
        if (methodName.equals("ISO6976")) {
            return new Standard_ISO6976(system);
        }
        if (methodName.equals("SulfurSpecificationMethod")) {
            return new SulfurSpecificationMethod(system);
        }
        if (methodName.equals("BestPracticeHydrocarbonDewPoint")) {
            return new BestPracticeHydrocarbonDewPoint(system);
        }
        if (methodName.equals("UKspecifications")) {
            return new UKspecifications_ICF_SI(system);
        }
        return null;
    }

    public ContractSpecification getSpecification(StandardInterface method, String specificationName, String specificationName2, String country, String terminal, double minValue, double maxValue, String unit, double referenceTemperature, double referenceTemperatureComb, double referencePressure, String comments) {
        return new ContractSpecification(specificationName, specificationName2, country, terminal, method, minValue, maxValue, unit, referenceTemperature, referenceTemperatureComb, referencePressure, comments);
    }

    @Override
    public void runCheck() {
        int j = 0;
        this.resultTable = new String[this.specificationsNumber][12];
        for (ContractSpecification spesification : this.spesifications) {
            if (spesification == null) continue;
            try {
                spesification.getStandard().calculate();
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            spesification.getStandard().setSalesContract(this);
            System.out.println("Type: " + spesification.getSpecification() + " Standard " + spesification.getStandard().getName() + " : " + spesification.getStandard().isOnSpec());
            this.getResultTable()[j][0] = spesification.getSpecification();
            this.getResultTable()[j][1] = Double.toString(spesification.getStandard().getValue(spesification.getSpecification(), spesification.getUnit()));
            this.getResultTable()[j][2] = spesification.getCountry();
            this.getResultTable()[j][3] = spesification.getTerminal();
            this.getResultTable()[j][4] = Double.toString(spesification.getMinValue());
            this.getResultTable()[j][5] = Double.toString(spesification.getMaxValue());
            this.getResultTable()[j][6] = spesification.getUnit();
            this.getResultTable()[j][7] = spesification.getStandard().getName();
            this.getResultTable()[j][8] = Double.toString(spesification.getReferenceTemperatureMeasurement());
            this.getResultTable()[j][9] = Double.toString(spesification.getReferenceTemperatureCombustion());
            this.getResultTable()[j][10] = Double.toString(spesification.getReferencePressure());
            this.getResultTable()[j][11] = spesification.getComments();
            ++j;
        }
    }

    @Override
    public void display() {
        JFrame dialog = new JFrame("Specification check against sales specifications: " + this.getContractName());
        Container dialogContentPane = dialog.getContentPane();
        dialogContentPane.setLayout(new BorderLayout());
        Object[] names = new String[]{"Specification", "Value", "Country", "Terminal", "Minimum", "Maximum", "Unit", "Method", "Reference temperature measurement", "Reference temperature of combustion", "Reference pressure", "Comments"};
        JTable Jtab = new JTable(this.getResultTable(), names);
        JScrollPane scrollpane = new JScrollPane(Jtab);
        dialogContentPane.add(scrollpane);
        dialog.pack();
        dialog.setVisible(true);
    }

    @Override
    public void setContract(String name) {
        this.waterDewPointTemperature = -12.0;
        this.waterDewPointSpecPressure = 70.0;
    }

    @Override
    public double getWaterDewPointTemperature() {
        return this.waterDewPointTemperature;
    }

    @Override
    public void setWaterDewPointTemperature(double waterDewPointTemperature) {
        this.waterDewPointTemperature = waterDewPointTemperature;
    }

    @Override
    public double getWaterDewPointSpecPressure() {
        return this.waterDewPointSpecPressure;
    }

    @Override
    public void setWaterDewPointSpecPressure(double waterDewPointSpecPressure) {
        this.waterDewPointSpecPressure = waterDewPointSpecPressure;
    }

    @Override
    public int getSpecificationsNumber() {
        return this.specificationsNumber;
    }

    @Override
    public void setSpecificationsNumber(int specificationsNumber) {
        this.specificationsNumber = specificationsNumber;
    }

    @Override
    public String[][] getResultTable() {
        return this.resultTable;
    }

    @Override
    public void setResultTable(String[][] resultTable) {
        this.resultTable = resultTable;
    }

    @Override
    public String getContractName() {
        return this.contractName;
    }

    @Override
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
}

