/*
 * Decompiled with CFR 0.152.
 */
package neqsim.statistics.parameterfitting;

import neqsim.statistics.parameterfitting.FunctionInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.ThermodynamicOperations;

public abstract class BaseFunction
implements FunctionInterface {
    public double[] params = null;
    public double[][] bounds = null;
    public SystemInterface system;
    public ThermodynamicOperations thermoOps;

    @Override
    public BaseFunction clone() {
        BaseFunction clonedClass = null;
        try {
            clonedClass = (BaseFunction)super.clone();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        clonedClass.params = (double[])this.params.clone();
        System.arraycopy(this.params, 0, clonedClass.params, 0, this.params.length);
        return clonedClass;
    }

    @Override
    public void setThermodynamicSystem(SystemInterface system) {
        this.system = system;
        this.thermoOps = new ThermodynamicOperations(system);
    }

    @Override
    public double[] getFittingParams() {
        return this.params;
    }

    @Override
    public double getFittingParams(int i) {
        return this.params[i];
    }

    @Override
    public SystemInterface getSystem() {
        return this.system;
    }

    @Override
    public int getNumberOfFittingParams() {
        return this.params.length;
    }

    @Override
    public void setInitialGuess(double[] guess) {
        System.out.println("start fitting " + guess.length + " parameter(s)...");
        this.params = new double[guess.length];
        System.arraycopy(guess, 0, this.params, 0, guess.length);
    }

    @Override
    public abstract double calcValue(double[] var1);

    @Override
    public double calcTrueValue(double val) {
        return val;
    }

    @Override
    public abstract void setFittingParams(int var1, double var2);

    @Override
    public void setDatabaseParameters() {
    }

    @Override
    public double getLowerBound(int i) {
        return this.bounds[i][0];
    }

    @Override
    public double getUpperBound(int i) {
        return this.bounds[i][1];
    }

    @Override
    public double[][] getBounds() {
        return this.bounds;
    }

    @Override
    public void setBounds(double[][] bounds) {
        this.bounds = bounds;
    }
}

