/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.atomelement;

import java.sql.ResultSet;
import java.util.ArrayList;
import neqsim.thermo.ThermodynamicConstantsInterface;
import neqsim.util.database.NeqSimDataBase;
import neqsim.util.exception.InvalidInputException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Element
implements ThermodynamicConstantsInterface {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(Element.class);
    private String name;
    private String[] nameArray;
    private double[] coefArray;

    public Element(String name) {
        this.name = name;
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String> stocCoef = new ArrayList<String>();
        try (NeqSimDataBase database = new NeqSimDataBase();
             ResultSet dataSet = database.getResultSet("SELECT * FROM element WHERE componentname='" + name + "'");){
            if (!dataSet.next()) {
                return;
            }
            do {
                names.add(dataSet.getString("atomelement").trim());
                stocCoef.add(dataSet.getString("number"));
            } while (dataSet.next());
            this.nameArray = new String[names.size()];
            this.coefArray = new double[this.nameArray.length];
            for (int i = 0; i < this.nameArray.length; ++i) {
                this.coefArray[i] = Double.parseDouble((String)stocCoef.get(i));
                this.nameArray[i] = (String)names.get(i);
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public String getName() {
        return this.name;
    }

    public String[] getElementNames() {
        return this.nameArray;
    }

    public double getNumberOfElements(String elementName) {
        if (this.nameArray == null) {
            throw new RuntimeException(new InvalidInputException(this, "getNumberOfElements", elementName, "component not in element database.."));
        }
        for (int i = 0; i < this.nameArray.length; ++i) {
            if (!this.nameArray[i].equals(elementName)) continue;
            return this.coefArray[i];
        }
        return 0.0;
    }

    public double[] getElementCoefs() {
        return this.coefArray;
    }

    public static ArrayList<String> getAllElementComponentNames() {
        ArrayList<String> names = new ArrayList<String>();
        try (NeqSimDataBase database = new NeqSimDataBase();
             ResultSet dataSet = database.getResultSet("SELECT * FROM element");){
            dataSet.next();
            do {
                names.add(dataSet.getString("componentname").trim());
            } while (dataSet.next());
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return names;
    }
}

