/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.characterization;

import java.io.Serializable;
import neqsim.thermo.characterization.PedersenPlusModelSolver;
import neqsim.thermo.characterization.PlusFractionModelInterface;
import neqsim.thermo.characterization.TBPModelInterface;
import neqsim.thermo.system.SystemInterface;

public class PlusFractionModel
implements Serializable {
    private static final long serialVersionUID = 1000L;
    private String name = "";
    private SystemInterface system = null;
    double MPlus = 0.0;
    double zPlus = 0.0;
    double densPlus = 0.0;
    int firstPlusFractionNumber = 1;
    int lastPlusFractionNumber = 80;
    int plusComponentNumber = 0;
    private double maxPlusMolarMass = 1000.0;
    double[] z;
    double[] M;
    double[] dens;
    double[] TC;
    double[] PC;
    double[] acs;

    public PlusFractionModel(SystemInterface system) {
        this.system = system;
    }

    public PlusFractionModelInterface getModel(String name) {
        if (name.equals("Pedersen")) {
            return new PedersenPlusModel();
        }
        if (name.equals("Pedersen Heavy Oil")) {
            return new PedersenHeavyOilPlusModel();
        }
        if (name.equals("Whitson Gamma Model")) {
            return new WhitsonGammaModel();
        }
        return new PedersenPlusModel();
    }

    class WhitsonGammaModel
    extends PedersenPlusModel {
        private static final long serialVersionUID = 1L;
        public double[] zValues;
        public double[] molarMasses;
        public double[] densities;
        public double eta;
        public String model;
        public double alfa;
        public double betta;

        public WhitsonGammaModel() {
            this.eta = 90.0;
            this.model = "Whitson";
            this.alfa = 1.0;
            this.betta = Double.NaN;
            PlusFractionModel.this.name = "Whitson Gamma";
        }

        public void setCalculationModel(String model) {
            this.model = model;
        }

        public void characterizePlusFractionWhitsonGamma() {
        }

        public double gamma(double X) {
            double[] dataB = new double[]{-0.577191652, 0.988205891, -0.897056937, 0.918206857, -0.756704078, 0.482199394, -0.193527818, 0.035868343};
            double const_ = 1.0;
            double XX = X;
            if (X < 1.0) {
                XX = X + 1.0;
            }
            while (XX >= 2.0) {
                XX -= 1.0;
            }
            const_ = XX * const_;
            XX -= 1.0;
            double Y = 1.0;
            for (int i = 1; i <= 8; ++i) {
                Y += dataB[i - 1] * XX * (double)i;
            }
            double GAMMA = const_ * Y;
            if (X < 1.0) {
                GAMMA /= X;
            }
            return GAMMA;
        }

        public double[] P0P1(double MWB) {
            double TERM;
            double P0 = 0.0;
            double P1 = 0.0;
            if (MWB == this.eta) {
                return new double[]{P0, P1};
            }
            double Y = (MWB - this.eta) / this.betta;
            double Q = Math.exp(-Y) * Math.pow(Y, this.alfa) / this.gamma(this.alfa);
            double S = TERM = 1.0 / this.alfa;
            for (int j = 1; j <= 10000; ++j) {
                S += (TERM *= Y / (this.alfa + (double)j));
                if (!(Math.abs(TERM) <= 1.0E-8)) continue;
                P0 = Q * S;
                P1 = Q * (S - 1.0 / this.alfa);
                break;
            }
            return new double[]{P0, P1};
        }

        public void densityUOP() {
            double Kw = 4.5579 * Math.pow(PlusFractionModel.this.MPlus * 1000.0, 0.15178) * Math.pow(PlusFractionModel.this.densPlus, -1.18241);
            for (int i = PlusFractionModel.this.firstPlusFractionNumber; i < PlusFractionModel.this.lastPlusFractionNumber; ++i) {
                this.densities[i - 1] = 6.0108 * Math.pow(this.molarMasses[i - 1], 0.17947) * Math.pow(Kw, -1.18241);
            }
        }

        @Override
        public void characterizePlusFraction(TBPModelInterface TBPModel) {
            int i;
            PlusFractionModel.this.system.init(0);
            double MWBU = Double.NaN;
            double MWBL = Double.NaN;
            double sumZ = 0.0;
            this.betta = (PlusFractionModel.this.MPlus * 1000.0 - this.eta) / this.alfa;
            this.zValues = new double[PlusFractionModel.this.lastPlusFractionNumber];
            this.molarMasses = new double[PlusFractionModel.this.lastPlusFractionNumber];
            this.densities = new double[PlusFractionModel.this.lastPlusFractionNumber];
            if (this.model.equals("Whitson")) {
                for (i = PlusFractionModel.this.firstPlusFractionNumber; i < PlusFractionModel.this.lastPlusFractionNumber; ++i) {
                    if (i == 1) {
                        MWBU = this.eta;
                    }
                    MWBL = MWBU;
                    MWBU = MWBL + 14.0;
                    if (i == PlusFractionModel.this.lastPlusFractionNumber) {
                        MWBU = 10000.0;
                    }
                    double[] P0LP1L = this.P0P1(MWBL);
                    double P0L = P0LP1L[0];
                    double P1L = P0LP1L[1];
                    double[] P0UP1U = this.P0P1(MWBU);
                    double P0U = P0UP1U[0];
                    double P1U = P0UP1U[1];
                    double Z = P0U - P0L;
                    if (Z < 1.0E-15) {
                        Z = 1.0E-15;
                    }
                    this.zValues[i] = Z * PlusFractionModel.this.zPlus;
                    double MWAV = this.eta + this.alfa * this.betta * (P1U - P1L) / (P0U - P0L);
                    this.molarMasses[i] = MWAV / 1000.0;
                    sumZ += this.zValues[i];
                }
                this.densityUOP();
            }
            i = PlusFractionModel.this.firstPlusFractionNumber;
            while (i < PlusFractionModel.this.lastPlusFractionNumber) {
                int n = i++;
                this.zValues[n] = this.zValues[n] * (PlusFractionModel.this.zPlus / sumZ);
            }
        }

        public void setGammaParameters(double shape, double minMW) {
            this.alfa = shape;
            this.eta = minMW;
        }

        public double[] getGammaParameters() {
            return new double[]{this.alfa, this.eta};
        }

        @Override
        public double[] getCoefs() {
            return new double[]{this.alfa, this.eta};
        }

        @Override
        public double getCoef(int i) {
            if (i == 0) {
                return this.alfa;
            }
            if (i == 1) {
                return this.eta;
            }
            return 0.0;
        }

        @Override
        public double[] getZ() {
            return this.zValues;
        }

        @Override
        public double[] getM() {
            return this.molarMasses;
        }

        @Override
        public double[] getDens() {
            return this.densities;
        }
    }

    private class PedersenHeavyOilPlusModel
    extends PedersenPlusModel {
        private static final long serialVersionUID = 1000L;

        public PedersenHeavyOilPlusModel() {
            PlusFractionModel.this.lastPlusFractionNumber = 200;
            PlusFractionModel.this.maxPlusMolarMass = 2.1;
            PlusFractionModel.this.name = "Pedersen Heavy Oil";
        }
    }

    class PedersenPlusModel
    implements PlusFractionModelInterface,
    Cloneable {
        private static final long serialVersionUID = 1000L;
        double[] coefs = new double[]{4.4660105006, -1.1266303727, 0.8, 0.0408709562};
        double[] SRKcoefs = new double[]{4.4660105006, -1.1266303727, 8.1927423578, -3.4668277785};
        double[] PRcoefs = new double[]{4.4660105006, -1.1266303727, 8.1927423578, -3.4668277785};
        double[] plusCoefs = new double[]{0.7774204804, -0.05721666929};
        public double[] PVTsimMolarMass = new double[]{86.178f, 96.0, 107.0, 121.0, 134.0, 147.0, 161.0, 175.0, 190.0, 206.0, 222.0, 237.0, 251.0, 263.0, 275.0, 291.0, 305.0, 318.0, 331.0, 345.0, 359.0, 374.0, 388.0, 402.0, 416.0, 430.0, 444.0, 458.0, 472.0, 486.0, 500.0, 514.0, 528.0, 542.0, 556.0, 570.0, 584.0, 598.0, 612.0, 626.0, 640.0, 654.0, 668.0, 682.0, 696.0, 710.0, 724.0, 738.0, 752.0, 766.0, 780.0, 794.0, 808.0, 822.0, 836.0, 850.0, 864.0, 878.0, 892.0, 906.0, 920.0, 934.0, 948.0, 962.0, 976.0, 990.0, 1004.0, 1018.0, 1032.0, 1046.0, 1060.0, 1074.0, 1088.0, 1102.0, 1116.0, 1130.0, 1144.0, 1158.0, 1172.0, 1186.0, 1200.0, 1214.0, 1228.0, 1242.0, 1256.0, 1270.0, 1284.0, 1298.0, 1312.0, 1326.0, 1340.0, 1354.0, 1368.0, 1382.0, 1396.0, 1410.0, 1424.0, 1438.0, 1452.0, 1466.0, 1480.0, 1494.0, 1508.0, 1522.0, 1536.0, 1550.0, 1564.0, 1578.0, 1592.0, 1606.0, 1620.0, 1634.0, 1648.0, 1662.0, 1676.0, 1690.0, 1704.0, 1718.0, 1732.0, 1746.0, 1760.0, 1774.0, 1788.0, 1802.0, 1816.0, 1830.0, 1844.0, 1858.0, 1872.0, 1886.0, 1900.0, 1914.0, 1928.0, 1942.0, 1956.0, 1970.0, 1984.0, 1998.0, 2012.0, 2026.0, 2040.0, 2054.0, 2068.0, 2082.0, 2096.0, 2110.0, 2124.0, 2138.0, 2152.0, 2166.0, 2180.0, 2194.0, 2208.0, 2222.0, 2236.0, 2250.0, 2264.0, 2278.0, 2292.0, 2306.0, 2320.0, 2334.0, 2348.0, 2362.0, 2376.0, 2390.0, 2404.0, 2418.0, 2432.0, 2446.0, 2460.0, 2474.0, 2488.0, 2502.0, 2516.0, 2530.0, 2544.0, 2558.0, 2572.0, 2586.0, 2600.0, 2614.0, 2628.0, 2642.0, 2656.0, 2670.0, 2684.0, 2698.0, 2712.0, 2726.0, 2740.0, 2754.0, 2768.0, 2782.0, 2796.0};
        public double[] PVTsimDensities = new double[]{0.663999915122986, 0.737999975681305, 0.764999985694885, 0.781f, 0.791999995708466, 0.796000003814697, 0.810000002384186, 0.825f, 0.836000025272369, 0.842000007629395, 0.848999977111816, 0.845000028610229, 0.84799998998642, 0.857999980449677, 0.862999975681305, 0.867999970912933, 0.873000025749207, 0.876999974250793, 0.880999982357025, 0.884999990463257, 0.888999998569489, 0.89300000667572, 0.897000014781952, 0.899999976158142, 0.903f, 0.907000005245209, 0.910000026226044, 0.912999987602234, 0.916000008583069, 0.919000029563904, 0.922f, 0.924000024795532, 0.926999986171722, 0.930000007152557, 0.931999981403351, 0.935000002384186, 0.936999976634979, 0.939000010490417, 0.941999971866608, 0.944000005722046, 0.945999979972839, 0.948000013828278, 0.95f, 0.952000021934509, 0.953999996185303, 0.955999970436096, 0.958000004291534, 0.959999978542328, 0.962000012397766, 0.96399998664856, 0.966000020503998, 0.967000007629395, 0.969f, 0.971000015735626, 0.972f, 0.973999977111816, 0.976000010967255, 0.976999998092651, 0.978999972343445, 0.980000019073486, 0.98199999332428, 0.982999980449677, 0.985000014305115, 0.986000001430511, 0.987999975681305, 0.989000022411346, 0.99099999666214, 0.991999983787537, 0.992999970912933, 0.995000004768372, 0.995999991893768, 0.997f, 0.999000012874603, 1.0, 1.00100004673004};
        boolean firsttime = true;
        int numberOfPlusPseudocomponents = 0;

        public PedersenPlusModel() {
            PlusFractionModel.this.name = "Standard Pedersen";
            PlusFractionModel.this.lastPlusFractionNumber = 80;
            PlusFractionModel.this.maxPlusMolarMass = 0.605;
        }

        @Override
        public String getName() {
            return PlusFractionModel.this.name;
        }

        @Override
        public double getMPlus() {
            return PlusFractionModel.this.MPlus;
        }

        @Override
        public double getZPlus() {
            return PlusFractionModel.this.zPlus;
        }

        @Override
        public double getMaxPlusMolarMass() {
            return PlusFractionModel.this.maxPlusMolarMass;
        }

        @Override
        public double getNumberOfPlusPseudocomponents() {
            return this.numberOfPlusPseudocomponents;
        }

        @Override
        public double[] getZ() {
            return PlusFractionModel.this.z;
        }

        @Override
        public double[] getM() {
            return PlusFractionModel.this.M;
        }

        @Override
        public double[] getDens() {
            return PlusFractionModel.this.dens;
        }

        @Override
        public double getDensPlus() {
            return PlusFractionModel.this.densPlus;
        }

        @Override
        public int getFirstPlusFractionNumber() {
            return PlusFractionModel.this.firstPlusFractionNumber;
        }

        @Override
        public int getFirstTBPFractionNumber() {
            int firstTBPNumber = 0;
            double M = 1.0E10;
            double Mmin = 1.0E10;
            for (int i = 0; i < PlusFractionModel.this.system.getPhase(0).getNumberOfComponents(); ++i) {
                if (!PlusFractionModel.this.system.getPhase(0).getComponent(i).isIsTBPfraction() || !((M = PlusFractionModel.this.system.getPhase(0).getComponent(i).getMolarMass()) < Mmin)) continue;
                Mmin = M;
                firstTBPNumber = PlusFractionModel.this.system.getPhase(0).getComponent(i).getComponentName().substring(3, 4).equals("_") ? Integer.valueOf(PlusFractionModel.this.system.getPhase(0).getComponent(i).getComponentName().substring(1, 3)).intValue() : Integer.valueOf(PlusFractionModel.this.system.getPhase(0).getComponent(i).getComponentName().substring(1, 2)).intValue();
            }
            return firstTBPNumber;
        }

        @Override
        public int getPlusComponentNumber() {
            return PlusFractionModel.this.plusComponentNumber;
        }

        @Override
        public int getLastPlusFractionNumber() {
            return PlusFractionModel.this.lastPlusFractionNumber;
        }

        @Override
        public boolean hasPlusFraction() {
            for (int i = 0; i < PlusFractionModel.this.system.getPhase(0).getNumberOfComponents(); ++i) {
                if (!PlusFractionModel.this.system.getPhase(0).getComponent(i).isIsPlusFraction()) continue;
                PlusFractionModel.this.MPlus = PlusFractionModel.this.system.getPhase(0).getComponent(i).getMolarMass();
                PlusFractionModel.this.zPlus = PlusFractionModel.this.system.getPhase(0).getComponent(i).getz();
                PlusFractionModel.this.densPlus = PlusFractionModel.this.system.getPhase(0).getComponent(i).getNormalLiquidDensity();
                PlusFractionModel.this.plusComponentNumber = i;
                return true;
            }
            return false;
        }

        @Override
        public void characterizePlusFraction(TBPModelInterface TBPModel) {
            PlusFractionModel.this.system.init(0);
            Integer firstPlusNumber = 0;
            firstPlusNumber = PlusFractionModel.this.system.getPhase(0).getComponent(PlusFractionModel.this.plusComponentNumber).getComponentName().substring(3, 4).equals("_") ? Integer.valueOf(PlusFractionModel.this.system.getPhase(0).getComponent(PlusFractionModel.this.plusComponentNumber).getComponentName().substring(1, 3)) : Integer.valueOf(PlusFractionModel.this.system.getPhase(0).getComponent(PlusFractionModel.this.plusComponentNumber).getComponentName().substring(1, 2));
            if (PlusFractionModel.this.firstPlusFractionNumber < firstPlusNumber) {
                PlusFractionModel.this.firstPlusFractionNumber = firstPlusNumber;
            }
            this.numberOfPlusPseudocomponents = PlusFractionModel.this.lastPlusFractionNumber - PlusFractionModel.this.firstPlusFractionNumber + 1;
            this.coefs[0] = 0.1;
            this.coefs[1] = Math.log(PlusFractionModel.this.zPlus) / (double)this.getFirstPlusFractionNumber();
            PedersenPlusModelSolver solver3 = new PedersenPlusModelSolver(PlusFractionModel.this.system, this);
            solver3.solve();
            PlusFractionModel.this.z = new double[PlusFractionModel.this.lastPlusFractionNumber];
            PlusFractionModel.this.M = new double[PlusFractionModel.this.lastPlusFractionNumber];
            PlusFractionModel.this.dens = new double[PlusFractionModel.this.lastPlusFractionNumber];
            PlusFractionModel.this.TC = new double[PlusFractionModel.this.lastPlusFractionNumber];
            PlusFractionModel.this.PC = new double[PlusFractionModel.this.lastPlusFractionNumber];
            PlusFractionModel.this.acs = new double[PlusFractionModel.this.lastPlusFractionNumber];
            for (int i = PlusFractionModel.this.firstPlusFractionNumber; i < PlusFractionModel.this.lastPlusFractionNumber; ++i) {
                PlusFractionModel.this.z[i] = Math.exp(this.getCoef(0) + this.getCoef(1) * (double)i);
                PlusFractionModel.this.M[i] = this.PVTsimMolarMass[i - 6] / 1000.0;
                PlusFractionModel.this.dens[i] = this.getCoef(2) + this.getCoef(3) * Math.log(i);
            }
        }

        @Override
        public double[] getCoefs() {
            return this.coefs;
        }

        @Override
        public double getCoef(int i) {
            return this.coefs[i];
        }

        public void setCoefs(double[] coefs) {
            System.arraycopy(coefs, 0, this.coefs, 0, coefs.length);
            if (this.firsttime) {
                if (coefs.length == 3) {
                    double Dtot = 0.0;
                    for (int i = PlusFractionModel.this.firstPlusFractionNumber; i < PlusFractionModel.this.lastPlusFractionNumber; ++i) {
                        Dtot += (PlusFractionModel.this.densPlus - this.getCoef(2)) / Math.log(i);
                    }
                    double lengthPlus = PlusFractionModel.this.lastPlusFractionNumber - PlusFractionModel.this.firstPlusFractionNumber;
                    this.coefs[3] = Dtot /= lengthPlus;
                }
                this.firsttime = false;
            }
            double mSum = 0.0;
            double densSum = 0.0;
            int iter = 0;
            do {
                ++iter;
                mSum = 0.0;
                densSum = 0.0;
                for (int i = PlusFractionModel.this.firstPlusFractionNumber; i < PlusFractionModel.this.lastPlusFractionNumber; ++i) {
                    double ztemp = Math.exp(this.getCoef(0) + this.getCoef(1) * (double)i);
                    double M = this.PVTsimMolarMass[i - 6] / 1000.0;
                    double dens = this.getCoef(2) + this.getCoef(3) * Math.log(i);
                    mSum += ztemp * M;
                    densSum += ztemp * M / dens;
                }
                densSum = mSum / densSum;
                this.coefs[3] = this.coefs[3] + 1.0 * (PlusFractionModel.this.densPlus - densSum) / densSum * this.coefs[3];
            } while (Math.abs(PlusFractionModel.this.densPlus - densSum) > 1.0E-6 && iter < 1000);
        }

        public void setCoefs(double coef, int i) {
            this.coefs[i] = coef;
        }

        @Override
        public void setLastPlusFractionNumber(int fract) {
            PlusFractionModel.this.lastPlusFractionNumber = fract + 1;
        }
    }
}

