/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component;

import neqsim.thermo.component.ComponentSrk;
import neqsim.thermo.component.attractiveeosterm.AttractiveTermSchwartzentruber;
import neqsim.thermo.phase.PhaseInterface;
import neqsim.thermo.phase.PhaseModifiedFurstElectrolyteEosMod2004;
import neqsim.thermo.util.constants.FurstElectrolyteConstants;

public class ComponentModifiedFurstElectrolyteEosMod2004
extends ComponentSrk {
    private static final long serialVersionUID = 1000L;
    double Wi = 0.0;
    double WiT = 0.0;
    double epsi = 0.0;
    double epsiV = 0.0;
    double epsIonici = 0.0;
    double epsIoniciV = 0.0;
    double dEpsdNi = 0.0;
    double ionicCoVolume = 0.0;
    double solventdiElectricdn = 0.0;
    double solventdiElectricdndT = 0.0;
    double diElectricdn = 0.0;
    double diElectricdndV = 0.0;
    double diElectricdndT = 0.0;
    double bornterm = 0.0;
    double alphai = 0.0;
    double alphaiT = 0.0;
    double alphaiV = 0.0;
    double XLRi = 0.0;
    double XBorni = 0.0;
    double sr2On = 1.0;
    double lrOn = 1.0;
    double bornOn = 1.0;

    public ComponentModifiedFurstElectrolyteEosMod2004(String name, double moles, double molesInPhase, int compIndex) {
        super(name, moles, molesInPhase, compIndex);
        this.ionicCoVolume = this.getIonicDiameter();
        if (this.ionicCharge != 0) {
            this.setIsIon(true);
        }
        this.b = this.ionicCharge != 0 ? (FurstElectrolyteConstants.furstParams[0] * Math.pow(this.getIonicDiameter(), 3.0) + FurstElectrolyteConstants.furstParams[1]) * 100000.0 : this.b;
        this.a = this.ionicCharge != 0 ? 1.0E-35 : this.a;
        this.setAttractiveParameter(new AttractiveTermSchwartzentruber(this));
        this.lennardJonesMolecularDiameter = this.ionicCharge != 0 ? Math.pow(6.0 * this.b / 100000.0 / 1.892181253095E24, 0.3333333333333333) * 1.0E10 : this.lennardJonesMolecularDiameter;
    }

    public ComponentModifiedFurstElectrolyteEosMod2004(int number, double TC, double PC, double M, double a, double moles) {
        super(number, TC, PC, M, a, moles);
    }

    public void initFurstParam() {
        this.b = this.ionicCharge != 0 ? (FurstElectrolyteConstants.furstParams[0] * Math.pow(this.getIonicDiameter(), 3.0) + FurstElectrolyteConstants.furstParams[1]) * 100000.0 : this.b;
        this.lennardJonesMolecularDiameter = this.ionicCharge != 0 ? Math.pow(6.0 * this.b / 100000.0 / 1.892181253095E24, 0.3333333333333333) * 1.0E10 : this.lennardJonesMolecularDiameter;
    }

    @Override
    public ComponentModifiedFurstElectrolyteEosMod2004 clone() {
        ComponentModifiedFurstElectrolyteEosMod2004 clonedComponent = null;
        try {
            clonedComponent = (ComponentModifiedFurstElectrolyteEosMod2004)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return clonedComponent;
    }

    @Override
    public double calca() {
        return this.a;
    }

    @Override
    public double calcb() {
        return this.b;
    }

    @Override
    public void Finit(PhaseInterface phase, double temp, double pres, double totMoles, double beta, int numberOfComponents, int initType) {
        this.Wi = ((PhaseModifiedFurstElectrolyteEosMod2004)phase).calcWi(this.componentNumber, phase, temp, pres, numberOfComponents);
        this.WiT = ((PhaseModifiedFurstElectrolyteEosMod2004)phase).calcWiT(this.componentNumber, phase, temp, pres, numberOfComponents);
        this.epsi = this.dEpsdNi(phase, numberOfComponents, temp, pres);
        this.epsiV = this.dEpsdNidV(phase, numberOfComponents, temp, pres);
        this.epsIonici = this.dEpsIonicdNi(phase, numberOfComponents, temp, pres);
        this.epsIoniciV = this.dEpsIonicdNidV(phase, numberOfComponents, temp, pres);
        this.solventdiElectricdn = this.calcSolventdiElectricdn(phase, numberOfComponents, temp, pres);
        this.solventdiElectricdndT = this.calcSolventdiElectricdndT(phase, numberOfComponents, temp, pres);
        this.diElectricdn = this.calcdiElectricdn(phase, numberOfComponents, temp, pres);
        this.diElectricdndV = this.calcdiElectricdndV(phase, numberOfComponents, temp, pres);
        this.diElectricdndT = this.calcdiElectricdndT(phase, numberOfComponents, temp, pres);
        this.alphai = -1.5461150880894962E-14 / (8.85419E-12 * Math.pow(((PhaseModifiedFurstElectrolyteEosMod2004)phase).getDiElectricConstant(), 2.0) * 8.3144621 * temp) * this.diElectricdn;
        this.alphaiT = -1.5461150880894962E-14 / (8.85419E-12 * Math.pow(((PhaseModifiedFurstElectrolyteEosMod2004)phase).getDiElectricConstant(), 2.0) * 8.3144621 * temp) * this.diElectricdndT + 1.5461150880894962E-14 / (8.85419E-12 * Math.pow(((PhaseModifiedFurstElectrolyteEosMod2004)phase).getDiElectricConstant(), 2.0) * 8.3144621 * temp * temp) * this.diElectricdn + 3.0922301761789923E-14 / (8.85419E-12 * Math.pow(((PhaseModifiedFurstElectrolyteEosMod2004)phase).getDiElectricConstant(), 3.0) * 8.3144621 * temp) * this.diElectricdn * ((PhaseModifiedFurstElectrolyteEosMod2004)phase).getDiElectricConstantdT();
        this.alphaiV = -1.5461150880894962E-14 / (8.85419E-12 * Math.pow(((PhaseModifiedFurstElectrolyteEosMod2004)phase).getDiElectricConstant(), 2.0) * 8.3144621 * temp) * this.diElectricdndV + 3.0922301761789923E-14 / (8.85419E-12 * Math.pow(((PhaseModifiedFurstElectrolyteEosMod2004)phase).getDiElectricConstant(), 3.0) * 8.3144621 * temp) * this.diElectricdn * ((PhaseModifiedFurstElectrolyteEosMod2004)phase).getDiElectricConstantdV();
        this.XLRi = this.calcXLRdN(phase, numberOfComponents, temp, pres);
        this.XBorni = (double)(this.ionicCharge * this.ionicCharge) / (this.getLennardJonesMolecularDiameter() * 1.0E-10);
        super.Finit(phase, temp, pres, totMoles, beta, numberOfComponents, initType);
    }

    public double dAlphaLRdndn(int j, PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        double temp = 3.0922301761789923E-14 / (8.85419E-12 * Math.pow(((PhaseModifiedFurstElectrolyteEosMod2004)phase).getDiElectricConstant(), 3.0) * 8.3144621 * temperature) * this.diElectricdn * ((ComponentModifiedFurstElectrolyteEosMod2004)((PhaseModifiedFurstElectrolyteEosMod2004)phase).getComponents()[j]).getDiElectricConstantdn() - 1.5461150880894962E-14 / (8.85419E-12 * Math.pow(((PhaseModifiedFurstElectrolyteEosMod2004)phase).getDiElectricConstant(), 2.0) * 8.3144621 * temperature) * this.calcdiElectricdndn(j, phase, numberOfComponents, temperature, pressure);
        return temp;
    }

    @Override
    public double dFdN(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        double Fsup = 0.0;
        double FSR2 = 0.0;
        double FLR = 0.0;
        double FBorn = 0.0;
        Fsup = super.dFdN(phase, numberOfComponents, temperature, pressure);
        FSR2 = this.dFSR2dN(phase, numberOfComponents, temperature, pressure);
        FLR = this.dFLRdN(phase, numberOfComponents, temperature, pressure);
        FBorn = this.dFBorndN(phase, numberOfComponents, temperature, pressure);
        return Fsup + this.sr2On * FSR2 + this.lrOn * FLR + this.bornOn * FBorn;
    }

    @Override
    public double dFdNdT(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        return super.dFdNdT(phase, numberOfComponents, temperature, pressure) + this.sr2On * this.dFSR2dNdT(phase, numberOfComponents, temperature, pressure) + this.lrOn * this.dFLRdNdT(phase, numberOfComponents, temperature, pressure) + this.bornOn * this.dFBorndNdT(phase, numberOfComponents, temperature, pressure);
    }

    @Override
    public double dFdNdV(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        return super.dFdNdV(phase, numberOfComponents, temperature, pressure) + this.sr2On * this.dFSR2dNdV(phase, numberOfComponents, temperature, pressure) + this.lrOn * this.dFLRdNdV(phase, numberOfComponents, temperature, pressure);
    }

    @Override
    public double dFdNdN(int j, PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        return super.dFdNdN(j, phase, numberOfComponents, temperature, pressure) + this.sr2On * this.dFSR2dNdN(j, phase, numberOfComponents, temperature, pressure) + this.lrOn * this.dFLRdNdN(j, phase, numberOfComponents, temperature, pressure) + this.bornOn * this.dFBorndNdN(j, phase, numberOfComponents, temperature, pressure);
    }

    public double dFLRdN(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        return ((PhaseModifiedFurstElectrolyteEosMod2004)phase).FLRXLR() * this.XLRi + ((PhaseModifiedFurstElectrolyteEosMod2004)phase).dFdAlphaLR() * this.alphai;
    }

    public double dFLRdNdT(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        return ((PhaseModifiedFurstElectrolyteEosMod2004)phase).dFdAlphaLRdX() * this.XLRi * ((PhaseModifiedFurstElectrolyteEosMod2004)phase).getAlphaLRT() + ((PhaseModifiedFurstElectrolyteEosMod2004)phase).dFdAlphaLR() * this.alphaiT;
    }

    public double dFLRdNdV(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        return 1.0E-5 * (((PhaseModifiedFurstElectrolyteEosMod2004)phase).dFdAlphaLRdX() * this.XLRi * ((PhaseModifiedFurstElectrolyteEosMod2004)phase).getAlphaLRV() + ((PhaseModifiedFurstElectrolyteEosMod2004)phase).dFdAlphaLR() * this.alphaiV);
    }

    public double dFLRdNdN(int j, PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        return ((PhaseModifiedFurstElectrolyteEosMod2004)phase).dFdAlphaLRdX() * this.XLRi * ((ComponentModifiedFurstElectrolyteEosMod2004)((PhaseModifiedFurstElectrolyteEosMod2004)phase).getComponents()[j]).getAlphai() + ((PhaseModifiedFurstElectrolyteEosMod2004)phase).dFdAlphaLR() * this.dAlphaLRdndn(j, phase, numberOfComponents, temperature, pressure) + ((PhaseModifiedFurstElectrolyteEosMod2004)phase).dFdAlphaLRdX() * this.alphai * ((ComponentModifiedFurstElectrolyteEosMod2004)((PhaseModifiedFurstElectrolyteEosMod2004)phase).getComponents()[j]).getXLRi();
    }

    public double calcXLRdN(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        return Math.pow(this.getIonicCharge(), 2.0) * ((PhaseModifiedFurstElectrolyteEosMod2004)phase).getShieldingParameter() / (1.0 + ((PhaseModifiedFurstElectrolyteEosMod2004)phase).getShieldingParameter() * this.getLennardJonesMolecularDiameter() * 1.0E-10);
    }

    public double FLRN() {
        return 0.0;
    }

    public double calcSolventdiElectricdn(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        if (this.getIonicCharge() != 0.0) {
            // empty if block
        }
        return 0.0;
    }

    public double calcSolventdiElectricdndn(int j, PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        if (this.getIonicCharge() != 0.0 || ((PhaseModifiedFurstElectrolyteEosMod2004)phase).getComponents()[j].getIonicCharge() != 0.0) {
            // empty if block
        }
        return 0.0;
    }

    public double calcSolventdiElectricdndT(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        if (this.getIonicCharge() != 0.0) {
            // empty if block
        }
        return 0.0;
    }

    public double calcdiElectricdn(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        double X = (1.0 - ((PhaseModifiedFurstElectrolyteEosMod2004)phase).getEpsIonic()) / (1.0 + ((PhaseModifiedFurstElectrolyteEosMod2004)phase).getEpsIonic() / 2.0);
        double Y = ((PhaseModifiedFurstElectrolyteEosMod2004)phase).getSolventDiElectricConstant() - 1.0;
        double dXdf = this.getEpsIonici() * -3.0 / 2.0 / Math.pow(((PhaseModifiedFurstElectrolyteEosMod2004)phase).getEpsIonic() / 2.0 + 1.0, 2.0);
        double dYdf = this.getSolventDiElectricConstantdn();
        return dYdf * X + Y * dXdf;
    }

    public double calcdiElectricdndV(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        double dXdf = ((PhaseModifiedFurstElectrolyteEosMod2004)phase).getEpsIonicdV() * -3.0 / 2.0 / Math.pow(((PhaseModifiedFurstElectrolyteEosMod2004)phase).getEpsIonic() / 2.0 + 1.0, 2.0);
        double dYdf = this.getSolventDiElectricConstantdn();
        double d1 = ((PhaseModifiedFurstElectrolyteEosMod2004)phase).getSolventDiElectricConstant();
        double d2 = this.epsIoniciV * -3.0 / 2.0 / Math.pow(((PhaseModifiedFurstElectrolyteEosMod2004)phase).getEpsIonic() / 2.0 + 1.0, 2.0);
        double d3 = ((PhaseModifiedFurstElectrolyteEosMod2004)phase).getEpsIonicdV() * this.epsIonici * 3.0 / 2.0 / Math.pow(((PhaseModifiedFurstElectrolyteEosMod2004)phase).getEpsIonic() / 2.0 + 1.0, 3.0);
        return dYdf * dXdf + d1 * d2 + d1 * d3;
    }

    public double calcdiElectricdndn(int j, PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        double dYdf = ((ComponentModifiedFurstElectrolyteEosMod2004)((PhaseModifiedFurstElectrolyteEosMod2004)phase).getComponents()[j]).getSolventDiElectricConstantdn();
        double dXdfdfj = this.getEpsIonici() * -3.0 / 2.0 / Math.pow(((PhaseModifiedFurstElectrolyteEosMod2004)phase).getEpsIonic() / 2.0 + 1.0, 2.0);
        double dXdf = ((ComponentModifiedFurstElectrolyteEosMod2004)((PhaseModifiedFurstElectrolyteEosMod2004)phase).getComponents()[j]).getEpsIonici() * this.getEpsIonici() * 3.0 / 2.0 / Math.pow(((PhaseModifiedFurstElectrolyteEosMod2004)phase).getEpsIonic() / 2.0 + 1.0, 3.0);
        double d1 = ((PhaseModifiedFurstElectrolyteEosMod2004)phase).getSolventDiElectricConstant();
        double d2 = ((ComponentModifiedFurstElectrolyteEosMod2004)((PhaseModifiedFurstElectrolyteEosMod2004)phase).getComponents()[j]).getEpsIonici() * -3.0 / 2.0 / Math.pow(((PhaseModifiedFurstElectrolyteEosMod2004)phase).getEpsIonic() / 2.0 + 1.0, 2.0);
        double d5 = this.getSolventDiElectricConstantdn();
        double d3 = this.calcSolventdiElectricdndn(j, phase, numberOfComponents, temperature, pressure);
        double d4 = (1.0 - ((PhaseModifiedFurstElectrolyteEosMod2004)phase).getEpsIonic()) / (1.0 + ((PhaseModifiedFurstElectrolyteEosMod2004)phase).getEpsIonic() / 2.0);
        return dYdf * dXdfdfj + dXdf * d1 + d2 * d5 + d3 * d4;
    }

    public double calcdiElectricdndT(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        double X = (1.0 - ((PhaseModifiedFurstElectrolyteEosMod2004)phase).getEpsIonic()) / (1.0 + ((PhaseModifiedFurstElectrolyteEosMod2004)phase).getEpsIonic() / 2.0);
        double Y = ((PhaseModifiedFurstElectrolyteEosMod2004)phase).getSolventDiElectricConstantdT();
        double dXdf = this.getEpsIonici() * -3.0 / 2.0 / Math.pow(((PhaseModifiedFurstElectrolyteEosMod2004)phase).getEpsIonic() / 2.0 + 1.0, 2.0);
        double dYdf = this.solventdiElectricdndT;
        return dYdf * X + Y * dXdf;
    }

    public double calcGammaLRdn(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        return 0.0;
    }

    public double dFSR2dN(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        return ((PhaseModifiedFurstElectrolyteEosMod2004)phase).FSR2eps() * this.epsi + ((PhaseModifiedFurstElectrolyteEosMod2004)phase).FSR2W() * this.Wi;
    }

    public double dFSR2dNdT(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        return ((PhaseModifiedFurstElectrolyteEosMod2004)phase).FSR2W() * this.WiT + ((PhaseModifiedFurstElectrolyteEosMod2004)phase).FSR2epsW() * this.epsi * ((PhaseModifiedFurstElectrolyteEosMod2004)phase).getWT();
    }

    public double dFSR2dNdV(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        return 1.0E-5 * (((PhaseModifiedFurstElectrolyteEosMod2004)phase).FSR2epseps() * this.epsi * ((PhaseModifiedFurstElectrolyteEosMod2004)phase).getEpsdV() + ((PhaseModifiedFurstElectrolyteEosMod2004)phase).FSR2eps() * this.epsiV + ((PhaseModifiedFurstElectrolyteEosMod2004)phase).FSR2epsW() * this.Wi * ((PhaseModifiedFurstElectrolyteEosMod2004)phase).getEpsdV() + ((PhaseModifiedFurstElectrolyteEosMod2004)phase).FSR2epsV() * this.epsi + ((PhaseModifiedFurstElectrolyteEosMod2004)phase).FSR2VW() * this.Wi);
    }

    public double dFSR2dNdN(int j, PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        return ((PhaseModifiedFurstElectrolyteEosMod2004)phase).FSR2epseps() * this.epsi * ((ComponentModifiedFurstElectrolyteEosMod2004)((PhaseModifiedFurstElectrolyteEosMod2004)phase).getComponents()[j]).getEpsi() + ((PhaseModifiedFurstElectrolyteEosMod2004)phase).FSR2epsW() * this.Wi * ((ComponentModifiedFurstElectrolyteEosMod2004)((PhaseModifiedFurstElectrolyteEosMod2004)phase).getComponents()[j]).getEpsi() + ((PhaseModifiedFurstElectrolyteEosMod2004)phase).FSR2W() * ((PhaseModifiedFurstElectrolyteEosMod2004)phase).calcWij(this.componentNumber, j, phase, temperature, pressure, numberOfComponents) + ((PhaseModifiedFurstElectrolyteEosMod2004)phase).FSR2epsW() * this.epsi * ((PhaseModifiedFurstElectrolyteEosMod2004)phase).calcWi(j, phase, temperature, pressure, numberOfComponents);
    }

    public double dEpsdNi(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        return 3.153635421825E23 * Math.pow(this.lennardJonesMolecularDiameter * 1.0E-10, 3.0) * (1.0 / (phase.getMolarVolume() * 1.0E-5 * phase.getNumberOfMolesInPhase()));
    }

    public double dEpsdNidV(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        return -3.153635421825E23 * Math.pow(this.lennardJonesMolecularDiameter * 1.0E-10, 3.0) * (1.0 / Math.pow(phase.getMolarVolume() * 1.0E-5 * phase.getNumberOfMolesInPhase(), 2.0));
    }

    public double dEpsIonicdNi(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        if (this.ionicCharge == 0) {
            return 0.0;
        }
        return 0.5235987750000001 * (6.023E23 * Math.pow(this.lennardJonesMolecularDiameter * 1.0E-10, 3.0)) * (1.0 / (phase.getMolarVolume() * 1.0E-5 * phase.getNumberOfMolesInPhase()));
    }

    public double dEpsIonicdNidV(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        if (this.ionicCharge == 0) {
            return 0.0;
        }
        return -3.153635421825E23 * Math.pow(this.lennardJonesMolecularDiameter * 1.0E-10, 3.0) / Math.pow(phase.getMolarVolume() * 1.0E-5 * phase.getNumberOfMolesInPhase(), 2.0);
    }

    public double dFBorndN(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        return ((PhaseModifiedFurstElectrolyteEosMod2004)phase).FBornX() * this.getXBorni() + ((PhaseModifiedFurstElectrolyteEosMod2004)phase).FBornD();
    }

    public double dFBorndNdT(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        return ((PhaseModifiedFurstElectrolyteEosMod2004)phase).FBornTX() * this.XBorni;
    }

    public double dFBorndNdN(int j, PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        return 0.0;
    }

    public double getIonicCoVolume() {
        return this.ionicCoVolume;
    }

    public double getDiElectricConstantdn() {
        return this.diElectricdn;
    }

    public double getSolventDiElectricConstantdn() {
        return this.solventdiElectricdn;
    }

    public double getBornVal() {
        return this.bornterm;
    }

    public double getEpsi() {
        return this.epsi;
    }

    public double getEpsIonici() {
        return this.epsIonici;
    }

    public double getAlphai() {
        return this.alphai;
    }

    public double getXLRi() {
        return this.XLRi;
    }

    public double getXBorni() {
        return this.XBorni;
    }
}

