/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component;

import neqsim.thermo.component.ComponentSolid;
import neqsim.thermo.phase.PhaseInterface;
import neqsim.thermo.phase.PhaseType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ComponentWaxWilson
extends ComponentSolid {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(ComponentWaxWilson.class);

    public ComponentWaxWilson(String name, double moles, double molesInPhase, int compIndex) {
        super(name, moles, molesInPhase, compIndex);
    }

    @Override
    public double fugcoef(PhaseInterface phase1) {
        if (!this.isWaxFormer()) {
            this.fugacityCoefficient = 1.0E30;
            return this.fugacityCoefficient;
        }
        return this.fugcoef2(phase1);
    }

    @Override
    public double fugcoef2(PhaseInterface phase1) {
        this.refPhase.setTemperature(phase1.getTemperature());
        this.refPhase.setPressure(phase1.getPressure());
        this.refPhase.init(this.refPhase.getNumberOfMolesInPhase(), 1, 1, PhaseType.byValue(0), 1.0);
        this.refPhase.getComponent(0).fugcoef(this.refPhase);
        double liquidPhaseFugacity = this.refPhase.getComponent(0).getFugacityCoefficient() * this.refPhase.getPressure();
        double Tf = 374.5 + 0.2617 * this.getMolarMass() - 20.172 / this.getMolarMass();
        double Hf = 0.1426 * this.getMolarMass() * Tf * 4.184 * 1000.0;
        this.setHeatOfFusion(Hf);
        double deltaCpSL = (0.3033 * this.getMolarMass() - 4.635E-4 * this.getMolarMass() * phase1.getTemperature()) * 4.1868;
        double solMolVol = 0.0;
        double liqMolVol = 0.0;
        double deltaSolVol = solMolVol - liqMolVol;
        double solidActivityCoefficient = this.getWilsonActivityCoefficient(phase1);
        this.SolidFug = this.getx() * liquidPhaseFugacity * Math.exp(-this.getHeatOfFusion() / (8.3144621 * phase1.getTemperature()) * (1.0 - phase1.getTemperature() / this.getTriplePointTemperature()) + deltaCpSL / (8.3144621 * phase1.getTemperature()) * (this.getTriplePointTemperature() - phase1.getTemperature()) - deltaCpSL / 8.3144621 * Math.log(this.getTriplePointTemperature() / phase1.getTemperature()) - deltaSolVol * (1.0 - phase1.getPressure()) / (8.3144621 * phase1.getTemperature()));
        this.fugacityCoefficient = solidActivityCoefficient * this.SolidFug / (phase1.getPressure() * this.getx());
        return this.fugacityCoefficient;
    }

    public double getWilsonActivityCoefficient(PhaseInterface phase1) {
        double sum1 = 0.0;
        double sum2 = 0.0;
        double tempSum = 0.0;
        for (int i = 0; i < phase1.getNumberOfComponents(); ++i) {
            sum1 += phase1.getComponent(i).getx() * ((ComponentWaxWilson)phase1.getComponent(i)).getCharEnergyParamter(phase1, this.getComponentNumber(), i);
            tempSum = 0.0;
            for (int j = 0; j < phase1.getNumberOfComponents(); ++j) {
                tempSum += phase1.getComponent(j).getx() * ((ComponentWaxWilson)phase1.getComponent(j)).getCharEnergyParamter(phase1, i, j);
            }
            sum2 += phase1.getComponent(i).getx() * ((ComponentWaxWilson)phase1.getComponent(i)).getCharEnergyParamter(phase1, i, this.getComponentNumber()) / tempSum;
        }
        return Math.exp(1.0 - Math.log(sum1) - sum2);
    }

    public double getCharEnergyParamter(PhaseInterface phase1, int comp1, int comp2) {
        double param1 = 0.0;
        double param2 = 0.0;
        if (phase1.getComponent(comp1).getMolarMass() - 1.0E-10 > phase1.getComponent(comp2).getMolarMass()) {
            param1 = ((ComponentWaxWilson)phase1.getComponent(comp2)).getWilsonInteractionEnergy(phase1);
            param2 = ((ComponentWaxWilson)phase1.getComponent(comp1)).getWilsonInteractionEnergy(phase1);
        } else {
            param1 = 1.0;
            param2 = 1.0;
        }
        return Math.exp(-(param2 - param1) / (8.3144621 * phase1.getTemperature()));
    }

    public double getWilsonInteractionEnergy(PhaseInterface phase1) {
        double coordinationNumber = 6.0;
        double carbonnumber = this.getMolarMass() / 0.014;
        double x = 1.0 - phase1.getTemperature() / this.getTC();
        double deltaHvap0 = 5.2804 * Math.pow(x, 0.3333) + 12.865 * Math.pow(x, 0.8333) + 1.171 * Math.pow(x, 1.2083) - 13.166 * x + 0.4858 * Math.pow(x, 2.0) - 1.088 * Math.pow(x, 3.0);
        double deltaHvap1 = 0.80022 * Math.pow(x, 0.3333) + 273.23 * Math.pow(x, 0.8333) + 465.08 * Math.pow(x, 1.2083) - 638.51 * x - 145.12 * Math.pow(x, 2.0) + 74.049 * Math.pow(x, 3.0);
        double deltaHvap2 = 7.2543 * Math.pow(x, 0.3333) - 346.45 * Math.pow(x, 0.8333) - 610.48 * Math.pow(x, 1.2083) + 839.89 * x + 160.05 * Math.pow(x, 2.0) - 50.711 * Math.pow(x, 3.0);
        double omega = 0.052075 + 0.0448946 * carbonnumber - 1.85397E-4 * carbonnumber * carbonnumber;
        double deltaHvap = 8.3144621 * this.getTC() * ((deltaHvap0 + omega * deltaHvap1 + omega * omega * deltaHvap2) * 4.1868);
        double deltaHtot = (3.7791 * carbonnumber - 12.654) * 1000.0;
        double Tf = 374.5 + 0.2617 * this.getMolarMass() - 20.172 / this.getMolarMass();
        double deltaHf = 0.1426 * this.getMolarMass() * Tf * 4.1868;
        double deltaHtrans = deltaHtot - deltaHf;
        double deltaHsub = deltaHvap + deltaHf + deltaHtrans;
        return -2.0 / coordinationNumber * (deltaHsub - 8.3144621 * phase1.getTemperature());
    }
}

