/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component;

import neqsim.thermo.component.ComponentSolid;
import neqsim.thermo.phase.PhaseInterface;
import neqsim.thermo.phase.PhaseType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ComponentWonWax
extends ComponentSolid {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(ComponentWonWax.class);

    public ComponentWonWax(String name, double moles, double molesInPhase, int compIndex) {
        super(name, moles, molesInPhase, compIndex);
    }

    @Override
    public double fugcoef(PhaseInterface phase1) {
        if (!this.isWaxFormer()) {
            this.fugacityCoefficient = 1.0E30;
            return this.fugacityCoefficient;
        }
        return this.fugcoef2(phase1);
    }

    @Override
    public double fugcoef2(PhaseInterface phase1) {
        this.refPhase.setTemperature(phase1.getTemperature());
        this.refPhase.setPressure(phase1.getPressure());
        this.refPhase.init(this.refPhase.getNumberOfMolesInPhase(), 1, 1, PhaseType.byValue(0), 1.0);
        this.refPhase.getComponent(0).fugcoef(this.refPhase);
        double liquidPhaseFugacity = this.refPhase.getComponent(0).getFugacityCoefficient() * this.refPhase.getPressure();
        double solidActivityCoefficient = this.getWonActivityCoefficient(phase1);
        logger.info("activity coef Won " + solidActivityCoefficient);
        this.SolidFug = this.getx() * liquidPhaseFugacity * Math.exp(-this.getHeatOfFusion() / (8.3144621 * phase1.getTemperature()) * (1.0 - phase1.getTemperature() / this.getTriplePointTemperature()));
        this.fugacityCoefficient = solidActivityCoefficient * this.SolidFug / (phase1.getPressure() * this.getx());
        return this.fugacityCoefficient;
    }

    public double getWonActivityCoefficient(PhaseInterface phase1) {
        double TetaAvg = 0.0;
        double gamma = 0.0;
        for (int i = 0; i < phase1.getNumberOfComponents(); ++i) {
            double tempSum = 0.0;
            for (int j = 0; j < phase1.getNumberOfComponents(); ++j) {
                tempSum += phase1.getComponent(j).getx() * ((ComponentWonWax)phase1.getComponent(j)).getWonVolume(phase1);
            }
            TetaAvg += phase1.getComponent(i).getx() * ((ComponentWonWax)phase1.getComponent(i)).getWonVolume(phase1) / tempSum * ((ComponentWonWax)phase1.getComponent(i)).getWonParam(phase1);
        }
        gamma = Math.exp(this.getWonVolume(phase1) * Math.pow(TetaAvg - this.getWonParam(phase1), 2.0) / (1.9858775 * phase1.getTemperature()));
        return gamma;
    }

    public double getWonVolume(PhaseInterface phase1) {
        double d25 = 0.8155 + 6.273E-5 * this.getMolarMass() - 13.06 / this.getMolarMass();
        return this.getMolarMass() / d25;
    }

    public double getWonParam(PhaseInterface phase1) {
        double Tf = 9.800665 * this.getMolarMass() - 20172.0 / this.getMolarMass();
        double Hf = 0.1426 * this.getMolarMass() * Tf;
        double x = 1.0 - phase1.getTemperature() / this.getTC();
        double deltaHvap0 = 5.2804 * Math.pow(x, 0.3333) + 12.865 * Math.pow(x, 0.8333) + 1.171 * Math.pow(x, 1.2083) - 13.166 * x + 0.4858 * Math.pow(x, 2.0) - 1.088 * Math.pow(x, 3.0);
        double deltaHvap1 = 0.80022 * Math.pow(x, 0.3333) + 273.23 * Math.pow(x, 0.8333) + 465.08 * Math.pow(x, 1.2083) - 638.51 * x - 145.12 * Math.pow(x, 2.0) - 74.049 * Math.pow(x, 3.0);
        double deltaHvap2 = 7.2543 * Math.pow(x, 0.3333) - 346.45 * Math.pow(x, 0.8333) - 610.48 * Math.pow(x, 1.2083) + 839.89 * x + 160.05 * Math.pow(x, 2.0) - 50.711 * Math.pow(x, 3.0);
        double carbonnumber = this.getMolarMass() / 0.014;
        double omega = 0.052075 + 0.0448946 * carbonnumber - 1.85397E-4 * carbonnumber * carbonnumber;
        double Hvap = 1.9858775 * this.getTC() * (deltaHvap0 + omega * deltaHvap1 + omega * omega * deltaHvap2);
        return Math.sqrt((Hvap - Hf - 1.9858775 * phase1.getTemperature()) / (this.getMolarMass() / (0.8155 + 6.273E-5 * this.getMolarMass() - 13.06 / this.getMolarMass())));
    }
}

