/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component.attractiveeosterm;

import neqsim.thermo.component.ComponentEosInterface;
import neqsim.thermo.component.attractiveeosterm.AttractiveTermBaseClass;

public class AttractiveTermMollerup
extends AttractiveTermBaseClass {
    private static final long serialVersionUID = 1000L;

    public AttractiveTermMollerup(ComponentEosInterface component) {
        super(component);
    }

    public AttractiveTermMollerup(ComponentEosInterface component, double[] params) {
        this(component);
        System.arraycopy(params, 0, this.parameters, 0, params.length);
    }

    @Override
    public AttractiveTermMollerup clone() {
        AttractiveTermMollerup attractiveTerm = null;
        try {
            attractiveTerm = (AttractiveTermMollerup)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return attractiveTerm;
    }

    @Override
    public double alpha(double temperature) {
        return 1.0 + this.parameters[0] * (1.0 / temperature * this.getComponent().getTC() - 1.0) + this.parameters[1] * temperature / this.getComponent().getTC() * Math.log(temperature / this.getComponent().getTC()) + this.parameters[2] * (temperature / this.getComponent().getTC() - 1.0);
    }

    @Override
    public double aT(double temperature) {
        return this.getComponent().geta() * this.alpha(temperature);
    }

    @Override
    public double diffalphaT(double temperature) {
        return -this.parameters[0] / (temperature * temperature) * this.getComponent().getTC() + this.parameters[1] / this.getComponent().getTC() * Math.log(temperature / this.getComponent().getTC()) + this.parameters[1] / this.getComponent().getTC() + this.parameters[2] / this.getComponent().getTC();
    }

    @Override
    public double diffdiffalphaT(double temperature) {
        return 2.0 * this.parameters[0] / (temperature * temperature * temperature) * this.getComponent().getTC() + this.parameters[1] / this.getComponent().getTC() / temperature;
    }

    @Override
    public double diffaT(double temperature) {
        return this.getComponent().geta() * this.diffalphaT(temperature);
    }

    @Override
    public double diffdiffaT(double temperature) {
        return this.getComponent().geta() * this.diffdiffalphaT(temperature);
    }
}

