/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component.attractiveeosterm;

import neqsim.thermo.component.ComponentEosInterface;
import neqsim.thermo.component.attractiveeosterm.AttractiveTermBaseClass;

public class AttractiveTermRk
extends AttractiveTermBaseClass {
    private static final long serialVersionUID = 1000L;

    public AttractiveTermRk(ComponentEosInterface component) {
        super(component);
    }

    @Override
    public AttractiveTermRk clone() {
        AttractiveTermRk attractiveTerm = null;
        try {
            attractiveTerm = (AttractiveTermRk)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return attractiveTerm;
    }

    @Override
    public double alpha(double temperature) {
        return Math.sqrt(this.getComponent().getTC() / temperature);
    }

    @Override
    public double aT(double temperature) {
        return this.getComponent().geta() * this.alpha(temperature);
    }

    @Override
    public double diffalphaT(double temperature) {
        return -0.5 * this.getComponent().getTC() / (Math.sqrt(this.getComponent().getTC() / temperature) * Math.pow(temperature, 2.0));
    }

    @Override
    public double diffdiffalphaT(double temperature) {
        return -0.25 * this.getComponent().getTC() * this.getComponent().getTC() / (Math.pow(this.getComponent().getTC() / temperature, 1.5) * Math.pow(temperature, 4.0)) + this.getComponent().getTC() / (Math.sqrt(this.getComponent().getTC() / temperature) * Math.pow(temperature, 3.0));
    }

    @Override
    public double diffaT(double temperature) {
        return this.getComponent().geta() * this.diffalphaT(temperature);
    }

    @Override
    public double diffdiffaT(double temperature) {
        return this.getComponent().geta() * this.diffdiffalphaT(temperature);
    }
}

