/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.mixingrule;

import java.awt.BorderLayout;
import java.awt.Container;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import neqsim.thermo.ThermodynamicConstantsInterface;
import neqsim.thermo.component.ComponentEosInterface;
import neqsim.thermo.component.ComponentGEInterface;
import neqsim.thermo.mixingrule.ElectrolyteMixingRulesInterface;
import neqsim.thermo.mixingrule.EosMixingRulesInterface;
import neqsim.thermo.mixingrule.HVmixingRuleInterface;
import neqsim.thermo.phase.PhaseGE;
import neqsim.thermo.phase.PhaseGENRTLmodifiedHV;
import neqsim.thermo.phase.PhaseGEUnifac;
import neqsim.thermo.phase.PhaseGEUnifacPSRK;
import neqsim.thermo.phase.PhaseGEUnifacUMRPRU;
import neqsim.thermo.phase.PhaseInterface;
import neqsim.thermo.phase.PhaseType;
import neqsim.thermo.util.constants.FurstElectrolyteConstants;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ejml.simple.SimpleMatrix;

public class EosMixingRules
implements Cloneable,
ThermodynamicConstantsInterface {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(EosMixingRules.class);
    public double Atot = 0.0;
    public double Btot = 0.0;
    public double Ai = 0.0;
    public double Bi = 0.0;
    public double A;
    public double B;
    public String mixingRuleGEModel = "NRTL";
    public String mixingRuleName = "no (kij=0)";
    public double[][] intparam;
    public double[][] intparamT;
    public double[][] WSintparam;
    public double[][] intparamij;
    public double[][] intparamji;
    public int[][] intparamTType;
    double[][] HVDij;
    double[][] HValpha;
    double[][] HVDijT;
    double[][] NRTLDij;
    double[][] NRTLalpha;
    double[][] NRTLDijT;
    double[][][] wij;
    int[][] wijCalcOrFitted;
    String[][] classicOrHV;
    String[][] classicOrWS;
    public double nEOSkij = 3.0;
    public static boolean calcEOSInteractionParameters = false;
    private int bmixType = 0;

    public EosMixingRules clone() {
        EosMixingRules clonedSystem = null;
        try {
            clonedSystem = (EosMixingRules)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return clonedSystem;
    }

    public EosMixingRulesInterface getMixingRule(int i) {
        if (i == 1) {
            return new ClassicVdW();
        }
        if (i == 2) {
            return new ClassicSRK();
        }
        if (i == 3) {
            return new ClassicVdW();
        }
        return new ClassicVdW();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EosMixingRulesInterface getMixingRule(int i, PhaseInterface phase) {
        this.wij = new double[3][phase.getNumberOfComponents()][phase.getNumberOfComponents()];
        if (i == 1) {
            this.intparam = new double[phase.getNumberOfComponents()][phase.getNumberOfComponents()];
            return new ClassicVdW();
        }
        this.intparam = new double[phase.getNumberOfComponents()][phase.getNumberOfComponents()];
        this.intparamji = new double[phase.getNumberOfComponents()][phase.getNumberOfComponents()];
        this.intparamij = new double[phase.getNumberOfComponents()][phase.getNumberOfComponents()];
        this.intparamT = new double[phase.getNumberOfComponents()][phase.getNumberOfComponents()];
        this.intparamTType = new int[phase.getNumberOfComponents()][phase.getNumberOfComponents()];
        this.HVDij = new double[phase.getNumberOfComponents()][phase.getNumberOfComponents()];
        this.HVDijT = new double[phase.getNumberOfComponents()][phase.getNumberOfComponents()];
        this.NRTLDij = new double[phase.getNumberOfComponents()][phase.getNumberOfComponents()];
        this.NRTLDijT = new double[phase.getNumberOfComponents()][phase.getNumberOfComponents()];
        this.WSintparam = new double[phase.getNumberOfComponents()][phase.getNumberOfComponents()];
        this.HValpha = new double[phase.getNumberOfComponents()][phase.getNumberOfComponents()];
        this.NRTLalpha = new double[phase.getNumberOfComponents()][phase.getNumberOfComponents()];
        this.classicOrHV = new String[phase.getNumberOfComponents()][phase.getNumberOfComponents()];
        this.classicOrWS = new String[phase.getNumberOfComponents()][phase.getNumberOfComponents()];
        this.wijCalcOrFitted = new int[phase.getNumberOfComponents()][phase.getNumberOfComponents()];
        try (NeqSimDataBase database = new NeqSimDataBase();){
            for (int k = 0; k < phase.getNumberOfComponents(); ++k) {
                String component_name = phase.getComponents()[k].getComponentName();
                for (int l = k; l < phase.getNumberOfComponents(); ++l) {
                    if (k == l) {
                        this.classicOrHV[k][l] = "Classic";
                        this.classicOrWS[k][l] = "Classic";
                        this.classicOrHV[l][k] = this.classicOrHV[k][l];
                        this.classicOrWS[l][k] = this.classicOrWS[k][l];
                        continue;
                    }
                    ResultSet dataSet = null;
                    try {
                        if (phase.getComponent(k).isIsTBPfraction() || phase.getComponent(l).isIsTBPfraction()) {
                            throw new Exception("no interaction coefficient for TBP fractions");
                        }
                        int templ = l;
                        int tempk = k;
                        dataSet = NeqSimDataBase.createTemporaryTables() ? database.getResultSet("SELECT * FROM intertemp WHERE (comp1='" + component_name + "' AND comp2='" + phase.getComponents()[l].getComponentName() + "') OR (comp1='" + phase.getComponents()[l].getComponentName() + "' AND comp2='" + component_name + "')") : database.getResultSet("SELECT * FROM inter WHERE (comp1='" + component_name + "' AND comp2='" + phase.getComponents()[l].getComponentName() + "') OR (comp1='" + phase.getComponents()[l].getComponentName() + "' AND comp2='" + component_name + "')");
                        dataSet.next();
                        if (dataSet.getString("comp1").trim().equals(phase.getComponents()[l].getComponentName())) {
                            templ = k;
                            tempk = l;
                        }
                        this.classicOrHV[k][l] = dataSet.getString("HVTYPE").trim();
                        this.classicOrHV[l][k] = this.classicOrHV[k][l];
                        if (this.isCalcEOSInteractionParameters()) {
                            this.intparam[k][l] = 1.0 - Math.pow(2.0 * Math.sqrt(Math.pow(phase.getComponent(l).getCriticalVolume(), 0.0) * Math.pow(phase.getComponent(k).getCriticalVolume(), 0.0)) / (Math.pow(phase.getComponent(l).getCriticalVolume(), 0.0) + Math.pow(phase.getComponent(k).getCriticalVolume(), 0.0)), this.nEOSkij);
                            this.intparamT[k][l] = 0.0;
                        } else {
                            if (phase.getClass().getName().equals("neqsim.thermo.phase.PhasePrEos")) {
                                this.intparam[k][l] = Double.parseDouble(dataSet.getString("kijpr"));
                                this.intparamT[k][l] = Double.parseDouble(dataSet.getString("KIJTpr"));
                            } else {
                                this.intparam[k][l] = Double.parseDouble(dataSet.getString("kijsrk"));
                                this.intparamT[k][l] = Double.parseDouble(dataSet.getString("KIJTSRK"));
                            }
                            if (phase.getClass().getName().equals("neqsim.thermo.phase.PhasePrCPA")) {
                                this.intparam[k][l] = Double.parseDouble(dataSet.getString("cpakij_PR"));
                                this.intparamT[k][l] = 0.0;
                            } else if (phase.getClass().getName().equals("neqsim.thermo.phase.PhaseSrkCPA") || phase.getClass().getName().equals("neqsim.thermo.phase.PhaseSrkCPAs") || phase.getClass().getName().equals("neqsim.thermo.phase.PhaseElectrolyteCPAstatoil")) {
                                this.intparam[k][l] = Double.parseDouble(dataSet.getString("cpakij_SRK"));
                                this.intparamT[k][l] = Double.parseDouble(dataSet.getString("cpakijT_SRK"));
                                this.intparamij[tempk][templ] = Double.parseDouble(dataSet.getString("cpakijx_SRK"));
                                this.intparamji[templ][tempk] = this.intparamij[tempk][templ];
                                this.intparamji[tempk][templ] = Double.parseDouble(dataSet.getString("cpakjix_SRK"));
                                this.intparamij[templ][tempk] = this.intparamji[tempk][templ];
                            }
                            if (phase.getClass().getName().equals("neqsim.thermo.phase.PhasePCSAFTRahmat") || phase.getClass().getName().equals("neqsim.thermo.phase.PhasePCSAFT") || phase.getClass().getName().equals("neqsim.thermo.phase.PhasePCSAFTa")) {
                                this.intparam[k][l] = Double.parseDouble(dataSet.getString("KIJPCSAFT"));
                                this.intparamT[k][l] = 0.0;
                            }
                        }
                        ResultSetMetaData dataSetMD = dataSet.getMetaData();
                        int cols = dataSetMD.getColumnCount();
                        boolean hasKIJTTypeCPAcol = false;
                        String colname = "KIJTTypeCPA";
                        for (int x = 1; x <= cols; ++x) {
                            if (!colname.equals(dataSetMD.getColumnName(x))) continue;
                            hasKIJTTypeCPAcol = true;
                        }
                        this.intparamTType[k][l] = !phase.getClass().getName().equals("neqsim.thermo.phase.PhaseSrkCPAs") || !hasKIJTTypeCPAcol ? Integer.parseInt(dataSet.getString("KIJTType")) : Integer.parseInt(dataSet.getString("KIJTTypeCPA"));
                        this.intparamTType[l][k] = this.intparamTType[k][l];
                        this.HValpha[k][l] = Double.parseDouble(dataSet.getString("HValpha"));
                        this.HValpha[l][k] = this.HValpha[k][l];
                        this.HVDij[tempk][templ] = Double.parseDouble(dataSet.getString("HVgij"));
                        this.HVDij[templ][tempk] = Double.parseDouble(dataSet.getString("HVgji"));
                        this.wijCalcOrFitted[k][l] = Integer.parseInt(dataSet.getString("CalcWij"));
                        this.wijCalcOrFitted[l][k] = this.wijCalcOrFitted[k][l];
                        this.wij[0][k][l] = Double.parseDouble(dataSet.getString("w1"));
                        this.wij[0][l][k] = this.wij[0][k][l];
                        this.wij[1][k][l] = Double.parseDouble(dataSet.getString("w2"));
                        this.wij[1][l][k] = this.wij[1][k][l];
                        this.wij[2][k][l] = Double.parseDouble(dataSet.getString("w3"));
                        this.wij[2][l][k] = this.wij[2][k][l];
                        this.classicOrWS[k][l] = dataSet.getString("WSTYPE").trim();
                        this.classicOrWS[l][k] = this.classicOrWS[k][l];
                        this.WSintparam[k][l] = Double.parseDouble(dataSet.getString("kijWS"));
                        this.WSintparam[k][l] = Double.parseDouble(dataSet.getString("KIJWSunifac"));
                        this.WSintparam[l][k] = this.WSintparam[k][l];
                        this.NRTLalpha[k][l] = Double.parseDouble(dataSet.getString("NRTLalpha"));
                        this.NRTLalpha[l][k] = this.NRTLalpha[k][l];
                        this.NRTLDij[tempk][templ] = Double.parseDouble(dataSet.getString("NRTLgij"));
                        this.NRTLDij[templ][tempk] = Double.parseDouble(dataSet.getString("NRTLgji"));
                        this.HVDijT[tempk][templ] = Double.parseDouble(dataSet.getString("HVgijT"));
                        this.HVDijT[templ][tempk] = Double.parseDouble(dataSet.getString("HVgjiT"));
                        this.NRTLDijT[tempk][templ] = Double.parseDouble(dataSet.getString("WSgijT"));
                        this.NRTLDijT[templ][tempk] = Double.parseDouble(dataSet.getString("WSgjiT"));
                        continue;
                    }
                    catch (Exception ex) {
                        if (this.isCalcEOSInteractionParameters()) {
                            this.intparam[k][l] = 1.0 - Math.pow(2.0 * Math.sqrt(Math.pow(phase.getComponent(l).getCriticalVolume(), 0.3333333333333333) * Math.pow(phase.getComponent(k).getCriticalVolume(), 0.3333333333333333)) / (Math.pow(phase.getComponent(l).getCriticalVolume(), 0.3333333333333333) + Math.pow(phase.getComponent(k).getCriticalVolume(), 0.3333333333333333)), this.nEOSkij);
                        } else if (phase.getComponents()[k].getComponentName().equals("CO2") && phase.getComponents()[l].isIsTBPfraction() || phase.getComponents()[l].getComponentName().equals("CO2") && phase.getComponents()[k].isIsTBPfraction()) {
                            this.intparam[k][l] = 0.1;
                        } else if (phase.getComponents()[k].getComponentName().equals("nitrogen") && phase.getComponents()[l].isIsTBPfraction() || phase.getComponents()[l].getComponentName().equals("nitrogen") && phase.getComponents()[k].isIsTBPfraction()) {
                            this.intparam[k][l] = 0.08;
                        } else if (phase.getComponents()[k].getComponentName().equals("water") && phase.getComponents()[l].isIsTBPfraction() || phase.getComponents()[l].getComponentName().equals("water") && phase.getComponents()[k].isIsTBPfraction()) {
                            this.intparam[k][l] = 0.2;
                            if (phase.getClass().getName().equals("neqsim.thermo.phase.PhaseSrkCPA") || phase.getClass().getName().equals("neqsim.thermo.phase.PhaseSrkCPAs") || phase.getClass().getName().equals("neqsim.thermo.phase.PhaseElectrolyteCPAstatoil")) {
                                double intparamkPC;
                                double molmassPC = phase.getComponents()[l].getMolarMass();
                                if (phase.getComponents()[k].isIsTBPfraction()) {
                                    molmassPC = phase.getComponents()[k].getMolarMass();
                                }
                                this.intparam[k][l] = intparamkPC = -0.1533 * Math.log(1000.0 * molmassPC) + 0.7055;
                                this.intparamT[k][l] = 0.0;
                            }
                        } else if (phase.getComponents()[k].getComponentName().equals("MEG") && phase.getComponents()[l].isIsTBPfraction() || phase.getComponents()[l].getComponentName().equals("MEG") && phase.getComponents()[k].isIsTBPfraction()) {
                            this.intparam[k][l] = 0.2;
                            if (phase.getClass().getName().equals("neqsim.thermo.phase.PhaseSrkCPA") || phase.getClass().getName().equals("neqsim.thermo.phase.PhaseSrkCPAs") || phase.getClass().getName().equals("neqsim.thermo.phase.PhaseElectrolyteCPAstatoil")) {
                                double intparamkPC;
                                double molmassPC = phase.getComponents()[l].getMolarMass();
                                if (phase.getComponents()[k].isIsTBPfraction()) {
                                    molmassPC = phase.getComponents()[k].getMolarMass();
                                }
                                this.intparam[k][l] = intparamkPC = -0.0701 * Math.log(1000.0 * molmassPC) + 0.3521;
                                this.intparamT[k][l] = 0.0;
                            }
                        } else if (phase.getComponents()[k].getComponentName().equals("ethanol") && phase.getComponents()[l].isIsTBPfraction() || phase.getComponents()[l].getComponentName().equals("ethanol") && phase.getComponents()[k].isIsTBPfraction()) {
                            this.intparam[k][l] = 0.0;
                            if (phase.getClass().getName().equals("neqsim.thermo.phase.PhaseSrkCPA") || phase.getClass().getName().equals("neqsim.thermo.phase.PhaseSrkCPAs") || phase.getClass().getName().equals("neqsim.thermo.phase.PhaseElectrolyteCPAstatoil")) {
                                this.intparam[k][l] = -0.05;
                                this.intparamT[k][l] = 0.0;
                                if (phase.getComponents()[k].getMolarMass() > 0.2 || phase.getComponents()[l].getMolarMass() > 0.2) {
                                    this.intparam[k][l] = -0.1;
                                }
                            }
                        } else if (phase.getComponents()[k].getComponentName().equals("methanol") && phase.getComponents()[l].isIsTBPfraction() || phase.getComponents()[l].getComponentName().equals("methanol") && phase.getComponents()[k].isIsTBPfraction()) {
                            this.intparam[k][l] = 0.0;
                            if (phase.getClass().getName().equals("neqsim.thermo.phase.PhaseSrkCPA") || phase.getClass().getName().equals("neqsim.thermo.phase.PhaseSrkCPAs") || phase.getClass().getName().equals("neqsim.thermo.phase.PhaseElectrolyteCPAstatoil")) {
                                this.intparam[k][l] = -0.1;
                                this.intparamT[k][l] = 0.0;
                                if (phase.getComponents()[k].getMolarMass() > 0.2 || phase.getComponents()[l].getMolarMass() > 0.2) {
                                    this.intparam[k][l] = -0.2;
                                }
                            }
                        } else if (phase.getComponents()[k].getComponentName().equals("TEG") && phase.getComponents()[l].isIsTBPfraction() || phase.getComponents()[l].getComponentName().equals("TEG") && phase.getComponents()[k].isIsTBPfraction()) {
                            this.intparam[k][l] = 0.12;
                            if (phase.getClass().getName().equals("neqsim.thermo.phase.PhaseSrkCPA") || phase.getClass().getName().equals("neqsim.thermo.phase.PhaseSrkCPAs") || phase.getClass().getName().equals("neqsim.thermo.phase.PhaseElectrolyteCPAstatoil")) {
                                this.intparam[k][l] = 0.12;
                                this.intparamT[k][l] = 0.0;
                            }
                        } else if (phase.getComponents()[k].getComponentName().equals("S8") && phase.getComponents()[l].isIsTBPfraction() || phase.getComponents()[l].getComponentName().equals("S8") && phase.getComponents()[k].isIsTBPfraction()) {
                            this.intparam[k][l] = 0.05;
                        }
                        this.intparamij[k][l] = this.intparam[k][l];
                        this.intparamij[l][k] = this.intparam[k][l];
                        this.intparamji[k][l] = this.intparam[k][l];
                        this.intparamji[l][k] = this.intparam[k][l];
                        this.classicOrHV[k][l] = "Classic";
                        this.classicOrHV[l][k] = this.classicOrHV[k][l];
                        this.classicOrWS[k][l] = "Classic";
                        this.classicOrWS[l][k] = this.classicOrWS[k][l];
                        continue;
                    }
                    finally {
                        this.intparam[l][k] = this.intparam[k][l];
                        this.intparamT[l][k] = this.intparamT[k][l];
                        try {
                            if (dataSet != null) {
                                dataSet.close();
                            }
                        }
                        catch (Exception ex) {
                            logger.error("err closing dataSet IN MIX...", (Throwable)ex);
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error("error reading from database", (Throwable)ex);
        }
        if (i == 2) {
            this.mixingRuleName = "classic";
            return new ClassicSRK();
        }
        if (i == 3) {
            this.mixingRuleName = "Huron-Vidal";
            return new SRKHuronVidal2(phase, this.HValpha, this.HVDij, this.classicOrHV);
        }
        if (i == 4) {
            this.mixingRuleName = "Huron-Vidal";
            return new SRKHuronVidal2(phase, this.HValpha, this.HVDij, this.HVDijT, this.classicOrHV);
        }
        if (i == 5) {
            this.mixingRuleName = "Wong-Sandler";
            return new WongSandlerMixingRule(phase, this.NRTLalpha, this.NRTLDij, this.NRTLDijT, this.classicOrWS);
        }
        if (i == 6) {
            this.mixingRuleName = "Wong-Sandler";
            return new WongSandlerMixingRule(phase, this.NRTLalpha, this.NRTLDij, this.NRTLDijT, this.classicOrWS);
        }
        if (i == 7) {
            this.mixingRuleName = "classic-CPA";
            return new ClassicSRK();
        }
        if (i == 8) {
            this.mixingRuleName = "classicdT";
            return new ClassicSRKT();
        }
        if (i == 9) {
            this.mixingRuleName = "classic-CPA_T";
            return new ClassicSRKT2();
        }
        if (i == 10) {
            SimpleMatrix mat1 = new SimpleMatrix(this.intparamij);
            SimpleMatrix mat2 = new SimpleMatrix(this.intparamji);
            SimpleMatrix mat3 = new SimpleMatrix(this.intparamT);
            if (mat1.isIdentical(mat2, 1.0E-8)) {
                if (mat3.elementMaxAbs() < 1.0E-8) {
                    this.mixingRuleName = "classic-CPA";
                    return new ClassicSRK();
                }
                this.mixingRuleName = "classic-CPA_T";
                return new ClassicSRKT2();
            }
            this.mixingRuleName = "classic-CPA_Tx";
            return new ClassicSRKT2x();
        }
        return new ClassicVdW();
    }

    public EosMixingRulesInterface resetMixingRule(int i, PhaseInterface phase) {
        if (i == 1) {
            this.mixingRuleName = "no (kij=0)";
            return new ClassicVdW();
        }
        if (i == 2) {
            this.mixingRuleName = "classic";
            return new ClassicSRK();
        }
        if (i == 3) {
            this.mixingRuleName = "Huron-Vidal";
            return new SRKHuronVidal2(phase, this.HValpha, this.HVDij, this.classicOrHV);
        }
        if (i == 4) {
            this.mixingRuleName = "Huron-Vidal";
            return new SRKHuronVidal2(phase, this.HValpha, this.HVDij, this.HVDijT, this.classicOrHV);
        }
        if (i == 5) {
            this.mixingRuleName = "Wong-Sandler";
            return new WongSandlerMixingRule(phase, this.NRTLalpha, this.NRTLDij, this.NRTLDijT, this.classicOrWS);
        }
        if (i == 6) {
            this.mixingRuleName = "Wong-Sandler";
            return new WongSandlerMixingRule(phase, this.NRTLalpha, this.NRTLDij, this.NRTLDijT, this.classicOrWS);
        }
        if (i == 7) {
            this.mixingRuleName = "classic-CPA";
            return new ClassicSRK();
        }
        if (i == 8) {
            this.mixingRuleName = "classic-T";
            return new ClassicSRKT();
        }
        if (i == 9) {
            this.mixingRuleName = "classic-CPA_T";
            return new ClassicSRKT2();
        }
        if (i == 10) {
            SimpleMatrix mat1 = new SimpleMatrix(this.intparamij);
            SimpleMatrix mat2 = new SimpleMatrix(this.intparamji);
            SimpleMatrix mat3 = new SimpleMatrix(this.intparamT);
            if (mat1.isIdentical(mat2, 1.0E-8)) {
                if (mat3.elementMaxAbs() < 1.0E-8) {
                    this.mixingRuleName = "classic-CPA";
                    return new ClassicSRK();
                }
                this.mixingRuleName = "classic-CPA_T";
                return new ClassicSRKT2();
            }
            this.mixingRuleName = "classic-CPA_Tx";
            return new ClassicSRKT2x();
        }
        return new ClassicVdW();
    }

    public ElectrolyteMixingRulesInterface getElectrolyteMixingRule(PhaseInterface phase) {
        return new ElectrolyteMixRule(phase);
    }

    public boolean isCalcEOSInteractionParameters() {
        return calcEOSInteractionParameters;
    }

    public void setCalcEOSInteractionParameters(boolean CalcEOSInteractionParameters2) {
        calcEOSInteractionParameters = CalcEOSInteractionParameters2;
    }

    public String getMixingRuleName() {
        return this.mixingRuleName;
    }

    public void setMixingRuleName(String mixingRuleName) {
        this.mixingRuleName = mixingRuleName;
    }

    public void setMixingRuleGEModel(String GEmodel) {
        this.mixingRuleGEModel = GEmodel;
    }

    public double[][] getSRKbinaryInteractionParameters() {
        return this.intparam;
    }

    public double[][] getHVDij() {
        return this.HVDij;
    }

    public double[][] getHValpha() {
        return this.HValpha;
    }

    public double[][] getHVDijT() {
        return this.HVDijT;
    }

    public double[][] getNRTLDij() {
        return this.NRTLDij;
    }

    public double[][] getNRTLalpha() {
        return this.NRTLalpha;
    }

    public double[][] getNRTLDijT() {
        return this.NRTLDijT;
    }

    public double[][] getWSintparam() {
        return this.WSintparam;
    }

    public String[][] getClassicOrHV() {
        return this.classicOrHV;
    }

    public String[][] getClassicOrWS() {
        return this.classicOrWS;
    }

    public void displayInteractionCoefficients(String intType, PhaseInterface phase) {
        Object[][] interactTable = new String[phase.getNumberOfComponents() + 1][phase.getNumberOfComponents() + 1];
        DecimalFormat nf = new DecimalFormat();
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        nf.setDecimalFormatSymbols(symbols);
        nf.setMaximumFractionDigits(5);
        nf.applyPattern("#.#####E0");
        Object[] names = new String[phase.getNumberOfComponents() + 1];
        names[0] = "";
        for (int i = 0; i < phase.getNumberOfComponents(); ++i) {
            interactTable[i + 1][0] = phase.getComponent(i).getComponentName();
            interactTable[0][i + 1] = phase.getComponent(i).getComponentName();
            names[i + 1] = "";
            for (int j = 0; j < phase.getNumberOfComponents(); ++j) {
                interactTable[i + 1][j + 1] = Double.toString(this.intparam[i][j]);
            }
        }
        JFrame dialog = new JFrame("Interaction coefficients");
        Container dialogContentPane = dialog.getContentPane();
        dialogContentPane.setLayout(new BorderLayout());
        JTable Jtab = new JTable(interactTable, names);
        JScrollPane scrollpane = new JScrollPane(Jtab);
        dialogContentPane.add(scrollpane);
        dialog.setSize(800, 600);
        dialog.setVisible(true);
    }

    public class ElectrolyteMixRule
    implements ElectrolyteMixingRulesInterface,
    Cloneable {
        private static final long serialVersionUID = 1000L;

        public ElectrolyteMixRule(PhaseInterface phase) {
            this.calcWij(phase);
        }

        @Override
        public void calcWij(PhaseInterface phase) {
            ComponentEosInterface[] compArray = (ComponentEosInterface[])phase.getcomponentArray();
            int numbcomp = phase.getNumberOfComponents();
            for (int i = 0; i < numbcomp; ++i) {
                if (!(compArray[i].getIonicCharge() > 0.0)) continue;
                for (int j = 0; j < numbcomp; ++j) {
                    if (EosMixingRules.this.wijCalcOrFitted[i][j] != 0) continue;
                    if (compArray[j].getComponentName().equals("water") || compArray[j].getComponentName().equals("MDEA") || compArray[j].getComponentName().equals("Piperazine")) {
                        EosMixingRules.this.wij[0][i][j] = FurstElectrolyteConstants.getFurstParam(2) * compArray[i].getStokesCationicDiameter() + FurstElectrolyteConstants.getFurstParam(3);
                    }
                    if (compArray[j].getIonicCharge() < -0.01) {
                        EosMixingRules.this.wij[0][i][j] = FurstElectrolyteConstants.getFurstParam(4) * Math.pow(compArray[i].getStokesCationicDiameter() + compArray[j].getPaulingAnionicDiameter(), 4.0) + FurstElectrolyteConstants.getFurstParam(5);
                    }
                    EosMixingRules.this.wij[0][j][i] = EosMixingRules.this.wij[0][i][j];
                }
            }
        }

        @Override
        public void setWijParameter(int i, int j, double value) {
            EosMixingRules.this.wij[0][i][j] = value;
            EosMixingRules.this.wij[0][j][i] = value;
        }

        @Override
        public double getWijParameter(int i, int j) {
            return EosMixingRules.this.wij[0][i][j];
        }

        @Override
        public void setWijT1Parameter(int i, int j, double value) {
            EosMixingRules.this.wij[1][i][j] = value;
            EosMixingRules.this.wij[1][j][i] = value;
        }

        @Override
        public double gettWijT1Parameter(int i, int j) {
            return EosMixingRules.this.wij[1][i][j];
        }

        @Override
        public void setWijT2Parameter(int i, int j, double value) {
            EosMixingRules.this.wij[2][i][j] = value;
            EosMixingRules.this.wij[2][j][i] = value;
        }

        @Override
        public double gettWijT2Parameter(int i, int j) {
            return EosMixingRules.this.wij[2][i][j];
        }

        @Override
        public double getWij(int i, int j, double temperature) {
            return EosMixingRules.this.wij[0][i][j] + EosMixingRules.this.wij[1][i][j] * (1.0 / temperature - 0.0033540164346805303) + EosMixingRules.this.wij[2][i][j] * ((298.15 - temperature) / temperature + Math.log(temperature / 298.15));
        }

        @Override
        public double getWijT(int i, int j, double temperature) {
            return -EosMixingRules.this.wij[1][i][j] / (temperature * temperature) - EosMixingRules.this.wij[2][i][j] * (298.15 - temperature) / (temperature * temperature);
        }

        @Override
        public double getWijTT(int i, int j, double temperature) {
            return 2.0 * EosMixingRules.this.wij[1][i][j] / (temperature * temperature * temperature) + EosMixingRules.this.wij[2][i][j] / (temperature * temperature) + 2.0 * EosMixingRules.this.wij[2][i][j] * (298.15 - temperature) / (temperature * temperature * temperature);
        }

        @Override
        public double calcW(PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            ComponentEosInterface[] compArray = (ComponentEosInterface[])phase.getcomponentArray();
            double W = 0.0;
            for (int i = 0; i < numbcomp; ++i) {
                for (int j = 0; j < numbcomp; ++j) {
                    W += compArray[i].getNumberOfMolesInPhase() * compArray[j].getNumberOfMolesInPhase() * this.getWij(i, j, temperature);
                }
            }
            return -W;
        }

        @Override
        public double calcWi(int compNumb, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            ComponentEosInterface[] compArray = (ComponentEosInterface[])phase.getcomponentArray();
            double Wi = 0.0;
            for (int j = 0; j < numbcomp; ++j) {
                Wi += compArray[j].getNumberOfMolesInPhase() * this.getWij(compNumb, j, temperature);
            }
            return -2.0 * Wi;
        }

        @Override
        public double calcWiT(int compNumb, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            ComponentEosInterface[] compArray = (ComponentEosInterface[])phase.getcomponentArray();
            double WiT = 0.0;
            for (int j = 0; j < numbcomp; ++j) {
                WiT += compArray[j].getNumberOfMolesInPhase() * this.getWijT(compNumb, j, temperature);
            }
            return -2.0 * WiT;
        }

        @Override
        public double calcWT(PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            ComponentEosInterface[] compArray = (ComponentEosInterface[])phase.getcomponentArray();
            double WT = 0.0;
            for (int i = 0; i < numbcomp; ++i) {
                for (int j = 0; j < numbcomp; ++j) {
                    WT += compArray[i].getNumberOfMolesInPhase() * compArray[j].getNumberOfMolesInPhase() * this.getWijT(i, j, temperature);
                }
            }
            return -WT;
        }

        @Override
        public double calcWTT(PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            ComponentEosInterface[] compArray = (ComponentEosInterface[])phase.getcomponentArray();
            double WTT = 0.0;
            for (int i = 0; i < numbcomp; ++i) {
                for (int j = 0; j < numbcomp; ++j) {
                    WTT += compArray[i].getNumberOfMolesInPhase() * compArray[j].getNumberOfMolesInPhase() * this.getWijTT(i, j, temperature);
                }
            }
            return -WTT;
        }

        @Override
        public double calcWij(int compNumbi, int compNumj, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            return -2.0 * this.getWij(compNumbi, compNumj, temperature);
        }
    }

    public class WongSandlerMixingRule
    extends SRKHuronVidal2 {
        private static final long serialVersionUID = 1000L;
        double Q;
        double QT;
        double DDE2;
        double alpha_mix;
        double dadt;
        double b_mix;
        double dbdt;
        double bdert;
        double d2adt2;
        double d2bdt2;
        double[] ader;
        double[] adert;
        double[] qf1;
        double[] d2qp;
        double[] qPure;
        double[] qPuredT;
        double[] qPuredTdT;
        double[][] ad2;
        double[][] qf2;
        double[][] qft;
        double[][] bd2;
        double hwfc;
        double gex;
        double hex;
        double cpex;
        double[] oneSubAlf;
        double[] abf;
        double[] bc;
        double[] abft2;
        double[] abft;
        double[] QFTD;
        double[] BDER;
        double[] BDERT;

        public WongSandlerMixingRule(PhaseInterface phase, double[][] WSalpha, double[][] WSDij, String[][] mixRule) {
            super(phase, WSalpha, WSDij, mixRule);
            this.Q = 0.0;
            this.QT = 0.0;
            this.alpha_mix = 0.0;
            this.dadt = 0.0;
            this.b_mix = 0.0;
            this.dbdt = 0.0;
            this.bdert = 0.0;
            this.d2adt2 = 0.0;
            this.d2bdt2 = 0.0;
            this.hwfc = 0.0;
            this.gex = 0.0;
            this.hex = 0.0;
            this.cpex = 0.0;
        }

        public WongSandlerMixingRule(PhaseInterface phase, double[][] WSalpha, double[][] WSDij, double[][] WSDijT, String[][] mixRule) {
            super(phase, WSalpha, WSDij, WSDijT, mixRule);
            this.Q = 0.0;
            this.QT = 0.0;
            this.alpha_mix = 0.0;
            this.dadt = 0.0;
            this.b_mix = 0.0;
            this.dbdt = 0.0;
            this.bdert = 0.0;
            this.d2adt2 = 0.0;
            this.d2bdt2 = 0.0;
            this.hwfc = 0.0;
            this.gex = 0.0;
            this.hex = 0.0;
            this.cpex = 0.0;
        }

        @Override
        public void init(PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            int i;
            int i2;
            ComponentEosInterface[] compArray = (ComponentEosInterface[])phase.getcomponentArray();
            this.gePhase.setProperties(phase);
            if (EosMixingRules.this.mixingRuleGEModel.equals("NRTL")) {
                this.gePhase.getExcessGibbsEnergy(phase, numbcomp, temperature, pressure, phase.getType());
            } else {
                this.gePhase.init(phase.getNumberOfMolesInPhase(), phase.getNumberOfComponents(), 3, phase.getType(), phase.getBeta());
            }
            this.hwfc = -1.0 / (1.0 / (compArray[0].getDeltaEosParameters()[1] - compArray[0].getDeltaEosParameters()[0]) * Math.log((1.0 + compArray[0].getDeltaEosParameters()[1]) / (1.0 + compArray[0].getDeltaEosParameters()[0])));
            double term = 0.0;
            this.qPure = new double[numbcomp];
            this.qPuredT = new double[numbcomp];
            this.qPuredTdT = new double[numbcomp];
            this.ader = new double[numbcomp];
            this.adert = new double[numbcomp];
            this.ad2 = new double[numbcomp][numbcomp];
            this.qf2 = new double[numbcomp][numbcomp];
            this.bd2 = new double[numbcomp][numbcomp];
            this.qft = new double[numbcomp][numbcomp];
            this.qf1 = new double[numbcomp];
            this.oneSubAlf = new double[numbcomp];
            this.abf = new double[numbcomp];
            this.bc = new double[numbcomp];
            this.abft2 = new double[numbcomp];
            this.abft = new double[numbcomp];
            this.QFTD = new double[numbcomp];
            this.BDER = new double[numbcomp];
            this.BDERT = new double[numbcomp];
            this.hex = phase.getHresTP() / phase.getNumberOfMolesInPhase();
            this.cpex = phase.getCpres() / phase.getNumberOfMolesInPhase();
            for (int i3 = 0; i3 < numbcomp; ++i3) {
                this.qPure[i3] = compArray[i3].getaT() / (compArray[i3].getb() * 8.3144621 * temperature);
                this.qPuredT[i3] = -compArray[i3].getaT() / (compArray[i3].getb() * 8.3144621 * temperature * temperature) + compArray[i3].diffaT(temperature) / (compArray[i3].getb() * 8.3144621 * temperature);
                this.qPuredTdT[i3] = 2.0 * compArray[i3].getaT() / (compArray[i3].getb() * 8.3144621 * Math.pow(temperature, 3.0)) - compArray[i3].getaDiffT() / (compArray[i3].getb() * 8.3144621 * Math.pow(temperature, 2.0)) + compArray[i3].getaDiffDiffT() / (compArray[i3].getb() * 8.3144621 * temperature) - compArray[i3].getaDiffT() / (compArray[i3].getb() * 8.3144621 * Math.pow(temperature, 2.0));
            }
            double sd2 = (2.0 * this.hex - this.cpex * temperature) / Math.pow(temperature, 3.0);
            double cnt2 = 0.0;
            for (i2 = 0; i2 < numbcomp; ++i2) {
                cnt2 += phase.getComponents()[i2].getNumberOfMolesInPhase() / phase.getNumberOfMolesInPhase() * this.qPuredTdT[i2];
            }
            this.alpha_mix = 0.0;
            this.dadt = 0.0;
            for (i2 = 0; i2 < numbcomp; ++i2) {
                term = this.qPure[i2] + this.hwfc * Math.log(((ComponentGEInterface)this.gePhase.getComponents()[i2]).getGamma());
                this.alpha_mix += phase.getComponents()[i2].getNumberOfMolesInPhase() / phase.getNumberOfMolesInPhase() * term;
                this.ader[i2] = term;
                compArray[i2].setAder(this.ader[i2]);
                term = this.qPuredT[i2] + this.hwfc * ((ComponentGEInterface)this.gePhase.getComponents()[i2]).getlnGammadt();
                this.dadt += term * phase.getComponents()[i2].getNumberOfMolesInPhase() / phase.getNumberOfMolesInPhase();
                this.adert[i2] = term;
                compArray[i2].setdAdTdn(this.adert[i2]);
            }
            this.d2adt2 = cnt2 + this.hwfc * sd2;
            for (i2 = 0; i2 < numbcomp; ++i2) {
                for (int j = 0; j < numbcomp; ++j) {
                    this.ad2[i2][j] = this.hwfc * ((ComponentGEInterface)this.gePhase.getComponents()[i2]).getlnGammadn(j);
                    compArray[i2].setdAdndn(j, this.ad2[i2][j]);
                }
            }
            for (i2 = 0; i2 < numbcomp; ++i2) {
                this.oneSubAlf[i2] = 1.0 - this.qPure[i2];
                this.abf[i2] = compArray[i2].getb() * this.oneSubAlf[i2];
                this.abft[i2] = -compArray[i2].getb() * this.qPuredT[i2];
                this.abft2[i2] = -compArray[i2].getb() * this.qPuredTdT[i2];
            }
            double dd2 = 0.0;
            for (i = 0; i < numbcomp; ++i) {
                double ssi = 0.0;
                for (int j = 0; j < numbcomp; ++j) {
                    ssi += (1.0 - EosMixingRules.this.WSintparam[i][j]) * (this.abft2[i] + this.abft2[j]) * phase.getComponents()[j].getNumberOfMolesInPhase() / phase.getNumberOfMolesInPhase();
                }
                dd2 += phase.getComponents()[i].getNumberOfMolesInPhase() / phase.getNumberOfMolesInPhase() * ssi;
            }
            dd2 = 0.5 * dd2;
            for (i = 0; i < numbcomp; ++i) {
                for (int j = i; j < numbcomp; ++j) {
                    double ee = 1.0 - EosMixingRules.this.WSintparam[i][j];
                    this.qf2[i][j] = ee * (this.abf[i] + this.abf[j]);
                    this.qf2[j][i] = this.qf2[i][j];
                    this.qft[i][j] = ee * (this.abft[i] + this.abft[j]);
                    this.qft[j][i] = this.qft[i][j];
                }
            }
            this.Q = 0.0;
            this.QT = 0.0;
            for (i = 0; i < numbcomp; ++i) {
                double ss = 0.0;
                for (int j = 0; j < numbcomp; ++j) {
                    ss += this.qf2[j][i] * phase.getComponents()[j].getNumberOfMolesInPhase() / phase.getNumberOfMolesInPhase();
                }
                this.qf1[i] = ss;
                this.Q += phase.getComponents()[i].getNumberOfMolesInPhase() / phase.getNumberOfMolesInPhase() * ss;
                double sst = 0.0;
                for (int j = 0; j < numbcomp; ++j) {
                    sst += this.qft[j][i] * phase.getComponents()[j].getNumberOfMolesInPhase() / phase.getNumberOfMolesInPhase();
                }
                this.QFTD[i] = sst;
                this.QT += phase.getComponents()[i].getNumberOfMolesInPhase() / phase.getNumberOfMolesInPhase() * sst;
            }
            double d_mix = 0.5 * this.Q;
            double d_mixt = 0.5 * this.QT;
            double enum1 = 1.0 - this.alpha_mix;
            double enumr = 1.0 / enum1;
            this.b_mix = d_mix * enumr;
            this.dbdt = (d_mixt + this.b_mix * this.dadt) * enumr;
            for (int i4 = 0; i4 < numbcomp; ++i4) {
                this.BDER[i4] = (this.qf1[i4] - this.b_mix * (1.0 - this.ader[i4])) * enumr;
                compArray[i4].setBder(this.BDER[i4]);
                double ss = this.QFTD[i4] + this.b_mix * this.adert[i4] + this.BDER[i4] * this.dadt + this.dbdt * (this.ader[i4] - 1.0);
                this.BDERT[i4] = ss * enumr;
                compArray[i4].setdBdndT(this.BDERT[i4]);
            }
            double DD2E = dd2 + this.b_mix * this.d2adt2 + 2.0 * this.dbdt * this.dadt;
            this.d2bdt2 = DD2E / (1.0 - this.alpha_mix);
            for (int i5 = 0; i5 < numbcomp; ++i5) {
                for (int j = 0; j < numbcomp; ++j) {
                    this.bd2[i5][j] = (this.qf2[i5][j] + this.b_mix * this.ad2[i5][j] + this.BDER[j] * this.ader[i5] + this.BDER[i5] * this.ader[j]) * enumr;
                    compArray[i5].setdBdndn(j, this.ad2[i5][j]);
                }
            }
        }

        @Override
        public double calcA(PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            double A = 0.0;
            this.init(phase, temperature, pressure, numbcomp);
            EosMixingRules.this.Atot = A = Math.pow(phase.getNumberOfMolesInPhase(), 1.0) * this.calcB(phase, temperature, pressure, numbcomp) * 8.3144621 * temperature * this.alpha_mix;
            return A;
        }

        @Override
        public double calcAi(int compNumb, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            double A = 0.0;
            ComponentEosInterface[] compArray = (ComponentEosInterface[])phase.getcomponentArray();
            A = this.getB() * 8.3144621 * temperature * compArray[compNumb].getAder() + Math.pow(phase.getNumberOfMolesInPhase(), 1.0) * this.calcBi(compNumb, phase, temperature, pressure, numbcomp) * 8.3144621 * temperature * this.alpha_mix;
            return A;
        }

        @Override
        public double calcAT(PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            double A = 0.0;
            A = Math.pow(phase.getNumberOfMolesInPhase(), 1.0) * this.getB() * 8.3144621 * temperature * this.dadt + Math.pow(phase.getNumberOfMolesInPhase(), 1.0) * this.getB() * 8.3144621 * this.alpha_mix + Math.pow(phase.getNumberOfMolesInPhase(), 1.0) * this.calcBT(phase, temperature, pressure, numbcomp) * 8.3144621 * temperature * this.alpha_mix;
            return A;
        }

        @Override
        public double calcATT(PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            double A = 0.0;
            A = Math.pow(phase.getNumberOfMolesInPhase(), 1.0) * this.getB() * 8.3144621 * temperature * this.d2adt2 + Math.pow(phase.getNumberOfMolesInPhase(), 1.0) * this.getB() * 8.3144621 * this.dadt + Math.pow(phase.getNumberOfMolesInPhase(), 1.0) * this.getB() * 8.3144621 * this.dadt + Math.pow(phase.getNumberOfMolesInPhase(), 1.0) * this.calcBTT(phase, temperature, pressure, numbcomp) * 8.3144621 * temperature * this.alpha_mix + Math.pow(phase.getNumberOfMolesInPhase(), 1.0) * this.calcBT(phase, temperature, pressure, numbcomp) * 8.3144621 * this.alpha_mix + Math.pow(phase.getNumberOfMolesInPhase(), 1.0) * this.calcBT(phase, temperature, pressure, numbcomp) * 8.3144621 * temperature * this.dadt;
            return A;
        }

        @Override
        public double calcAiT(int compNumb, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            ComponentEosInterface[] compArray = (ComponentEosInterface[])phase.getcomponentArray();
            double A = this.getB() * 8.3144621 * compArray[compNumb].getAder() + this.getB() * 8.3144621 * temperature * compArray[compNumb].getdAdTdn() + Math.pow(phase.getNumberOfMolesInPhase(), 1.0) * this.calcBi(compNumb, phase, temperature, pressure, numbcomp) * 8.3144621 * temperature * this.dadt + Math.pow(phase.getNumberOfMolesInPhase(), 1.0) * this.calcBi(compNumb, phase, temperature, pressure, numbcomp) * 8.3144621 * this.alpha_mix + this.calcBT(phase, temperature, pressure, numbcomp) * 8.3144621 * temperature * compArray[compNumb].getAder() + Math.pow(phase.getNumberOfMolesInPhase(), 1.0) * this.calcBiT(compNumb, phase, temperature, pressure, numbcomp) * 8.3144621 * temperature * this.alpha_mix;
            return A;
        }

        @Override
        public double calcAij(int compNumb, int compNumbj, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            double A = 0.0;
            ComponentEosInterface[] compArray = (ComponentEosInterface[])phase.getcomponentArray();
            A = Math.pow(phase.getNumberOfMolesInPhase(), 0.0) * this.calcBi(compNumbj, phase, temperature, pressure, numbcomp) * 8.3144621 * temperature * compArray[compNumb].getAder() + Math.pow(phase.getNumberOfMolesInPhase(), 0.0) * this.calcB(phase, temperature, pressure, numbcomp) * 8.3144621 * temperature * compArray[compNumb].getdAdndn(compNumbj) + Math.pow(phase.getNumberOfMolesInPhase(), 0.0) * this.calcBi(compNumb, phase, temperature, pressure, numbcomp) * 8.3144621 * temperature * compArray[compNumbj].getAder() + Math.pow(phase.getNumberOfMolesInPhase(), 0.0) * this.calcBij(compNumb, compNumbj, phase, temperature, pressure, numbcomp) * 8.3144621 * temperature * this.alpha_mix;
            return A;
        }

        @Override
        public double calcB(PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            double B;
            EosMixingRules.this.Btot = B = this.b_mix * phase.getNumberOfMolesInPhase();
            return B;
        }

        @Override
        public double calcBi(int compNumb, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            ComponentEosInterface[] compArray = (ComponentEosInterface[])phase.getcomponentArray();
            return compArray[compNumb].getBder();
        }

        public double calcBT(PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            return this.dbdt * phase.getNumberOfMolesInPhase();
        }

        public double calcBTT(PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            return this.d2bdt2 * phase.getNumberOfMolesInPhase();
        }

        public double calcBiT(int compNumb, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            ComponentEosInterface[] compArray = (ComponentEosInterface[])phase.getcomponentArray();
            double bit = compArray[compNumb].getdBdndT();
            return bit;
        }

        @Override
        public double calcBij(int compNumb, int compNumbj, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            ComponentEosInterface[] compArray = (ComponentEosInterface[])phase.getcomponentArray();
            return compArray[compNumb].getdBdndn(compNumbj);
        }
    }

    public class SRKHuronVidal2
    extends ClassicSRK
    implements HVmixingRuleInterface {
        private static final long serialVersionUID = 1000L;
        PhaseInterface orgPhase;
        PhaseGE gePhase;
        double Q;
        double QT;
        double DDE2;
        double alpha_mix;
        double dadt;
        double b_mix;
        double dbdt;
        double bdert;
        double d2adt2;
        double d2bdt2;
        double[] ader;
        double[] adert;
        double[] qf1;
        double[] d2qp;
        double[] qPure;
        double[] qPuredT;
        double[] qPuredTdT;
        double[][] ad2;
        double[][] qf2;
        double[][] qft;
        double[][] bd2;
        double hwfc;
        double gex;
        double[] oneSubAlf;
        double[] abf;
        double[] bc;
        double[] abft2;
        double[] abft;
        double[] QFTD;
        double[] BDER;
        double[] BDERT;

        public SRKHuronVidal2(PhaseInterface phase, double[][] HValpha, double[][] HVDij, String[][] mixRule) {
            this.Q = 0.0;
            this.QT = 0.0;
            this.alpha_mix = 0.0;
            this.dadt = 0.0;
            this.b_mix = 0.0;
            this.dbdt = 0.0;
            this.bdert = 0.0;
            this.d2adt2 = 0.0;
            this.d2bdt2 = 0.0;
            this.hwfc = 0.0;
            this.gex = 0.0;
            this.orgPhase = phase;
            this.gePhase = EosMixingRules.this.mixingRuleGEModel.equals("NRTL") ? new PhaseGENRTLmodifiedHV(this.orgPhase, HValpha, HVDij, mixRule, EosMixingRules.this.intparam) : (EosMixingRules.this.mixingRuleGEModel.equals("NRTL_HV") ? new PhaseGENRTLmodifiedHV(this.orgPhase, HValpha, HVDij, mixRule, EosMixingRules.this.intparam) : (EosMixingRules.this.mixingRuleGEModel.equals("UNIQUAQ") ? new PhaseGENRTLmodifiedHV(this.orgPhase, HValpha, HVDij, mixRule, EosMixingRules.this.intparam) : (EosMixingRules.this.mixingRuleGEModel.equals("UNIFAC") ? new PhaseGEUnifac(this.orgPhase, HValpha, HVDij, mixRule, EosMixingRules.this.intparam) : (EosMixingRules.this.mixingRuleGEModel.equals("UNIFAC_PSRK") ? new PhaseGEUnifacPSRK(this.orgPhase, HValpha, HVDij, mixRule, EosMixingRules.this.intparam) : (EosMixingRules.this.mixingRuleGEModel.equals("UNIFAC_UMRPRU") ? new PhaseGEUnifacUMRPRU(this.orgPhase, HValpha, HVDij, mixRule, EosMixingRules.this.intparam) : new PhaseGEUnifac(this.orgPhase, HValpha, HVDij, mixRule, EosMixingRules.this.intparam))))));
            this.gePhase.init(phase.getNumberOfMolesInPhase(), phase.getNumberOfComponents(), 0, phase.getType(), phase.getBeta());
            this.gePhase.setProperties(phase);
        }

        public SRKHuronVidal2(PhaseInterface phase, double[][] HValpha, double[][] HVDij, double[][] HVDijT, String[][] mixRule) {
            this.Q = 0.0;
            this.QT = 0.0;
            this.alpha_mix = 0.0;
            this.dadt = 0.0;
            this.b_mix = 0.0;
            this.dbdt = 0.0;
            this.bdert = 0.0;
            this.d2adt2 = 0.0;
            this.d2bdt2 = 0.0;
            this.hwfc = 0.0;
            this.gex = 0.0;
            this.orgPhase = phase;
            this.gePhase = EosMixingRules.this.mixingRuleGEModel.equals("NRTL") ? new PhaseGENRTLmodifiedHV(this.orgPhase, HValpha, HVDij, HVDijT, mixRule, EosMixingRules.this.intparam) : (EosMixingRules.this.mixingRuleGEModel.equals("NRTL_HV") ? new PhaseGENRTLmodifiedHV(this.orgPhase, HValpha, HVDij, mixRule, EosMixingRules.this.intparam) : (EosMixingRules.this.mixingRuleGEModel.equals("UNIQUAQ") ? new PhaseGENRTLmodifiedHV(this.orgPhase, HValpha, HVDij, HVDijT, mixRule, EosMixingRules.this.intparam) : (EosMixingRules.this.mixingRuleGEModel.equals("UNIFAC") ? new PhaseGEUnifac(this.orgPhase, HValpha, HVDij, mixRule, EosMixingRules.this.intparam) : (EosMixingRules.this.mixingRuleGEModel.equals("UNIFAC_PSRK") ? new PhaseGEUnifacPSRK(this.orgPhase, HValpha, HVDij, mixRule, EosMixingRules.this.intparam) : (EosMixingRules.this.mixingRuleGEModel.equals("UNIFAC_UMRPRU") ? new PhaseGEUnifacUMRPRU(this.orgPhase, HValpha, HVDij, mixRule, EosMixingRules.this.intparam) : new PhaseGEUnifac(this.orgPhase, HValpha, HVDij, mixRule, EosMixingRules.this.intparam))))));
            this.gePhase.setProperties(phase);
        }

        public void init(PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            int i;
            ComponentEosInterface[] compArray = (ComponentEosInterface[])phase.getcomponentArray();
            this.gePhase.setProperties(phase);
            this.gePhase.setParams(phase, EosMixingRules.this.HValpha, EosMixingRules.this.HVDij, EosMixingRules.this.HVDijT, EosMixingRules.this.classicOrHV, EosMixingRules.this.intparam);
            if (EosMixingRules.this.mixingRuleGEModel.equals("NRTL")) {
                this.gePhase.getExcessGibbsEnergy(phase, numbcomp, temperature, pressure, phase.getType());
            } else {
                this.gePhase.init(phase.getNumberOfMolesInPhase() / phase.getBeta(), phase.getNumberOfComponents(), phase.getInitType(), phase.getType(), phase.getBeta());
            }
            this.hwfc = -1.0 / (1.0 / (compArray[0].getDeltaEosParameters()[1] - compArray[0].getDeltaEosParameters()[0]) * Math.log((1.0 + compArray[0].getDeltaEosParameters()[1]) / (1.0 + compArray[0].getDeltaEosParameters()[0])));
            if (EosMixingRules.this.mixingRuleGEModel.equals("UNIFAC_PSRK")) {
                this.hwfc = -1.546479439555851;
            }
            if (EosMixingRules.this.mixingRuleGEModel.equals("UNIFAC_UMRPRU")) {
                this.hwfc = -1.8867924528301885;
            }
            double term = 0.0;
            double dubdert = 0.0;
            if (this.qPure == null) {
                this.qPure = new double[numbcomp];
                this.qPuredT = new double[numbcomp];
                this.qPuredTdT = new double[numbcomp];
                this.ader = new double[numbcomp];
                this.adert = new double[numbcomp];
                this.ad2 = new double[numbcomp][numbcomp];
                this.qf2 = new double[numbcomp][numbcomp];
                this.bd2 = new double[numbcomp][numbcomp];
                this.qft = new double[numbcomp][numbcomp];
                this.qf1 = new double[numbcomp];
                this.oneSubAlf = new double[numbcomp];
                this.abf = new double[numbcomp];
                this.bc = new double[numbcomp];
                this.QFTD = new double[numbcomp];
            }
            for (i = 0; i < numbcomp; ++i) {
                this.qPure[i] = compArray[i].getaT() / (compArray[i].getb() * 8.3144621 * temperature);
                if (phase.getInitType() <= 1) continue;
                this.qPuredT[i] = -compArray[i].getaT() / (compArray[i].getb() * 8.3144621 * temperature * temperature) + compArray[i].diffaT(temperature) / (compArray[i].getb() * 8.3144621 * temperature);
                this.qPuredTdT[i] = 2.0 * compArray[i].getaT() / (compArray[i].getb() * 8.3144621 * Math.pow(temperature, 3.0)) - compArray[i].getaDiffT() / (compArray[i].getb() * 8.3144621 * temperature * temperature) + compArray[i].getaDiffDiffT() / (compArray[i].getb() * 8.3144621 * temperature) - compArray[i].getaDiffT() / (compArray[i].getb() * 8.3144621 * temperature * temperature);
            }
            this.alpha_mix = 0.0;
            this.dadt = 0.0;
            for (i = 0; i < numbcomp; ++i) {
                term = this.qPure[i] + this.hwfc * Math.log(((ComponentGEInterface)this.gePhase.getComponents()[i]).getGamma());
                this.alpha_mix += phase.getComponents()[i].getNumberOfMolesInPhase() / phase.getNumberOfMolesInPhase() * term;
                this.ader[i] = term;
                compArray[i].setAder(this.ader[i]);
                if (phase.getInitType() <= 1) continue;
                term = this.qPuredT[i] + this.hwfc * ((ComponentGEInterface)this.gePhase.getComponents()[i]).getlnGammadt();
                dubdert += (this.qPuredTdT[i] + this.hwfc * ((ComponentGEInterface)this.gePhase.getComponents()[i]).getlnGammadtdt()) * phase.getComponents()[i].getNumberOfMolesInPhase() / phase.getNumberOfMolesInPhase();
                this.dadt += term * phase.getComponents()[i].getNumberOfMolesInPhase() / phase.getNumberOfMolesInPhase();
                this.adert[i] = term;
                compArray[i].setdAdTdn(this.adert[i]);
            }
            this.d2adt2 = dubdert;
            if (phase.getInitType() > 2) {
                for (i = 0; i < numbcomp; ++i) {
                    for (int j = 0; j < numbcomp; ++j) {
                        this.ad2[i][j] = this.hwfc * ((ComponentGEInterface)this.gePhase.getComponents()[i]).getlnGammadn(j);
                        compArray[i].setdAdndn(j, this.ad2[i][j]);
                    }
                }
            }
        }

        @Override
        public PhaseInterface getGEPhase() {
            return this.gePhase;
        }

        @Override
        public void setHVDijParameter(int i, int j, double value) {
            EosMixingRules.this.HVDij[i][j] = value;
            this.gePhase.setDij(EosMixingRules.this.HVDij);
        }

        @Override
        public double getHVDijParameter(int i, int j) {
            return EosMixingRules.this.HVDij[i][j];
        }

        @Override
        public void setHVDijTParameter(int i, int j, double value) {
            EosMixingRules.this.HVDijT[i][j] = value;
            this.gePhase.setDijT(EosMixingRules.this.HVDijT);
        }

        @Override
        public double getHVDijTParameter(int i, int j) {
            return EosMixingRules.this.HVDijT[i][j];
        }

        @Override
        public void setHValphaParameter(int i, int j, double value) {
            EosMixingRules.this.HValpha[i][j] = value;
            EosMixingRules.this.HValpha[j][i] = value;
            this.gePhase.setAlpha(EosMixingRules.this.HValpha);
        }

        @Override
        public double getHValphaParameter(int i, int j) {
            return EosMixingRules.this.HValpha[i][j];
        }

        @Override
        public double getKijWongSandler(int i, int j) {
            return EosMixingRules.this.WSintparam[i][j];
        }

        @Override
        public void setKijWongSandler(int i, int j, double value) {
            EosMixingRules.this.WSintparam[i][j] = value;
            EosMixingRules.this.WSintparam[j][i] = value;
        }

        @Override
        public double calcA(PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            double A = 0.0;
            this.init(phase, temperature, pressure, numbcomp);
            EosMixingRules.this.Atot = A = phase.getNumberOfMolesInPhase() * phase.getB() * 8.3144621 * temperature * this.alpha_mix;
            return A;
        }

        @Override
        public double calcAi(int compNumb, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            double A = 0.0;
            ComponentEosInterface[] compArray = (ComponentEosInterface[])phase.getcomponentArray();
            A = this.getB() * 8.3144621 * temperature * compArray[compNumb].getAder() + phase.getNumberOfMolesInPhase() * compArray[compNumb].getBi() * 8.3144621 * temperature * this.alpha_mix;
            return A;
        }

        @Override
        public double calcAij(int compNumb, int compNumbj, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            double A = 0.0;
            ComponentEosInterface[] compArray = (ComponentEosInterface[])phase.getcomponentArray();
            A = this.calcBi(compNumbj, phase, temperature, pressure, numbcomp) * 8.3144621 * temperature * compArray[compNumb].getAder() + this.getB() * 8.3144621 * temperature * compArray[compNumb].getdAdndn(compNumbj) + this.calcBi(compNumb, phase, temperature, pressure, numbcomp) * 8.3144621 * temperature * compArray[compNumbj].getAder() + this.calcBij(compNumb, compNumbj, phase, temperature, pressure, numbcomp) * phase.getNumberOfMolesInPhase() * 8.3144621 * temperature * this.alpha_mix;
            return A;
        }

        @Override
        public double calcAT(PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            double A = 0.0;
            A = phase.getNumberOfMolesInPhase() * this.getB() * 8.3144621 * temperature * this.dadt + phase.getNumberOfMolesInPhase() * this.getB() * 8.3144621 * this.alpha_mix;
            return A;
        }

        @Override
        public double calcATT(PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            double A = 0.0;
            A = phase.getNumberOfMolesInPhase() * this.getB() * 8.3144621 * temperature * this.d2adt2 + 2.0 * phase.getNumberOfMolesInPhase() * this.getB() * 8.3144621 * this.dadt;
            return A;
        }

        @Override
        public double calcAiT(int compNumb, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            ComponentEosInterface[] compArray = (ComponentEosInterface[])phase.getcomponentArray();
            double A = this.getB() * 8.3144621 * compArray[compNumb].getAder() + this.getB() * 8.3144621 * temperature * compArray[compNumb].getdAdTdn() + phase.getNumberOfMolesInPhase() * this.calcBi(compNumb, phase, temperature, pressure, numbcomp) * 8.3144621 * temperature * this.dadt + phase.getNumberOfMolesInPhase() * this.calcBi(compNumb, phase, temperature, pressure, numbcomp) * 8.3144621 * this.alpha_mix;
            return A;
        }
    }

    public class SRKHuronVidal
    extends ClassicSRK
    implements HVmixingRuleInterface {
        private static final long serialVersionUID = 1000L;
        PhaseInterface orgPhase;
        PhaseGENRTLmodifiedHV gePhase;
        double hwfc;

        public SRKHuronVidal(PhaseInterface phase, double[][] HValpha, double[][] HVDij, String[][] mixRule) {
            this.hwfc = 0.0;
            ComponentEosInterface[] compArray = (ComponentEosInterface[])phase.getcomponentArray();
            this.orgPhase = phase;
            this.hwfc = 1.0 / (compArray[0].getDeltaEosParameters()[1] - compArray[0].getDeltaEosParameters()[0]) * Math.log((1.0 + compArray[0].getDeltaEosParameters()[1]) / (1.0 + compArray[0].getDeltaEosParameters()[0]));
            this.gePhase = new PhaseGENRTLmodifiedHV(this.orgPhase, HValpha, HVDij, mixRule, EosMixingRules.this.intparam);
            this.gePhase.getExcessGibbsEnergy(phase, phase.getNumberOfComponents(), phase.getTemperature(), phase.getPressure(), PhaseType.byValue(1));
            this.gePhase.setProperties(phase);
        }

        public SRKHuronVidal(PhaseInterface phase, double[][] HValpha, double[][] HVDij, double[][] HVDijT, String[][] mixRule) {
            this.hwfc = 0.0;
            ComponentEosInterface[] compArray = (ComponentEosInterface[])phase.getcomponentArray();
            this.orgPhase = phase;
            this.hwfc = 1.0 / (compArray[0].getDeltaEosParameters()[1] - compArray[0].getDeltaEosParameters()[0]) * Math.log((1.0 + compArray[0].getDeltaEosParameters()[1]) / (1.0 + compArray[0].getDeltaEosParameters()[0]));
            this.gePhase = new PhaseGENRTLmodifiedHV(this.orgPhase, HValpha, HVDij, HVDijT, mixRule, EosMixingRules.this.intparam);
            this.gePhase.getExcessGibbsEnergy(phase, phase.getNumberOfComponents(), phase.getTemperature(), phase.getPressure(), PhaseType.byValue(1));
            this.gePhase.setProperties(phase);
        }

        @Override
        public void setHVDijParameter(int i, int j, double value) {
            EosMixingRules.this.HVDij[i][j] = value;
            this.gePhase.setDij(EosMixingRules.this.HVDij);
        }

        @Override
        public double getHVDijParameter(int i, int j) {
            return EosMixingRules.this.HVDij[i][j];
        }

        @Override
        public void setHVDijTParameter(int i, int j, double value) {
            EosMixingRules.this.HVDijT[i][j] = value;
            this.gePhase.setDijT(EosMixingRules.this.HVDijT);
        }

        @Override
        public double getHVDijTParameter(int i, int j) {
            return EosMixingRules.this.HVDijT[i][j];
        }

        @Override
        public void setHValphaParameter(int i, int j, double value) {
            EosMixingRules.this.HValpha[i][j] = value;
            EosMixingRules.this.HValpha[j][i] = value;
            this.gePhase.setAlpha(EosMixingRules.this.HValpha);
        }

        @Override
        public double getHValphaParameter(int i, int j) {
            return EosMixingRules.this.HValpha[i][j];
        }

        @Override
        public double getKijWongSandler(int i, int j) {
            return EosMixingRules.this.WSintparam[i][j];
        }

        @Override
        public void setKijWongSandler(int i, int j, double value) {
            EosMixingRules.this.WSintparam[i][j] = value;
            EosMixingRules.this.WSintparam[j][i] = value;
        }

        @Override
        public double calcA(PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            double A = 0.0;
            double aij = 0.0;
            ComponentEosInterface[] compArray = (ComponentEosInterface[])phase.getcomponentArray();
            this.gePhase.setProperties(phase);
            for (int i = 0; i < numbcomp; ++i) {
                aij = compArray[i].getaT() / compArray[i].getb();
                A += compArray[i].getNumberOfMolesInPhase() * aij;
            }
            EosMixingRules.this.Atot = A = this.calcB(phase, temperature, pressure, numbcomp) * (A - phase.getNumberOfMolesInPhase() * this.gePhase.getExcessGibbsEnergy(phase, phase.getNumberOfComponents(), phase.getTemperature(), phase.getPressure(), PhaseType.byValue(0)) / this.gePhase.getNumberOfMolesInPhase() / this.hwfc);
            return A;
        }

        @Override
        public double calcAi(int compNumb, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            double A = 0.0;
            double aij = 0.0;
            ComponentEosInterface[] compArray = (ComponentEosInterface[])phase.getcomponentArray();
            aij = compArray[compNumb].getaT() / compArray[compNumb].getb();
            A = this.getB() * (aij - 8.3144621 * temperature * Math.log(((ComponentGEInterface)this.gePhase.getComponents()[compNumb]).getGamma()) / this.hwfc);
            return A += this.getA() * this.calcBi(compNumb, phase, temperature, pressure, numbcomp) / this.getB();
        }

        @Override
        public double calcAiT(int compNumb, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            double A = 0.0;
            ComponentEosInterface[] compArray = (ComponentEosInterface[])phase.getcomponentArray();
            A = this.getB() * (compArray[compNumb].getaDiffT() / compArray[compNumb].getb() - 8.3144621 * Math.log(((ComponentGEInterface)this.gePhase.getComponents()[compNumb]).getGamma()) / this.hwfc - 8.3144621 * temperature * ((ComponentGEInterface)this.gePhase.getComponents()[compNumb]).getlnGammadt() / this.hwfc) + compArray[compNumb].getb() * this.calcAT(phase, temperature, pressure, numbcomp) / this.getB();
            return A;
        }

        @Override
        public double calcAT(PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            double A = 0.0;
            ComponentEosInterface[] compArray = (ComponentEosInterface[])phase.getcomponentArray();
            for (int i = 0; i < numbcomp; ++i) {
                A += compArray[i].getNumberOfMolesInPhase() * (compArray[i].getaDiffT() / compArray[i].getb() - 8.3144621 * Math.log(((ComponentGEInterface)this.gePhase.getComponents()[i]).getGamma()) / this.hwfc - 8.3144621 * temperature * ((ComponentGEInterface)this.gePhase.getComponents()[i]).getlnGammadt() / Math.log(2.0));
            }
            return A *= this.getB();
        }

        @Override
        public double calcAij(int compNumb, int compNumbj, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            ComponentEosInterface[] compArray = (ComponentEosInterface[])phase.getcomponentArray();
            double aij = compArray[compNumbj].getb() * (compArray[compNumb].getaT() / compArray[compNumb].getb() - 8.3144621 * temperature * Math.log(((ComponentGEInterface)this.gePhase.getComponents()[compNumb]).getGamma()) / this.hwfc) - this.getB() * 8.3144621 * temperature / this.hwfc * ((ComponentGEInterface)this.gePhase.getComponents()[compNumb]).getlnGammadn(compNumbj) + compArray[compNumb].getb() * (compArray[compNumbj].getaT() / compArray[compNumbj].getb() - 8.3144621 * temperature * Math.log(((ComponentGEInterface)this.gePhase.getComponents()[compNumbj]).getGamma()) / this.hwfc);
            return aij;
        }
    }

    public class ClassicSRKT2
    extends ClassicSRKT {
        private static final long serialVersionUID = 1000L;

        @Override
        public double getkij(double temperature, int i, int j) {
            if (EosMixingRules.this.intparamTType[i][j] == 0) {
                return EosMixingRules.this.intparam[i][j] + EosMixingRules.this.intparamT[i][j] * temperature;
            }
            if (EosMixingRules.this.intparamTType[i][j] == 1) {
                return EosMixingRules.this.intparam[i][j] + EosMixingRules.this.intparamT[i][j] / temperature;
            }
            return EosMixingRules.this.intparam[i][j] + EosMixingRules.this.intparamT[i][j] * temperature;
        }

        @Override
        public double getkijdT(double temperature, int i, int j) {
            if (EosMixingRules.this.intparamTType[i][j] == 0) {
                return EosMixingRules.this.intparamT[i][j];
            }
            if (EosMixingRules.this.intparamTType[i][j] == 1) {
                return -EosMixingRules.this.intparamT[i][j] / (temperature * temperature);
            }
            return EosMixingRules.this.intparamT[i][j];
        }

        @Override
        public double getkijdTdT(double temperature, int i, int j) {
            if (EosMixingRules.this.intparamTType[i][j] == 0) {
                return 0.0;
            }
            if (EosMixingRules.this.intparamTType[i][j] == 1) {
                return 2.0 * EosMixingRules.this.intparamT[i][j] / (temperature * temperature * temperature);
            }
            return 0.0;
        }

        @Override
        public ClassicSRKT clone() {
            ClassicSRKT clonedSystem = null;
            try {
                clonedSystem = super.clone();
            }
            catch (Exception ex) {
                logger.error("Cloning failed.", (Throwable)ex);
            }
            return clonedSystem;
        }
    }

    public class ClassicSRKT2x
    extends ClassicSRKT2 {
        private static final long serialVersionUID = 1000L;

        public double getkij(PhaseInterface phase, double temperature, int i, int j) {
            if (i == j) {
                return 0.0;
            }
            double tot = phase.getComponent(i).getNumberOfMolesInPhase() + phase.getComponent(j).getNumberOfMolesInPhase();
            if (tot < 1.0E-100) {
                return 0.0;
            }
            double intkijMix = (phase.getComponent(i).getNumberOfMolesInPhase() * EosMixingRules.this.intparamij[i][j] + phase.getComponent(j).getNumberOfMolesInPhase() * EosMixingRules.this.intparamji[i][j]) / tot;
            if (EosMixingRules.this.intparamTType[i][j] == 0) {
                return intkijMix + EosMixingRules.this.intparamT[i][j] * temperature;
            }
            if (EosMixingRules.this.intparamTType[i][j] == 1) {
                return intkijMix + EosMixingRules.this.intparamT[i][j] / temperature;
            }
            return intkijMix + EosMixingRules.this.intparamT[i][j] * temperature;
        }

        public double getkijdn(int k, PhaseInterface phase, double temperature, int i, int j) {
            if (i == j || i != k && j != k || Math.abs(EosMixingRules.this.intparamij[i][j] - EosMixingRules.this.intparamji[i][j]) < 1.0E-10) {
                return 0.0;
            }
            double tot = phase.getComponent(i).getNumberOfMolesInPhase() + phase.getComponent(j).getNumberOfMolesInPhase();
            if (tot < 1.0E-100) {
                return 0.0;
            }
            double intkijMix = (phase.getComponent(i).getNumberOfMolesInPhase() * EosMixingRules.this.intparamij[i][j] + phase.getComponent(j).getNumberOfMolesInPhase() * EosMixingRules.this.intparamji[i][j]) / tot;
            double temp = 0.0;
            temp = i == k ? EosMixingRules.this.intparamij[i][j] : EosMixingRules.this.intparamji[i][j];
            intkijMix = (temp - intkijMix) / tot;
            return intkijMix;
        }

        public double getkijdndn(int k, int l, PhaseInterface phase, double temperature, int i, int j) {
            if (i == j) {
                return 0.0;
            }
            double tot = phase.getComponent(i).getNumberOfMolesInPhase() + phase.getComponent(j).getNumberOfMolesInPhase();
            if (tot < 1.0E-100) {
                return 0.0;
            }
            double temp = 0.0;
            if (!(i != k && j != k || i != l && j != l)) {
                if (k == i && l == i) {
                    temp = -2.0 * EosMixingRules.this.intparamij[i][j] / (tot * tot) + 2.0 * phase.getComponent(i).getNumberOfMolesInPhase() / (tot * tot * tot) * EosMixingRules.this.intparamij[i][j] + 2.0 * phase.getComponent(j).getNumberOfMolesInPhase() / (tot * tot * tot) * EosMixingRules.this.intparamji[i][j];
                } else if (k == i && l == j) {
                    temp = -EosMixingRules.this.intparamij[i][j] / (tot * tot) + 2.0 * phase.getComponent(i).getNumberOfMolesInPhase() / (tot * tot * tot) * EosMixingRules.this.intparamij[i][j] - 1.0 / (tot * tot) * EosMixingRules.this.intparamji[i][j] + 2.0 * phase.getComponent(j).getNumberOfMolesInPhase() / (tot * tot * tot) * EosMixingRules.this.intparamji[i][j];
                } else if (k == j && l == i) {
                    temp = -EosMixingRules.this.intparamji[i][j] / (tot * tot) + 2.0 * phase.getComponent(j).getNumberOfMolesInPhase() / (tot * tot * tot) * EosMixingRules.this.intparamji[i][j] - 1.0 / (tot * tot) * EosMixingRules.this.intparamij[i][j] + 2.0 * phase.getComponent(i).getNumberOfMolesInPhase() / (tot * tot * tot) * EosMixingRules.this.intparamij[i][j];
                } else if (k == j && l == j) {
                    temp = -2.0 * EosMixingRules.this.intparamji[i][j] / (tot * tot) + 2.0 * phase.getComponent(j).getNumberOfMolesInPhase() / (tot * tot * tot) * EosMixingRules.this.intparamji[i][j] + 2.0 * phase.getComponent(i).getNumberOfMolesInPhase() / (tot * tot * tot) * EosMixingRules.this.intparamij[i][j];
                }
            } else {
                temp = 0.0;
            }
            return temp;
        }

        @Override
        public double calcA(PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            double aij = 0.0;
            ComponentEosInterface[] compArray = (ComponentEosInterface[])phase.getcomponentArray();
            double[] sqrtai = new double[numbcomp];
            for (int j = 0; j < numbcomp; ++j) {
                if (!(compArray[j].getNumberOfMolesInPhase() > 1.0E-100)) continue;
                sqrtai[j] = Math.sqrt(compArray[j].getaT());
            }
            EosMixingRules.this.A = 0.0;
            for (int i = 0; i < numbcomp; ++i) {
                if (compArray[i].getNumberOfMolesInPhase() < 1.0E-100) continue;
                for (int j = 0; j < numbcomp; ++j) {
                    if (!(compArray[j].getNumberOfMolesInPhase() > 1.0E-100)) continue;
                    aij = sqrtai[i] * sqrtai[j] * (1.0 - this.getkij(phase, temperature, i, j));
                    EosMixingRules.this.A += compArray[i].getNumberOfMolesInPhase() * compArray[j].getNumberOfMolesInPhase() * aij;
                }
            }
            EosMixingRules.this.Atot = EosMixingRules.this.A;
            return EosMixingRules.this.A;
        }

        @Override
        public double calcAi(int compNumb, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            int j;
            double aij = 0.0;
            ComponentEosInterface[] compArray = (ComponentEosInterface[])phase.getcomponentArray();
            double A1 = 0.0;
            double[] sqrtai = new double[numbcomp];
            for (j = 0; j < numbcomp; ++j) {
                if (!(compArray[j].getNumberOfMolesInPhase() > 1.0E-100)) continue;
                sqrtai[j] = Math.sqrt(compArray[j].getaT());
            }
            for (j = 0; j < numbcomp; ++j) {
                if (!(compArray[j].getNumberOfMolesInPhase() > 1.0E-100)) continue;
                aij = sqrtai[compNumb] * sqrtai[j] * (1.0 - this.getkij(phase, temperature, compNumb, j));
                A1 += compArray[j].getNumberOfMolesInPhase() * aij;
            }
            double A2 = 0.0;
            for (int i = 0; i < numbcomp; ++i) {
                if (compArray[i].getNumberOfMolesInPhase() < 1.0E-100) continue;
                for (int j2 = 0; j2 < numbcomp; ++j2) {
                    if (!(compArray[j2].getNumberOfMolesInPhase() > 1.0E-100) || compNumb != j2 && compNumb != i || i == j2) continue;
                    aij = -sqrtai[i] * sqrtai[j2] * this.getkijdn(compNumb, phase, temperature, i, j2);
                    A2 += compArray[i].getNumberOfMolesInPhase() * compArray[j2].getNumberOfMolesInPhase() * aij;
                }
            }
            return 2.0 * A1 + A2;
        }

        @Override
        public double calcAij(int compNumb, int compNumbj, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            int i;
            int j;
            double aij = 0.0;
            ComponentEosInterface[] compArray = (ComponentEosInterface[])phase.getcomponentArray();
            double A1 = 0.0;
            for (j = 0; j < numbcomp; ++j) {
                aij = -Math.sqrt(compArray[compNumb].getaT() * compArray[j].getaT()) * this.getkijdn(compNumbj, phase, temperature, compNumb, j);
                A1 += compArray[j].getNumberOfMolesInPhase() * aij;
            }
            for (j = 0; j < numbcomp; ++j) {
                aij = -Math.sqrt(compArray[compNumb].getaT() * compArray[j].getaT()) * this.getkijdn(compNumbj, phase, temperature, j, compNumb);
                A1 += compArray[j].getNumberOfMolesInPhase() * aij;
            }
            double A2 = 0.0;
            for (int i2 = 0; i2 < numbcomp; ++i2) {
                for (int j2 = 0; j2 < numbcomp; ++j2) {
                    aij = -Math.sqrt(compArray[i2].getaT() * compArray[j2].getaT()) * this.getkijdndn(compNumb, compNumbj, phase, temperature, i2, j2);
                    A2 += compArray[i2].getNumberOfMolesInPhase() * compArray[j2].getNumberOfMolesInPhase() * aij;
                }
            }
            double A4 = 0.0;
            A4 = 2.0 * Math.sqrt(compArray[compNumb].getaT() * compArray[compNumbj].getaT()) * (1.0 - this.getkij(phase, temperature, compNumbj, compNumb));
            for (i = 0; i < numbcomp; ++i) {
                A4 += -compArray[i].getNumberOfMolesInPhase() * Math.sqrt(compArray[compNumbj].getaT() * compArray[i].getaT()) * this.getkijdn(compNumb, phase, temperature, compNumbj, i);
            }
            for (i = 0; i < numbcomp; ++i) {
                A4 += -compArray[i].getNumberOfMolesInPhase() * Math.sqrt(compArray[compNumbj].getaT() * compArray[i].getaT()) * this.getkijdn(compNumb, phase, temperature, i, compNumbj);
            }
            return A1 + A2 + A4;
        }

        @Override
        public double calcAiT(int compNumb, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            int j;
            double A = 0.0;
            double aij = 0.0;
            double aij2 = 0.0;
            double aij3 = 0.0;
            ComponentEosInterface[] compArray = (ComponentEosInterface[])phase.getcomponentArray();
            double[] asqrt = new double[numbcomp];
            for (j = 0; j < numbcomp; ++j) {
                asqrt[j] = Math.sqrt(compArray[j].getaT());
            }
            for (j = 0; j < numbcomp; ++j) {
                if (compArray[j].getNumberOfMolesInPhase() < 1.0E-100) continue;
                aij = 0.5 / asqrt[compNumb] / asqrt[j] * (compArray[compNumb].getaT() * compArray[j].getaDiffT() + compArray[j].getaT() * compArray[compNumb].getaDiffT()) * (1.0 - this.getkij(phase, temperature, compNumb, j));
                aij2 = asqrt[compNumb] * asqrt[j] * -this.getkijdT(temperature, compNumb, j);
                A += compArray[j].getNumberOfMolesInPhase() * (aij + aij2);
            }
            double A2 = 0.0;
            for (int i = 0; i < numbcomp; ++i) {
                if (compArray[i].getNumberOfMolesInPhase() < 1.0E-100) continue;
                for (int j2 = 0; j2 < numbcomp; ++j2) {
                    if (!(compArray[j2].getNumberOfMolesInPhase() > 1.0E-100) || compNumb != j2 && compNumb != i || i == j2) continue;
                    aij3 = -0.5 / asqrt[compNumb] / asqrt[j2] * (compArray[compNumb].getaT() * compArray[j2].getaDiffT() + compArray[j2].getaT() * compArray[compNumb].getaDiffT()) * this.getkijdn(compNumb, phase, temperature, i, j2);
                    A2 += compArray[i].getNumberOfMolesInPhase() * compArray[j2].getNumberOfMolesInPhase() * aij3;
                }
            }
            return 2.0 * A + A2;
        }
    }

    public class ClassicSRKT
    extends ClassicSRK {
        private static final long serialVersionUID = 1000L;

        @Override
        public double getkij(double temperature, int i, int j) {
            return EosMixingRules.this.intparam[i][j] + EosMixingRules.this.intparamT[i][j] * (temperature / 273.15 - 1.0);
        }

        public double getkijdT(double temperature, int i, int j) {
            return EosMixingRules.this.intparamT[i][j] * 0.0036609921288669233;
        }

        public double getkijdTdT(double temperature, int i, int j) {
            return 0.0;
        }

        @Override
        public double calcAiT(int compNumb, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            double A = 0.0;
            double aij = 0.0;
            double aij2 = 0.0;
            ComponentEosInterface[] compArray = (ComponentEosInterface[])phase.getcomponentArray();
            for (int j = 0; j < numbcomp; ++j) {
                aij = 0.5 / Math.sqrt(compArray[compNumb].getaT() * compArray[j].getaT()) * (compArray[compNumb].getaT() * compArray[j].getaDiffT() + compArray[j].getaT() * compArray[compNumb].getaDiffT()) * (1.0 - this.getkij(temperature, compNumb, j));
                aij2 = Math.sqrt(compArray[compNumb].getaT() * compArray[j].getaT()) * -this.getkijdT(temperature, compNumb, j);
                A += compArray[j].getNumberOfMolesInPhase() * (aij + aij2);
            }
            return 2.0 * A;
        }

        public double calcAiTT(int compNumb, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            double A = 0.0;
            double aij = 0.0;
            double aij2 = 0.0;
            ComponentEosInterface[] compArray = (ComponentEosInterface[])phase.getcomponentArray();
            for (int j = 0; j < numbcomp; ++j) {
                aij = 0.5 / Math.sqrt(compArray[compNumb].getaT() * compArray[j].getaT()) * (compArray[compNumb].getaT() * compArray[j].getaDiffT() + compArray[j].getaT() * compArray[compNumb].getaDiffT()) * (1.0 - this.getkij(temperature, compNumb, j));
                aij2 = Math.sqrt(compArray[compNumb].getaT() * compArray[j].getaT()) * -this.getkijdT(temperature, compNumb, j);
                A += compArray[j].getNumberOfMolesInPhase() * (aij + aij2);
            }
            return 2.0 * A;
        }

        @Override
        public double calcATT(PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            double aij = 0.0;
            double aij2 = 0.0;
            double aij3 = 0.0;
            double aij4 = 0.0;
            ComponentEosInterface[] compArray = (ComponentEosInterface[])phase.getcomponentArray();
            EosMixingRules.this.A = 0.0;
            for (int i = 0; i < numbcomp; ++i) {
                for (int j = 0; j < numbcomp; ++j) {
                    aij = 0.5 * ((2.0 * compArray[i].getaDiffT() * compArray[j].getaDiffT() + compArray[i].getaT() * compArray[j].getaDiffDiffT() + compArray[j].getaT() * compArray[i].getaDiffDiffT()) / Math.sqrt(compArray[i].getaT() * compArray[j].getaT()) - Math.pow(compArray[i].getaT() * compArray[j].getaDiffT() + compArray[j].getaT() * compArray[i].getaDiffT(), 2.0) / (2.0 * Math.sqrt(compArray[i].getaT() * compArray[j].getaT()) * compArray[i].getaT() * compArray[j].getaT())) * (1.0 - this.getkij(temperature, i, j));
                    aij2 = 0.5 / Math.sqrt(compArray[i].getaT() * compArray[j].getaT()) * (compArray[i].getaT() * compArray[j].getaDiffT() + compArray[j].getaT() * compArray[i].getaDiffT()) * -this.getkijdT(temperature, i, j);
                    aij3 = 0.5 / Math.sqrt(compArray[i].getaT() * compArray[j].getaT()) * (compArray[i].getaT() * compArray[j].getaDiffT() + compArray[j].getaT() * compArray[i].getaDiffT()) * -this.getkijdT(temperature, i, j);
                    aij4 = Math.sqrt(compArray[i].getaT() * compArray[j].getaT()) * -this.getkijdTdT(temperature, i, j);
                    EosMixingRules.this.A += compArray[i].getNumberOfMolesInPhase() * compArray[j].getNumberOfMolesInPhase() * (aij + aij2 + aij3 + aij4);
                }
            }
            return EosMixingRules.this.A;
        }

        @Override
        public ClassicSRKT clone() {
            ClassicSRKT clonedSystem = null;
            try {
                clonedSystem = (ClassicSRKT)super.clone();
            }
            catch (Exception ex) {
                logger.error("Cloning failed.", (Throwable)ex);
            }
            return clonedSystem;
        }
    }

    public class ClassicSRK
    extends ClassicVdW {
        private static final long serialVersionUID = 1000L;

        public double getkij(double temp, int i, int j) {
            return EosMixingRules.this.intparam[i][j];
        }

        @Override
        public double calcA(PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            double aij = 0.0;
            ComponentEosInterface[] compArray = (ComponentEosInterface[])phase.getcomponentArray();
            EosMixingRules.this.A = 0.0;
            for (int i = 0; i < numbcomp; ++i) {
                for (int j = 0; j < numbcomp; ++j) {
                    aij = Math.sqrt(compArray[i].getaT() * compArray[j].getaT()) * (1.0 - this.getkij(temperature, i, j));
                    EosMixingRules.this.A += compArray[i].getNumberOfMolesInPhase() * compArray[j].getNumberOfMolesInPhase() * aij;
                }
            }
            EosMixingRules.this.Atot = EosMixingRules.this.A;
            return EosMixingRules.this.A;
        }

        @Override
        public double calcAi(int compNumb, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            double aij = 0.0;
            ComponentEosInterface[] compArray = (ComponentEosInterface[])phase.getcomponentArray();
            EosMixingRules.this.A = 0.0;
            for (int j = 0; j < numbcomp; ++j) {
                aij = Math.sqrt(compArray[compNumb].getaT() * compArray[j].getaT()) * (1.0 - this.getkij(temperature, compNumb, j));
                EosMixingRules.this.A += compArray[j].getNumberOfMolesInPhase() * aij;
            }
            return 2.0 * EosMixingRules.this.A;
        }

        @Override
        public double calcAiT(int compNumb, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            double A = 0.0;
            double aij = 0.0;
            ComponentEosInterface[] compArray = (ComponentEosInterface[])phase.getcomponentArray();
            for (int j = 0; j < numbcomp; ++j) {
                aij = 0.5 / Math.sqrt(compArray[compNumb].getaT() * compArray[j].getaT()) * (compArray[compNumb].getaT() * compArray[j].getaDiffT() + compArray[j].getaT() * compArray[compNumb].getaDiffT()) * (1.0 - this.getkij(temperature, compNumb, j));
                A += compArray[j].getNumberOfMolesInPhase() * aij;
            }
            return 2.0 * A;
        }

        @Override
        public double calcAij(int compNumb, int compNumbj, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            double aij = 0.0;
            ComponentEosInterface[] compArray = (ComponentEosInterface[])phase.getcomponentArray();
            aij = Math.sqrt(compArray[compNumb].getaT() * compArray[compNumbj].getaT()) * (1.0 - this.getkij(temperature, compNumb, compNumbj));
            return 2.0 * aij;
        }

        @Override
        public double calcAT(PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            double A = 0.0;
            ComponentEosInterface[] compArray = (ComponentEosInterface[])phase.getcomponentArray();
            for (int i = 0; i < numbcomp; ++i) {
                A += compArray[i].getNumberOfMolesInPhase() * ((ComponentEosInterface)phase.getComponent(i)).getAiT();
            }
            return 0.5 * A;
        }

        @Override
        public double calcATT(PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            int i;
            double aij = 0.0;
            double[] sqrtai = new double[numbcomp];
            ComponentEosInterface[] compArray = (ComponentEosInterface[])phase.getcomponentArray();
            for (i = 0; i < numbcomp; ++i) {
                sqrtai[i] = Math.sqrt(compArray[i].getaT());
            }
            EosMixingRules.this.A = 0.0;
            for (i = 0; i < numbcomp; ++i) {
                if (compArray[i].getNumberOfmoles() < 1.0E-100) continue;
                for (int j = 0; j < numbcomp; ++j) {
                    if (compArray[j].getNumberOfmoles() < 1.0E-100) continue;
                    double temp1 = compArray[i].getaT() * compArray[j].getaDiffT() + compArray[j].getaT() * compArray[i].getaDiffT();
                    aij = 0.5 * ((2.0 * compArray[i].getaDiffT() * compArray[j].getaDiffT() + compArray[i].getaT() * compArray[j].getaDiffDiffT() + compArray[j].getaT() * compArray[i].getaDiffDiffT()) / sqrtai[i] / sqrtai[j] - temp1 * temp1 / (2.0 * sqrtai[i] * sqrtai[j] * compArray[i].getaT() * compArray[j].getaT())) * (1.0 - this.getkij(temperature, i, j));
                    EosMixingRules.this.A += compArray[i].getNumberOfMolesInPhase() * compArray[j].getNumberOfMolesInPhase() * aij;
                }
            }
            return EosMixingRules.this.A;
        }

        @Override
        public ClassicSRK clone() {
            ClassicSRK clonedSystem = null;
            try {
                clonedSystem = (ClassicSRK)super.clone();
            }
            catch (Exception ex) {
                logger.error("Cloning failed.", (Throwable)ex);
            }
            return clonedSystem;
        }
    }

    public class ClassicVdW
    implements EosMixingRulesInterface,
    Serializable {
        private static final long serialVersionUID = 1000L;

        @Override
        public String getMixingRuleName() {
            return EosMixingRules.this.mixingRuleName;
        }

        @Override
        public PhaseInterface getGEPhase() {
            return null;
        }

        @Override
        public void setMixingRuleGEModel(String GEmodel) {
            EosMixingRules.this.mixingRuleGEModel = GEmodel;
        }

        @Override
        public double getBinaryInteractionParameter(int i, int j) {
            if (i == j) {
                return 0.0;
            }
            return EosMixingRules.this.intparam[i][j];
        }

        @Override
        public double[][] getBinaryInteractionParameters() {
            return EosMixingRules.this.intparam;
        }

        public void prettyPrintKij() {
        }

        @Override
        public double getBinaryInteractionParameterT1(int i, int j) {
            if (i == j) {
                return 0.0;
            }
            return EosMixingRules.this.intparamT[i][j];
        }

        @Override
        public int getBmixType() {
            return EosMixingRules.this.bmixType;
        }

        @Override
        public void setBmixType(int bmixType2) {
            EosMixingRules.this.bmixType = bmixType2;
        }

        public double getbij(ComponentEosInterface compi, ComponentEosInterface compj) {
            switch (this.getBmixType()) {
                case 0: {
                    return (compi.getb() + compj.getb()) * 0.5;
                }
                case 1: {
                    double temp = (Math.sqrt(compi.getb()) + Math.sqrt(compj.getb())) * 0.5;
                    return temp * temp;
                }
            }
            return (compi.getb() + compj.getb()) * 0.5;
        }

        @Override
        public void setBinaryInteractionParameter(int i, int j, double value) {
            EosMixingRules.this.intparam[i][j] = value;
            EosMixingRules.this.intparam[j][i] = value;
        }

        @Override
        public void setBinaryInteractionParameterij(int i, int j, double value) {
            EosMixingRules.this.intparamij[i][j] = value;
            EosMixingRules.this.intparamji[j][i] = value;
        }

        @Override
        public void setBinaryInteractionParameterji(int i, int j, double value) {
            EosMixingRules.this.intparamji[i][j] = value;
            EosMixingRules.this.intparamij[j][i] = value;
        }

        @Override
        public void setBinaryInteractionParameterT1(int i, int j, double value) {
            EosMixingRules.this.intparamT[i][j] = value;
            EosMixingRules.this.intparamT[j][i] = value;
        }

        @Override
        public void setCalcEOSInteractionParameters(boolean CalcEOSInteractionParameters2) {
            calcEOSInteractionParameters = CalcEOSInteractionParameters2;
        }

        @Override
        public void setnEOSkij(double n) {
            EosMixingRules.this.nEOSkij = n;
        }

        public double getA() {
            return EosMixingRules.this.Atot;
        }

        public double getB() {
            return EosMixingRules.this.Btot;
        }

        @Override
        public double calcA(PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            double aij = 0.0;
            double A = 0.0;
            ComponentEosInterface[] compArray = (ComponentEosInterface[])phase.getcomponentArray();
            for (int i = 0; i < numbcomp; ++i) {
                for (int j = 0; j < numbcomp; ++j) {
                    aij = Math.sqrt(compArray[i].getaT() * compArray[j].getaT());
                    A += compArray[i].getNumberOfMolesInPhase() * compArray[j].getNumberOfMolesInPhase() * aij;
                }
            }
            EosMixingRules.this.Atot = A;
            return A;
        }

        @Override
        public double calcB(PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            EosMixingRules.this.B = 0.0;
            ComponentEosInterface[] compArray = (ComponentEosInterface[])phase.getcomponentArray();
            for (int i = 0; i < numbcomp; ++i) {
                for (int j = 0; j < numbcomp; ++j) {
                    EosMixingRules.this.B += compArray[i].getNumberOfMolesInPhase() * compArray[j].getNumberOfMolesInPhase() * this.getbij(compArray[i], compArray[j]);
                }
            }
            EosMixingRules.this.B /= phase.getNumberOfMolesInPhase();
            EosMixingRules.this.Btot = EosMixingRules.this.B;
            return EosMixingRules.this.B;
        }

        @Override
        public double calcAi(int compNumb, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            double aij = 0.0;
            ComponentEosInterface[] compArray = (ComponentEosInterface[])phase.getcomponentArray();
            EosMixingRules.this.Ai = 0.0;
            for (int j = 0; j < numbcomp; ++j) {
                aij = Math.sqrt(compArray[compNumb].getaT() * compArray[j].getaT());
                EosMixingRules.this.Ai += compArray[j].getNumberOfMolesInPhase() * aij;
            }
            return 2.0 * EosMixingRules.this.Ai;
        }

        @Override
        public double calcBi(int compNumb, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            double Bi = 0.0;
            ComponentEosInterface[] compArray = (ComponentEosInterface[])phase.getcomponentArray();
            for (int j = 0; j < numbcomp; ++j) {
                Bi += compArray[j].getNumberOfMolesInPhase() * this.getbij(compArray[compNumb], compArray[j]);
            }
            Bi = (2.0 * Bi - this.getB()) / phase.getNumberOfMolesInPhase();
            return Bi;
        }

        public double calcBi2(int compNumb, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            double Bi = 0.0;
            ComponentEosInterface[] compArray = (ComponentEosInterface[])phase.getcomponentArray();
            double sumk = 0.0;
            for (int j = 0; j < numbcomp; ++j) {
                Bi += compArray[j].getNumberOfMolesInPhase() * this.getbij(compArray[compNumb], compArray[j]);
                for (int k = 0; k < numbcomp; ++k) {
                    sumk += compArray[j].getNumberOfMolesInPhase() * compArray[k].getNumberOfMolesInPhase() * this.getbij(compArray[j], compArray[k]);
                }
            }
            double ans1 = phase.getNumberOfMolesInPhase() * Bi - sumk;
            return ans1 / (phase.getNumberOfMolesInPhase() * phase.getNumberOfMolesInPhase());
        }

        @Override
        public double calcBij(int compNumb, int compNumbj, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            double bij = 0.0;
            ComponentEosInterface[] compArray = (ComponentEosInterface[])phase.getcomponentArray();
            bij = this.getbij(compArray[compNumb], compArray[compNumbj]);
            return (2.0 * bij - compArray[compNumb].getBi() - compArray[compNumbj].getBi()) / phase.getNumberOfMolesInPhase();
        }

        @Override
        public double calcAiT(int compNumb, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            double A = 0.0;
            double aij = 0.0;
            ComponentEosInterface[] compArray = (ComponentEosInterface[])phase.getcomponentArray();
            for (int j = 0; j < numbcomp; ++j) {
                aij = 0.5 / Math.sqrt(compArray[compNumb].getaT() * compArray[j].getaT()) * (compArray[compNumb].getaT() * compArray[j].getaDiffT() + compArray[j].getaT() * compArray[compNumb].getaDiffT());
                A += compArray[j].getNumberOfMolesInPhase() * aij;
            }
            return 2.0 * A;
        }

        @Override
        public double calcAij(int compNumb, int compNumbj, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            double aij = 0.0;
            ComponentEosInterface[] compArray = (ComponentEosInterface[])phase.getcomponentArray();
            aij = Math.sqrt(compArray[compNumb].getaT() * compArray[compNumbj].getaT());
            return 2.0 * aij;
        }

        @Override
        public double calcAT(PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            double A = 0.0;
            ComponentEosInterface[] compArray = (ComponentEosInterface[])phase.getcomponentArray();
            for (int i = 0; i < numbcomp; ++i) {
                A += compArray[i].getNumberOfMolesInPhase() * phase.calcAiT(i, phase, temperature, pressure, numbcomp);
            }
            return 0.5 * A;
        }

        @Override
        public double calcATT(PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            double aij = 0.0;
            double sqrtaij = 0.0;
            double tempPow = 0.0;
            ComponentEosInterface[] compArray = (ComponentEosInterface[])phase.getcomponentArray();
            EosMixingRules.this.A = 0.0;
            for (int i = 0; i < numbcomp; ++i) {
                for (int j = 0; j < numbcomp; ++j) {
                    sqrtaij = Math.sqrt(compArray[i].getaT() * compArray[j].getaT());
                    tempPow = compArray[i].getaT() * compArray[j].getaDiffT() + compArray[j].getaT() * compArray[i].getaDiffT();
                    aij = 0.5 * ((2.0 * compArray[i].getaDiffT() * compArray[j].getaDiffT() + compArray[i].getaT() * compArray[j].getaDiffDiffT() + compArray[j].getaT() * compArray[i].getaDiffDiffT()) / sqrtaij - tempPow * tempPow / (2.0 * sqrtaij * compArray[i].getaT() * compArray[j].getaT()));
                    EosMixingRules.this.A += compArray[i].getNumberOfMolesInPhase() * compArray[j].getNumberOfMolesInPhase() * aij;
                }
            }
            return EosMixingRules.this.A;
        }

        public ClassicVdW clone() {
            ClassicVdW clonedSystem = null;
            try {
                clonedSystem = (ClassicVdW)super.clone();
            }
            catch (Exception ex) {
                logger.error("Cloning failed.", (Throwable)ex);
            }
            return clonedSystem;
        }
    }
}

