/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.phase;

import java.util.ArrayList;
import neqsim.physicalproperties.PhysicalPropertyHandler;
import neqsim.physicalproperties.PhysicalPropertyType;
import neqsim.physicalproperties.system.PhysicalProperties;
import neqsim.physicalproperties.system.PhysicalPropertyModel;
import neqsim.thermo.component.ComponentInterface;
import neqsim.thermo.phase.PhaseInterface;
import neqsim.thermo.phase.PhaseType;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.util.empiric.Water;
import neqsim.thermo.util.gerg.NeqSimAGA8Detail;
import neqsim.thermo.util.gerg.NeqSimGERG2008;
import neqsim.util.exception.InvalidInputException;
import neqsim.util.unit.PressureUnit;
import neqsim.util.unit.TemperatureUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Phase
implements PhaseInterface {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(Phase.class);
    public int numberOfComponents = 0;
    public ComponentInterface[] componentArray;
    public boolean mixingRuleDefined = false;
    public boolean calcMolarVolume = true;
    private boolean constantPhaseVolume = false;
    private PhysicalPropertyModel ppm = PhysicalPropertyModel.DEFAULT;
    public PhysicalPropertyHandler physicalPropertyHandler = null;
    protected boolean useVolumeCorrection = true;
    protected double molarVolume = 1.0;
    protected double phaseVolume = 1.0;
    public boolean chemSyst = false;
    protected double diElectricConstant = 0.0;
    double Z = 1.0;
    public String thermoPropertyModelName = null;
    double beta = 1.0;
    public double numberOfMolesInPhase = 0.0;
    private int initType = 0;
    int mixingRuleNumber = 0;
    double temperature = 0.0;
    double pressure = 0.0;
    protected PhaseInterface[] refPhase = null;
    protected PhaseType pt = PhaseType.GAS;

    public Phase() {
        this.componentArray = new ComponentInterface[100];
    }

    @Override
    public Phase clone() {
        Phase clonedPhase = null;
        try {
            clonedPhase = (Phase)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        clonedPhase.componentArray = (ComponentInterface[])this.componentArray.clone();
        for (int i = 0; i < this.numberOfComponents; ++i) {
            clonedPhase.componentArray[i] = this.componentArray[i].clone();
        }
        if (this.physicalPropertyHandler != null) {
            clonedPhase.physicalPropertyHandler = this.physicalPropertyHandler.clone();
        }
        return clonedPhase;
    }

    public void addComponent(String name, double moles, int compNumber) {
        if (name == null) {
            throw new RuntimeException(new InvalidInputException(this, "addcomponent", "name", "can not be null"));
        }
        if (name.equals("")) {
            throw new RuntimeException(new InvalidInputException(this, "addcomponent", "name", "can not be empty."));
        }
        if (this.hasComponent(name)) {
            throw new RuntimeException(new InvalidInputException(this, "addComponent", "name", "component with same name already exists in phase. Use addMoles or addMolesChemreac."));
        }
        if (moles < 0.0) {
            throw new RuntimeException(new InvalidInputException(this, "addComponent", "moles", "can not be negative"));
        }
        if (compNumber < 0 || compNumber >= 100) {
            throw new RuntimeException(new InvalidInputException(this, "addComponent", "compNumber", " must be valid index, i.e., between 0 and 100."));
        }
        if (this.componentArray[compNumber] != null) {
            throw new RuntimeException(new InvalidInputException(this, "addComponent", "compNumber", "number is already in use."));
        }
        this.numberOfMolesInPhase += moles;
        ++this.numberOfComponents;
    }

    @Override
    public void removeComponent(String name, double moles, double molesInPhase) {
        name = ComponentInterface.getComponentNameFromAlias(name);
        ArrayList<ComponentInterface> temp = new ArrayList<ComponentInterface>();
        try {
            int i;
            for (i = 0; i < this.numberOfComponents; ++i) {
                if (this.componentArray[i].getName().equals(name)) continue;
                temp.add(this.componentArray[i]);
            }
            for (i = 0; i < temp.size(); ++i) {
                this.componentArray[i] = (ComponentInterface)temp.get(i);
                this.getComponent(i).setComponentNumber(i);
            }
        }
        catch (Exception ex) {
            logger.error("not able to remove " + name, (Throwable)ex);
        }
        this.componentArray[this.numberOfComponents - 1] = null;
        this.numberOfMolesInPhase -= molesInPhase;
        --this.numberOfComponents;
    }

    @Override
    public void setEmptyFluid() {
        this.numberOfMolesInPhase = 0.0;
        for (int i = 0; i < this.getNumberOfComponents(); ++i) {
            this.getComponent(i).setNumberOfMolesInPhase(0.0);
            this.getComponent(i).setNumberOfmoles(0.0);
        }
    }

    @Override
    public void addMoles(int component, double dn) {
        this.numberOfMolesInPhase += dn;
        this.componentArray[component].addMoles(dn);
    }

    @Override
    public void addMolesChemReac(int component, double dn, double totdn) {
        if ((this.numberOfMolesInPhase + dn) / this.numberOfMolesInPhase < -1.0E-10) {
            String msg = "will lead to negative number of moles in phase." + (this.numberOfMolesInPhase + dn);
            InvalidInputException ex = new InvalidInputException(this, "addMolesChemReac", "dn", msg);
            throw new RuntimeException(ex);
        }
        this.numberOfMolesInPhase += dn;
        this.componentArray[component].addMolesChemReac(dn, totdn);
    }

    @Override
    public void setProperties(PhaseInterface phase) {
        this.setType(phase.getType());
        for (int i = 0; i < phase.getNumberOfComponents(); ++i) {
            this.getComponent(i).setProperties(phase.getComponent(i));
        }
        this.numberOfMolesInPhase = phase.getNumberOfMolesInPhase();
        this.numberOfComponents = phase.getNumberOfComponents();
        this.setBeta(phase.getBeta());
        this.setTemperature(phase.getTemperature());
        this.setPressure(phase.getPressure());
    }

    @Override
    public ComponentInterface[] getcomponentArray() {
        return this.componentArray;
    }

    @Override
    public double getAntoineVaporPressure(double temp) {
        double pres = 0.0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            pres += this.componentArray[i].getx() * this.componentArray[i].getAntoineVaporPressure(temp);
        }
        return pres;
    }

    @Override
    public double getWtFrac(String componentName) {
        return this.getWtFrac(this.getComponent(componentName).getComponentNumber());
    }

    @Override
    public double getWtFrac(int component) {
        return this.getComponent(component).getMolarMass() * this.getComponent(component).getx() / this.getMolarMass();
    }

    @Override
    public double getPseudoCriticalTemperature() {
        double temp = 0.0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            temp += this.componentArray[i].getx() * this.componentArray[i].getTC();
        }
        return temp;
    }

    @Override
    public double getPseudoCriticalPressure() {
        double pres = 0.0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            pres += this.componentArray[i].getx() * this.componentArray[i].getPC();
        }
        return pres;
    }

    @Override
    public void normalize() {
        int i;
        double sumx = 0.0;
        for (i = 0; i < this.numberOfComponents; ++i) {
            sumx += this.componentArray[i].getx();
        }
        for (i = 0; i < this.numberOfComponents; ++i) {
            this.componentArray[i].setx(this.componentArray[i].getx() / sumx);
        }
    }

    @Override
    public void setMoleFractions(double[] x) {
        for (int i = 0; i < this.numberOfComponents; ++i) {
            this.componentArray[i].setx(x[i]);
        }
        this.normalize();
    }

    @Override
    public double getTemperature() {
        return this.temperature;
    }

    @Override
    public double getTemperature(String unit) {
        TemperatureUnit tempConversion = new TemperatureUnit(this.getTemperature(), "K");
        return tempConversion.getValue(unit);
    }

    @Override
    public double getPressure() {
        return this.pressure;
    }

    @Override
    public final double getPressure(String unit) {
        PressureUnit presConversion = new PressureUnit(this.getPressure(), "bara");
        return presConversion.getValue(unit);
    }

    @Override
    public int getInitType() {
        return this.initType;
    }

    @Override
    public double[] getMolarComposition() {
        double[] comp = new double[this.getNumberOfComponents()];
        for (int compNumb = 0; compNumb < this.numberOfComponents; ++compNumb) {
            comp[compNumb] = this.getComponent(compNumb).getx();
        }
        return comp;
    }

    @Override
    public double[] getComposition(String unit) {
        double[] comp = new double[this.getNumberOfComponents()];
        for (int compNumb = 0; compNumb < this.numberOfComponents; ++compNumb) {
            if (unit.equals("molefraction")) {
                comp[compNumb] = this.getComponent(compNumb).getx();
            }
            if (unit.equals("wtfraction")) {
                comp[compNumb] = this.getWtFrac(compNumb);
            }
            if (unit.equals("molespersec")) {
                comp[compNumb] = this.getWtFrac(compNumb);
            }
            if (!unit.equals("volumefraction")) continue;
            comp[compNumb] = this.getComponent(compNumb).getVoli() / this.getVolume();
        }
        return comp;
    }

    @Override
    public double getMixGibbsEnergy() {
        double gmix = 0.0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            gmix += this.getComponent(i).getx() * Math.log(this.getComponent(i).getx());
        }
        return 8.3144621 * this.temperature * this.numberOfMolesInPhase * this.getExcessGibbsEnergy() * gmix;
    }

    @Override
    public double getExcessGibbsEnergy() {
        double GE = 0.0;
        if (this.refPhase == null) {
            this.initRefPhases(false);
        }
        for (int i = 0; i < this.numberOfComponents; ++i) {
            GE += this.getComponent(i).getx() * Math.log(this.getActivityCoefficient(i));
        }
        return 8.3144621 * this.temperature * this.numberOfMolesInPhase * GE;
    }

    @Override
    public double getExcessGibbsEnergySymetric() {
        double GE = 0.0;
        if (this.refPhase == null) {
            this.initRefPhases(true);
        }
        for (int i = 0; i < this.numberOfComponents; ++i) {
            GE += this.getComponent(i).getx() * Math.log(this.getActivityCoefficientSymetric(i));
        }
        return 8.3144621 * this.temperature * this.numberOfMolesInPhase * GE;
    }

    @Override
    public double getZ() {
        return this.Z;
    }

    @Override
    public double getZvolcorr() {
        return this.getPressure("Pa") * this.getMolarMass() / 8.3144621 / this.temperature / this.getDensity("kg/m3");
    }

    @Override
    public void setPressure(double pres) {
        this.pressure = pres;
    }

    @Override
    public void setTemperature(double temp) {
        this.temperature = temp;
    }

    @Override
    public PhysicalProperties getPhysicalProperties() {
        if (this.physicalPropertyHandler == null) {
            this.initPhysicalProperties();
        }
        return this.physicalPropertyHandler.getPhysicalProperties(this);
    }

    @Override
    public void init(double totalNumberOfMoles, int numberOfComponents, int initType, PhaseType pt, double beta) {
        if (totalNumberOfMoles <= 0.0) {
            throw new RuntimeException(new InvalidInputException(this, "init", "totalNumberOfMoles", "must be larger than or equal to zero."));
        }
        this.beta = beta;
        this.numberOfMolesInPhase = beta * totalNumberOfMoles;
        if (this.pt != pt) {
            this.setType(pt);
        }
        this.setInitType(initType);
        this.numberOfComponents = numberOfComponents;
        for (int i = 0; i < numberOfComponents; ++i) {
            this.componentArray[i].init(this.temperature, this.pressure, totalNumberOfMoles, beta, initType);
        }
    }

    @Override
    public void setPpm(PhysicalPropertyModel ppm) {
        this.ppm = ppm;
    }

    @Override
    public PhysicalPropertyModel getPhysicalPropertyModel() {
        return this.ppm;
    }

    @Override
    public void setPhysicalPropertyModel(PhysicalPropertyModel ppm) {
        this.setPpm(ppm);
        if (this.physicalPropertyHandler == null) {
            this.physicalPropertyHandler = new PhysicalPropertyHandler();
        }
        this.physicalPropertyHandler.setPhysicalProperties(this, ppm);
    }

    @Override
    public void resetPhysicalProperties() {
        this.physicalPropertyHandler = null;
    }

    @Override
    public void initPhysicalProperties() {
        if (this.physicalPropertyHandler == null) {
            this.physicalPropertyHandler = new PhysicalPropertyHandler();
        }
        if (this.physicalPropertyHandler.getPhysicalProperties(this) == null) {
            this.setPhysicalPropertyModel(this.ppm);
        }
        this.getPhysicalProperties().init(this);
    }

    @Override
    public void initPhysicalProperties(PhysicalPropertyType ppt) {
        if (this.physicalPropertyHandler == null) {
            this.physicalPropertyHandler = new PhysicalPropertyHandler();
        }
        if (this.physicalPropertyHandler.getPhysicalProperties(this) == null) {
            this.setPhysicalPropertyModel(this.ppm);
        }
        this.getPhysicalProperties().setPhase(this);
        this.getPhysicalProperties().init((PhaseInterface)this, ppt);
    }

    @Override
    public void setPhysicalProperties(PhysicalPropertyModel ppm) {
        this.physicalPropertyHandler.setPhysicalProperties(this, ppm);
    }

    @Override
    public double geta(PhaseInterface phase, double temperature, double pressure, int numbcomp) {
        throw new UnsupportedOperationException("Unimplemented method 'geta'");
    }

    @Override
    public double calcA(PhaseInterface phase, double temperature, double pressure, int numbcomp) {
        throw new UnsupportedOperationException("Unimplemented method 'calcA'");
    }

    public double calcA(int comp, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
        throw new UnsupportedOperationException("Unimplemented method 'calcA'");
    }

    @Override
    public double calcAi(int comp, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
        throw new UnsupportedOperationException("Unimplemented method 'calcAi'");
    }

    @Override
    public double calcAiT(int comp, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
        throw new UnsupportedOperationException("Unimplemented method 'calcAiT'");
    }

    @Override
    public double calcAT(int comp, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
        throw new UnsupportedOperationException("Unimplemented method 'calcAT'");
    }

    @Override
    public double calcAij(int compNumb, int j, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
        throw new UnsupportedOperationException("Unimplemented method 'calcAij'");
    }

    @Override
    public double getb(PhaseInterface phase, double temperature, double pressure, int numbcomp) {
        throw new UnsupportedOperationException("Unimplemented method 'getb'");
    }

    @Override
    public double calcB(PhaseInterface phase, double temperature, double pressure, int numbcomp) {
        throw new UnsupportedOperationException("Unimplemented method 'calcB'");
    }

    @Override
    public double getg() {
        throw new UnsupportedOperationException("Unimplemented method 'getg'");
    }

    @Override
    public double calcBij(int compNumb, int j, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
        throw new UnsupportedOperationException("Unimplemented method 'calcBij'");
    }

    @Override
    public double calcBi(int comp, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
        throw new UnsupportedOperationException("Unimplemented method 'calcBi'");
    }

    @Override
    public void setAttractiveTerm(int i) {
        for (int k = 0; k < this.numberOfComponents; ++k) {
            this.componentArray[k].setAttractiveTerm(i);
        }
    }

    @Override
    public double getMolarVolume() {
        return this.molarVolume;
    }

    @Override
    public double getMolarVolume(String unit) {
        double conversionFactor = 1.0;
        switch (unit) {
            case "m3/mol": {
                conversionFactor = 1.0;
                break;
            }
            case "cm3/mol": {
                conversionFactor = 1000000.0;
                break;
            }
            case "litre/mol": {
                conversionFactor = 1000.0;
                break;
            }
            case "ft3/lbmole": {
                conversionFactor = 16018.463373960138;
                break;
            }
            default: {
                throw new RuntimeException("unit not supported " + unit);
            }
        }
        return this.getMolarMass() / this.getDensity("kg/m3") * conversionFactor;
    }

    @Override
    public int getNumberOfComponents() {
        return this.numberOfComponents;
    }

    @Override
    public double getA() {
        throw new UnsupportedOperationException("Unimplemented method 'calcAij'");
    }

    @Override
    public double getB() {
        throw new UnsupportedOperationException("Unimplemented method 'getB'");
    }

    public double getBi() {
        throw new UnsupportedOperationException("Unimplemented method 'getBi'");
    }

    @Override
    public double getAT() {
        throw new UnsupportedOperationException("Unimplemented method 'getAT'");
    }

    @Override
    public double getATT() {
        throw new UnsupportedOperationException("Unimplemented method 'getATT'");
    }

    public double getAiT() {
        throw new UnsupportedOperationException("Unimplemented method 'getAiT'");
    }

    @Override
    public PhaseInterface getPhase() {
        return this;
    }

    @Override
    public double getNumberOfMolesInPhase() {
        return this.numberOfMolesInPhase;
    }

    @Override
    public ComponentInterface[] getComponents() {
        return this.componentArray;
    }

    @Override
    public void setComponentArray(ComponentInterface[] components) {
        this.componentArray = components;
    }

    @Override
    public double calcR() {
        double R = 8.3144621 / this.getMolarMass();
        return R;
    }

    @Override
    public double Fn() {
        throw new UnsupportedOperationException("Unimplemented method 'Fn'");
    }

    @Override
    public double FT() {
        throw new UnsupportedOperationException("Unimplemented method 'FT'");
    }

    @Override
    public double FV() {
        throw new UnsupportedOperationException("Unimplemented method 'FV'");
    }

    @Override
    public double FD() {
        throw new UnsupportedOperationException("Unimplemented method 'FD'");
    }

    @Override
    public double FB() {
        throw new UnsupportedOperationException("Unimplemented method 'FB'");
    }

    @Override
    public double gb() {
        throw new UnsupportedOperationException("Unimplemented method 'gb'");
    }

    @Override
    public double fb() {
        throw new UnsupportedOperationException("Unimplemented method 'fb'");
    }

    @Override
    public double gV() {
        throw new UnsupportedOperationException("Unimplemented method 'gV'");
    }

    @Override
    public double fv() {
        throw new UnsupportedOperationException("Unimplemented method 'fv'");
    }

    @Override
    public double FnV() {
        throw new UnsupportedOperationException("Unimplemented method 'FnV'");
    }

    @Override
    public double FnB() {
        throw new UnsupportedOperationException("Unimplemented method 'FnB'");
    }

    @Override
    public double FTT() {
        throw new UnsupportedOperationException("Unimplemented method 'FTT'");
    }

    @Override
    public double FBT() {
        throw new UnsupportedOperationException("Unimplemented method 'FBT'");
    }

    @Override
    public double FDT() {
        throw new UnsupportedOperationException("Unimplemented method 'FDT'");
    }

    @Override
    public double FBV() {
        throw new UnsupportedOperationException("Unimplemented method 'FBV'");
    }

    @Override
    public double FBB() {
        throw new UnsupportedOperationException("Unimplemented method 'FBB'");
    }

    @Override
    public double FDV() {
        throw new UnsupportedOperationException("Unimplemented method 'FDV'");
    }

    @Override
    public double FBD() {
        throw new UnsupportedOperationException("Unimplemented method 'FBD'");
    }

    @Override
    public double FTV() {
        throw new UnsupportedOperationException("Unimplemented method 'FTV'");
    }

    @Override
    public double FVV() {
        throw new UnsupportedOperationException("Unimplemented method 'FVV'");
    }

    @Override
    public double gVV() {
        throw new UnsupportedOperationException("Unimplemented method 'gVV'");
    }

    @Override
    public double gBV() {
        throw new UnsupportedOperationException("Unimplemented method 'gBV'");
    }

    @Override
    public double gBB() {
        throw new UnsupportedOperationException("Unimplemented method 'gBB'");
    }

    @Override
    public double fVV() {
        throw new UnsupportedOperationException("Unimplemented method 'fVV'");
    }

    @Override
    public double fBV() {
        throw new UnsupportedOperationException("Unimplemented method 'fBV'");
    }

    @Override
    public double fBB() {
        throw new UnsupportedOperationException("Unimplemented method 'fBB'");
    }

    @Override
    public double dFdT() {
        throw new UnsupportedOperationException("Unimplemented method 'dFdT'");
    }

    @Override
    public double dFdV() {
        throw new UnsupportedOperationException("Unimplemented method 'dFdV'");
    }

    @Override
    public double dFdTdV() {
        throw new UnsupportedOperationException("Unimplemented method 'dFdTdV'");
    }

    @Override
    public double dFdVdV() {
        throw new UnsupportedOperationException("Unimplemented method 'dFdVdV'");
    }

    @Override
    public double dFdTdT() {
        throw new UnsupportedOperationException("Unimplemented method 'dFdTdT'");
    }

    @Override
    public double getCpres() {
        throw new UnsupportedOperationException("Unimplemented method 'getCpres'");
    }

    public double getCvres() {
        throw new UnsupportedOperationException("Unimplemented method 'getCvres'");
    }

    @Override
    public double getHresTP() {
        throw new UnsupportedOperationException("Unimplemented method 'getHresTP'");
    }

    public double getHresdP() {
        throw new UnsupportedOperationException("Unimplemented method 'getHresdP'");
    }

    @Override
    public double getGresTP() {
        throw new UnsupportedOperationException("Unimplemented method 'getGresTP'");
    }

    public double getSresTV() {
        throw new UnsupportedOperationException("Unimplemented method 'getSresTV'");
    }

    @Override
    public double getSresTP() {
        throw new UnsupportedOperationException("Unimplemented method 'getSresTP'");
    }

    @Override
    public double getCp0() {
        double tempVar = 0.0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            tempVar += this.componentArray[i].getx() * this.componentArray[i].getCp0(this.temperature);
        }
        return tempVar;
    }

    public double getHID() {
        double tempVar = 0.0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            tempVar += this.componentArray[i].getx() * this.componentArray[i].getHID(this.temperature);
        }
        return tempVar;
    }

    @Override
    public double getCp() {
        return this.getCp0() * this.numberOfMolesInPhase + this.getCpres();
    }

    @Override
    public double getCp(String unit) {
        double refCp = this.getCp();
        double conversionFactor = 1.0;
        switch (unit) {
            case "J/K": {
                conversionFactor = 1.0;
                break;
            }
            case "J/molK": {
                conversionFactor = 1.0 / this.getNumberOfMolesInPhase();
                break;
            }
            case "J/kgK": {
                conversionFactor = 1.0 / this.getNumberOfMolesInPhase() / this.getMolarMass();
                break;
            }
            case "kJ/kgK": {
                conversionFactor = 1.0 / this.getNumberOfMolesInPhase() / this.getMolarMass() / 1000.0;
                break;
            }
            case "btu/lbmole-F": {
                conversionFactor = 1.0 / this.getNumberOfMolesInPhase() / this.getMolarMass() / 1000.0 * 0.2388;
                break;
            }
            default: {
                throw new RuntimeException("unit not supported " + unit);
            }
        }
        return refCp * conversionFactor;
    }

    @Override
    public double getCv() {
        return this.getCp0() * this.numberOfMolesInPhase - 8.3144621 * this.numberOfMolesInPhase + this.getCvres();
    }

    @Override
    public double getCv(String unit) {
        double refCv = this.getCv();
        double conversionFactor = 1.0;
        switch (unit) {
            case "J/K": {
                conversionFactor = 1.0;
                break;
            }
            case "J/molK": {
                conversionFactor = 1.0 / this.getNumberOfMolesInPhase();
                break;
            }
            case "J/kgK": {
                conversionFactor = 1.0 / this.getNumberOfMolesInPhase() / this.getMolarMass();
                break;
            }
            case "kJ/kgK": {
                conversionFactor = 1.0 / this.getNumberOfMolesInPhase() / this.getMolarMass() / 1000.0;
                break;
            }
            case "btu/lbmole-F": {
                conversionFactor = 1.0 / this.getNumberOfMolesInPhase() / this.getMolarMass() / 1000.0 * 0.2388;
                break;
            }
            default: {
                throw new RuntimeException("unit not supported " + unit);
            }
        }
        return refCv * conversionFactor;
    }

    @Override
    public double getKappa() {
        return this.getCp() / this.getCv();
    }

    @Override
    public double getGamma() {
        return this.getCp() / this.getCv();
    }

    @Override
    public double getEnthalpy() {
        return this.getHID() * this.numberOfMolesInPhase + this.getHresTP();
    }

    @Override
    public double getEnthalpy(String unit) {
        double refEnthalpy = this.getEnthalpy();
        double conversionFactor = 1.0;
        switch (unit) {
            case "J": {
                conversionFactor = 1.0;
                break;
            }
            case "kJ/kmol": 
            case "J/mol": {
                conversionFactor = 1.0 / this.getNumberOfMolesInPhase();
                break;
            }
            case "J/kg": {
                conversionFactor = 1.0 / this.getNumberOfMolesInPhase() / this.getMolarMass();
                break;
            }
            case "kJ/kg": {
                conversionFactor = 1.0 / this.getNumberOfMolesInPhase() / this.getMolarMass() / 1000.0;
                break;
            }
            case "Btu/lbmol": {
                conversionFactor = 1.0 / this.getNumberOfMolesInPhase() * 0.429923;
                break;
            }
            case "Btu": {
                conversionFactor = 9.4781712E-4;
                break;
            }
            default: {
                throw new RuntimeException("unit not supported " + unit);
            }
        }
        return refEnthalpy * conversionFactor;
    }

    @Override
    public double getEnthalpydP() {
        return this.getHresdP();
    }

    @Override
    public double getEnthalpydT() {
        return this.getCp();
    }

    @Override
    public void setNumberOfComponents(int numberOfComponents) {
        this.numberOfComponents = numberOfComponents;
    }

    @Override
    public final int getNumberOfMolecularComponents() {
        int mol = 0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            if (this.componentArray[i].getIonicCharge() != 0.0) continue;
            ++mol;
        }
        return mol;
    }

    @Override
    public final int getNumberOfIonicComponents() {
        int ion = 0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            if (this.componentArray[i].getIonicCharge() == 0.0) continue;
            ++ion;
        }
        return ion;
    }

    @Override
    public double getEntropy() {
        double tempVar = 0.0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            tempVar += this.componentArray[i].getx() * this.componentArray[i].getIdEntropy(this.temperature);
        }
        double tempVar2 = 0.0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            if (!(this.componentArray[i].getx() > 1.0E-100)) continue;
            tempVar2 += -8.3144621 * this.componentArray[i].getx() * Math.log(this.componentArray[i].getx());
        }
        return tempVar * this.numberOfMolesInPhase - this.numberOfMolesInPhase * 8.3144621 * Math.log(this.pressure / 1.01325) + tempVar2 * this.numberOfMolesInPhase + this.getSresTP();
    }

    @Override
    public double getEntropy(String unit) {
        double refEntropy = this.getEntropy();
        double conversionFactor = 1.0;
        switch (unit) {
            case "J/K": {
                conversionFactor = 1.0;
                break;
            }
            case "J/molK": {
                conversionFactor = 1.0 / this.getNumberOfMolesInPhase();
                break;
            }
            case "J/kgK": {
                conversionFactor = 1.0 / this.getNumberOfMolesInPhase() / this.getMolarMass();
                break;
            }
            case "kJ/kgK": {
                conversionFactor = 1.0 / this.getNumberOfMolesInPhase() / this.getMolarMass() / 1000.0;
                break;
            }
            case "btu/lb-F": {
                conversionFactor = 1.0 / this.getNumberOfMolesInPhase() / this.getMolarMass() / 1000.0 * 0.2388;
                break;
            }
            default: {
                throw new RuntimeException("unit not supported " + unit);
            }
        }
        return refEntropy * conversionFactor;
    }

    @Override
    public double getEntropydP() {
        return this.getdPdTVn() / this.getdPdVTn();
    }

    @Override
    public double getEntropydT() {
        return this.getCp() / this.temperature;
    }

    @Override
    public double getViscosity() {
        return this.getPhysicalProperties().getViscosity();
    }

    @Override
    public double getViscosity(String unit) {
        double refViscosity = this.getViscosity();
        double conversionFactor = 1.0;
        switch (unit) {
            case "Pas": 
            case "kg/msec": {
                conversionFactor = 1.0;
                break;
            }
            case "cP": {
                conversionFactor = 1000.0;
                break;
            }
            default: {
                throw new RuntimeException("unit not supported " + unit);
            }
        }
        return refViscosity * conversionFactor;
    }

    @Override
    public double getThermalConductivity() {
        return this.getPhysicalProperties().getConductivity();
    }

    @Override
    public double getThermalConductivity(String unit) {
        double refConductivity = this.getThermalConductivity();
        double conversionFactor = 1.0;
        switch (unit) {
            case "W/mK": 
            case "J/sec-m-K": {
                conversionFactor = 1.0;
                break;
            }
            case "W/cmK": {
                conversionFactor = 0.01;
                break;
            }
            case "Btu/hr-ft-F": {
                conversionFactor = 0.5781759824;
                break;
            }
            default: {
                throw new RuntimeException("unit not supported " + unit);
            }
        }
        return refConductivity * conversionFactor;
    }

    @Override
    public void initRefPhases(boolean onlyPure) {
        if (this.refPhase == null) {
            this.initRefPhases(onlyPure, "water");
        }
    }

    public void initRefPhases(boolean onlyPure, String name) {
        this.refPhase = new PhaseInterface[this.numberOfComponents];
        for (int i = 0; i < this.numberOfComponents; ++i) {
            try {
                this.refPhase[i] = (PhaseInterface)this.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            this.refPhase[i].setTemperature(this.temperature);
            this.refPhase[i].setPressure(this.pressure);
            if (this.getComponent(i).getReferenceStateType().equals("solvent") || onlyPure) {
                if (this.getComponent(i).isIsTBPfraction() || this.getComponent(i).isIsPlusFraction()) {
                    this.refPhase[i].addComponent("default", 10.0, 10.0, 0);
                    this.refPhase[i].getComponent(0).setMolarMass(this.getComponent(i).getMolarMass());
                    this.refPhase[i].getComponent(0).setAcentricFactor(this.getComponent(i).getAcentricFactor());
                    this.refPhase[i].getComponent(0).setTC(this.getComponent(i).getTC());
                    this.refPhase[i].getComponent(0).setPC(this.getComponent(i).getPC());
                    this.refPhase[i].getComponent(0).setComponentType("TBPfraction");
                    this.refPhase[i].getComponent(0).setIsTBPfraction(true);
                } else {
                    this.refPhase[i].addComponent(this.getComponent(i).getComponentName(), 10.0, 10.0, 0);
                }
                this.refPhase[i].setAttractiveTerm(this.getComponent(i).getAttractiveTermNumber());
                this.refPhase[i].setMixingRule(this.getMixingRuleNumber());
                this.refPhase[i].setType(this.getType());
                this.refPhase[i].init(this.refPhase[i].getNumberOfMolesInPhase(), 1, 0, this.getType(), 1.0);
                continue;
            }
            if (this.getComponent(i).isIsTBPfraction() || this.getComponent(i).isIsPlusFraction()) {
                this.refPhase[i].addComponent("default", 10.0, 10.0, 0);
                this.refPhase[i].getComponent(0).setMolarMass(this.getComponent(i).getMolarMass());
                this.refPhase[i].getComponent(0).setAcentricFactor(this.getComponent(i).getAcentricFactor());
                this.refPhase[i].getComponent(0).setTC(this.getComponent(i).getTC());
                this.refPhase[i].getComponent(0).setPC(this.getComponent(i).getPC());
                this.refPhase[i].getComponent(0).setComponentType("TBPfraction");
                this.refPhase[i].getComponent(0).setIsTBPfraction(true);
            } else {
                this.refPhase[i].addComponent(this.getComponent(i).getComponentName(), 1.0E-10, 1.0E-10, 0);
            }
            this.refPhase[i].addComponent(name, 10.0, 10.0, 1);
            this.refPhase[i].setAttractiveTerm(this.getComponent(i).getAttractiveTermNumber());
            this.refPhase[i].setMixingRule(this.getMixingRuleNumber());
            this.refPhase[i].init(this.refPhase[i].getNumberOfMolesInPhase(), 2, 0, this.getType(), 1.0);
        }
    }

    public double getLogPureComponentFugacity(int k, boolean pure) {
        if (this.refPhase == null) {
            this.initRefPhases(pure);
        }
        this.refPhase[k].setTemperature(this.temperature);
        this.refPhase[k].setPressure(this.pressure);
        this.refPhase[k].init(this.refPhase[k].getNumberOfMolesInPhase(), 1, 1, this.getType(), 1.0);
        this.refPhase[k].getComponent(0).fugcoef(this.refPhase[k]);
        return this.refPhase[k].getComponent(0).getLogFugacityCoefficient();
    }

    @Override
    public double getLogPureComponentFugacity(int p) {
        return this.getLogPureComponentFugacity(p, false);
    }

    @Override
    public double getPureComponentFugacity(int p) {
        return Math.exp(this.getLogPureComponentFugacity(p));
    }

    @Override
    public double getPureComponentFugacity(int p, boolean pure) {
        return Math.exp(this.getLogPureComponentFugacity(p, pure));
    }

    @Override
    public double getLogInfiniteDiluteFugacity(int k, int p) {
        if (this.refPhase == null) {
            this.initRefPhases(false, this.getComponent(p).getName());
        }
        this.refPhase[k].setTemperature(this.temperature);
        this.refPhase[k].setPressure(this.pressure);
        this.refPhase[k].init(this.refPhase[k].getNumberOfMolesInPhase(), 2, 1, this.getType(), 1.0);
        this.refPhase[k].getComponent(0).fugcoef(this.refPhase[k]);
        return this.refPhase[k].getComponent(0).getLogFugacityCoefficient();
    }

    @Override
    public double getLogInfiniteDiluteFugacity(int k) {
        Phase dilphase = this.clone();
        dilphase.addMoles(k, -0.9999999999 * dilphase.getComponent(k).getNumberOfMolesInPhase());
        dilphase.getComponent(k).setx(1.0E-10);
        dilphase.init(dilphase.getNumberOfMolesInPhase(), dilphase.getNumberOfComponents(), 1, dilphase.getType(), 1.0);
        dilphase.getComponent(k).fugcoef(dilphase);
        return dilphase.getComponent(k).getLogFugacityCoefficient();
    }

    @Override
    public double getInfiniteDiluteFugacity(int k, int p) {
        return Math.exp(this.getLogInfiniteDiluteFugacity(k, p));
    }

    public double getInfiniteDiluteFugacity(int k) {
        return Math.exp(this.getLogInfiniteDiluteFugacity(k));
    }

    @Override
    public double getLogActivityCoefficient(int k, int p) {
        double fug = 0.0;
        double oldFug = this.getComponent(k).getLogFugacityCoefficient();
        fug = this.getComponent(k).getReferenceStateType().equals("solvent") ? this.getLogPureComponentFugacity(k) : this.getLogInfiniteDiluteFugacity(k, p);
        return oldFug - fug;
    }

    @Override
    public double getActivityCoefficient(int k, int p) {
        double fug = 0.0;
        double oldFug = this.getComponent(k).getLogFugacityCoefficient();
        fug = this.getComponent(k).getReferenceStateType().equals("solvent") ? this.getLogPureComponentFugacity(k) : this.getLogInfiniteDiluteFugacity(k, p);
        return Math.exp(oldFug - fug);
    }

    @Override
    public double getActivityCoefficient(int k) {
        double fug = 0.0;
        double oldFug = this.getComponent(k).getLogFugacityCoefficient();
        fug = this.getComponent(k).getReferenceStateType().equals("solvent") ? this.getLogPureComponentFugacity(k) : this.getLogInfiniteDiluteFugacity(k);
        return Math.exp(oldFug - fug);
    }

    @Override
    public double getActivityCoefficientSymetric(int k) {
        if (this.refPhase == null) {
            this.initRefPhases(true);
        }
        double fug = 0.0;
        double oldFug = this.getComponent(k).getLogFugacityCoefficient();
        fug = this.getLogPureComponentFugacity(k);
        return Math.exp(oldFug - fug);
    }

    @Override
    public double getActivityCoefficientUnSymetric(int k) {
        double fug = 0.0;
        double oldFug = this.getComponent(k).getLogFugacityCoefficient();
        fug = this.getLogInfiniteDiluteFugacity(k);
        return Math.exp(oldFug - fug);
    }

    @Override
    public double getMolalMeanIonicActivity(int comp1, int comp2) {
        int watNumb = 0;
        double ions = 0.0;
        for (int j = 0; j < this.numberOfComponents; ++j) {
            if (this.getComponent(j).getIonicCharge() == 0.0) continue;
            ions += this.getComponent(j).getx();
        }
        double val = ions / this.getComponent("water").getx();
        for (int j = 0; j < this.numberOfComponents; ++j) {
            if (!this.getComponent(j).getComponentName().equals("water")) continue;
            watNumb = j;
        }
        double act1 = Math.pow(this.getActivityCoefficient(comp1, watNumb), Math.abs(this.getComponent(comp2).getIonicCharge()));
        double act2 = Math.pow(this.getActivityCoefficient(comp2, watNumb), Math.abs(this.getComponent(comp1).getIonicCharge()));
        return Math.pow(act1 * act2, 1.0 / (Math.abs(this.getComponent(comp1).getIonicCharge()) + Math.abs(this.getComponent(comp2).getIonicCharge()))) * 1.0 / (1.0 + val);
    }

    @Override
    public double getOsmoticCoefficientOfWater() {
        int watNumb = 0;
        for (int j = 0; j < this.numberOfComponents; ++j) {
            if (!this.getComponent(j).getComponentName().equals("water")) continue;
            watNumb = j;
        }
        return this.getOsmoticCoefficient(watNumb);
    }

    @Override
    public double getOsmoticCoefficient(int watNumb) {
        double oldFug = this.getComponent(watNumb).getFugacityCoefficient();
        double pureFug = this.getPureComponentFugacity(watNumb);
        double ions = 0.0;
        for (int j = 0; j < this.numberOfComponents; ++j) {
            if (this.getComponent(j).getIonicCharge() == 0.0) continue;
            ions += this.getComponent(j).getx();
        }
        return -Math.log(oldFug * this.getComponent(watNumb).getx() / pureFug) * this.getComponent(watNumb).getx() / ions;
    }

    @Override
    public double getMeanIonicActivity(int comp1, int comp2) {
        double act1 = 0.0;
        double act2 = 0.0;
        int watNumb = 0;
        for (int j = 0; j < this.numberOfComponents; ++j) {
            if (!this.getComponent(j).getComponentName().equals("water")) continue;
            watNumb = j;
        }
        act1 = Math.pow(this.getActivityCoefficient(comp1, watNumb), Math.abs(this.getComponent(comp2).getIonicCharge()));
        act2 = Math.pow(this.getActivityCoefficient(comp2, watNumb), Math.abs(this.getComponent(comp1).getIonicCharge()));
        return Math.pow(act1 * act2, 1.0 / (Math.abs(this.getComponent(comp1).getIonicCharge()) + Math.abs(this.getComponent(comp2).getIonicCharge())));
    }

    @Override
    public double getGibbsEnergy() {
        return this.getEnthalpy() - this.temperature * this.getEntropy();
    }

    @Override
    public double getInternalEnergy() {
        return this.getEnthalpy() - this.pressure * this.getMolarVolume() * this.numberOfMolesInPhase;
    }

    @Override
    public double getHelmholtzEnergy() {
        return this.getInternalEnergy() - this.temperature * this.getEntropy();
    }

    @Override
    public final double getMolarMass() {
        double tempVar = 0.0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            tempVar += this.componentArray[i].getx() * this.componentArray[i].getMolarMass();
        }
        return tempVar;
    }

    @Override
    public double getMolarMass(String unit) {
        double refMolarMass = this.getMolarMass();
        double conversionFactor = 1.0;
        switch (unit) {
            case "kg/mol": {
                conversionFactor = 1.0;
                break;
            }
            case "gr/mol": {
                conversionFactor = 1000.0;
                break;
            }
            case "lbm/lbmol": {
                conversionFactor = 1000.0;
                break;
            }
            default: {
                throw new RuntimeException("unit not supported " + unit);
            }
        }
        return refMolarMass * conversionFactor;
    }

    @Override
    public double getJouleThomsonCoefficient(String unit) {
        double JTcoef = this.getJouleThomsonCoefficient();
        double conversionFactor = 1.0;
        switch (unit) {
            case "K/bar": {
                conversionFactor = 1.0;
                break;
            }
            case "C/bar": {
                conversionFactor = 1.0;
                break;
            }
            case "K/Pa": {
                conversionFactor = 1.0E-5;
                break;
            }
            case "F/psi": {
                conversionFactor = 0.12410563127720953;
                break;
            }
            default: {
                throw new RuntimeException("unit not supported " + unit);
            }
        }
        return JTcoef * conversionFactor;
    }

    @Override
    public double getJouleThomsonCoefficient() {
        throw new UnsupportedOperationException("Unimplemented method 'getJouleThomsonCoefficient'");
    }

    @Override
    public double getDensity() {
        return 1.0 / this.getMolarVolume() * this.getMolarMass() * 100000.0;
    }

    @Override
    public double getDensity(String unit) {
        double refDensity = this.getPhysicalProperties().getDensity();
        double conversionFactor = 1.0;
        switch (unit) {
            case "kg/m3": {
                conversionFactor = 1.0;
                break;
            }
            case "mol/m3": {
                conversionFactor = 1.0 / this.getMolarMass();
                break;
            }
            case "lb/ft3": {
                conversionFactor = 0.0624279606;
                break;
            }
            default: {
                throw new RuntimeException("unit not supported " + unit);
            }
        }
        return refDensity * conversionFactor;
    }

    @Override
    public final double getPhaseFraction() {
        return this.getBeta();
    }

    @Override
    public double getdPdrho() {
        throw new UnsupportedOperationException("Unimplemented method 'getdPdrho'");
    }

    @Override
    public double getdrhodP() {
        throw new UnsupportedOperationException("Unimplemented method 'getdrhodP'");
    }

    @Override
    public double getdrhodT() {
        throw new UnsupportedOperationException("Unimplemented method 'getdrhodT'");
    }

    @Override
    public double getdrhodN() {
        throw new UnsupportedOperationException("Unimplemented method 'getdrhodN'");
    }

    @Override
    public void setMixingRule(int type) {
        this.mixingRuleNumber = type;
    }

    public double calcDiElectricConstant(double temperature) {
        double tempVar = 0.0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            tempVar += this.componentArray[i].getNumberOfMolesInPhase() * this.componentArray[i].getDiElectricConstant(temperature);
        }
        return tempVar / this.numberOfMolesInPhase;
    }

    public double calcDiElectricConstantdT(double temperature) {
        double tempVar = 0.0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            tempVar += this.componentArray[i].getNumberOfMolesInPhase() * this.componentArray[i].getDiElectricConstantdT(temperature);
        }
        return tempVar / this.numberOfMolesInPhase;
    }

    public double calcDiElectricConstantdTdT(double temperature) {
        double tempVar = 0.0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            tempVar += this.componentArray[i].getNumberOfMolesInPhase() * this.componentArray[i].getDiElectricConstantdTdT(temperature);
        }
        return tempVar / this.numberOfMolesInPhase;
    }

    public final double getDiElectricConstant() {
        return this.diElectricConstant;
    }

    @Override
    public double getdPdTVn() {
        throw new UnsupportedOperationException("Unimplemented method 'getdPdTVn'");
    }

    @Override
    public double getdPdVTn() {
        throw new UnsupportedOperationException("Unimplemented method 'getdPdVTn'");
    }

    @Override
    public double getpH() {
        return this.getpH_old();
    }

    public double getpH_old() {
        for (int i = 0; i < this.numberOfComponents; ++i) {
            if (!this.componentArray[i].getName().equals("H3O+")) continue;
            return -Math.log10(this.componentArray[i].getx() * this.getActivityCoefficient(i) / (0.01802 * Water.waterDensity(this.temperature) / 1000.0));
        }
        logger.info("no H3Oplus");
        return 7.0;
    }

    @Override
    public ComponentInterface getComponent(int i) {
        return this.componentArray[i];
    }

    @Override
    public ComponentInterface getComponent(String name) {
        try {
            for (int i = 0; i < this.numberOfComponents; ++i) {
                if (!this.componentArray[i].getName().equals(name)) continue;
                return this.componentArray[i];
            }
            logger.error("could not find component " + name + ", returning null");
            throw new Exception("component not in fluid... " + name);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    @Override
    public String[] getComponentNames() {
        ArrayList<String> components = new ArrayList<String>();
        for (int j = 0; j < this.componentArray.length; ++j) {
            if (this.componentArray[j] == null) continue;
            components.add(this.componentArray[j].getComponentName());
        }
        String[] componentList = new String[components.size()];
        for (int j = 0; j < this.numberOfComponents; ++j) {
            componentList[j] = (String)components.get(j);
        }
        return componentList;
    }

    @Override
    public boolean hasComponent(String name, boolean normalized) {
        for (int i = 0; i < this.numberOfComponents; ++i) {
            if (this.componentArray == null || !(normalized ? this.componentArray[i].getComponentName().equals(ComponentInterface.getComponentNameFromAlias(name)) : this.componentArray[i].getName().equals(name))) continue;
            return true;
        }
        return false;
    }

    @Override
    public final int getMixingRuleNumber() {
        return this.mixingRuleNumber;
    }

    @Override
    public PhaseInterface getRefPhase(int index) {
        if (this.refPhase == null) {
            this.initRefPhases(false);
        }
        return this.refPhase[index];
    }

    @Override
    public PhaseInterface[] getRefPhase() {
        if (this.refPhase == null) {
            this.initRefPhases(false);
        }
        return this.refPhase;
    }

    @Override
    public void setRefPhase(int index, PhaseInterface refPhase) {
        this.refPhase[index] = refPhase;
    }

    @Override
    public void setRefPhase(PhaseInterface[] refPhase) {
        this.refPhase = refPhase;
    }

    @Override
    public void setParams(PhaseInterface phase, double[][] alpha, double[][] Dij, double[][] DijT, String[][] mixRule, double[][] intparam) {
    }

    @Override
    public final boolean useVolumeCorrection() {
        return this.useVolumeCorrection;
    }

    @Override
    public void useVolumeCorrection(boolean volcor) {
        this.useVolumeCorrection = volcor;
    }

    @Override
    public double getFugacity(int compNumb) {
        return this.getComponent(compNumb).getx() * this.getComponent(compNumb).getFugacityCoefficient() * this.pressure;
    }

    @Override
    public double getFugacity(String compName) {
        return this.getComponent(compName).getx() * this.getComponent(compName).getFugacityCoefficient() * this.pressure;
    }

    public double[] groupTBPfractions() {
        double[] TPBfrac = new double[20];
        for (int i = 0; i < this.getNumberOfComponents(); ++i) {
            double boilpoint = this.getComponent(i).getNormalBoilingPoint("C");
            if (boilpoint >= 331.0) {
                TPBfrac[19] = TPBfrac[19] + this.getComponent(i).getx();
                continue;
            }
            if (boilpoint >= 317.0) {
                TPBfrac[18] = TPBfrac[18] + this.getComponent(i).getx();
                continue;
            }
            if (boilpoint >= 303.0) {
                TPBfrac[17] = TPBfrac[17] + this.getComponent(i).getx();
                continue;
            }
            if (boilpoint >= 287.0) {
                TPBfrac[16] = TPBfrac[16] + this.getComponent(i).getx();
                continue;
            }
            if (boilpoint >= 271.1) {
                TPBfrac[15] = TPBfrac[15] + this.getComponent(i).getx();
                continue;
            }
            if (boilpoint >= 253.9) {
                TPBfrac[14] = TPBfrac[14] + this.getComponent(i).getx();
                continue;
            }
            if (boilpoint >= 235.9) {
                TPBfrac[13] = TPBfrac[13] + this.getComponent(i).getx();
                continue;
            }
            if (boilpoint >= 216.8) {
                TPBfrac[12] = TPBfrac[12] + this.getComponent(i).getx();
                continue;
            }
            if (boilpoint >= 196.4) {
                TPBfrac[11] = TPBfrac[11] + this.getComponent(i).getx();
                continue;
            }
            if (boilpoint >= 174.6) {
                TPBfrac[10] = TPBfrac[10] + this.getComponent(i).getx();
                continue;
            }
            if (boilpoint >= 151.3) {
                TPBfrac[9] = TPBfrac[9] + this.getComponent(i).getx();
                continue;
            }
            if (boilpoint >= 126.1) {
                TPBfrac[8] = TPBfrac[8] + this.getComponent(i).getx();
                continue;
            }
            if (boilpoint >= 98.9) {
                TPBfrac[7] = TPBfrac[7] + this.getComponent(i).getx();
                continue;
            }
            if (!(boilpoint >= 69.2)) continue;
            TPBfrac[6] = TPBfrac[6] + this.getComponent(i).getx();
        }
        return TPBfrac;
    }

    @Override
    public final double getBeta() {
        return this.beta;
    }

    @Override
    public final void setBeta(double b) {
        if (b < 0.0) {
            b = 1.0E-12;
        }
        if (b > 1.0) {
            b = 0.999999999999;
        }
        this.beta = b;
    }

    @Override
    public void setMixingRuleGEModel(String name) {
    }

    @Override
    public boolean isMixingRuleDefined() {
        return this.mixingRuleDefined;
    }

    @Override
    public void setMixingRuleDefined(boolean mixingRuleDefined) {
        this.mixingRuleDefined = mixingRuleDefined;
    }

    @Override
    public final PhaseType getType() {
        return this.pt;
    }

    @Override
    public final void setType(PhaseType pt) {
        this.pt = pt;
    }

    @Override
    public void setMolarVolume(double molarVolume) {
        this.molarVolume = molarVolume;
    }

    @Override
    public void calcMolarVolume(boolean test) {
        this.calcMolarVolume = test;
    }

    @Override
    public void setTotalVolume(double volume) {
        this.phaseVolume = volume;
    }

    @Override
    public double getTotalVolume() {
        if (this.constantPhaseVolume) {
            return this.phaseVolume;
        }
        return this.getMolarVolume() * this.getNumberOfMolesInPhase();
    }

    @Override
    public double getVolume() {
        return this.getTotalVolume();
    }

    @Override
    public double getVolume(String unit) {
        double conversionFactor = 1.0;
        switch (unit) {
            case "m3": {
                conversionFactor = 1.0;
                break;
            }
            case "litre": {
                conversionFactor = 1000.0;
                break;
            }
            default: {
                throw new RuntimeException("unit not supported " + unit);
            }
        }
        return conversionFactor * this.getVolume() / 100000.0;
    }

    @Override
    public double getCorrectedVolume() {
        return this.getMolarMass() / this.getPhysicalProperties().getDensity() * this.getNumberOfMolesInPhase();
    }

    @Override
    public boolean hasPlusFraction() {
        for (int i = 0; i < this.numberOfComponents; ++i) {
            if (!this.getComponent(i).isIsPlusFraction()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasTBPFraction() {
        for (int i = 0; i < this.numberOfComponents; ++i) {
            if (!this.getComponent(i).isIsTBPfraction()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isConstantPhaseVolume() {
        return this.constantPhaseVolume;
    }

    @Override
    public void setConstantPhaseVolume(boolean constantPhaseVolume) {
        this.constantPhaseVolume = constantPhaseVolume;
    }

    @Override
    public double getMass() {
        return this.getMolarMass() * this.numberOfMolesInPhase;
    }

    @Override
    public abstract double getSoundSpeed();

    @Override
    public double getSoundSpeed(String unit) {
        double refVel = this.getSoundSpeed();
        double conversionFactor = 1.0;
        switch (unit) {
            case "m/s": 
            case "m/sec": {
                conversionFactor = 1.0;
                break;
            }
            case "km/hr": {
                conversionFactor = 3.6;
                break;
            }
            case "ft/sec": {
                conversionFactor = 3.280839895;
                break;
            }
            default: {
                throw new RuntimeException("unit not supported " + unit);
            }
        }
        return refVel * conversionFactor;
    }

    @Override
    public ComponentInterface getComponentWithIndex(int index) {
        for (int i = 0; i < this.numberOfComponents; ++i) {
            if (this.componentArray[i].getIndex() != index) continue;
            return this.componentArray[i];
        }
        return null;
    }

    @Override
    public double getWtFraction(SystemInterface system) {
        return this.getBeta() * this.getMolarMass() / system.getMolarMass();
    }

    @Override
    public double getMoleFraction() {
        return this.beta;
    }

    @Override
    public void setInitType(int initType) {
        this.initType = initType;
    }

    @Override
    public double getWtFractionOfWaxFormingComponents() {
        double wtFrac = 0.0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            if (!this.componentArray[i].isWaxFormer()) continue;
            wtFrac += this.componentArray[i].getx() * this.componentArray[i].getMolarMass() / this.getMolarMass();
        }
        return wtFrac;
    }

    @Override
    public double getDensity_GERG2008() {
        NeqSimGERG2008 test = new NeqSimGERG2008(this);
        return test.getDensity();
    }

    @Override
    public double[] getProperties_GERG2008() {
        NeqSimGERG2008 test = new NeqSimGERG2008(this);
        return test.propertiesGERG();
    }

    @Override
    public double getDensity_AGA8() {
        NeqSimAGA8Detail test = new NeqSimAGA8Detail(this);
        return test.getDensity();
    }

    @Override
    public double getFlowRate(String flowunit) {
        if (flowunit.equals("kg/sec")) {
            return this.numberOfMolesInPhase * this.getMolarMass();
        }
        if (flowunit.equals("kg/min")) {
            return this.numberOfMolesInPhase * this.getMolarMass() * 60.0;
        }
        if (flowunit.equals("kg/hr")) {
            return this.numberOfMolesInPhase * this.getMolarMass() * 3600.0;
        }
        if (flowunit.equals("m3/sec")) {
            this.initPhysicalProperties(PhysicalPropertyType.MASS_DENSITY);
            return this.numberOfMolesInPhase * this.getMolarMass() / this.getDensity("kg/m3");
        }
        if (flowunit.equals("m3/min")) {
            this.initPhysicalProperties(PhysicalPropertyType.MASS_DENSITY);
            return this.numberOfMolesInPhase * this.getMolarMass() / this.getDensity("kg/m3") * 60.0;
        }
        if (flowunit.equals("m3/hr")) {
            this.initPhysicalProperties(PhysicalPropertyType.MASS_DENSITY);
            return this.numberOfMolesInPhase * this.getMolarMass() / this.getDensity("kg/m3") * 3600.0;
        }
        if (flowunit.equals("ft3/sec")) {
            this.initPhysicalProperties(PhysicalPropertyType.MASS_DENSITY);
            return this.numberOfMolesInPhase * this.getMolarMass() / this.getDensity("kg/m3") * Math.pow(3.2808399, 3.0);
        }
        if (flowunit.equals("mole/sec")) {
            return this.numberOfMolesInPhase;
        }
        if (flowunit.equals("mole/min")) {
            return this.numberOfMolesInPhase * 60.0;
        }
        if (flowunit.equals("mole/hr")) {
            return this.numberOfMolesInPhase * 3600.0;
        }
        if (flowunit.equals("Sm3/sec")) {
            return this.numberOfMolesInPhase * 8.3144621 * 288.15 / 101325.0;
        }
        if (flowunit.equals("Sm3/hr")) {
            return this.numberOfMolesInPhase * 3600.0 * 8.3144621 * 288.15 / 101325.0;
        }
        if (flowunit.equals("Sm3/day")) {
            return this.numberOfMolesInPhase * 3600.0 * 24.0 * 8.3144621 * 288.15 / 101325.0;
        }
        if (flowunit.equals("MSm3/day")) {
            return this.numberOfMolesInPhase * 3600.0 * 24.0 * 8.3144621 * 288.15 / 101325.0 / 1000000.0;
        }
        if (flowunit.equals("lbmole/hr")) {
            return this.numberOfMolesInPhase * 3600.0 / 1000.0 * 2.205;
        }
        if (flowunit.equals("lb/hr")) {
            return this.numberOfMolesInPhase * this.getMolarMass() * 60.0 * 2.20462262;
        }
        if (flowunit.equals("barrel/day")) {
            return this.numberOfMolesInPhase * this.getMolarMass() * 60.0 * 2.20462262 * 0.068;
        }
        throw new RuntimeException("failed.. unit: " + flowunit + " not supported");
    }

    public String getThermoPropertyModelName() {
        return this.thermoPropertyModelName;
    }

    @Override
    public double getCompressibilityX() {
        return this.getTemperature() / this.getTotalVolume() * this.getdPdTVn() / this.getdPdVTn();
    }

    @Override
    public double getCompressibilityY() {
        return this.getPressure() / this.getTotalVolume() * 1.0 / this.getdPdVTn();
    }

    @Override
    public double getIsothermalCompressibility() {
        return -1.0 / this.getTotalVolume() * 1.0 / this.getdPdVTn();
    }

    @Override
    public double getIsobaricThermalExpansivity() {
        return this.getIsothermalCompressibility() * this.getdPdTVn();
    }

    @Override
    public String getModelName() {
        return this.thermoPropertyModelName;
    }
}

