/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.phase;

import neqsim.thermo.component.ComponentInterface;
import neqsim.thermo.phase.Phase;
import neqsim.thermo.phase.PhaseType;
import neqsim.util.exception.IsNaNException;
import neqsim.util.exception.TooManyIterationsException;

public class PhaseDefault
extends Phase {
    private static final long serialVersionUID = 1000L;
    protected ComponentInterface defComponent = null;

    public PhaseDefault() {
    }

    public PhaseDefault(ComponentInterface comp) {
        this.defComponent = comp;
    }

    public void setComponentType(ComponentInterface comp) {
        this.defComponent = comp;
    }

    @Override
    public void addComponent(String name, double moles, double molesInPhase, int compNumber) {
        super.addComponent(name, moles, compNumber);
        try {
            this.componentArray[compNumber] = (ComponentInterface)this.defComponent.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        this.componentArray[compNumber].createComponent(name, moles, molesInPhase, compNumber);
    }

    @Override
    public double molarVolume(double pressure, double temperature, double A, double B, PhaseType pt) throws IsNaNException, TooManyIterationsException {
        throw new UnsupportedOperationException("Unimplemented method 'molarVolume'");
    }

    @Override
    public void resetMixingRule(int type) {
    }

    @Override
    public double getMolarVolume() {
        throw new UnsupportedOperationException("Unimplemented method 'getMolarVolume'");
    }

    @Override
    public double getGibbsEnergy() {
        double val = 0.0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            val += this.getComponent(i).getNumberOfMolesInPhase() * this.getComponent(i).getLogFugacityCoefficient();
        }
        return 8.3144621 * this.temperature * (val + Math.log(this.pressure) * this.numberOfMolesInPhase);
    }

    @Override
    public double getSoundSpeed() {
        return Double.NaN;
    }
}

