/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.phase;

import neqsim.thermo.component.ComponentGeDuanSun;
import neqsim.thermo.phase.PhaseGE;
import neqsim.thermo.phase.PhaseInterface;
import neqsim.thermo.phase.PhaseType;
import neqsim.util.exception.IsNaNException;
import neqsim.util.exception.TooManyIterationsException;

public class PhaseDuanSun
extends PhaseGE {
    private static final long serialVersionUID = 1000L;
    double[][] alpha;
    String[][] mixRule;
    double[][] intparam;
    double[][] Dij;
    double GE = 0.0;

    @Override
    public void addComponent(String name, double moles, double molesInPhase, int compNumber) {
        super.addComponent(name, molesInPhase, compNumber);
        this.componentArray[compNumber] = new ComponentGeDuanSun(name, moles, molesInPhase, compNumber);
    }

    @Override
    public void setMixingRule(int type) {
        super.setMixingRule(type);
        this.alpha = this.mixSelect.getNRTLalpha();
        this.Dij = this.mixSelect.getNRTLDij();
    }

    @Override
    public void setAlpha(double[][] alpha) {
        for (int i = 0; i < alpha.length; ++i) {
            System.arraycopy(alpha[i], 0, this.alpha[i], 0, alpha[0].length);
        }
    }

    @Override
    public void setDij(double[][] Dij) {
        for (int i = 0; i < Dij.length; ++i) {
            System.arraycopy(Dij[i], 0, this.Dij[i], 0, Dij[0].length);
        }
    }

    @Override
    public void setDijT(double[][] DijT) {
        throw new UnsupportedOperationException("Unimplemented method 'setDijT'");
    }

    @Override
    public double getExcessGibbsEnergy() {
        return this.GE;
    }

    @Override
    public double getExcessGibbsEnergy(PhaseInterface phase, int numberOfComponents, double temperature, double pressure, PhaseType pt) {
        int i;
        this.GE = 0.0;
        double salinity = 0.0;
        for (i = 0; i < numberOfComponents; ++i) {
            if (!phase.getComponents()[i].isIsIon()) continue;
            salinity += phase.getComponents()[i].getNumberOfMolesInPhase() / (phase.getComponent("water").getNumberOfMolesInPhase() * phase.getComponent("water").getMolarMass());
        }
        for (i = 0; i < numberOfComponents; ++i) {
            this.GE += phase.getComponents()[i].getx() * Math.log(((ComponentGeDuanSun)this.componentArray[i]).getGammaPitzer(phase, numberOfComponents, temperature, pressure, pt, salinity));
        }
        return 8.3144621 * temperature * this.numberOfMolesInPhase * this.GE;
    }

    @Override
    public double getGibbsEnergy() {
        return 8.3144621 * this.temperature * this.numberOfMolesInPhase * (this.GE + Math.log(this.pressure));
    }

    @Override
    public double molarVolume(double pressure, double temperature, double A, double B, PhaseType pt) throws IsNaNException, TooManyIterationsException {
        throw new UnsupportedOperationException("Unimplemented method 'molarVolume'");
    }
}

