/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.phase;

import neqsim.thermo.component.ComponentCPAInterface;
import neqsim.thermo.component.ComponentElectrolyteCPA;
import neqsim.thermo.component.ComponentEosInterface;
import neqsim.thermo.mixingrule.CPAMixing;
import neqsim.thermo.mixingrule.CPAMixingInterface;
import neqsim.thermo.phase.PhaseCPAInterface;
import neqsim.thermo.phase.PhaseModifiedFurstElectrolyteEos;
import neqsim.thermo.phase.PhaseType;
import neqsim.util.exception.IsNaNException;
import neqsim.util.exception.TooManyIterationsException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PhaseElectrolyteCPAOld
extends PhaseModifiedFurstElectrolyteEos
implements PhaseCPAInterface {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(PhaseElectrolyteCPAOld.class);
    public CPAMixing cpaSelect = new CPAMixing();
    int totalNumberOfAccociationSites = 0;
    public CPAMixingInterface cpamix;
    double hcpatot = 1.0;
    double hcpatotdT = 0.0;
    double hcpatotdTdT = 0.0;
    double gcpav = 0.0;
    double lngcpa = 0.0;
    double lngcpav = 0.0;
    double gcpavv = 1.0;
    double gcpavvv = 0.0;
    double gcpa = 0.0;
    int cpaon = 1;
    int[][][] selfAccociationScheme = null;
    int[][][][] crossAccociationScheme = null;
    double dFdVdXdXdVtotal = 0.0;
    double dFCPAdXdXdTtotal = 0.0;
    double dFCPAdTdT = 0.0;

    @Override
    public PhaseElectrolyteCPAOld clone() {
        PhaseElectrolyteCPAOld clonedPhase = null;
        try {
            clonedPhase = (PhaseElectrolyteCPAOld)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return clonedPhase;
    }

    @Override
    public void init(double totalNumberOfMoles, int numberOfComponents, int initType, PhaseType pt, double beta) {
        if (initType == 0) {
            this.selfAccociationScheme = new int[numberOfComponents][0][0];
            this.crossAccociationScheme = new int[numberOfComponents][numberOfComponents][0][0];
            for (int i = 0; i < numberOfComponents; ++i) {
                this.selfAccociationScheme[i] = this.cpaSelect.setAssociationScheme(i, this);
                for (int j = 0; j < numberOfComponents; ++j) {
                    this.crossAccociationScheme[i][j] = this.cpaSelect.setCrossAssociationScheme(i, j, this);
                }
            }
        }
        do {
            super.init(totalNumberOfMoles, numberOfComponents, initType, pt, beta);
        } while (!this.solveX());
        if (initType > 1) {
            this.hcpatotdT = this.calc_hCPAdT();
            this.hcpatotdTdT = this.calc_hCPAdTdT();
        }
    }

    @Override
    public void setMixingRule(int type) {
        super.setMixingRule(type);
        this.cpamix = this.cpaSelect.getMixingRule(1, this);
    }

    @Override
    public void addComponent(String name, double moles, double molesInPhase, int compNumber) {
        super.addComponent(name, moles, molesInPhase, compNumber);
        this.componentArray[compNumber] = new ComponentElectrolyteCPA(name, moles, molesInPhase, compNumber);
    }

    @Override
    public double getF() {
        return super.getF() + (double)this.cpaon * this.FCPA();
    }

    @Override
    public double dFdT() {
        return super.dFdT() + (double)this.cpaon * this.dFCPAdT();
    }

    @Override
    public double dFdTdV() {
        return super.dFdTdV();
    }

    @Override
    public double dFdV() {
        double dv2 = this.dFCPAdV();
        return super.dFdV() + (double)this.cpaon * dv2;
    }

    @Override
    public double dFdVdV() {
        return super.dFdVdV() + (double)this.cpaon * this.dFCPAdVdV();
    }

    @Override
    public double dFdVdVdV() {
        return super.dFdVdVdV() + (double)this.cpaon * this.dFCPAdVdVdV();
    }

    @Override
    public double dFdTdT() {
        return super.dFdTdT() + (double)this.cpaon * this.dFCPAdTdT();
    }

    public double FCPA() {
        double tot = 0.0;
        double ans = 0.0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            tot = 0.0;
            for (int j = 0; j < this.getComponent(i).getNumberOfAssociationSites(); ++j) {
                double xai = ((ComponentElectrolyteCPA)this.getComponent(i)).getXsite()[j];
                tot += Math.log(xai) - 0.5 * xai + 0.5;
            }
            ans += this.getComponent(i).getNumberOfMolesInPhase() * tot;
        }
        return ans;
    }

    public double dFCPAdV() {
        return 1.0 / (2.0 * this.getTotalVolume()) * (1.0 - this.getTotalVolume() * this.getGcpav()) * this.hcpatot;
    }

    public double dFCPAdVdV() {
        return -1.0 / this.getTotalVolume() * this.dFCPAdV() + this.hcpatot / (2.0 * this.getTotalVolume()) * (-this.getGcpav() - this.getTotalVolume() * this.gcpavv) + this.getdFdVdXdXdVtotal();
    }

    public double dFCPAdVdVdV() {
        return -1.0 / this.getTotalVolume() * this.dFCPAdVdV() + 1.0 / Math.pow(this.getTotalVolume(), 2.0) * this.dFCPAdV() - this.hcpatot / (2.0 * Math.pow(this.getTotalVolume(), 2.0)) * (-this.getGcpav() - this.getTotalVolume() * this.gcpavv) + this.hcpatot / (2.0 * this.getTotalVolume()) * (-this.gcpavv - this.getTotalVolume() * this.gcpavvv - this.gcpavv);
    }

    public double dFCPAdT() {
        return this.dFCPAdXdXdTtotal;
    }

    public double dFCPAdTdT() {
        return this.dFCPAdTdT;
    }

    public double calc_hCPA() {
        double htot = 0.0;
        double tot = 0.0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            htot = 0.0;
            for (int j = 0; j < this.getComponent(i).getNumberOfAssociationSites(); ++j) {
                htot += 1.0 - ((ComponentElectrolyteCPA)this.getComponent(i)).getXsite()[j];
            }
            tot += this.getComponent(i).getNumberOfMolesInPhase() * htot;
        }
        return tot;
    }

    public double calc_hCPAdT() {
        double htot = 0.0;
        double tot = 0.0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            for (int k = 0; k < this.numberOfComponents; ++k) {
                htot = 0.0;
                for (int j = 0; j < this.getComponent(i).getNumberOfAssociationSites(); ++j) {
                    for (int l = 0; l < this.getComponent(k).getNumberOfAssociationSites(); ++l) {
                        htot += ((ComponentElectrolyteCPA)this.getComponent(i)).getXsite()[j] * ((ComponentElectrolyteCPA)this.getComponent(k)).getXsite()[l] * this.cpamix.calcDeltadT(j, l, i, k, this, this.temperature, this.pressure, this.numberOfComponents);
                    }
                }
                tot += this.getComponent(i).getNumberOfMolesInPhase() * this.getComponent(k).getNumberOfMolesInPhase() * htot;
            }
        }
        return tot / this.getTotalVolume();
    }

    public double calc_hCPAdTdT() {
        double htot = 0.0;
        double tot = 0.0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            for (int k = 0; k < this.numberOfComponents; ++k) {
                htot = 0.0;
                for (int j = 0; j < this.getComponent(i).getNumberOfAssociationSites(); ++j) {
                    for (int l = 0; l < this.getComponent(k).getNumberOfAssociationSites(); ++l) {
                        htot += ((ComponentElectrolyteCPA)this.getComponent(i)).getXsite()[j] * ((ComponentElectrolyteCPA)this.getComponent(k)).getXsite()[l] * this.cpamix.calcDeltadTdT(j, l, i, k, this, this.temperature, this.pressure, this.numberOfComponents);
                    }
                }
                tot += this.getComponent(i).getNumberOfMolesInPhase() * this.getComponent(k).getNumberOfMolesInPhase() * htot;
            }
        }
        return tot / this.getTotalVolume();
    }

    public double calc_g() {
        double x = 0.475 * this.getB() / this.getTotalVolume();
        double g = 1.0 / (1.0 - x);
        return g;
    }

    public double calc_lngni(int comp) {
        double nbet = this.getb() / 4.0 / this.getMolarVolume();
        double dlngdb = 1.9 / (1.0 - 1.9 * nbet);
        double nbeti = nbet / this.getb() * ((ComponentEosInterface)this.getComponent(comp)).getBi();
        return dlngdb * nbeti;
    }

    public double calc_lngV() {
        double x = 0.475 * this.getB() / this.getTotalVolume();
        double gv = x / this.getTotalVolume() / (1.0 - x);
        return -gv;
    }

    public double calc_lngVV() {
        double x = 0.475 * this.getB() / this.getTotalVolume();
        double xV = -0.475 * this.getB() / Math.pow(this.getTotalVolume(), 2.0);
        double u = 1.0 - x;
        double val = -x / (Math.pow(this.getTotalVolume(), 2.0) * u) + xV / (this.getTotalVolume() * u) - x / (this.getTotalVolume() * u * u) * -1.0 * xV;
        return -val;
    }

    public double calc_lngVVV() {
        double gvv = -0.21434375 / Math.pow(1.0 - 0.475 * this.getB() / this.getTotalVolume(), 3.0) * Math.pow(this.getB(), 3.0) / Math.pow(this.getTotalVolume(), 6.0) - 1.35375 / Math.pow(1.0 - 0.475 * this.getB() / this.getTotalVolume(), 2.0) * Math.pow(this.getB(), 2.0) / Math.pow(this.getTotalVolume(), 5.0) - 2.85 / (1.0 - 0.475 * this.getB() / this.getTotalVolume()) * this.getB() / Math.pow(this.getTotalVolume(), 4.0);
        return gvv;
    }

    public void setXsiteOld() {
        for (int i = 0; i < this.numberOfComponents; ++i) {
            for (int j = 0; j < this.getComponent(i).getNumberOfAssociationSites(); ++j) {
                ((ComponentCPAInterface)this.getComponent(i)).setXsiteOld(j, ((ComponentCPAInterface)this.getComponent(i)).getXsite()[j]);
            }
        }
    }

    public void setXsitedV(double dV) {
        this.dFdVdXdXdVtotal = 0.0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            for (int j = 0; j < this.getComponent(i).getNumberOfAssociationSites(); ++j) {
                double XdV = (((ComponentCPAInterface)this.getComponent(i)).getXsite()[j] - ((ComponentCPAInterface)this.getComponent(i)).getXsiteOld()[j]) / dV;
                ((ComponentCPAInterface)this.getComponent(i)).setXsitedV(j, XdV);
                this.dFdVdXdXdVtotal += XdV * ((ComponentCPAInterface)this.getComponent(i)).dFCPAdVdXi(j, this);
            }
        }
    }

    public void calcXsitedT() {
        int j;
        int i;
        double dt = 0.01;
        double XdT = 0.0;
        this.setXsiteOld();
        this.setTemperature(this.temperature + dt);
        this.solveX();
        this.dFCPAdXdXdTtotal = 0.0;
        this.dFCPAdTdT = 0.0;
        for (i = 0; i < this.numberOfComponents; ++i) {
            for (j = 0; j < this.getComponent(i).getNumberOfAssociationSites(); ++j) {
                XdT = (((ComponentCPAInterface)this.getComponent(i)).getXsite()[j] - ((ComponentCPAInterface)this.getComponent(i)).getXsiteOld()[j]) / dt;
                ((ComponentCPAInterface)this.getComponent(i)).setXsitedT(j, XdT);
                this.dFCPAdXdXdTtotal += XdT * ((ComponentCPAInterface)this.getComponent(i)).dFCPAdXi(j, this);
            }
        }
        for (i = 0; i < this.numberOfComponents; ++i) {
            for (j = 0; j < this.getComponent(i).getNumberOfAssociationSites(); ++j) {
                for (int k = 0; k < this.numberOfComponents; ++k) {
                    for (int j2 = 0; j2 < this.getComponent(k).getNumberOfAssociationSites(); ++j2) {
                        this.dFCPAdTdT += ((ComponentCPAInterface)this.getComponent(i)).dFCPAdXidXj(j, j2, k, this) * ((ComponentCPAInterface)this.getComponent(i)).getXsitedT()[j] * ((ComponentCPAInterface)this.getComponent(k)).getXsitedT()[j2];
                    }
                }
            }
        }
        this.setTemperature(this.temperature - dt);
        this.solveX();
    }

    public double getdFdVdXdXdVtotal() {
        return this.dFdVdXdXdVtotal;
    }

    public boolean solveX() {
        double err = 0.0;
        int iter = 0;
        do {
            ++iter;
            err = 0.0;
            for (int i = 0; i < this.numberOfComponents; ++i) {
                for (int j = 0; j < this.getComponent(i).getNumberOfAssociationSites(); ++j) {
                    double old = ((ComponentElectrolyteCPA)this.getComponent(i)).getXsite()[j];
                    double neeval = this.getCpamix().calcXi(this.selfAccociationScheme, this.crossAccociationScheme, j, i, this, this.temperature, this.pressure, this.numberOfComponents);
                    ((ComponentCPAInterface)this.getComponent(i)).setXsite(j, neeval);
                    err += Math.abs((old - neeval) / neeval);
                }
            }
        } while (Math.abs(err) > 1.0E-10 && iter < 100);
        return Math.abs(err) < 1.0E-10;
    }

    @Override
    public double getHcpatot() {
        return this.hcpatot;
    }

    public void setHcpatot(double hcpatot) {
        this.hcpatot = hcpatot;
    }

    @Override
    public double getGcpa() {
        return this.gcpa;
    }

    public double molarVolume3(double pressure, double temperature, double A, double B, PhaseType pt) throws IsNaNException, TooManyIterationsException {
        double BonV;
        double d = BonV = pt == PhaseType.LIQUID ? 2.0 / (2.0 + temperature / this.getPseudoCriticalTemperature()) : pressure * this.getB() / (this.numberOfMolesInPhase * temperature * 8.3144621);
        if (BonV < 0.0) {
            BonV = 1.0E-8;
        }
        if (BonV > 1.0) {
            BonV = 0.99999999;
        }
        double BonVold = BonV;
        double Btemp = 0.0;
        double h = 0.0;
        double dh = 0.0;
        double dhh = 0.0;
        double d1 = 0.0;
        double d2 = 0.0;
        Btemp = this.getB();
        if (Btemp < 0.0) {
            logger.info("b negative in volume calc");
        }
        this.setMolarVolume(1.0 / BonV * Btemp / this.numberOfMolesInPhase);
        int iterations = 0;
        int maxIterations = 101;
        do {
            this.volInit();
            this.gcpa = this.calc_g();
            this.lngcpa = Math.log(this.gcpa);
            this.gcpav = this.calc_lngV();
            this.gcpavv = this.calc_lngVV();
            this.gcpavvv = this.calc_lngVVV();
            this.solveX();
            this.hcpatot = this.calc_hCPA();
            ++iterations;
            BonVold = BonV;
            h = BonV - Btemp / this.numberOfMolesInPhase * this.dFdV() - pressure * Btemp / (this.numberOfMolesInPhase * 8.3144621 * temperature);
            dh = 1.0 + Btemp / Math.pow(BonV, 2.0) * (Btemp / this.numberOfMolesInPhase * this.dFdVdV());
            dhh = -2.0 * Btemp / Math.pow(BonV, 3.0) * (Btemp / this.numberOfMolesInPhase * this.dFdVdV()) - Math.pow(Btemp, 2.0) / Math.pow(BonV, 4.0) * (Btemp / this.numberOfMolesInPhase * this.dFdVdVdV());
            d1 = -h / dh;
            d2 = -dh / dhh;
            if (Math.abs(d1 / d2) <= 1.0) {
                BonV += d1 * (1.0 + 0.5 * d1 / d2);
            } else if (d1 / d2 < -1.0) {
                BonV += d1 * 0.5;
            } else if (d1 / d2 > 1.0) {
                BonV += d2;
                double hnew = h + d2 * -h / d1;
                if (Math.abs(hnew) > Math.abs(h)) {
                    double d3 = BonV = pt == PhaseType.GAS ? 2.0 / (2.0 + temperature / this.getPseudoCriticalTemperature()) : pressure * this.getB() / (this.numberOfMolesInPhase * temperature * 8.3144621);
                }
            }
            if (BonV > 1.0) {
                BonV = 0.99999999;
                BonVold = 10.0;
            }
            if (BonV < 0.0) {
                BonV = 1.0E-8;
                BonVold = 10.0;
            }
            this.setMolarVolume(1.0 / BonV * Btemp / this.numberOfMolesInPhase);
            this.Z = pressure * this.getMolarVolume() / (8.3144621 * temperature);
        } while (Math.abs((BonV - BonVold) / BonV) > 1.0E-10 && iterations < maxIterations);
        if (Double.isNaN(this.getMolarVolume())) {
            throw new IsNaNException(this, "molarVolume3", "Molar volume");
        }
        return this.getMolarVolume();
    }

    @Override
    public double molarVolume(double pressure, double temperature, double A, double B, PhaseType pt) throws IsNaNException, TooManyIterationsException {
        double BonV;
        double d = BonV = pt == PhaseType.LIQUID ? 2.0 / (2.0 + temperature / this.getPseudoCriticalTemperature()) : pressure * this.getB() / (this.numberOfMolesInPhase * temperature * 8.3144621);
        if (BonV < 0.0) {
            BonV = 1.0E-8;
        }
        if (BonV > 1.0) {
            BonV = 0.99999999;
        }
        double BonVold = BonV;
        double Btemp = 0.0;
        double h = 0.0;
        double dh = 0.0;
        double dhh = 0.0;
        double d1 = 0.0;
        double d2 = 0.0;
        Btemp = this.getB();
        if (Btemp < 0.0) {
            logger.info("b negative in volume calc");
        }
        this.setMolarVolume(1.0 / BonV * Btemp / this.numberOfMolesInPhase);
        int iterations = 0;
        int maxIterations = 1000;
        double oldVolume = this.getVolume();
        do {
            this.volInit();
            this.gcpa = this.calc_g();
            this.lngcpa = Math.log(this.gcpa);
            this.setGcpav(this.calc_lngV());
            this.gcpavv = this.calc_lngVV();
            this.gcpavvv = this.calc_lngVVV();
            this.solveX();
            this.hcpatot = this.calc_hCPA();
            double dV = this.getVolume() - oldVolume;
            if (iterations > 0) {
                this.setXsitedV(dV);
            }
            oldVolume = this.getVolume();
            this.setXsiteOld();
            ++iterations;
            BonVold = BonV;
            h = BonV - Btemp / this.numberOfMolesInPhase * this.dFdV() - pressure * Btemp / (this.numberOfMolesInPhase * 8.3144621 * temperature);
            dh = 1.0 + Btemp / Math.pow(BonV, 2.0) * (Btemp / this.numberOfMolesInPhase * this.dFdVdV());
            dhh = -2.0 * Btemp / Math.pow(BonV, 3.0) * (Btemp / this.numberOfMolesInPhase * this.dFdVdV()) - Math.pow(Btemp, 2.0) / Math.pow(BonV, 4.0) * (Btemp / this.numberOfMolesInPhase * this.dFdVdVdV());
            d1 = -h / dh;
            d2 = -dh / dhh;
            if (Math.abs(d1 / d2) <= 1.0) {
                BonV += d1 * (1.0 + 0.5 * d1 / d2);
            } else if (d1 / d2 < -1.0) {
                BonV += d1 * 0.5;
            } else if (d1 / d2 > 1.0) {
                BonV += d2;
                double hnew = h + d2 * -h / d1;
                if (Math.abs(hnew) > Math.abs(h)) {
                    double d3 = BonV = pt == PhaseType.GAS ? 2.0 / (2.0 + temperature / this.getPseudoCriticalTemperature()) : pressure * this.getB() / (this.numberOfMolesInPhase * temperature * 8.3144621);
                }
            }
            if (BonV > 1.0) {
                BonV = 0.99999999;
                BonVold = 10.0;
            }
            if (BonV < 0.0) {
                BonV = 1.0E-8;
                BonVold = 10.0;
            }
            this.setMolarVolume(1.0 / BonV * Btemp / this.numberOfMolesInPhase);
            this.Z = pressure * this.getMolarVolume() / (8.3144621 * temperature);
        } while (Math.abs((BonV - BonVold) / BonV) > 1.0E-10 && iterations < maxIterations);
        if (Double.isNaN(this.getMolarVolume())) {
            throw new IsNaNException(this, "molarVolume", "Molar volume");
        }
        return this.getMolarVolume();
    }

    @Override
    public double molarVolume2(double pressure, double temperature, double A, double B, PhaseType pt) throws IsNaNException, TooManyIterationsException {
        this.Z = pt == PhaseType.LIQUID ? 1.0 : 1.0E-5;
        this.setMolarVolume(this.Z * 8.3144621 * temperature / pressure);
        int iterations = 0;
        double err = 0.0;
        double dErrdV = 0.0;
        double deltaV = 0.0;
        do {
            A = this.calcA(this, temperature, pressure, this.numberOfComponents);
            B = this.calcB(this, temperature, pressure, this.numberOfComponents);
            double dFdV = this.dFdV();
            double dFdVdV = this.dFdVdV();
            err = -8.3144621 * temperature * dFdV + 8.3144621 * temperature / this.getMolarVolume() - pressure;
            logger.info("pressure " + -8.3144621 * temperature * dFdV + " " + 8.3144621 * temperature / this.getMolarVolume());
            dErrdV = -8.3144621 * temperature * dFdVdV - 8.3144621 * temperature * this.numberOfMolesInPhase / Math.pow(this.getVolume(), 2.0);
            logger.info("errdV " + dErrdV);
            logger.info("err " + err);
            deltaV = -err / dErrdV;
            this.setMolarVolume(this.getMolarVolume() + deltaV / this.numberOfMolesInPhase);
            this.Z = pressure * this.getMolarVolume() / (8.3144621 * temperature);
            if (!(this.Z < 0.0)) continue;
            this.Z = 1.0E-6;
            this.setMolarVolume(this.Z * 8.3144621 * temperature / pressure);
        } while (Math.abs(err) > 1.0E-8 || iterations < 100);
        return this.getMolarVolume();
    }

    @Override
    public double getGcpav() {
        return this.gcpav;
    }

    public void setGcpav(double gcpav) {
        this.gcpav = gcpav;
    }

    @Override
    public CPAMixingInterface getCpamix() {
        return this.cpamix;
    }

    @Override
    public int getCrossAssosiationScheme(int comp1, int comp2, int site1, int site2) {
        if (comp1 == comp2) {
            return this.selfAccociationScheme[comp1][site1][site2];
        }
        return this.crossAccociationScheme[comp1][comp2][site1][site2];
    }

    @Override
    public int getTotalNumberOfAccociationSites() {
        return this.totalNumberOfAccociationSites;
    }

    @Override
    public void setTotalNumberOfAccociationSites(int totalNumberOfAccociationSites) {
        this.totalNumberOfAccociationSites = totalNumberOfAccociationSites;
    }
}

