/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.phase;

import neqsim.thermo.component.ComponentGEInterface;
import neqsim.thermo.mixingrule.EosMixingRules;
import neqsim.thermo.mixingrule.EosMixingRulesInterface;
import neqsim.thermo.phase.Phase;
import neqsim.thermo.phase.PhaseGEInterface;
import neqsim.thermo.phase.PhaseType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class PhaseGE
extends Phase
implements PhaseGEInterface {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(PhaseGE.class);
    EosMixingRules mixSelect = new EosMixingRules();
    EosMixingRulesInterface mixRuleEos;

    public PhaseGE() {
        this.setType(PhaseType.LIQUID);
        this.componentArray = new ComponentGEInterface[100];
        this.useVolumeCorrection = false;
    }

    public void init(double temperature, double pressure, double totalNumberOfMoles, double beta, int numberOfComponents, PhaseType pt, int phase) {
        if (totalNumberOfMoles <= 0.0) {
            // empty if block
        }
        for (int i = 0; i < numberOfComponents; ++i) {
            this.componentArray[i].init(temperature, pressure, totalNumberOfMoles, beta, pt.getValue());
        }
        this.getExcessGibbsEnergy(this, numberOfComponents, temperature, pressure, pt);
        double sumHydrocarbons = 0.0;
        double sumAqueous = 0.0;
        for (int i = 0; i < numberOfComponents; ++i) {
            if (this.getComponent(i).isHydrocarbon() || this.getComponent(i).isInert() || this.getComponent(i).isIsTBPfraction()) {
                sumHydrocarbons += this.getComponent(i).getx();
                continue;
            }
            sumAqueous += this.getComponent(i).getx();
        }
        if (sumHydrocarbons > sumAqueous) {
            this.setType(PhaseType.OIL);
        } else {
            this.setType(PhaseType.AQUEOUS);
        }
    }

    @Override
    public void init(double totalNumberOfMoles, int numberOfComponents, int initType, PhaseType pt, double beta) {
        super.init(totalNumberOfMoles, numberOfComponents, initType, pt, beta);
        if (initType != 0) {
            this.getExcessGibbsEnergy(this, numberOfComponents, this.temperature, this.pressure, pt);
        }
        double sumHydrocarbons = 0.0;
        double sumAqueous = 0.0;
        for (int i = 0; i < numberOfComponents; ++i) {
            if (this.getComponent(i).isHydrocarbon() || this.getComponent(i).isInert() || this.getComponent(i).isIsTBPfraction()) {
                sumHydrocarbons += this.getComponent(i).getx();
                continue;
            }
            sumAqueous += this.getComponent(i).getx();
        }
        if (sumHydrocarbons > sumAqueous) {
            this.setType(PhaseType.OIL);
        } else {
            this.setType(PhaseType.AQUEOUS);
        }
        if (initType > 1) {
            // empty if block
        }
    }

    @Override
    public void setMixingRule(int type) {
        this.mixingRuleDefined = true;
        super.setMixingRule(2);
        this.mixRuleEos = this.mixSelect.getMixingRule(2, this);
    }

    @Override
    public void resetMixingRule(int type) {
        this.mixingRuleDefined = true;
        super.setMixingRule(2);
        this.mixRuleEos = this.mixSelect.resetMixingRule(2, this);
    }

    @Override
    public double getActivityCoefficientSymetric(int k) {
        return ((ComponentGEInterface)this.getComponent(k)).getGamma();
    }

    @Override
    public double getActivityCoefficient(int k) {
        return ((ComponentGEInterface)this.getComponent(k)).getGamma();
    }

    public double getActivityCoefficientInfDilWater(int k, int p) {
        if (this.refPhase == null) {
            this.initRefPhases(false, this.getComponent(p).getName());
        }
        this.refPhase[k].setTemperature(this.temperature);
        this.refPhase[k].setPressure(this.pressure);
        this.refPhase[k].init(this.refPhase[k].getNumberOfMolesInPhase(), 2, 1, this.getType(), 1.0);
        ((PhaseGEInterface)((Object)this.refPhase[k])).getExcessGibbsEnergy(this.refPhase[k], 2, this.refPhase[k].getTemperature(), this.refPhase[k].getPressure(), this.refPhase[k].getType());
        return ((ComponentGEInterface)this.refPhase[k].getComponent(0)).getGamma();
    }

    public double getActivityCoefficientInfDil(int k) {
        Phase dilphase = this.clone();
        dilphase.addMoles(k, -0.9999999999 * dilphase.getComponent(k).getNumberOfMolesInPhase());
        dilphase.getComponent(k).setx(1.0E-10);
        dilphase.init(dilphase.getNumberOfMolesInPhase(), dilphase.getNumberOfComponents(), 1, dilphase.getType(), 1.0);
        ((PhaseGEInterface)((Object)dilphase)).getExcessGibbsEnergy(dilphase, 2, dilphase.getTemperature(), dilphase.getPressure(), dilphase.getType());
        return ((ComponentGEInterface)dilphase.getComponent(0)).getGamma();
    }

    @Override
    public double getEnthalpy() {
        return this.getCp() * this.temperature * this.numberOfMolesInPhase;
    }

    @Override
    public double getEntropy() {
        return this.getCp() * Math.log(this.temperature / 273.15);
    }

    @Override
    public double getCp() {
        double tempVar = 0.0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            tempVar += this.componentArray[i].getx() * this.componentArray[i].getPureComponentCpLiquid(this.temperature);
        }
        return tempVar;
    }

    @Override
    public double getCv() {
        return this.getCp();
    }

    @Override
    public double getZ() {
        double densityIdealGas = this.pressure * 100000.0 / 8.3144621 / this.temperature * this.getMolarMass();
        return densityIdealGas / this.getDensity("kg/m3");
    }

    @Override
    public double getSoundSpeed() {
        return 1470.0;
    }

    @Override
    public double getJouleThomsonCoefficient() {
        return -0.0125;
    }

    @Override
    public double getDensity() {
        return 997.0;
    }

    @Override
    public double getMolarVolume() {
        return 1.0 / (this.getDensity() / this.getMolarMass()) * 100000.0;
    }
}

