/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.phase;

import neqsim.thermo.component.ComponentGEInterface;
import neqsim.thermo.component.ComponentGENRTLmodifiedWS;
import neqsim.thermo.phase.PhaseGENRTLmodifiedHV;
import neqsim.thermo.phase.PhaseInterface;
import neqsim.thermo.phase.PhaseType;

public class PhaseGENRTLmodifiedWS
extends PhaseGENRTLmodifiedHV {
    private static final long serialVersionUID = 1000L;

    public PhaseGENRTLmodifiedWS() {
    }

    public PhaseGENRTLmodifiedWS(PhaseInterface phase, double[][] alpha, double[][] Dij, String[][] mixRule, double[][] intparam) {
        super(phase, alpha, Dij, mixRule, intparam);
        this.componentArray = new ComponentGENRTLmodifiedWS[alpha[0].length];
        for (int i = 0; i < alpha[0].length; ++i) {
            ++this.numberOfComponents;
            this.componentArray[i] = new ComponentGENRTLmodifiedWS(phase.getComponents()[i].getName(), phase.getComponents()[i].getNumberOfmoles(), phase.getComponents()[i].getNumberOfMolesInPhase(), phase.getComponents()[i].getComponentNumber());
        }
    }

    public PhaseGENRTLmodifiedWS(PhaseInterface phase, double[][] alpha, double[][] Dij, double[][] DijT, String[][] mixRule, double[][] intparam) {
        super(phase, alpha, Dij, DijT, mixRule, intparam);
        this.componentArray = new ComponentGENRTLmodifiedWS[alpha[0].length];
        for (int i = 0; i < alpha[0].length; ++i) {
            this.componentArray[i] = new ComponentGENRTLmodifiedWS(phase.getComponents()[i].getName(), phase.getComponents()[i].getNumberOfmoles(), phase.getComponents()[i].getNumberOfMolesInPhase(), phase.getComponents()[i].getComponentNumber());
        }
    }

    @Override
    public void setMixingRule(int type) {
        super.setMixingRule(type);
        this.intparam = this.mixSelect.getWSintparam();
        this.alpha = this.mixSelect.getNRTLalpha();
        this.mixRule = this.mixSelect.getClassicOrHV();
        this.Dij = this.mixSelect.getNRTLDij();
    }

    @Override
    public void addComponent(String name, double moles, double molesInPhase, int compNumber) {
        super.addComponent(name, molesInPhase, compNumber);
        this.componentArray[compNumber] = new ComponentGENRTLmodifiedWS(name, moles, molesInPhase, compNumber);
    }

    @Override
    public double getExcessGibbsEnergy(PhaseInterface phase, int numberOfComponents, double temperature, double pressure, PhaseType pt) {
        double GE = 0.0;
        for (int i = 0; i < numberOfComponents; ++i) {
            if (this.type == 0) {
                GE += phase.getComponents()[i].getx() * Math.log(((ComponentGEInterface)this.componentArray[i]).getGamma(phase, numberOfComponents, temperature, pressure, pt, this.alpha, this.Dij, this.intparam, this.mixRule));
                continue;
            }
            if (this.type != 1) continue;
            GE += phase.getComponents()[i].getx() * Math.log(((ComponentGENRTLmodifiedWS)this.componentArray[i]).getGamma(phase, numberOfComponents, temperature, pressure, pt, this.alpha, this.Dij, this.DijT, this.intparam, this.mixRule));
        }
        return 8.3144621 * temperature * this.numberOfMolesInPhase * GE;
    }
}

