/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.phase;

import neqsim.thermo.component.ComponentGEInterface;
import neqsim.thermo.component.ComponentGEUniquac;
import neqsim.thermo.phase.PhaseGE;
import neqsim.thermo.phase.PhaseInterface;
import neqsim.thermo.phase.PhaseType;
import neqsim.util.exception.IsNaNException;
import neqsim.util.exception.TooManyIterationsException;

public class PhaseGEUniquac
extends PhaseGE {
    private static final long serialVersionUID = 1000L;
    double[][] alpha;
    String[][] mixRule;
    double[][] intparam;
    double[][] Dij;
    double GE = 0.0;

    public PhaseGEUniquac() {
        this.componentArray = new ComponentGEInterface[100];
    }

    public PhaseGEUniquac(PhaseInterface phase, double[][] alpha, double[][] Dij, String[][] mixRule, double[][] intparam) {
        this.componentArray = new ComponentGEUniquac[alpha[0].length];
        this.mixRule = mixRule;
        this.alpha = alpha;
        this.Dij = Dij;
        this.intparam = intparam;
        for (int i = 0; i < alpha[0].length; ++i) {
            ++this.numberOfComponents;
            this.componentArray[i] = new ComponentGEUniquac(phase.getComponents()[i].getName(), phase.getComponents()[i].getNumberOfmoles(), phase.getComponents()[i].getNumberOfMolesInPhase(), phase.getComponents()[i].getComponentNumber());
        }
    }

    @Override
    public void setAlpha(double[][] alpha) {
        throw new UnsupportedOperationException("Unimplemented method 'setAlpha'");
    }

    @Override
    public void setDij(double[][] Dij) {
        throw new UnsupportedOperationException("Unimplemented method 'setDij'");
    }

    @Override
    public void setDijT(double[][] DijT) {
        throw new UnsupportedOperationException("Unimplemented method 'setDijT'");
    }

    @Override
    public void addComponent(String name, double moles, double molesInPhase, int compNumber) {
        super.addComponent(name, molesInPhase, compNumber);
        this.componentArray[compNumber] = new ComponentGEUniquac(name, moles, molesInPhase, compNumber);
    }

    @Override
    public double getGibbsEnergy() {
        return 8.3144621 * this.temperature * this.numberOfMolesInPhase * (this.GE + Math.log(this.pressure));
    }

    @Override
    public double getExcessGibbsEnergy() {
        return this.GE;
    }

    @Override
    public double getExcessGibbsEnergy(PhaseInterface phase, int numberOfComponents, double temperature, double pressure, PhaseType pt) {
        this.GE = 0.0;
        for (int i = 0; i < numberOfComponents; ++i) {
            this.GE += phase.getComponents()[i].getx() * Math.log(((ComponentGEInterface)this.componentArray[i]).getGamma(phase, numberOfComponents, temperature, pressure, pt, this.alpha, this.Dij, this.intparam, this.mixRule));
        }
        return 8.3144621 * temperature * this.numberOfMolesInPhase * this.GE;
    }

    @Override
    public double molarVolume(double pressure, double temperature, double A, double B, PhaseType pt) throws IsNaNException, TooManyIterationsException {
        throw new UnsupportedOperationException("Unimplemented method 'molarVolume'");
    }
}

