/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.system;

import neqsim.thermo.phase.PhaseDuanSun;
import neqsim.thermo.phase.PhasePureComponentSolid;
import neqsim.thermo.phase.PhaseSrkEos;
import neqsim.thermo.system.SystemEos;

public class SystemDuanSun
extends SystemEos {
    private static final long serialVersionUID = 1000L;
    protected String[] CapeOpenProperties11 = new String[]{"molecularWeight", "fugacityCoefficient", "logFugacityCoefficient"};

    public SystemDuanSun() {
        this(298.15, 1.0, false);
    }

    public SystemDuanSun(double T, double P) {
        this(T, P, false);
    }

    public SystemDuanSun(double T, double P, boolean checkForSolids) {
        super(T, P, checkForSolids);
        this.attractiveTermNumber = 0;
        this.modelName = "Duan-Sun-model";
        this.phaseArray[0] = new PhaseSrkEos();
        this.phaseArray[0].setTemperature(T);
        this.phaseArray[0].setPressure(P);
        for (int i = 1; i < this.numberOfPhases; ++i) {
            this.phaseArray[i] = new PhaseDuanSun();
            this.phaseArray[i].setTemperature(T);
            this.phaseArray[i].setPressure(P);
        }
        if (this.solidPhaseCheck) {
            this.setNumberOfPhases(4);
            this.phaseArray[this.numberOfPhases - 1] = new PhasePureComponentSolid();
            this.phaseArray[this.numberOfPhases - 1].setTemperature(T);
            this.phaseArray[this.numberOfPhases - 1].setPressure(P);
            this.phaseArray[this.numberOfPhases - 1].setRefPhase(this.phaseArray[1].getRefPhase());
        }
    }

    @Override
    public SystemDuanSun clone() {
        SystemDuanSun clonedSystem = null;
        try {
            clonedSystem = (SystemDuanSun)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return clonedSystem;
    }
}

